/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.runprofiles;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

final class DirectoryChooserPanel
extends JPanel
implements PropertyChangeListener {
    private PropertyEditorSupport editor;
    private String seed;
    private JButton browseButton;
    private JLabel directoryLabel;
    private JTextField directoryTextField;

    public DirectoryChooserPanel(String seed, PropertyEditorSupport editor, PropertyEnv propenv) {
        this.initComponents();
        this.seed = seed;
        this.editor = editor;
        this.directoryTextField.setText(seed);
        propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propenv.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.directoryTextField.getText());
        }
    }

    private void initComponents() {
        this.directoryLabel = new JLabel();
        this.directoryTextField = new JTextField();
        this.browseButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.directoryLabel.setLabelFor(this.directoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.directoryLabel, (String)NbBundle.getMessage(DirectoryChooserPanel.class, (String)"DirectoryChooserPanel.directoryLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.add((Component)this.directoryLabel, gridBagConstraints);
        this.directoryTextField.setColumns(60);
        this.directoryTextField.setText(NbBundle.getMessage(DirectoryChooserPanel.class, (String)"DirectoryChooserPanel.directoryTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        this.add((Component)this.directoryTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(DirectoryChooserPanel.class, (String)"DirectoryChooserPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryChooserPanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 4, 8, 8);
        this.add((Component)this.browseButton, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        FileChooser fileChooser;
        int ret;
        if (this.seed == null && FileChooser.getCurrentChooserFile() != null) {
            this.seed = FileChooser.getCurrentChooserFile().getPath();
        }
        if ((ret = (fileChooser = new FileChooser(DirectoryChooserPanel.getString("Run_Directory"), DirectoryChooserPanel.getString("SelectLabel"), 1, null, this.seed, true)).showOpenDialog((Component)this)) == 1) {
            return;
        }
        String dirPath = fileChooser.getSelectedFile().getPath();
        this.directoryTextField.setText(dirPath);
    }

    private static String getString(String key) {
        return NbBundle.getMessage(DirectoryChooserPanel.class, (String)key);
    }
}

