/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.CancellationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.makeproject.MakeActionProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;

public class ProjectSupport {
    private ProjectSupport() {
    }

    public static boolean saveAllProjects(String extraMessage) {
        boolean ok = true;
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < openProjects.length; ++i) {
            MakeConfigurationDescriptor projectDescriptor = MakeConfigurationDescriptor.getMakeConfigurationDescriptor(openProjects[i]);
            if (projectDescriptor == null) continue;
            ok = ok && projectDescriptor.save(extraMessage);
        }
        return ok;
    }

    public static Date lastModified(Project project) {
        FileObject projectFile = null;
        try {
            projectFile = project.getProjectDirectory().getFileObject("nbproject" + File.separator + "Makefile-impl.mk");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (projectFile == null) {
            projectFile = project.getProjectDirectory();
        }
        return projectFile.lastModified();
    }

    public static void executeCustomAction(Project project, ProjectActionHandler customProjectActionHandler) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null) {
            return;
        }
        MakeConfigurationDescriptor projectDescriptor = pdp.getConfigurationDescriptor();
        MakeConfiguration conf = projectDescriptor.getActiveConfiguration();
        if (conf == null) {
            return;
        }
        MakeActionProvider ap = (MakeActionProvider)project.getLookup().lookup(MakeActionProvider.class);
        if (ap == null) {
            return;
        }
        ap.invokeCustomAction(projectDescriptor, conf, customProjectActionHandler);
    }

    public static MakeProjectOptions.PathMode getPathMode(Project project) {
        return MakeProjectOptions.getPathMode();
    }

    public static String toProperPath(FileObject base, FileObject path, Project project) {
        return ProjectSupport.toProperPath(base, path, ProjectSupport.getPathMode(project));
    }

    public static String toProperPath(FileObject base, String path, Project project) {
        return ProjectSupport.toProperPath(base, path, ProjectSupport.getPathMode(project));
    }

    public static String toProperPath(String base, String path, Project project) {
        return ProjectSupport.toProperPath(base, path, ProjectSupport.getPathMode(project));
    }

    public static String toProperPath(FileObject base, FileObject path, MakeProjectOptions.PathMode pathMode) {
        switch (pathMode) {
            case REL_OR_ABS: {
                return CndPathUtilitities.toAbsoluteOrRelativePath((FileObject)base, (FileObject)path);
            }
            case REL: {
                return CndPathUtilitities.toRelativePath((FileObject)base, (FileObject)path);
            }
            case ABS: {
                try {
                    return CndFileUtils.getCanonicalPath((FileObject)path);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    return path.getPath();
                }
            }
        }
        throw new IllegalStateException("Unexpected path mode: " + (Object)((Object)pathMode));
    }

    public static String toProperPath(FileObject base, String path, MakeProjectOptions.PathMode pathMode) {
        switch (pathMode) {
            case REL_OR_ABS: {
                return CndPathUtilitities.toAbsoluteOrRelativePath((FileObject)base, (String)path);
            }
            case REL: {
                return CndPathUtilitities.toRelativePath((FileObject)base, (String)path);
            }
            case ABS: {
                return CndPathUtilitities.toAbsolutePath((FileObject)base, (String)path);
            }
        }
        throw new IllegalStateException("Unexpected path mode: " + (Object)((Object)pathMode));
    }

    public static String toProperPath(String base, String path, MakeProjectOptions.PathMode pathMode) {
        switch (pathMode) {
            case REL_OR_ABS: {
                return CndPathUtilitities.toAbsoluteOrRelativePath((String)base, (String)path);
            }
            case REL: {
                return CndPathUtilitities.toRelativePath((String)base, (String)path);
            }
            case ABS: {
                return CndPathUtilitities.toAbsolutePath((String)base, (String)path);
            }
        }
        throw new IllegalStateException("Unexpected path mode: " + (Object)((Object)pathMode));
    }

    public static String convertWorkingDirToRemoteIfNeeded(ProjectActionEvent pae, String localDir) {
        ExecutionEnvironment execEnv = pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
        if (!ProjectSupport.checkConnection(execEnv)) {
            return null;
        }
        if (execEnv.isRemote()) {
            if (RemoteSyncSupport.getRemoteMode((Project)pae.getProject()) == RemoteProject.Mode.LOCAL_SOURCES) {
                PathMap mapper = RemoteSyncSupport.getPathMap((Project)pae.getProject());
                return mapper.getRemotePath(localDir, false);
            }
            CndUtils.assertAbsolutePathInConsole((String)localDir);
            if (CndPathUtilitities.isPathAbsolute((CharSequence)localDir)) {
                return localDir;
            }
            RemoteProject remoteProject = (RemoteProject)pae.getProject().getLookup().lookup(RemoteProject.class);
            CndUtils.assertNotNullInConsole((Object)pae, (String)localDir);
            if (remoteProject != null) {
                localDir = remoteProject.getSourceBaseDir() + '/' + localDir;
                localDir = FileSystemProvider.normalizeAbsolutePath((String)localDir, (ExecutionEnvironment)execEnv);
                return localDir;
            }
        }
        return localDir;
    }

    public static boolean checkConnection(ExecutionEnvironment execEnv) {
        if (execEnv.isRemote()) {
            try {
                ConnectionManager.getInstance().connectTo(execEnv);
                ServerRecord record = ServerList.get((ExecutionEnvironment)execEnv);
                if (record.isOffline()) {
                    record.validate(true);
                }
                return record.isOnline();
            }
            catch (IOException ex) {
                return false;
            }
            catch (CancellationException ex) {
                return false;
            }
        }
        return true;
    }
}

