/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.actions;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.RunDialogPanel;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public class RunDialogAction
extends NodeAction {
    protected JButton runButton = null;
    private Object[] options;
    private FileObject contextFileObject;
    private ResourceBundle bundle;

    private void init(boolean isRun) {
        if (this.runButton == null) {
            this.runButton = new JButton(this.getString("RunButtonText"));
            this.runButton.getAccessibleContext().setAccessibleDescription(this.getString("RunButtonAD"));
            this.options = new Object[]{this.runButton, DialogDescriptor.CANCEL_OPTION};
        }
        if (isRun) {
            this.runButton.setText(this.getString("RunButtonText"));
            this.runButton.getAccessibleContext().setAccessibleDescription(this.getString("RunButtonAD"));
        } else {
            this.runButton.setText(this.getString("CreateButtonText"));
            this.runButton.getAccessibleContext().setAccessibleDescription(this.getString("CreateButtonAD"));
        }
    }

    public String getName() {
        return this.getString("RUN_COMMAND");
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        this.contextFileObject = (FileObject)actionContext.lookup(FileObject.class);
        return super.createContextAwareInstance(actionContext);
    }

    protected void performAction(Node[] activatedNodes) {
        String path = null;
        boolean isRun = true;
        if (activatedNodes != null && activatedNodes.length == 1) {
            File file;
            FileObject fo;
            DataObject dataObject = (DataObject)activatedNodes[0].getCookie(DataObject.class);
            String mime = this.getMime(dataObject);
            if (dataObject != null && dataObject.isValid() && MIMENames.isBinary((String)mime) && (fo = dataObject.getPrimaryFile()) != null && (file = FileUtil.toFile((FileObject)fo)) != null) {
                path = file.getPath();
            }
        } else if (this.contextFileObject != null) {
            File file = FileUtil.toFile((FileObject)this.contextFileObject);
            if (file != null) {
                path = file.getPath();
            }
            isRun = false;
        }
        this.perform(path, isRun);
    }

    private String getMime(DataObject dob) {
        FileObject primaryFile = dob == null ? null : dob.getPrimaryFile();
        String mime = primaryFile == null ? "" : primaryFile.getMIMEType();
        return mime;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        DataObject dataObject = (DataObject)activatedNodes[0].getCookie(DataObject.class);
        String mime = this.getMime(dataObject);
        return MIMENames.isBinary((String)mime) && !"application/x-core+elf".equals(mime);
    }

    private void perform(String executablePath, boolean isRun) {
        this.init(isRun);
        this.perform(new RunDialogPanel(executablePath, this.runButton, isRun), isRun);
    }

    private void perform(final RunDialogPanel runDialogPanel, boolean isRun) {
        Project project;
        MakeConfiguration conf;
        if (WindowManager.getDefault().getRegistry().getOpened().isEmpty()) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            Project project = runDialogPanel.getSelectedProject();
                        }
                    });
                }
            });
            return;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)runDialogPanel, isRun ? this.getString("RunDialogTitle") : this.getString("CreateDialogTitle"), true, this.options, (Object)this.runButton, 0, null, null);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (ret == this.runButton && (conf = ConfigurationSupport.getProjectActiveConfiguration(project = runDialogPanel.getSelectedProject())) != null && isRun) {
            RunProfile profile = conf.getProfile();
            String path = runDialogPanel.getExecutablePath();
            path = CndPathUtilitities.toRelativePath((String)profile.getRunDirectory(), (String)path);
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(project, ProjectActionEvent.PredefinedType.RUN, path, conf, profile, false);
            ProjectActionSupport.getInstance().fireActionPerformed(new ProjectActionEvent[]{projectActionEvent});
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RunDialogAction.class);
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(RunDialogAction.class);
        }
        return this.bundle.getString(s);
    }
}

