/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.actions;

import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.makeproject.actions.ShadowProjectSynchronizer;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.FullRemoteExtensionProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class FullRemoteExtensionProviderImpl
implements FullRemoteExtensionProvider {
    private final LinkedList<MakeConfigurationDescriptor> savingProjects = new LinkedList();
    private final Object lock = new Object();
    private static final Logger LOGGER = Logger.getLogger("cnd.remote.logger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean configurationSaving(MakeConfigurationDescriptor mkd) {
        RemoteProject remoteProject;
        Project project = mkd.getProject();
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && remoteProject.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES) {
            Object object = this.lock;
            synchronized (object) {
                this.savingProjects.add(mkd);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean configurationSaved(MakeConfigurationDescriptor mkd, boolean success) {
        Object object = this.lock;
        synchronized (object) {
            if (this.savingProjects.contains(mkd)) {
                this.savingProjects.remove(mkd);
            } else {
                mkd = null;
            }
        }
        if (mkd != null) {
            LOGGER.log(Level.FINE, "Synchronizing remote project {0}", mkd.getProjectDirFileObject().getPath());
            this.updateRemoteProject(mkd);
        }
        return true;
    }

    @Override
    public boolean canChangeHost(MakeConfiguration makeConfiguration) {
        return Boolean.getBoolean("cnd.full.remote.change.host");
    }

    private void updateRemoteProject(MakeConfigurationDescriptor mkd) {
        RemoteProject remoteProject;
        Project project = mkd.getProject();
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && remoteProject.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES) {
            ExecutionEnvironment env = remoteProject.getSourceFileSystemHost();
            if (!ConnectionManager.getInstance().isConnectedTo(env)) {
                return;
            }
            String remotePath = remoteProject.resolveRelativeRemotePath(".");
            FileObject localProjectFO = mkd.getProjectDirFileObject();
            try {
                ShadowProjectSynchronizer sync = new ShadowProjectSynchronizer(remotePath, localProjectFO.getPath(), env);
                sync.updateRemoteProject();
            }
            catch (IOException ex) {
                this.reportException(ex, localProjectFO, remotePath, env);
            }
            catch (SAXException ex) {
                this.reportException(ex, localProjectFO, remotePath, env);
            }
            catch (InterruptedException ex) {
                this.reportException(ex, localProjectFO, remotePath, env);
            }
        }
    }

    private void reportException(Exception ex, FileObject localProjectFO, String remotePath, ExecutionEnvironment env) {
        String title = NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"ERR_SyncToRemote", (Object)env.getDisplayName());
        ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/exclamation.gif", (boolean)false);
        String details = NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"ERR_SyncToRemote_Details", (Object)ex.getLocalizedMessage());
        LOGGER.log(Level.INFO, title, ex);
        NotificationDisplayer.getDefault().notify(title, (Icon)icon, details, null, NotificationDisplayer.Priority.HIGH);
    }
}

