/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.makeproject.FileObjectBasedSources;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MakeSources
implements Sources,
AntProjectListener {
    private static final String GENERIC = "generic";
    private final MakeProject project;
    private final AntProjectHelper helper;
    private Sources delegate;
    private final ChangeSupport changeSupport;
    private long eventID = 0L;

    public MakeSources(MakeProject project, AntProjectHelper helper) {
        this.project = project;
        this.helper = helper;
        helper.addAntProjectListener((AntProjectListener)this);
        this.changeSupport = new ChangeSupport((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceGroup[] getSourceGroups(String str) {
        long curEvent;
        Sources srcs;
        if (!str.equals(GENERIC)) {
            return new SourceGroup[0];
        }
        MakeSources makeSources = this;
        synchronized (makeSources) {
            srcs = this.delegate;
            curEvent = ++this.eventID;
        }
        AtomicBoolean completeSouces = new AtomicBoolean(true);
        if (srcs == null) {
            srcs = this.initSources(completeSouces);
        }
        MakeSources makeSources2 = this;
        synchronized (makeSources2) {
            if (curEvent == this.eventID && completeSouces.get()) {
                this.delegate = srcs;
            }
        }
        SourceGroup[] sg = srcs.getSourceGroups(str);
        return sg;
    }

    private List<String> getSourceRootsFromProjectXML() {
        Element data = this.helper.getPrimaryConfigurationData(true);
        if (data.getElementsByTagName("sourceRootList").getLength() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            NodeList nl4 = data.getElementsByTagName("sourceRootElem");
            if (nl4.getLength() > 0) {
                for (int i = 0; i < nl4.getLength(); ++i) {
                    Node node = nl4.item(i);
                    NodeList nl2 = node.getChildNodes();
                    for (int j = 0; j < nl2.getLength(); ++j) {
                        String typeTxt;
                        String sRoot = typeTxt = nl2.item(j).getNodeValue();
                        list.add(sRoot);
                    }
                }
            }
            return list;
        }
        return null;
    }

    private List<String> getAbsoluteSourceRootsFromProjectXML() {
        RemoteProject remoteProject = (RemoteProject)this.project.getLookup().lookup(RemoteProject.class);
        List<String> sourceRoots = this.getSourceRootsFromProjectXML();
        ArrayList<String> absSourceRoots = null;
        if (sourceRoots != null) {
            absSourceRoots = new ArrayList<String>();
            for (String sRoot : sourceRoots) {
                String absSRoot;
                if (remoteProject != null && remoteProject.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES) {
                    absSRoot = remoteProject.resolveRelativeRemotePath(sRoot);
                } else {
                    String baseDir = FileUtil.toFile((FileObject)this.helper.getProjectDirectory()).getPath();
                    absSRoot = CndPathUtilitities.toAbsolutePath((String)baseDir, (String)sRoot);
                }
                absSourceRoots.add(absSRoot);
            }
        }
        return absSourceRoots;
    }

    private Sources initSources(AtomicBoolean completeSouces) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        LinkedHashSet<String> sourceRootList = null;
        if (!pdp.gotDescriptor()) {
            completeSouces.set(false);
            List<String> absSourceRoots = this.getAbsoluteSourceRootsFromProjectXML();
            if (absSourceRoots != null) {
                completeSouces.set(true);
                sourceRootList = new LinkedHashSet();
                sourceRootList.addAll(absSourceRoots);
            }
        }
        if (sourceRootList == null) {
            sourceRootList = new LinkedHashSet<String>();
            MakeConfigurationDescriptor pd = pdp.getConfigurationDescriptor(true);
            if (pd != null) {
                Item[] projectItems;
                completeSouces.set(true);
                if (pd.getVersion() < 41 && (projectItems = pd.getProjectItems()) != null) {
                    for (int i = 0; i < projectItems.length; ++i) {
                        File file;
                        Item item = projectItems[i];
                        String name = item.getPath();
                        if (!CndPathUtilitities.isPathAbsolute((CharSequence)name) || !(file = new File(name)).exists()) continue;
                        if (!file.isDirectory()) {
                            file = file.getParentFile();
                        }
                        name = file.getPath();
                        sourceRootList.add(name);
                        pd.addSourceRootRaw(CndPathUtilitities.toRelativePath((String)pd.getBaseDir(), (String)name));
                    }
                }
                List<String> list = pd.getAbsoluteSourceRoots();
                for (String sr : list) {
                    sourceRootList.add(sr);
                }
                if (pd.getVersion() < 41) {
                    Configuration[] confs = pd.getConfs().toArray();
                    for (int i = 0; i < confs.length; ++i) {
                        MakeConfiguration makeConfiguration = (MakeConfiguration)confs[i];
                        if (!makeConfiguration.isMakefileConfiguration()) continue;
                        MakefileConfiguration makefileConfiguration = makeConfiguration.getMakefileConfiguration();
                        String path = makefileConfiguration.getAbsBuildCommandWorkingDir();
                        sourceRootList.add(path);
                        pd.addSourceRootRaw(CndPathUtilitities.toRelativePath((String)pd.getBaseDir(), (String)path));
                    }
                }
            } else {
                completeSouces.set(false);
            }
        }
        if (this.project.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES) {
            FileObjectBasedSources sources = new FileObjectBasedSources();
            MakeConfigurationDescriptor pd = pdp.getConfigurationDescriptor(true);
            if (pd != null) {
                String baseDir = pd.getBaseDir();
                HashSet<FileObject> added = new HashSet<FileObject>();
                ExecutionEnvironment fsEnv = this.project.getRemoteFileSystemHost();
                sourceRootList.add(baseDir);
                for (String name : sourceRootList) {
                    String path = CndPathUtilitities.toAbsolutePath((String)baseDir, (String)name);
                    path = RemoteFileUtil.normalizeAbsolutePath((String)path, (ExecutionEnvironment)fsEnv);
                    String displayName = fsEnv.getDisplayName() + ":" + path;
                    FileObject fo = RemoteFileUtil.getFileObject((String)path, (ExecutionEnvironment)fsEnv);
                    if (added.contains(fo)) continue;
                    if (fo == null) {
                        new NullPointerException("Null file object for " + fsEnv + ':' + path).printStackTrace();
                        continue;
                    }
                    sources.addGroup(this.project, GENERIC, fo, displayName);
                    added.add(fo);
                }
            } else {
                completeSouces.set(false);
            }
            sources.addGroup(this.project, GENERIC, this.project.getProjectDirectory(), NbBundle.getMessage(MakeSources.class, (String)"SHADOW_METADATA_DISPLAY_NAME"));
            return sources;
        }
        String baseDir = this.helper.getProjectDirectory().getPath();
        SourcesHelper h = new SourcesHelper((Project)this.project, this.helper, this.project.evaluator());
        for (String name : sourceRootList) {
            String displayName = CndPathUtilitities.toRelativePath((String)baseDir, (String)name);
            displayName = CndPathUtilitities.naturalizeSlashes((String)displayName);
            h.sourceRoot(name).displayName(displayName).add();
            h.sourceRoot(name).type(GENERIC).displayName(displayName).add();
        }
        h.registerExternalRoots(0);
        return h.createSources();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private void fireChange() {
        this.delegate = null;
        this.changeSupport.fireChange();
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
    }

    public void descriptorChanged() {
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public void sourceRootsChanged() {
        this.fireChange();
    }
}

