/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.palette.items;

import java.util.ResourceBundle;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.web.core.palette.JspPaletteUtilities;
import org.netbeans.modules.web.core.palette.items.SQLStmt;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.NbBundle;

public class Query
implements ActiveEditorDrop {
    public static String QUERY_DEFAULT = "SELECT column_name(s) FROM table_name";
    SQLStmt stmt = null;
    private String variable = "";
    private int scopeIndex = 0;
    private String dataSource = "";
    private String query = QUERY_DEFAULT;
    private String displayName;
    private String stmtLabel = "";
    private String stmtACSN = "";
    private String stmtACSD = "";

    public Query() {
        try {
            this.displayName = NbBundle.getBundle((String)"org.netbeans.modules.web.core.palette.items.resources.Bundle").getString("NAME_jsp-Query");
        }
        catch (Exception e) {
            // empty catch block
        }
        ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.web.core.palette.items.Bundle");
        try {
            this.stmtLabel = bundle.getString("LBL_Query_Stmt");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.stmtACSN = bundle.getString("ACSN_Query_Stmt");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.stmtACSD = bundle.getString("ACSD_Query_Stmt");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stmt = new SQLStmt(this.variable, this.scopeIndex, this.dataSource, this.query, "QueryStmtCustomizer");
    }

    public boolean handleTransfer(JTextComponent targetComponent) {
        boolean accept = this.stmt.customize(targetComponent, this.displayName, this.stmtLabel, this.stmtACSN, this.stmtACSD);
        if (accept) {
            String prefix = JspPaletteUtilities.findSqlPrefix(targetComponent);
            String body = this.createBody(prefix);
            try {
                JspPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody(String prefix) {
        String strDS;
        this.variable = this.stmt.getVariable();
        this.dataSource = this.stmt.getDataSource();
        if (this.variable.equals("")) {
            this.variable = "&CARET&";
        } else if (this.dataSource.equals("")) {
            this.dataSource = "&CARET&";
        }
        String strVariable = " var=\"\"";
        if (this.variable.length() > 0) {
            strVariable = " var=\"" + this.variable + "\"";
        }
        this.scopeIndex = this.stmt.getScopeIndex();
        String strScope = "";
        if (this.scopeIndex != 0) {
            strScope = " scope=\"" + SQLStmt.scopes[this.scopeIndex] + "\"";
        }
        if ((strDS = " dataSource=\"\"").length() > 0) {
            strDS = " dataSource=\"" + this.dataSource + "\"";
        }
        String strQuery = this.query = this.stmt.getStmt();
        if (this.query.length() > 0) {
            strQuery = strQuery + "\n";
        }
        return "<" + prefix + ":query" + strVariable + strScope + strDS + ">\n" + strQuery + "</" + prefix + ":query>";
    }
}

