/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.maven.api.customizer.support.DelayedDocumentChangeListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.PluginIndexManager;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.spi.nodes.MavenNodeFactory;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class NewPluginPanel
extends JPanel
implements ChangeListener,
Comparator<String> {
    private static final Object LOCK = new Object();
    private static Node noResultsRoot;
    private String curTypedText;
    private Color defSearchC;
    private String lastQueryText;
    private String inProgressText;
    private QueryPanel queryPanel;
    private DefaultListModel listModel;
    private NBVersionInfo selVi;
    private JCheckBox chkConfig;
    private JList goalsList;
    private JScrollPane jScrollPane1;
    private JLabel lblGoals;
    private JLabel lblHint;
    private JLabel lblPlugins;
    private JLabel lblQuery;
    private JPanel pluginsPanel;
    private JTextField tfQuery;

    public NewPluginPanel() {
        this.initComponents();
        this.defSearchC = this.tfQuery.getForeground();
        this.queryPanel = new QueryPanel(this);
        this.pluginsPanel.add((Component)this.queryPanel, "Center");
        this.tfQuery.getDocument().addDocumentListener(DelayedDocumentChangeListener.create((Document)this.tfQuery.getDocument(), (ChangeListener)this, (int)500));
        this.listModel = new DefaultListModel();
        this.goalsList.setModel(this.listModel);
        GoalRenderer gr = new GoalRenderer(this.goalsList);
        this.goalsList.setCellRenderer(gr);
        this.goalsList.addMouseListener(gr);
        this.goalsList.addKeyListener(gr);
    }

    public NBVersionInfo getPlugin() {
        return this.selVi;
    }

    public boolean isConfiguration() {
        return this.chkConfig.isSelected();
    }

    public List<String> getGoals() {
        ArrayList<String> goals = new ArrayList<String>();
        Enumeration e = this.listModel.elements();
        GoalEntry ge = null;
        while (e.hasMoreElements()) {
            ge = (GoalEntry)e.nextElement();
            if (!ge.isSelected) continue;
            goals.add(ge.name);
        }
        return goals;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Document doc = (Document)e.getSource();
        try {
            this.curTypedText = doc.getText(0, doc.getLength()).trim();
        }
        catch (BadLocationException ex) {
            return;
        }
        this.tfQuery.setForeground(this.defSearchC);
        if (this.curTypedText.length() < 3) {
            this.tfQuery.setForeground(Color.RED);
        } else {
            this.tfQuery.setForeground(this.defSearchC);
            this.find(this.curTypedText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void find(String queryText) {
        Object object = LOCK;
        synchronized (object) {
            if (this.inProgressText != null) {
                this.lastQueryText = queryText;
                return;
            }
            this.inProgressText = queryText;
            this.lastQueryText = null;
        }
        this.setSearchInProgressUI(true);
        final String q = queryText.trim();
        RequestProcessor.Task t = RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                String[] splits;
                ArrayList<QueryField> fields = new ArrayList<QueryField>();
                for (String curText : splits = q.split(" ")) {
                    QueryField f = new QueryField();
                    f.setField("artifactId");
                    f.setOccur(0);
                    f.setValue(curText);
                    fields.add(f);
                }
                QueryField f = new QueryField();
                f.setField("packaging");
                f.setValue("maven-plugin");
                f.setOccur(0);
                fields.add(f);
                List infos = RepositoryQueries.find(fields, (RepositoryInfo[])new RepositoryInfo[0]);
                Object node = null;
                final HashMap<String, ArrayList<NBVersionInfo>> map = new HashMap<String, ArrayList<NBVersionInfo>>();
                for (NBVersionInfo nbvi : infos) {
                    String key = nbvi.getGroupId() + " : " + nbvi.getArtifactId();
                    ArrayList<NBVersionInfo> get = (ArrayList<NBVersionInfo>)map.get(key);
                    if (get == null) {
                        get = new ArrayList<NBVersionInfo>();
                        map.put(key, get);
                    }
                    get.add(nbvi);
                }
                final ArrayList keyList = new ArrayList(map.keySet());
                Collections.sort(keyList, NewPluginPanel.this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewPluginPanel.this.queryPanel.getExplorerManager().setRootContext(NewPluginPanel.this.createResultsNode(keyList, map));
                    }
                });
            }
        });
        t.addTaskListener(new TaskListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskFinished(Task task) {
                Object object = LOCK;
                synchronized (object) {
                    String localText = NewPluginPanel.this.inProgressText;
                    NewPluginPanel.this.inProgressText = null;
                    if (NewPluginPanel.this.lastQueryText != null && !NewPluginPanel.this.lastQueryText.equals(localText)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (NewPluginPanel.this.lastQueryText != null) {
                                    NewPluginPanel.this.find(NewPluginPanel.this.lastQueryText);
                                }
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewPluginPanel.this.setSearchInProgressUI(false);
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public int compare(String s1, String s2) {
        int index1 = s1.indexOf(this.inProgressText);
        int index2 = s2.indexOf(this.inProgressText);
        if (index1 >= 0 || index2 >= 0) {
            if (index1 < 0) {
                return 1;
            }
            if (index2 < 0) {
                return -1;
            }
            return index1 - index2;
        }
        return s1.compareTo(s2);
    }

    private Node createResultsNode(List<String> keyList, Map<String, List<NBVersionInfo>> map) {
        Node node;
        if (keyList.size() > 0) {
            Children.Array array = new Children.Array();
            node = new AbstractNode((Children)array);
            for (String key : keyList) {
                array.add(new Node[]{MavenNodeFactory.createArtifactNode((String)key, map.get(key))});
            }
        } else {
            node = NewPluginPanel.getNoResultsRoot();
        }
        return node;
    }

    private static Node getNoResultsRoot() {
        if (noResultsRoot == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/codegen/empty.png");
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Empty");
            nd.setDisplayName(NbBundle.getMessage(NewPluginPanel.class, (String)"LBL_Node_Empty"));
            Children.Array array = new Children.Array();
            array.add(new Node[]{nd});
            noResultsRoot = new AbstractNode((Children)array);
        }
        return noResultsRoot;
    }

    private static Border getNbScrollPaneBorder() {
        Border b = UIManager.getBorder("Nb.ScrollPane.border");
        if (b == null) {
            Color c = UIManager.getColor("controlShadow");
            b = new LineBorder(c != null ? c : Color.GRAY);
        }
        return b;
    }

    private void initComponents() {
        this.lblQuery = new JLabel();
        this.tfQuery = new JTextField();
        this.lblHint = new JLabel();
        this.lblPlugins = new JLabel();
        this.pluginsPanel = new JPanel();
        this.lblGoals = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.goalsList = new JList();
        this.chkConfig = new JCheckBox();
        this.lblQuery.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.lblQuery.text"));
        this.tfQuery.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.tfQuery.text"));
        this.tfQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewPluginPanel.this.tfQueryActionPerformed(evt);
            }
        });
        this.lblHint.setForeground(UIManager.getDefaults().getColor("textInactiveText"));
        this.lblHint.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.lblHint.text"));
        this.lblPlugins.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.lblPlugins.text"));
        this.pluginsPanel.setBorder(NewPluginPanel.getNbScrollPaneBorder());
        this.pluginsPanel.setLayout(new BorderLayout());
        this.lblGoals.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.lblGoals.text"));
        this.jScrollPane1.setViewportView(this.goalsList);
        this.chkConfig.setSelected(true);
        this.chkConfig.setText(NbBundle.getMessage(NewPluginPanel.class, (String)"NewPluginPanel.chkConfig.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pluginsPanel, -1, 429, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblQuery).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblHint).addComponent(this.tfQuery, -1, 326, Short.MAX_VALUE))).addComponent(this.lblPlugins).addComponent(this.lblGoals).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 218, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.chkConfig).addGap(4, 4, 4))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblQuery).addComponent(this.tfQuery, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPlugins).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pluginsPanel, -1, 124, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblGoals).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 104, Short.MAX_VALUE).addComponent(this.chkConfig)).addContainerGap()));
    }

    private void setSearchInProgressUI(boolean b) {
    }

    private void updateGoals() {
        DefaultListModel m = (DefaultListModel)this.goalsList.getModel();
        m.clear();
        if (this.selVi != null) {
            Set goals = null;
            try {
                goals = PluginIndexManager.getPluginGoals((String)this.selVi.getGroupId(), (String)this.selVi.getArtifactId(), (String)this.selVi.getVersion());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (goals != null) {
                for (String goal : goals) {
                    m.addElement(new GoalEntry(goal));
                }
            }
        }
    }

    private void tfQueryActionPerformed(ActionEvent evt) {
    }

    private static class GoalEntry {
        boolean isSelected = false;
        String name;

        public GoalEntry(String name) {
            this.name = name;
        }
    }

    private static class QueryPanel
    extends JPanel
    implements ExplorerManager.Provider,
    PropertyChangeListener {
        private BeanTreeView btv;
        private ExplorerManager manager;
        private NewPluginPanel pluginPanel;

        private QueryPanel(NewPluginPanel plugPanel) {
            this.pluginPanel = plugPanel;
            this.btv = new BeanTreeView();
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(false);
            this.btv.setUseSubstringInQuickSearch(true);
            this.manager = new ExplorerManager();
            this.manager.setRootContext(NewPluginPanel.getNoResultsRoot());
            this.setLayout(new BorderLayout());
            this.add((Component)this.btv, "Center");
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.pluginPanel.lblPlugins.setLabelFor((Component)this.btv);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] selNodes = this.manager.getSelectedNodes();
                this.pluginPanel.selVi = null;
                if (selNodes.length == 1) {
                    List infos;
                    if (selNodes[0] instanceof MavenNodeFactory.VersionNode) {
                        this.pluginPanel.selVi = ((MavenNodeFactory.VersionNode)selNodes[0]).getNBVersionInfo();
                    } else if (selNodes[0] instanceof MavenNodeFactory.ArtifactNode && (infos = ((MavenNodeFactory.ArtifactNode)selNodes[0]).getVersionInfos()).size() > 0) {
                        this.pluginPanel.selVi = (NBVersionInfo)infos.get(0);
                    }
                }
                this.pluginPanel.updateGoals();
            }
        }
    }

    private static class GoalRenderer
    extends JCheckBox
    implements ListCellRenderer,
    MouseListener,
    KeyListener {
        private JList parentList;

        public GoalRenderer(JList list) {
            this.parentList = list;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            GoalEntry ge = (GoalEntry)value;
            this.setText(ge.name);
            this.setSelected(ge.isSelected);
            this.setOpaque(isSelected);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int idx = this.parentList.locationToIndex(e.getPoint());
            if (idx == -1) {
                return;
            }
            Rectangle rect = this.parentList.getCellBounds(idx, idx);
            if (rect.contains(e.getPoint())) {
                this.doCheck();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 32) {
                this.doCheck();
            }
        }

        private void doCheck() {
            int index = this.parentList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            GoalEntry ge = (GoalEntry)this.parentList.getModel().getElementAt(index);
            ge.isSelected = !ge.isSelected;
            this.parentList.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

