/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Profile;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyContainer;
import org.netbeans.modules.maven.model.pom.Exclusion;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.spi.grammar.DialogFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ExclusionGenerator
implements CodeGenerator {
    private POMModel model;
    private JTextComponent component;

    private ExclusionGenerator(POMModel model, JTextComponent component) {
        this.model = model;
        this.component = component;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ExclusionGenerator.class, (String)"NAME_Exclusion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        try {
            this.model.sync();
        }
        catch (IOException ex) {
            Logger.getLogger(ExclusionGenerator.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", ex);
        }
        if (!this.model.getState().equals((Object)Model.State.VALID)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExclusionGenerator.class, (String)"MSG_Cannot_Parse"));
            return;
        }
        FileObject fo = (FileObject)this.model.getModelSource().getLookup().lookup(FileObject.class);
        assert (fo != null);
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        assert (prj != null);
        int pos = this.component.getCaretPosition();
        DocumentComponent c = this.model.findComponent(pos);
        Map excludes = DialogFactory.showDependencyExcludeDialog((Project)prj);
        if (excludes != null) {
            this.model.startTransaction();
            try {
                for (Artifact exclude : excludes.keySet()) {
                    for (Artifact directArt : (List)excludes.get(exclude)) {
                        Exclusion ex;
                        Dependency dep = this.model.getProject().findDependencyById(directArt.getGroupId(), directArt.getArtifactId(), null);
                        if (dep == null) {
                            ArrayList<String> profileNames = new ArrayList<String>();
                            NbMavenProject project = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
                            for (Profile prof : project.getMavenProject().getActiveProfiles()) {
                                profileNames.add(prof.getId());
                            }
                            for (String profileId : profileNames) {
                                org.netbeans.modules.maven.model.pom.Profile modProf = this.model.getProject().findProfileById(profileId);
                                if (modProf == null || (dep = modProf.findDependencyById(directArt.getGroupId(), directArt.getArtifactId(), null)) == null) continue;
                                break;
                            }
                        }
                        if (dep == null) {
                            dep = this.model.getFactory().createDependency();
                            dep.setArtifactId(directArt.getArtifactId());
                            dep.setGroupId(directArt.getGroupId());
                            dep.setType(directArt.getType());
                            dep.setVersion(directArt.getVersion());
                            this.model.getProject().addDependency(dep);
                        }
                        if ((ex = dep.findExclusionById(exclude.getGroupId(), exclude.getArtifactId())) != null) continue;
                        ex = this.model.getFactory().createExclusion();
                        ex.setArtifactId(exclude.getArtifactId());
                        ex.setGroupId(exclude.getGroupId());
                        dep.addExclusion(ex);
                    }
                }
            }
            finally {
                this.model.endTransaction();
            }
        }
    }

    private DependencyContainer findContainer(int pos, POMModel model) {
        for (DocumentComponent dc = model.findComponent(pos); dc != null; dc = dc.getParent()) {
            if (!(dc instanceof DependencyContainer)) continue;
            return (DependencyContainer)dc;
        }
        return model.getProject();
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<ExclusionGenerator> toRet = new ArrayList<ExclusionGenerator>();
            POMModel model = (POMModel)context.lookup(POMModel.class);
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            if (model != null) {
                toRet.add(new ExclusionGenerator(model, component));
            }
            return toRet;
        }
    }
}

