/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.project.ui.J2eePlatformUiSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 1L;
    private String[] serverInstanceIDs;
    private String[] serverNames;
    private boolean initialized;
    private final EarProjectProperties uiProperties;
    private JPanel clientInfoPanel;
    private JComboBox clientModuleUriCombo;
    private JLabel dosDescription;
    private JLabel filler;
    private JCheckBox jCheckBoxDeployOnSave;
    private JCheckBox jCheckBoxDisplayBrowser;
    private JComboBox jComboBoxServer;
    private JLabel jLabelArgs;
    private JLabel jLabelContextPath;
    private JLabel jLabelContextPathDesc;
    private JLabel jLabelMainClass;
    private JLabel jLabelRelativeURL;
    private JLabel jLabelServer;
    private JLabel jLabelVMOptions;
    private JLabel jLabelVMOptionsExample;
    private JLabel jLabelVersion;
    private JTextField jTextArgs;
    private JTextField jTextFieldRelativeURL;
    private JTextField jTextFieldVersion;
    private JTextField jTextMainClass;
    private JTextField jTextVMOptions;
    private JPanel webInfoPanel;

    public CustomizerRun(EarProjectProperties earProperties) {
        this.uiProperties = earProperties;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_A11YDesc"));
        this.clientModuleUriCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizerRun.this.updateEnabled();
            }
        });
        this.initValues();
        this.updateEnabled();
    }

    private boolean isWebModuleSelected() {
        return this.clientModuleUriCombo.getSelectedItem() == null || !((ClientModuleItem)this.clientModuleUriCombo.getSelectedItem()).appClient;
    }

    private void updateEnabled() {
        boolean isWebUri = this.isWebModuleSelected();
        this.handleWebModuleRelated(isWebUri);
        this.jTextMainClass.setEnabled(!isWebUri);
        this.jTextArgs.setEnabled(!isWebUri);
        this.jTextVMOptions.setEnabled(!isWebUri);
        this.jLabelMainClass.setEnabled(!isWebUri);
        this.jLabelArgs.setEnabled(!isWebUri);
        this.jLabelVMOptions.setEnabled(!isWebUri);
        this.jLabelVMOptionsExample.setEnabled(!isWebUri);
    }

    public void initValues() {
        if (this.initialized) {
            return;
        }
        this.jTextFieldRelativeURL.setDocument(this.uiProperties.LAUNCH_URL_RELATIVE_MODEL);
        this.jCheckBoxDisplayBrowser.setModel(this.uiProperties.DISPLAY_BROWSER_MODEL);
        this.jComboBoxServer.setModel(this.uiProperties.J2EE_SERVER_INSTANCE_MODEL);
        this.jTextMainClass.setDocument(this.uiProperties.MAIN_CLASS_MODEL);
        this.jTextArgs.setDocument(this.uiProperties.ARUGMENTS_MODEL);
        this.jTextVMOptions.setDocument(this.uiProperties.VM_OPTIONS_MODEL);
        this.clientModuleUriCombo.setModel(this.uiProperties.CLIENT_MODULE_MODEL);
        this.jCheckBoxDeployOnSave.setModel(this.uiProperties.DEPLOY_ON_SAVE_MODEL);
        Profile j2eeProfile = this.uiProperties.getProject().getJ2eeProfile();
        if (j2eeProfile != null) {
            this.jTextFieldVersion.setText(j2eeProfile.getDisplayName());
        }
        this.setDeployOnSaveState();
        this.handleWebModuleRelated();
        this.initialized = true;
    }

    private void handleWebModuleRelated() {
        this.handleWebModuleRelated(this.isWebModuleSelected());
    }

    private void handleWebModuleRelated(Boolean isWebUri) {
        this.jCheckBoxDisplayBrowser.setEnabled(isWebUri);
        this.jLabelContextPathDesc.setEnabled(isWebUri);
        this.jLabelRelativeURL.setEnabled(isWebUri);
        this.jTextFieldRelativeURL.setEnabled(isWebUri);
    }

    private int getLongestVersionLength() {
        return Profile.JAVA_EE_6_FULL.getDisplayName().length();
    }

    private void initComponents() {
        this.jLabelContextPath = new JLabel();
        this.jLabelServer = new JLabel();
        this.jComboBoxServer = new JComboBox();
        this.clientModuleUriCombo = new JComboBox();
        this.webInfoPanel = new JPanel();
        this.jLabelContextPathDesc = new JLabel();
        this.jLabelRelativeURL = new JLabel();
        this.jTextFieldRelativeURL = new JTextField();
        this.jCheckBoxDisplayBrowser = new JCheckBox();
        this.clientInfoPanel = new JPanel();
        this.jLabelVMOptionsExample = new JLabel();
        this.jTextVMOptions = new JTextField();
        this.jLabelVMOptions = new JLabel();
        this.jLabelArgs = new JLabel();
        this.jLabelMainClass = new JLabel();
        this.jTextMainClass = new JTextField();
        this.jTextArgs = new JTextField();
        this.filler = new JLabel();
        this.jLabelVersion = new JLabel();
        this.jTextFieldVersion = new JTextField();
        this.jCheckBoxDeployOnSave = new JCheckBox();
        this.dosDescription = new JLabel();
        this.jLabelContextPath.setLabelFor(this.clientModuleUriCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabelContextPath, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_ClientModuleURI_JLabel"));
        this.jLabelServer.setLabelFor(this.jComboBoxServer);
        Mnemonics.setLocalizedText((JLabel)this.jLabelServer, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Server_JLabel"));
        this.jComboBoxServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.jComboBoxServerActionPerformed(evt);
            }
        });
        this.webInfoPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_WebModInfo")));
        Mnemonics.setLocalizedText((JLabel)this.jLabelContextPathDesc, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_ContextPathDesc_JLabel"));
        this.jLabelRelativeURL.setLabelFor(this.jTextFieldRelativeURL);
        Mnemonics.setLocalizedText((JLabel)this.jLabelRelativeURL, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_RelativeURL_JLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxDisplayBrowser, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_DisplayBrowser_JCheckBox"));
        this.jCheckBoxDisplayBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.jCheckBoxDisplayBrowserActionPerformed(evt);
            }
        });
        GroupLayout webInfoPanelLayout = new GroupLayout((Container)this.webInfoPanel);
        this.webInfoPanel.setLayout((LayoutManager)webInfoPanelLayout);
        webInfoPanelLayout.setHorizontalGroup((GroupLayout.Group)webInfoPanelLayout.createParallelGroup(1).add((GroupLayout.Group)webInfoPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)webInfoPanelLayout.createParallelGroup(1).add((Component)this.jCheckBoxDisplayBrowser).add((Component)this.jLabelContextPathDesc).add((GroupLayout.Group)webInfoPanelLayout.createSequentialGroup().add((Component)this.jLabelRelativeURL).addPreferredGap(0).add((Component)this.jTextFieldRelativeURL, -1, 514, Short.MAX_VALUE))).addContainerGap()));
        webInfoPanelLayout.setVerticalGroup((GroupLayout.Group)webInfoPanelLayout.createParallelGroup(1).add((GroupLayout.Group)webInfoPanelLayout.createSequentialGroup().add((Component)this.jCheckBoxDisplayBrowser).addPreferredGap(0).add((Component)this.jLabelContextPathDesc).addPreferredGap(0).add((GroupLayout.Group)webInfoPanelLayout.createParallelGroup(3).add((Component)this.jLabelRelativeURL).add((Component)this.jTextFieldRelativeURL, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextFieldRelativeURL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_RelativeURL_A11YDesc"));
        this.jCheckBoxDisplayBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_DisplayBrowser_A11YDesc"));
        this.clientInfoPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ClientInfo")));
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptionsExample, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_Example"));
        this.jLabelVMOptions.setLabelFor(this.jTextVMOptions);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptions, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options"));
        this.jLabelArgs.setLabelFor(this.jTextArgs);
        Mnemonics.setLocalizedText((JLabel)this.jLabelArgs, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Args_JLabel"));
        this.jLabelMainClass.setLabelFor(this.jTextMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JLabel"));
        GroupLayout clientInfoPanelLayout = new GroupLayout((Container)this.clientInfoPanel);
        this.clientInfoPanel.setLayout((LayoutManager)clientInfoPanelLayout);
        clientInfoPanelLayout.setHorizontalGroup((GroupLayout.Group)clientInfoPanelLayout.createParallelGroup(1).add((GroupLayout.Group)clientInfoPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)clientInfoPanelLayout.createParallelGroup(1, false).add((Component)this.jLabelMainClass).add((Component)this.jLabelArgs, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelVMOptions, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)clientInfoPanelLayout.createParallelGroup(1).add((Component)this.jLabelVMOptionsExample).add(2, (Component)this.jTextVMOptions, -1, 518, Short.MAX_VALUE).add(2, (Component)this.jTextArgs, -1, 518, Short.MAX_VALUE).add(2, (GroupLayout.Group)clientInfoPanelLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.jTextMainClass, -1, 518, Short.MAX_VALUE))).addContainerGap()));
        clientInfoPanelLayout.setVerticalGroup((GroupLayout.Group)clientInfoPanelLayout.createParallelGroup(1).add((GroupLayout.Group)clientInfoPanelLayout.createSequentialGroup().add((GroupLayout.Group)clientInfoPanelLayout.createParallelGroup(3).add((Component)this.jLabelMainClass).add((Component)this.jTextMainClass, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)clientInfoPanelLayout.createParallelGroup(3).add((Component)this.jTextArgs, -2, -1, -2).add((Component)this.jLabelArgs)).addPreferredGap(0).add((GroupLayout.Group)clientInfoPanelLayout.createParallelGroup(3).add((Component)this.jTextVMOptions, -2, -1, -2).add((Component)this.jLabelVMOptions)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabelVMOptionsExample)));
        this.jLabelVersion.setLabelFor(this.jTextFieldVersion);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVersion, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Version_JLabel"));
        this.jTextFieldVersion.setColumns(this.getLongestVersionLength());
        this.jTextFieldVersion.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxDeployOnSave, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_DeployOnSave_JCheckBox"));
        Mnemonics.setLocalizedText((JLabel)this.dosDescription, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_DeployOnSave_Description"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.filler).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelVersion).add((Component)this.jLabelContextPath).add((Component)this.jLabelServer)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.clientModuleUriCombo, 0, 530, Short.MAX_VALUE)).add((Component)this.jComboBoxServer, 0, 530, Short.MAX_VALUE).add((Component)this.jTextFieldVersion, -2, -1, -2))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((Component)this.dosDescription, -1, 623, Short.MAX_VALUE)).add((Component)this.jCheckBoxDeployOnSave))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.webInfoPanel, -1, -1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.clientInfoPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.filler).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelContextPath).add((Component)this.clientModuleUriCombo, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelServer).add((Component)this.jComboBoxServer, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelVersion).add((Component)this.jTextFieldVersion, -2, -1, -2)).add(7, 7, 7).add((Component)this.jCheckBoxDeployOnSave).addPreferredGap(0).add((Component)this.dosDescription).addPreferredGap(1).add((Component)this.webInfoPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.clientInfoPanel, -2, -1, -2).addContainerGap(126, Short.MAX_VALUE)));
        this.jComboBoxServer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_Server_A11YDesc"));
    }

    private void jCheckBoxDisplayBrowserActionPerformed(ActionEvent evt) {
        this.handleWebModuleRelated();
    }

    private void jComboBoxServerActionPerformed(ActionEvent evt) {
        this.setDeployOnSaveState();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private void setDeployOnSaveState() {
        if (this.uiProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem() != null) {
            String serverInstanceID = J2eePlatformUiSupport.getServerInstanceID((Object)this.uiProperties.J2EE_SERVER_INSTANCE_MODEL.getSelectedItem());
            J2eeModule module = this.uiProperties.getProject().getAppModule().getJ2eeModule();
            ServerInstance instance = Deployment.getDefault().getServerInstance(serverInstanceID);
            try {
                this.jCheckBoxDeployOnSave.setEnabled(instance.isDeployOnSaveSupported(module));
            }
            catch (InstanceRemovedException ex) {
                this.jCheckBoxDeployOnSave.setEnabled(false);
            }
        } else {
            this.jCheckBoxDeployOnSave.setEnabled(false);
        }
    }

    public static ApplicationUrisComboBoxModel createApplicationUrisComboBoxModel(EarProject project) {
        return new ApplicationUrisComboBoxModel(project);
    }

    public static final class ClientModuleItem
    implements Comparable {
        private String uri;
        private boolean appClient;

        public ClientModuleItem(String uri, boolean appClient) {
            assert (uri != null);
            this.uri = uri;
            this.appClient = appClient;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean isAppClient() {
            return this.appClient;
        }

        public String toString() {
            return this.uri;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ClientModuleItem)) {
                return false;
            }
            return this.uri.equals(((ClientModuleItem)obj).uri);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public int compareTo(Object obj) {
            if (obj == null || !(obj instanceof ClientModuleItem)) {
                return -1;
            }
            return this.uri.compareTo(((ClientModuleItem)obj).uri);
        }
    }

    public static final class ApplicationUrisComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private List<ClientModuleItem> values;
        private EarProject project;
        private ClientModuleItem selected;

        public ApplicationUrisComboBoxModel(EarProject project) {
            this.project = project;
            this.initValues(EarProjectProperties.getJarContentAdditional(project));
        }

        @Override
        public Object getElementAt(int index) {
            return this.values.get(index);
        }

        private boolean setSelectedItem(String clientModuleURI, String appClient) {
            if (clientModuleURI != null && this.values.contains(new ClientModuleItem(clientModuleURI, false))) {
                this.setSelectedItem(new ClientModuleItem(clientModuleURI, false));
                return true;
            }
            if (appClient != null && this.values.contains(new ClientModuleItem(appClient, true))) {
                this.setSelectedItem(new ClientModuleItem(appClient, true));
                return true;
            }
            return false;
        }

        public void storeSelectedItem(EditableProperties ep) {
            ClientModuleItem sel = (ClientModuleItem)this.getSelectedItem();
            if (sel == null) {
                ep.remove((Object)"app.client");
                ep.remove((Object)"client.module.uri");
            } else if (sel.isAppClient()) {
                ep.setProperty("app.client", sel.getUri());
                ep.setProperty("client.module.uri", ApplicationUrisComboBoxModel.getClientModuleUriForAppClient(this.project));
            } else {
                ep.remove((Object)"app.client");
                ep.setProperty("client.module.uri", sel.getUri());
            }
        }

        @Override
        public int getSize() {
            return this.values.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object obj) {
            this.selected = (ClientModuleItem)obj;
        }

        void refresh(List<ClassPathSupport.Item> list) {
            this.initValues(list);
            this.fireContentsChanged(this, 0, this.values.size());
        }

        private void initValues(List<ClassPathSupport.Item> list) {
            String appClient;
            TreeSet<ClientModuleItem> items = new TreeSet<ClientModuleItem>();
            for (Project p : EarProjectProperties.getApplicationSubprojects(list, J2eeModule.Type.WAR)) {
                items.add(new ClientModuleItem(ProjectUtils.getInformation((Project)p).getName(), false));
            }
            for (Project p : EarProjectProperties.getApplicationSubprojects(list, J2eeModule.Type.CAR)) {
                items.add(new ClientModuleItem(ProjectUtils.getInformation((Project)p).getName(), true));
            }
            this.values = new ArrayList<ClientModuleItem>(items);
            EditableProperties ep = this.project.getAntProjectHelper().getProperties("nbproject/project.properties");
            String clientModuleURI = ep.getProperty("client.module.uri");
            if (!this.setSelectedItem(clientModuleURI, appClient = ep.getProperty("app.client"))) {
                this.setSelectedItem(this.values.size() > 0 ? this.values.get(0) : null);
            }
        }

        private static String getClientModuleUriForAppClient(EarProject project) {
            String name = project.getAntProjectHelper().getProperties("nbproject/project.properties").getProperty("jar.name");
            if (name.endsWith(".ear")) {
                name = name.substring(0, name.length() - 4);
            }
            return name + "/${" + "app.client" + '}';
        }

        public static void moduleWasRemove(Project removedProject, EditableProperties props) {
            String name = ProjectUtils.getInformation((Project)removedProject).getName();
            if (name.equals(props.getProperty("app.client")) || name.equals(props.getProperty("client.module.uri"))) {
                props.remove((Object)"app.client");
                props.remove((Object)"client.module.uri");
            }
        }

        public static void initializeProperties(final EarProject project, final String warName, final String carName) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    try {
                        EditableProperties ep = project.getUpdateHelper().getProperties("nbproject/project.properties");
                        if (warName != null) {
                            ep.remove((Object)"app.client");
                            ep.setProperty("client.module.uri", warName);
                        } else if (carName != null) {
                            ep.setProperty("app.client", carName);
                            ep.setProperty("client.module.uri", ApplicationUrisComboBoxModel.getClientModuleUriForAppClient(project));
                        }
                        project.getUpdateHelper().putProperties("nbproject/project.properties", ep);
                        ProjectManager.getDefault().saveProject((Project)project);
                    }
                    catch (IOException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            });
        }
    }
}

