/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.actions;

import java.util.LinkedList;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.util.EarProjectUtil;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.actions.CookieAction;
import org.openide.util.lookup.Lookups;

public class AddModuleAction
extends CookieAction {
    private static final long serialVersionUID = 1L;
    private static final String FOLDER_ICON = "org/netbeans/modules/j2ee/earproject/ui/resources/folder.gif";
    private static final Class[] COOKIE_ARRAY = new Class[]{Project.class};

    public Class[] cookieClasses() {
        return COOKIE_ARRAY;
    }

    public int mode() {
        return 8;
    }

    public void performAction(Node[] activeNodes) {
        try {
            Project p = (Project)activeNodes[0].getLookup().lookup(Project.class);
            Project[] moduleProjects = this.getSelectedProjects(p.getProjectDirectory());
            EarProject ep = (EarProject)p.getLookup().lookup(EarProject.class);
            EarProjectProperties.addJ2eeSubprojects(ep, moduleProjects);
        }
        catch (UserCancelException userCancelException) {
            // empty catch block
        }
    }

    public String getName() {
        return NbBundle.getMessage(AddModuleAction.class, (String)"LBL_AddModuleAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private Project[] getSelectedProjects(FileObject projDir) throws UserCancelException {
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        LinkedList<FilterNode> moduleProjectNodes = new LinkedList<FilterNode>();
        for (int i = 0; i < allProjects.length; ++i) {
            if (!EarProjectUtil.isJavaEEModule(allProjects[i])) continue;
            LogicalViewProvider lvp = (LogicalViewProvider)allProjects[i].getLookup().lookup(LogicalViewProvider.class);
            Node mn = lvp.createLogicalView();
            FilterNode n = new FilterNode(mn, (Children)new FilterNode.Children(mn), Lookups.singleton((Object)allProjects[i]));
            moduleProjectNodes.add(n);
        }
        Children.Array children = new Children.Array();
        children.add(moduleProjectNodes.toArray(new Node[moduleProjectNodes.size()]));
        final AbstractNode root = new AbstractNode((Children)children);
        String moduleSelector = NbBundle.getMessage(AddModuleAction.class, (String)"LBL_ModuleSelectorTitle");
        Project parent = FileOwnerQuery.getOwner((FileObject)projDir);
        SubprojectProvider spp = (SubprojectProvider)parent.getLookup().lookup(SubprojectProvider.class);
        if (null != spp) {
            final Set s = spp.getSubprojects();
            NodeAcceptor na = new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodes) {
                    for (int i = 0; i < nodes.length; ++i) {
                        if (nodes[i].getParentNode() != root) {
                            return false;
                        }
                        Project p = (Project)nodes[i].getLookup().lookup(Project.class);
                        if (null == p) {
                            return false;
                        }
                        if (!s.contains(p)) continue;
                        return false;
                    }
                    return nodes.length > 0;
                }
            };
            root.setDisplayName(NbBundle.getMessage(AddModuleAction.class, (String)"LBL_J2EEModules"));
            root.setIconBaseWithExtension(FOLDER_ICON);
            Node[] selected = NodeOperation.getDefault().select(moduleSelector, root.getDisplayName(), (Node)root, na);
            Project[] modules = new Project[selected.length];
            for (int i = 0; i < modules.length; ++i) {
                modules[i] = (Project)selected[i].getLookup().lookup(Project.class);
            }
            return modules;
        }
        return new Project[0];
    }
}

