/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.ui.HostListRootNode;
import org.netbeans.modules.remote.ui.HostNode;
import org.netbeans.modules.remote.ui.SingleHostAction;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConnectAction
extends SingleHostAction {
    public String getName() {
        return NbBundle.getMessage(HostListRootNode.class, (String)"ConnectMenuItem");
    }

    @Override
    protected boolean enable(ExecutionEnvironment env) {
        return !ConnectionManager.getInstance().isConnectedTo(env);
    }

    @Override
    public boolean isVisible(Node node) {
        ExecutionEnvironment env = (ExecutionEnvironment)node.getLookup().lookup(ExecutionEnvironment.class);
        return env != null && env.isRemote();
    }

    @Override
    protected void performAction(final ExecutionEnvironment env, Node node) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ConnectAction.this.connect(env);
            }
        });
    }

    private void connect(ExecutionEnvironment env) {
        if (!ConnectionManager.getInstance().isConnectedTo(env)) {
            try {
                ConnectionManager.getInstance().connectTo(env);
                RemoteUtil.checkSetupAfterConnection(env);
            }
            catch (IOException ex) {
                this.conectionFailed(env, ex);
            }
            catch (CancellationException ex) {
                this.conectionFailed(env, ex);
            }
        }
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }

    private void conectionFailed(ExecutionEnvironment env, Exception e) {
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(HostNode.class, (String)"UnableToConnectMessage", (Object)RemoteUtil.getDisplayName(env), (Object)e.getMessage()));
    }
}

