/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.fs;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.remote.fs.RemoteCodeModelUtils;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.EnvUtils;
import org.netbeans.modules.remote.spi.FileSystemCacheProvider;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class CndFileSystemProviderImpl
extends CndFileSystemProvider
implements FileSystemProvider.DownloadListener {
    private static final boolean isWindows = Utilities.isWindows();
    private String cachePrefix;

    public CndFileSystemProviderImpl() {
        FileSystemProvider.addDownloadListener((FileSystemProvider.DownloadListener)this);
    }

    protected FileObject toFileObjectImpl(CharSequence absPath) {
        FileSystemAndString p = this.getFileSystemAndRemotePath(absPath);
        if (p == null) {
            return FileSystemProvider.urlToFileObject((String)((Object)absPath).toString());
        }
        return p.getFileObject();
    }

    protected FileObject toFileObjectImpl(File file) {
        return FileSystemProvider.fileToFileObject((File)file);
    }

    protected CharSequence fileObjectToUrlImpl(FileObject fileObject) {
        return FileSystemProvider.fileObjectToUrl((FileObject)fileObject);
    }

    protected CharSequence toUrlImpl(FSPath fsPath) {
        return FileSystemProvider.toUrl((FileSystem)fsPath.getFileSystem(), (String)fsPath.getPath());
    }

    protected CharSequence toUrlImpl(FileSystem fileSystem, CharSequence absPath) {
        return FileSystemProvider.toUrl((FileSystem)fileSystem, (String)((Object)absPath).toString());
    }

    protected CharSequence getCanonicalPathImpl(FileSystem fileSystem, CharSequence absPath) throws IOException {
        return FileSystemProvider.getCanonicalPath((FileSystem)fileSystem, (String)((Object)absPath).toString());
    }

    protected FileObject getCanonicalFileObjectImpl(FileObject fo) throws IOException {
        return FileSystemProvider.getCanonicalFileObject((FileObject)fo);
    }

    protected String getCanonicalPathImpl(FileObject fo) throws IOException {
        return FileSystemProvider.getCanonicalPath((FileObject)fo);
    }

    protected FileObject urlToFileObjectImpl(CharSequence url) {
        FileSystemAndString p = this.getFileSystemAndRemotePath(url);
        if (p == null) {
            return FileSystemProvider.urlToFileObject((String)((Object)url).toString());
        }
        return p.getFileObject();
    }

    protected CndFileSystemProvider.FileInfo[] getChildInfoImpl(CharSequence path) {
        FileSystemAndString p = this.getFileSystemAndRemotePath(path);
        if (p != null) {
            CndUtils.assertNotNull((Object)p.fileSystem, (String)"null file system");
            CndUtils.assertNotNull((Object)p.remotePath, (String)"null remote path");
            FileObject dirFO = p.getFileObject();
            if (dirFO == null) {
                return new CndFileSystemProvider.FileInfo[0];
            }
            FileObject[] children = dirFO.getChildren();
            CndFileSystemProvider.FileInfo[] result = new CndFileSystemProvider.FileInfo[children.length];
            for (int i = 0; i < children.length; ++i) {
                result[i] = new CndFileSystemProvider.FileInfo(((Object)path).toString() + '/' + children[i].getNameExt(), children[i].isFolder());
            }
            return result;
        }
        return null;
    }

    protected Boolean canReadImpl(CharSequence path) {
        FileSystemAndString p = this.getFileSystemAndRemotePath(path);
        if (p != null) {
            CndUtils.assertNotNull((Object)p.fileSystem, (String)"null file system");
            CndUtils.assertNotNull((Object)p.remotePath, (String)"null remote path");
            FileObject fo = p.getFileObject();
            return fo != null && fo.isValid() && fo.canRead();
        }
        return null;
    }

    protected Boolean existsImpl(CharSequence path) {
        FileSystemAndString p = this.getFileSystemAndRemotePath(path);
        if (p != null) {
            CndUtils.assertNotNull((Object)p.fileSystem, (String)"null file system");
            CndUtils.assertNotNull((Object)p.remotePath, (String)"null remote path");
            FileObject fo = p.getFileObject();
            return fo != null && fo.isValid();
        }
        return null;
    }

    private FileSystemAndString getFileSystemAndRemotePath(CharSequence path) {
        String prefix = this.getPrefix();
        if (prefix != null) {
            CharSequence rest;
            int slashPos;
            if (isWindows) {
                path = ((Object)path).toString().replace('\\', '/');
            }
            if (this.pathStartsWith(path, prefix) && (slashPos = CharSequenceUtils.indexOf((CharSequence)(rest = path.subSequence(prefix.length(), path.length())), (CharSequence)"/")) >= 0) {
                String envID = ((Object)rest.subSequence(0, slashPos)).toString();
                CharSequence remotePath = rest.subSequence(slashPos + 1, rest.length());
                ExecutionEnvironment env = CndFileSystemProviderImpl.getExecutionEnvironmentByEnvID(envID);
                if (env != null) {
                    FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
                    return new FileSystemAndString(fs, remotePath);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPrefix() {
        CndFileSystemProviderImpl cndFileSystemProviderImpl = this;
        synchronized (cndFileSystemProviderImpl) {
            String prefix;
            String cacheRoot;
            if (this.cachePrefix == null && (cacheRoot = FileSystemCacheProvider.getCacheRoot((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal())) != null && (prefix = new File(cacheRoot).getParent()) != null) {
                if (!(prefix = prefix.replace("\\", "/")).endsWith("/")) {
                    prefix = prefix + '/';
                }
                this.cachePrefix = prefix;
            }
        }
        return this.cachePrefix;
    }

    private boolean pathStartsWith(CharSequence path, CharSequence prefix) {
        if (CndFileUtils.isSystemCaseSensitive()) {
            return CharSequenceUtils.startsWith((CharSequence)path, (CharSequence)prefix);
        }
        return CharSequenceUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)prefix);
    }

    private static ExecutionEnvironment getExecutionEnvironmentByEnvID(String envID) {
        ExecutionEnvironment result = null;
        for (ExecutionEnvironment env : ServerList.getEnvironments()) {
            String user;
            String currHostID = EnvUtils.toHostID((ExecutionEnvironment)env);
            if (!envID.startsWith(currHostID) || envID.length() <= currHostID.length() || envID.charAt(currHostID.length()) != '_' || !(user = envID.substring(currHostID.length() + 1)).equals(env.getUser())) continue;
            return env;
        }
        return result;
    }

    public void postConnectDownloadFinished(ExecutionEnvironment env) {
        RemoteCodeModelUtils.scheduleReparse(env);
    }

    private static class FileSystemAndString {
        public final FileSystem fileSystem;
        public final CharSequence remotePath;

        public FileSystemAndString(FileSystem fs, CharSequence path) {
            this.fileSystem = fs;
            this.remotePath = path;
        }

        public FileObject getFileObject() {
            return this.fileSystem.findResource(((Object)this.remotePath).toString());
        }
    }
}

