/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerServer;

public class ThreadInfo {
    static final int MAX_EVENT_ENTRIES_IN_LOCAL_BUFFER = 500;
    static final int MAX_EVENT_SIZE = 17;
    static int evBufSize;
    static int evBufPosThreshold;
    static Thread[] profilerServerThreads;
    static int nProfilerServerThreads;
    static int nProfiledAppThreads;
    static ThreadInfo dummyThreadInfo;
    private static boolean profilingSuspended;
    private static ThreadInfo[] threadInfos;
    private static int threadInfosSize;
    private static int nThreads;
    private static boolean hasDeadThreads;
    private static ThreadInfo lastThreadInfo;
    Thread thread;
    byte[] evBuf;
    boolean inCallGraph;
    boolean sampleDue;
    int evBufDumpLastPos;
    int evBufPos;
    int inProfilingRuntimeMethod;
    int rootMethodStackDepth;
    int stackDepth;
    int threadId;
    long absEntryTime;
    long lastWaitStartTime;
    long threadEntryTime;
    private boolean initialized;

    private ThreadInfo(Thread thread) {
        this.thread = thread;
        this.inProfilingRuntimeMethod = 1;
        this.threadId = nThreads & 0xFFFF;
    }

    public final boolean isInCallGraph() {
        return this.inCallGraph;
    }

    public final Thread getThread() {
        return this.thread;
    }

    public final int getThreadId() {
        return this.threadId;
    }

    public static boolean isCurrentThreadProfilerServerThread() {
        return ThreadInfo.isProfilerServerThread(Thread.currentThread());
    }

    public static boolean isProfilerServerThread(Thread thread) {
        if (profilerServerThreads == null) {
            return false;
        }
        for (int i = 0; i < nProfilerServerThreads; ++i) {
            if (profilerServerThreads[i] != thread) continue;
            return true;
        }
        return false;
    }

    public static synchronized void addProfilerServerThread(Thread thread) {
        ThreadInfo.profilerServerThreads[ThreadInfo.nProfilerServerThreads++] = thread;
    }

    public static synchronized void clearProfilerServerThreads() {
        if (profilerServerThreads == null) {
            profilerServerThreads = new Thread[10];
        } else {
            for (int i = 0; i < nProfilerServerThreads; ++i) {
                ThreadInfo.profilerServerThreads[i] = null;
            }
            nProfilerServerThreads = 0;
        }
    }

    public static boolean profilingSuspended() {
        return profilingSuspended;
    }

    public static synchronized void removeProfilerServerThread(Thread thread) {
        if (profilerServerThreads == null) {
            return;
        }
        for (int i = 0; i < nProfilerServerThreads; ++i) {
            if (profilerServerThreads[i] != thread) continue;
            if (i == nProfilerServerThreads - 1) {
                ThreadInfo.profilerServerThreads[i] = null;
            } else {
                System.arraycopy(profilerServerThreads, i + 1, profilerServerThreads, i, nProfilerServerThreads - i - 1);
            }
            --nProfilerServerThreads;
            return;
        }
    }

    public static void resumeProfiling() {
        profilingSuspended = false;
    }

    public static void suspendProfiling() {
        profilingSuspended = true;
    }

    static byte[] getCurrentLivenessStatus() {
        ThreadInfo[] tis = threadInfos;
        int resLen = nThreads;
        byte[] res = new byte[resLen];
        for (int i = 0; i < tis.length; ++i) {
            ThreadInfo ti = tis[i];
            if (ti == null || ti.threadId >= resLen || ti.thread == null) continue;
            res[ti.threadId] = ti.thread.isAlive() ? (byte)1 : 0;
        }
        return res;
    }

    static void setDefaultEvBufParams() {
        evBufSize = 8500;
        evBufPosThreshold = evBufSize - 68 - 1;
        threadInfos = new ThreadInfo[1];
        threadInfosSize = 0;
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    final void initialize() {
        this.initialize(false);
    }

    final void initialize(boolean trackResultsAvailability) {
        ++this.inProfilingRuntimeMethod;
        if (!ThreadInfo.isProfilerServerThread(this.thread)) {
            if (trackResultsAvailability && nProfiledAppThreads == 0) {
                ProfilerServer.notifyClientOnResultsAvailability();
            }
            ++nProfiledAppThreads;
        }
        this.resetInternalState();
        this.initialized = true;
        --this.inProfilingRuntimeMethod;
    }

    final void useEventBuffer() {
        this.evBuf = new byte[evBufSize];
    }

    static int getNProfiledAppThreads() {
        return nProfiledAppThreads;
    }

    static void setSampleDueForAllThreads() {
        ThreadInfo[] tis = threadInfos;
        for (int i = 0; i < tis.length; ++i) {
            ThreadInfo ti = tis[i];
            if (ti == null) continue;
            ti.sampleDue = true;
        }
    }

    static ThreadInfo getThreadInfo() {
        Thread thread = Thread.currentThread();
        ThreadInfo ti = lastThreadInfo;
        if (ti.thread == thread) {
            return ti;
        }
        return ThreadInfo.getThreadInfo(thread);
    }

    static ThreadInfo getThreadInfo(Thread thread) {
        ThreadInfo ti = ThreadInfo.getThreadInfoOrNull(thread);
        if (ti == null) {
            ti = ThreadInfo.newThreadInfo(thread);
        }
        return ti;
    }

    static ThreadInfo[] getThreadInfos() {
        return threadInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void changeAllThreadsInProfRuntimeMethodStatus(int val) {
        ThreadInfo[] threadInfoArray = threadInfos;
        synchronized (threadInfos) {
            for (int i = 0; i < threadInfos.length; ++i) {
                ThreadInfo ti = threadInfos[i];
                if (!ti.inCallGraph) continue;
                ti.inProfilingRuntimeMethod += val;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetThreadInfoTable() {
        ThreadInfo[] oldTIs = threadInfos;
        ThreadInfo[] threadInfoArray = threadInfos;
        synchronized (threadInfos) {
            nProfiledAppThreads = 0;
            lastThreadInfo = dummyThreadInfo;
            for (int i = 0; i < oldTIs.length; ++i) {
                ThreadInfo ti = oldTIs[i];
                if (ti == null || ti.thread == null) {
                    oldTIs[i] = null;
                    continue;
                }
                ti.initialized = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void setEvBuf(byte[] buf) {
        this.evBuf = buf;
        evBufSize = buf.length;
        evBufPosThreshold = buf.length - 34 - 1;
    }

    static void releaseDeadThreads() {
        ThreadInfo[] tis = threadInfos;
        for (int i = 0; i < tis.length; ++i) {
            Thread t;
            ThreadInfo ti = tis[i];
            if (ti == null || (t = ti.thread) == null || t.isAlive()) continue;
            if (ti.evBuf != null) {
                if (ti.evBufPos > 0) {
                    ProfilerRuntimeCPU.copyLocalBuffer(ti);
                }
                ti.evBuf = null;
            }
            ti.thread = null;
            hasDeadThreads = true;
        }
    }

    private static int getThreadHashCode(Thread t) {
        return System.identityHashCode(t) & Integer.MAX_VALUE;
    }

    private static ThreadInfo getThreadInfoOrNull(Thread thread) {
        ThreadInfo ti;
        ThreadInfo[] tis = threadInfos;
        int capacity = tis.length;
        int pos = ThreadInfo.getThreadHashCode(thread) % capacity;
        while ((ti = tis[pos]) != null) {
            if (ti.thread == thread) {
                return ti;
            }
            pos = (pos + 1) % capacity;
        }
        return null;
    }

    private static void addThreadInfo(ThreadInfo res, Thread thread) {
        if (threadInfosSize >= threadInfos.length * 3 / 4) {
            ThreadInfo.rehash();
        }
        int capacity = threadInfos.length;
        int pos = ThreadInfo.getThreadHashCode(thread) % capacity;
        while (threadInfos[pos] != null) {
            pos = (pos + 1) % capacity;
        }
        ThreadInfo.threadInfos[pos] = res;
        ++threadInfosSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadInfo newThreadInfo(Thread thread) {
        ThreadInfo[] threadInfoArray = threadInfos;
        synchronized (threadInfos) {
            ThreadInfo ti = ThreadInfo.getThreadInfoOrNull(thread);
            if (ti != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ti;
            }
            ThreadInfo res = new ThreadInfo(thread);
            ++nThreads;
            ThreadInfo.addThreadInfo(res, thread);
            res.inProfilingRuntimeMethod = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return res;
        }
    }

    private static void rehash() {
        int capacity = hasDeadThreads ? threadInfos.length : threadInfos.length * 2 + 1;
        ThreadInfo[] newTIs = new ThreadInfo[capacity];
        int size = 0;
        for (int i = 0; i < threadInfos.length; ++i) {
            ThreadInfo ti = threadInfos[i];
            if (ti == null || ti.thread == null) continue;
            int pos = ThreadInfo.getThreadHashCode(ti.thread) % capacity;
            while (newTIs[pos] != null) {
                pos = (pos + 1) % capacity;
            }
            newTIs[pos] = ti;
            ++size;
        }
        threadInfos = newTIs;
        threadInfosSize = size;
        hasDeadThreads = false;
    }

    private void resetInternalState() {
        this.evBufDumpLastPos = 0;
        this.evBufPos = 0;
        this.threadEntryTime = 0L;
        this.lastWaitStartTime = 0L;
        this.absEntryTime = 0L;
        this.stackDepth = 0;
        this.rootMethodStackDepth = 0;
        this.sampleDue = false;
        this.inCallGraph = false;
        this.evBuf = null;
    }

    static {
        ThreadInfo.setDefaultEvBufParams();
        dummyThreadInfo = new ThreadInfo(null);
        profilingSuspended = false;
        threadInfos = new ThreadInfo[1];
        lastThreadInfo = dummyThreadInfo;
    }
}

