/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.dlg.AddIndexDialog;
import org.netbeans.modules.db.explorer.node.IndexListNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class AddIndexAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(AddIndexAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(AddIndexAction.class, (String)"AddIndex");
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = false;
        if (activatedNodes.length == 1) {
            IndexListNode node = (IndexListNode)((Object)activatedNodes[0].getLookup().lookup(IndexListNode.class));
            enabled = node != null;
        }
        return enabled;
    }

    protected void performAction(Node[] activatedNodes) {
        final IndexListNode node = (IndexListNode)((Object)activatedNodes[0].getLookup().lookup(IndexListNode.class));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                AddIndexAction.this.perform(node);
            }
        });
    }

    private void perform(final IndexListNode node) {
        try {
            DatabaseConnection dbConn = (DatabaseConnection)node.getLookup().lookup(DatabaseConnection.class);
            DatabaseConnector connector = dbConn.getConnector();
            String tablename = node.getTableName();
            String schemaName = node.getSchemaName();
            String catalogName = node.getCatalogName();
            if (schemaName == null) {
                schemaName = catalogName;
            }
            if (catalogName == null) {
                catalogName = schemaName;
            }
            Specification spec = connector.getDatabaseSpecification();
            DriverSpecification drvSpec = connector.getDriverSpecification(catalogName);
            ArrayList<Object> cols = new ArrayList<Object>(5);
            drvSpec.getColumns(tablename, "%");
            ResultSet rs = drvSpec.getResultSet();
            Map<Object, Object> rset = new HashMap();
            while (rs.next()) {
                rset = drvSpec.getRow();
                cols.add(rset.get(new Integer(4)));
                rset.clear();
            }
            rs.close();
            if (cols.isEmpty()) {
                throw new Exception(NbBundle.getMessage(AddIndexAction.class, (String)"EXC_NoUsableColumnInPlace"));
            }
            AddIndexDialog dlg = new AddIndexDialog(cols, spec, tablename, schemaName);
            dlg.setIndexName(tablename + "_idx");
            if (dlg.run()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        Object refreshNode = node.getParentNode();
                        if (refreshNode == null) {
                            refreshNode = node;
                        }
                        ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{refreshNode});
                    }
                });
            }
        }
        catch (Exception exc) {
            LOGGER.log(Level.INFO, exc.getLocalizedMessage(), exc);
            DbUtilities.reportError(NbBundle.getMessage(AddIndexAction.class, (String)"ERR_UnableToAddIndex"), exc.getMessage());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AddIndexAction.class);
    }
}

