/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.junit.output.AntSessionInfo;
import org.netbeans.modules.junit.output.JUnitOutputReader;
import org.netbeans.modules.junit.output.antutils.AntProject;
import org.netbeans.modules.junit.output.antutils.TestCounter;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class JUnitAntLogger
extends AntLogger {
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 3};
    public static final String TASK_JAVA = "java";
    public static final String TASK_JUNIT = "junit";
    private static final String[] INTERESTING_TASKS = new String[]{"java", "junit"};
    private static final String ANT_TEST_RUNNER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner";
    private static final String XML_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter";

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return INTERESTING_TASKS;
    }

    private static TestSession.SessionType detectSessionType(AntEvent event) {
        String taskName = event.getTaskName();
        if (taskName == null) {
            return null;
        }
        if (taskName.equals(TASK_JUNIT)) {
            return TestSession.SessionType.TEST;
        }
        if (taskName.equals(TASK_JAVA)) {
            TaskStructure taskStructure = event.getTaskStructure();
            String className = taskStructure.getAttribute("classname");
            if (className == null) {
                return null;
            }
            if ((className = event.evaluate(className)).equals("junit.textui.TestRunner") || className.startsWith("org.junit.runner.") || className.equals(ANT_TEST_RUNNER_CLASS_NAME)) {
                TaskStructure[] nestedElems;
                for (TaskStructure ts : nestedElems = taskStructure.getChildren()) {
                    if (!ts.getName().equals("jvmarg")) continue;
                    String a = ts.getAttribute("value");
                    if (a != null) {
                        if (!event.evaluate(a).equals("-Xdebug")) continue;
                        return TestSession.SessionType.DEBUG;
                    }
                    a = ts.getAttribute("line");
                    if (a == null) continue;
                    for (String part : JUnitAntLogger.parseCmdLine(event.evaluate(a))) {
                        if (!part.equals("-Xdebug")) continue;
                        return TestSession.SessionType.DEBUG;
                    }
                }
                return TestSession.SessionType.TEST;
            }
            return null;
        }
        assert (false) : "Unhandled task name";
        return null;
    }

    private static final List<String> parseCmdLine(String cmdLine) {
        if ((cmdLine = cmdLine.trim()).length() == 0) {
            return Collections.emptyList();
        }
        char[] chars = cmdLine.toCharArray();
        boolean simple = true;
        for (char c : chars) {
            if (c != ' ' && c != '\"' && c != '\'') continue;
            simple = false;
            break;
        }
        if (simple) {
            return Collections.singletonList(cmdLine);
        }
        ArrayList<String> result = new ArrayList<String>(4);
        StringBuilder buf = new StringBuilder(20);
        boolean stateBeforeWord = false;
        boolean stateAfterWord = true;
        int stateInSingleQuote = 2;
        int stateInDoubleQuote = 3;
        int state = 0;
        block7: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (state) {
                case 0: {
                    if (c == '\"') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '\'') {
                        state = 2;
                        continue block7;
                    }
                    if (c == ' ') continue block7;
                    buf.append(c);
                    state = 1;
                    continue block7;
                }
                case 3: {
                    if (c == '\"') {
                        state = 1;
                        continue block7;
                    }
                    buf.append(c);
                    continue block7;
                }
                case 2: {
                    if (c == '\'') {
                        state = 1;
                        continue block7;
                    }
                    buf.append(c);
                    continue block7;
                }
                case 1: {
                    if (c == '\"') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '\'') {
                        state = 2;
                        continue block7;
                    }
                    if (c != ' ') continue block7;
                    result.add(buf.toString());
                    buf = new StringBuilder(20);
                    state = 0;
                    continue block7;
                }
                default: {
                    assert (false);
                    continue block7;
                }
            }
        }
        assert (state != 0);
        result.add(buf.toString());
        return result;
    }

    private static boolean isTestSessionType(TestSession.SessionType sessionType) {
        return sessionType != null;
    }

    public boolean interestedInScript(File script, AntSession session) {
        return true;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent event) {
        if (this.isTestTaskRunning(event)) {
            if (event.getLogLevel() != 3) {
                this.getOutputReader(event).messageLogged(event);
            } else {
                this.getOutputReader(event).verboseMessageLogged(event);
            }
        }
    }

    private boolean isTestTaskRunning(AntEvent event) {
        return JUnitAntLogger.isTestSessionType(this.getSessionInfo(event.getSession()).getCurrentSessionType());
    }

    public void taskStarted(AntEvent event) {
        TestSession.SessionType sessionType = JUnitAntLogger.detectSessionType(event);
        if (JUnitAntLogger.isTestSessionType(sessionType)) {
            int testClassCount;
            AntSessionInfo sessionInfo = this.getSessionInfo(event.getSession());
            assert (!JUnitAntLogger.isTestSessionType(sessionInfo.getCurrentSessionType()));
            sessionInfo.setTimeOfTestTaskStart(System.currentTimeMillis());
            sessionInfo.setCurrentSessionType(sessionType);
            if (sessionInfo.getSessionType() == null) {
                sessionInfo.setSessionType(sessionType);
            }
            try {
                testClassCount = TestCounter.getTestClassCount(event);
            }
            catch (Exception ex) {
                testClassCount = 0;
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
            boolean hasXmlOutput = JUnitAntLogger.hasXmlOutput(event);
            this.getOutputReader(event).testTaskStarted(testClassCount, hasXmlOutput);
        }
    }

    public void taskFinished(AntEvent event) {
        AntSessionInfo sessionInfo = this.getSessionInfo(event.getSession());
        if (JUnitAntLogger.isTestSessionType(sessionInfo.getCurrentSessionType())) {
            this.getOutputReader(event).testTaskFinished();
            sessionInfo.setCurrentSessionType(null);
        }
    }

    public void buildFinished(AntEvent event) {
        AntSession session = event.getSession();
        AntSessionInfo sessionInfo = this.getSessionInfo(session);
        if (JUnitAntLogger.isTestSessionType(sessionInfo.getSessionType())) {
            this.getOutputReader(event).buildFinished(event);
        }
        session.putCustomData((AntLogger)this, null);
    }

    private JUnitOutputReader getOutputReader(AntEvent event) {
        assert (JUnitAntLogger.isTestSessionType(this.getSessionInfo(event.getSession()).getSessionType()));
        AntSession session = event.getSession();
        AntSessionInfo sessionInfo = this.getSessionInfo(session);
        JUnitOutputReader outputReader = sessionInfo.outputReader;
        if (outputReader == null) {
            String[] propsOfInterest;
            String projectDir = null;
            Project project = null;
            try {
                projectDir = event.getProperty("work.dir");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (projectDir == null) {
                    projectDir = event.getProperty("basedir");
                }
                if (projectDir != null && projectDir.length() != 0) {
                    File pd = new File(projectDir);
                    File f = FileUtil.normalizeFile((File)pd);
                    project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)f));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Properties props = new Properties();
            for (String prop : propsOfInterest = new String[]{"javac.includes", "classname", "methodname", "work.dir", "classpath", "platform.java"}) {
                String val = event.getProperty(prop);
                if (val == null) continue;
                props.setProperty(prop, val);
            }
            assert (project != null) : "See bug 187004:  project must not be null for projectDir=\"" + projectDir + "\"";
            sessionInfo.outputReader = outputReader = new JUnitOutputReader(session, sessionInfo, project, props);
        }
        return outputReader;
    }

    private AntSessionInfo getSessionInfo(AntSession session) {
        AntSessionInfo sessionInfo;
        Object o = session.getCustomData((AntLogger)this);
        assert (o == null || o instanceof AntSessionInfo);
        if (o != null) {
            sessionInfo = (AntSessionInfo)o;
        } else {
            sessionInfo = new AntSessionInfo();
            session.putCustomData((AntLogger)this, (Object)sessionInfo);
        }
        return sessionInfo;
    }

    private static boolean hasXmlOutput(AntEvent event) {
        String taskName = event.getTaskName();
        if (taskName.equals(TASK_JUNIT)) {
            return JUnitAntLogger.hasXmlOutputJunit(event);
        }
        if (taskName.equals(TASK_JAVA)) {
            return JUnitAntLogger.hasXmlOutputJava(event);
        }
        assert (false);
        return false;
    }

    private static boolean hasXmlOutputJunit(AntEvent event) {
        TaskStructure taskStruct = event.getTaskStructure();
        for (TaskStructure child : taskStruct.getChildren()) {
            String childName = child.getName();
            if (!childName.equals("formatter")) continue;
            String type = child.getAttribute("type");
            type = type != null ? event.evaluate(type) : null;
            String usefile = child.getAttribute("usefile");
            String string = usefile = usefile != null ? event.evaluate(usefile) : null;
            if (type == null || !type.equals("xml") || usefile == null || AntProject.toBoolean(usefile)) continue;
            String ifPropName = child.getAttribute("if");
            String unlessPropName = child.getAttribute("unless");
            if (ifPropName != null && event.getProperty(ifPropName) == null || unlessPropName != null && event.getProperty(unlessPropName) != null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasXmlOutputJava(AntEvent event) {
        TaskStructure taskStruct = event.getTaskStructure();
        String classname = taskStruct.getAttribute("classname");
        if (classname == null || !event.evaluate(classname).equals(ANT_TEST_RUNNER_CLASS_NAME)) {
            return false;
        }
        for (TaskStructure child : taskStruct.getChildren()) {
            String childName = child.getName();
            if (!childName.equals("arg")) continue;
            String argValue = child.getAttribute("value");
            if (argValue == null) {
                argValue = child.getAttribute("line");
            }
            if (argValue == null || !(argValue = event.evaluate(argValue)).equals("formatter=org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter")) continue;
            return true;
        }
        return false;
    }
}

