/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mozilla.nb.javascript.BaseFunction;
import org.mozilla.nb.javascript.Callable;
import org.mozilla.nb.javascript.ConstProperties;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.Function;
import org.mozilla.nb.javascript.FunctionObject;
import org.mozilla.nb.javascript.Kit;
import org.mozilla.nb.javascript.LazilyLoadedCtor;
import org.mozilla.nb.javascript.MemberBox;
import org.mozilla.nb.javascript.ObjToIntMap;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.Undefined;
import org.mozilla.nb.javascript.Wrapper;
import org.mozilla.nb.javascript.debug.DebuggableObject;

public abstract class ScriptableObject
implements Scriptable,
Serializable,
DebuggableObject,
ConstProperties {
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    public static final int UNINITIALIZED_CONST = 8;
    public static final int CONST = 13;
    private Scriptable prototypeObject;
    private Scriptable parentScopeObject;
    private static final Slot REMOVED = new Slot(null, 0, 1);
    private transient Slot[] slots;
    private int count;
    private transient Slot firstAdded;
    private transient Slot lastAdded;
    private transient Slot lastAccess = REMOVED;
    private volatile Map<Object, Object> associatedValues;
    private static final int SLOT_QUERY = 1;
    private static final int SLOT_MODIFY = 2;
    private static final int SLOT_REMOVE = 3;
    private static final int SLOT_MODIFY_GETTER_SETTER = 4;
    private static final int SLOT_MODIFY_CONST = 5;

    static void checkValidAttributes(int n) {
        if ((n & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    public ScriptableObject() {
    }

    public ScriptableObject(Scriptable scriptable, Scriptable scriptable2) {
        if (scriptable == null) {
            throw new IllegalArgumentException();
        }
        this.parentScopeObject = scriptable;
        this.prototypeObject = scriptable2;
    }

    @Override
    public abstract String getClassName();

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return null != this.getSlot(string, 0, 1);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return null != this.getSlot(null, n, 1);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        return this.getImpl(string, 0, scriptable);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        return this.getImpl(null, n, scriptable);
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        if (this.putImpl(string, 0, scriptable, object, 0)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        scriptable.put(string, scriptable, object);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (this.putImpl(null, n, scriptable, object, 0)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        scriptable.put(n, scriptable, object);
    }

    @Override
    public void delete(String string) {
        this.checkNotSealed(string, 0);
        this.accessSlot(string, 0, 3);
    }

    @Override
    public void delete(int n) {
        this.checkNotSealed(null, n);
        this.accessSlot(null, n, 3);
    }

    @Override
    public void putConst(String string, Scriptable scriptable, Object object) {
        if (this.putImpl(string, 0, scriptable, object, 1)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        if (scriptable instanceof ConstProperties) {
            ((ConstProperties)((Object)scriptable)).putConst(string, scriptable, object);
        } else {
            scriptable.put(string, scriptable, object);
        }
    }

    @Override
    public void defineConst(String string, Scriptable scriptable) {
        if (this.putImpl(string, 0, scriptable, Undefined.instance, 8)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        if (scriptable instanceof ConstProperties) {
            ((ConstProperties)((Object)scriptable)).defineConst(string, scriptable);
        }
    }

    @Override
    public boolean isConst(String string) {
        Slot slot = this.getSlot(string, 0, 1);
        if (slot == null) {
            return false;
        }
        return (slot.getAttributes() & 5) == 5;
    }

    public final int getAttributes(String string, Scriptable scriptable) {
        return this.getAttributes(string);
    }

    public final int getAttributes(int n, Scriptable scriptable) {
        return this.getAttributes(n);
    }

    public final void setAttributes(String string, Scriptable scriptable, int n) {
        this.setAttributes(string, n);
    }

    public void setAttributes(int n, Scriptable scriptable, int n2) {
        this.setAttributes(n, n2);
    }

    public int getAttributes(String string) {
        return this.findAttributeSlot(string, 0, 1).getAttributes();
    }

    public int getAttributes(int n) {
        return this.findAttributeSlot(null, n, 1).getAttributes();
    }

    public void setAttributes(String string, int n) {
        this.checkNotSealed(string, 0);
        this.findAttributeSlot(string, 0, 2).setAttributes(n);
    }

    public void setAttributes(int n, int n2) {
        this.checkNotSealed(null, n);
        this.findAttributeSlot(null, n, 2).setAttributes(n2);
    }

    public void setGetterOrSetter(String string, int n, Callable callable, boolean bl) {
        if (string != null && n != 0) {
            throw new IllegalArgumentException(string);
        }
        this.checkNotSealed(string, n);
        GetterSlot getterSlot = (GetterSlot)this.getSlot(string, n, 4);
        getterSlot.checkNotReadonly();
        if (bl) {
            getterSlot.setter = callable;
        } else {
            getterSlot.getter = callable;
        }
        getterSlot.value = Undefined.instance;
    }

    public Object getGetterOrSetter(String string, int n, boolean bl) {
        if (string != null && n != 0) {
            throw new IllegalArgumentException(string);
        }
        Slot slot = this.getSlot(string, n, 1);
        if (slot == null) {
            return null;
        }
        if (slot instanceof GetterSlot) {
            GetterSlot getterSlot = (GetterSlot)slot;
            Object object = bl ? getterSlot.setter : getterSlot.getter;
            return object != null ? object : Undefined.instance;
        }
        return Undefined.instance;
    }

    protected boolean isGetterOrSetter(String string, int n, boolean bl) {
        Slot slot = this.getSlot(string, n, 1);
        if (slot instanceof GetterSlot) {
            if (bl && ((GetterSlot)slot).setter != null) {
                return true;
            }
            if (!bl && ((GetterSlot)slot).getter != null) {
                return true;
            }
        }
        return false;
    }

    void addLazilyInitializedValue(String string, int n, LazilyLoadedCtor lazilyLoadedCtor, int n2) {
        if (string != null && n != 0) {
            throw new IllegalArgumentException(string);
        }
        this.checkNotSealed(string, n);
        GetterSlot getterSlot = (GetterSlot)this.getSlot(string, n, 4);
        getterSlot.setAttributes(n2);
        getterSlot.getter = null;
        getterSlot.setter = null;
        getterSlot.value = lazilyLoadedCtor;
    }

    @Override
    public Scriptable getPrototype() {
        return this.prototypeObject;
    }

    @Override
    public void setPrototype(Scriptable scriptable) {
        this.prototypeObject = scriptable;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parentScopeObject;
    }

    @Override
    public void setParentScope(Scriptable scriptable) {
        this.parentScopeObject = scriptable;
    }

    @Override
    public Object[] getIds() {
        return this.getIds(false);
    }

    @Override
    public Object[] getAllIds() {
        return this.getIds(true);
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return ScriptableObject.getDefaultValue(this, clazz);
    }

    public static Object getDefaultValue(Scriptable scriptable, Class<?> clazz) {
        Context context = null;
        for (int i = 0; i < 2; ++i) {
            Object object;
            Object object2;
            Object[] objectArray;
            String string;
            boolean bl;
            if (clazz == ScriptRuntime.StringClass) {
                bl = i == 0;
            } else {
                boolean bl2 = bl = i == 1;
            }
            if (bl) {
                string = "toString";
                objectArray = ScriptRuntime.emptyArgs;
            } else {
                string = "valueOf";
                objectArray = new Object[1];
                if (clazz == null) {
                    object2 = "undefined";
                } else if (clazz == ScriptRuntime.StringClass) {
                    object2 = "string";
                } else if (clazz == ScriptRuntime.ScriptableClass) {
                    object2 = "object";
                } else if (clazz == ScriptRuntime.FunctionClass) {
                    object2 = "function";
                } else if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
                    object2 = "boolean";
                } else if (clazz == ScriptRuntime.NumberClass || clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE || clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE || clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE || clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
                    object2 = "number";
                } else {
                    throw Context.reportRuntimeError1("msg.invalid.type", clazz.toString());
                }
                objectArray[0] = object2;
            }
            object2 = ScriptableObject.getProperty(scriptable, string);
            if (!(object2 instanceof Function)) continue;
            Function function = (Function)object2;
            if (context == null) {
                context = Context.getContext();
            }
            if ((object2 = function.call(context, function.getParentScope(), scriptable, objectArray)) == null) continue;
            if (!(object2 instanceof Scriptable)) {
                return object2;
            }
            if (clazz == ScriptRuntime.ScriptableClass || clazz == ScriptRuntime.FunctionClass) {
                return object2;
            }
            if (!bl || !(object2 instanceof Wrapper) || !((object = ((Wrapper)object2).unwrap()) instanceof String)) continue;
            return object;
        }
        String string = clazz == null ? "undefined" : clazz.getName();
        throw ScriptRuntime.typeError1("msg.default.value", string);
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        return ScriptRuntime.jsDelegatesTo(scriptable, this);
    }

    public boolean avoidObjectDetection() {
        return false;
    }

    protected Object equivalentValues(Object object) {
        return this == object ? Boolean.TRUE : Scriptable.NOT_FOUND;
    }

    public static <T extends Scriptable> void defineClass(Scriptable scriptable, Class<T> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scriptable, clazz, false, false);
    }

    public static <T extends Scriptable> void defineClass(Scriptable scriptable, Class<T> clazz, boolean bl) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scriptable, clazz, bl, false);
    }

    public static <T extends Scriptable> String defineClass(Scriptable scriptable, Class<T> clazz, boolean bl, boolean bl2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        BaseFunction baseFunction = ScriptableObject.buildClassCtor(scriptable, clazz, bl, bl2);
        if (baseFunction == null) {
            return null;
        }
        String string = baseFunction.getClassPrototype().getClassName();
        ScriptableObject.defineProperty(scriptable, string, baseFunction, 2);
        return string;
    }

    static <T extends Scriptable> BaseFunction buildClassCtor(Scriptable scriptable, Class<T> clazz, boolean bl, boolean bl2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        FunctionObject functionObject;
        Class<T> clazz2;
        String string;
        Class<T> clazz3;
        Executable executable;
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            executable = methodArray[i];
            if (!((Method)executable).getName().equals("init")) continue;
            Class<?>[] classArray = ((Method)executable).getParameterTypes();
            if (classArray.length == 3 && classArray[0] == ScriptRuntime.ContextClass && classArray[1] == ScriptRuntime.ScriptableClass && classArray[2] == Boolean.TYPE && Modifier.isStatic(((Method)executable).getModifiers())) {
                Object[] objectArray = new Object[]{Context.getContext(), scriptable, bl ? Boolean.TRUE : Boolean.FALSE};
                ((Method)executable).invoke(null, objectArray);
                return null;
            }
            if (classArray.length != 1 || classArray[0] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(((Method)executable).getModifiers())) continue;
            Object[] objectArray = new Object[]{scriptable};
            ((Method)executable).invoke(null, objectArray);
            return null;
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        executable = null;
        for (int i = 0; i < constructorArray.length; ++i) {
            if (constructorArray[i].getParameterTypes().length != 0) continue;
            executable = constructorArray[i];
            break;
        }
        if (executable == null) {
            throw Context.reportRuntimeError1("msg.zero.arg.ctor", clazz.getName());
        }
        Scriptable scriptable2 = (Scriptable)((Constructor)executable).newInstance(ScriptRuntime.emptyArgs);
        String string2 = scriptable2.getClassName();
        Scriptable scriptable3 = null;
        if (bl2 && ScriptRuntime.ScriptableClass.isAssignableFrom(clazz3 = clazz.getSuperclass()) && !Modifier.isAbstract(clazz3.getModifiers()) && (string = ScriptableObject.defineClass(scriptable, clazz2 = ScriptableObject.extendsScriptable(clazz3), bl, bl2)) != null) {
            scriptable3 = ScriptableObject.getClassPrototype(scriptable, string);
        }
        if (scriptable3 == null) {
            scriptable3 = ScriptableObject.getObjectPrototype(scriptable);
        }
        scriptable2.setPrototype(scriptable3);
        Executable executable2 = FunctionObject.findSingleMethod(methodArray, "jsConstructor");
        if (executable2 == null) {
            if (constructorArray.length == 1) {
                executable2 = constructorArray[0];
            } else if (constructorArray.length == 2) {
                if (constructorArray[0].getParameterTypes().length == 0) {
                    executable2 = constructorArray[1];
                } else if (constructorArray[1].getParameterTypes().length == 0) {
                    executable2 = constructorArray[0];
                }
            }
            if (executable2 == null) {
                throw Context.reportRuntimeError1("msg.ctor.multiple.parms", clazz.getName());
            }
        }
        if ((functionObject = new FunctionObject(string2, executable2, scriptable)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", executable2.getName());
        }
        functionObject.initAsConstructor(scriptable, scriptable2);
        Method method = null;
        HashSet<String> hashSet = new HashSet<String>(methodArray.length);
        for (int i = 0; i < methodArray.length; ++i) {
            Object object;
            Object object2;
            if (methodArray[i] == executable2) continue;
            String string3 = methodArray[i].getName();
            if (string3.equals("finishInit") && ((Class<?>[])(object2 = methodArray[i].getParameterTypes())).length == 3 && object2[0] == ScriptRuntime.ScriptableClass && object2[1] == FunctionObject.class && object2[2] == ScriptRuntime.ScriptableClass && Modifier.isStatic(methodArray[i].getModifiers())) {
                method = methodArray[i];
                continue;
            }
            if (string3.indexOf(36) != -1 || string3.equals("jsConstructor")) continue;
            object2 = null;
            if (string3.startsWith("jsFunction_")) {
                object2 = "jsFunction_";
            } else if (string3.startsWith("jsStaticFunction_")) {
                object2 = "jsStaticFunction_";
                if (!Modifier.isStatic(methodArray[i].getModifiers())) {
                    throw Context.reportRuntimeError("jsStaticFunction must be used with static method.");
                }
            } else {
                if (!string3.startsWith("jsGet_")) continue;
                object2 = "jsGet_";
            }
            String string4 = string3.substring(((String)object2).length());
            if (hashSet.contains(string4)) {
                throw Context.reportRuntimeError2("duplicate.defineClass.name", string3, string4);
            }
            hashSet.add(string4);
            string3 = string3.substring(((String)object2).length());
            if (object2 == "jsGet_") {
                if (!(scriptable2 instanceof ScriptableObject)) {
                    throw Context.reportRuntimeError2("msg.extend.scriptable", scriptable2.getClass().toString(), string3);
                }
                object = FunctionObject.findSingleMethod(methodArray, "jsSet_" + string3);
                int n = 6 | (object != null ? 0 : 1);
                ((ScriptableObject)scriptable2).defineProperty(string3, null, methodArray[i], (Method)object, n);
                continue;
            }
            object = new FunctionObject(string3, methodArray[i], scriptable2);
            if (((FunctionObject)object).isVarArgsConstructor()) {
                throw Context.reportRuntimeError1("msg.varargs.fun", executable2.getName());
            }
            Scriptable scriptable4 = object2 == "jsStaticFunction_" ? functionObject : scriptable2;
            ScriptableObject.defineProperty(scriptable4, string3, object, 2);
            if (!bl) continue;
            ((ScriptableObject)object).sealObject();
        }
        if (method != null) {
            Object[] objectArray = new Object[]{scriptable, functionObject, scriptable2};
            method.invoke(null, objectArray);
        }
        if (bl) {
            functionObject.sealObject();
            if (scriptable2 instanceof ScriptableObject) {
                ((ScriptableObject)scriptable2).sealObject();
            }
        }
        return functionObject;
    }

    private static <T extends Scriptable> Class<T> extendsScriptable(Class<?> clazz) {
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(clazz)) {
            return clazz;
        }
        return null;
    }

    public void defineProperty(String string, Object object, int n) {
        this.checkNotSealed(string, 0);
        this.put(string, (Scriptable)this, object);
        this.setAttributes(string, n);
    }

    public static void defineProperty(Scriptable scriptable, String string, Object object, int n) {
        if (!(scriptable instanceof ScriptableObject)) {
            scriptable.put(string, scriptable, object);
            return;
        }
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        scriptableObject.defineProperty(string, object, n);
    }

    public static void defineConstProperty(Scriptable scriptable, String string) {
        if (scriptable instanceof ConstProperties) {
            ConstProperties constProperties = (ConstProperties)((Object)scriptable);
            constProperties.defineConst(string, scriptable);
        } else {
            ScriptableObject.defineProperty(scriptable, string, Undefined.instance, 13);
        }
    }

    public void defineProperty(String string, Class<?> clazz, int n) {
        int n2 = string.length();
        if (n2 == 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[3 + n2];
        string.getChars(0, n2, cArray, 3);
        cArray[3] = Character.toUpperCase(cArray[3]);
        cArray[0] = 103;
        cArray[1] = 101;
        cArray[2] = 116;
        String string2 = new String(cArray);
        cArray[0] = 115;
        String string3 = new String(cArray);
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        Method method = FunctionObject.findSingleMethod(methodArray, string2);
        Method method2 = FunctionObject.findSingleMethod(methodArray, string3);
        if (method2 == null) {
            n |= 1;
        }
        this.defineProperty(string, null, method, method2 == null ? null : method2, n);
    }

    public void defineProperty(String string, Object object, Method method, Method method2, int n) {
        Object object2;
        Object object3;
        MemberBox memberBox = null;
        if (method != null) {
            boolean bl;
            memberBox = new MemberBox(method);
            if (!Modifier.isStatic(method.getModifiers())) {
                bl = object != null;
                memberBox.delegateTo = object;
            } else {
                bl = true;
                memberBox.delegateTo = Void.TYPE;
            }
            String string2 = null;
            object3 = method.getParameterTypes();
            if (((Class<?>[])object3).length == 0) {
                if (bl) {
                    string2 = "msg.obj.getter.parms";
                }
            } else if (((Class<?>[])object3).length == 1) {
                object2 = object3[0];
                if (object2 != ScriptRuntime.ScriptableClass && object2 != ScriptRuntime.ScriptableObjectClass) {
                    string2 = "msg.bad.getter.parms";
                } else if (!bl) {
                    string2 = "msg.bad.getter.parms";
                }
            } else {
                string2 = "msg.bad.getter.parms";
            }
            if (string2 != null) {
                throw Context.reportRuntimeError1(string2, method.toString());
            }
        }
        MemberBox memberBox2 = null;
        if (method2 != null) {
            boolean bl;
            if (method2.getReturnType() != Void.TYPE) {
                throw Context.reportRuntimeError1("msg.setter.return", method2.toString());
            }
            memberBox2 = new MemberBox(method2);
            if (!Modifier.isStatic(method2.getModifiers())) {
                bl = object != null;
                memberBox2.delegateTo = object;
            } else {
                bl = true;
                memberBox2.delegateTo = Void.TYPE;
            }
            object3 = null;
            object2 = method2.getParameterTypes();
            if (((Class<?>[])object2).length == 1) {
                if (bl) {
                    object3 = "msg.setter2.expected";
                }
            } else if (((Class<?>[])object2).length == 2) {
                Class<?> clazz = object2[0];
                if (clazz != ScriptRuntime.ScriptableClass && clazz != ScriptRuntime.ScriptableObjectClass) {
                    object3 = "msg.setter2.parms";
                } else if (!bl) {
                    object3 = "msg.setter1.parms";
                }
            } else {
                object3 = "msg.setter.parms";
            }
            if (object3 != null) {
                throw Context.reportRuntimeError1(object3, method2.toString());
            }
        }
        GetterSlot getterSlot = (GetterSlot)this.getSlot(string, 0, 4);
        getterSlot.setAttributes(n);
        getterSlot.getter = memberBox;
        getterSlot.setter = memberBox2;
    }

    public void defineFunctionProperties(String[] stringArray, Class<?> clazz, int n) {
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Method method = FunctionObject.findSingleMethod(methodArray, string);
            if (method == null) {
                throw Context.reportRuntimeError2("msg.method.not.found", string, clazz.getName());
            }
            FunctionObject functionObject = new FunctionObject(string, method, this);
            this.defineProperty(string, functionObject, n);
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Object");
    }

    public static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Function");
    }

    public static Scriptable getClassPrototype(Scriptable scriptable, String string) {
        Object object;
        Object object2 = ScriptableObject.getProperty(scriptable = ScriptableObject.getTopLevelScope(scriptable), string);
        if (object2 instanceof BaseFunction) {
            object = ((BaseFunction)object2).getPrototypeProperty();
        } else if (object2 instanceof Scriptable) {
            Scriptable scriptable2 = (Scriptable)object2;
            object = scriptable2.get("prototype", scriptable2);
        } else {
            return null;
        }
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return null;
    }

    public static Scriptable getTopLevelScope(Scriptable scriptable) {
        Scriptable scriptable2;
        while ((scriptable2 = scriptable.getParentScope()) != null) {
            scriptable = scriptable2;
        }
        return scriptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sealObject() {
        if (this.count >= 0) {
            Slot slot = this.firstAdded;
            while (slot != null) {
                if (slot.value instanceof LazilyLoadedCtor) {
                    LazilyLoadedCtor lazilyLoadedCtor = (LazilyLoadedCtor)slot.value;
                    try {
                        lazilyLoadedCtor.init();
                    }
                    finally {
                        slot.value = lazilyLoadedCtor.getValue();
                    }
                }
                slot = slot.orderedNext;
            }
            this.count ^= 0xFFFFFFFF;
        }
    }

    public final boolean isSealed() {
        return this.count < 0;
    }

    private void checkNotSealed(String string, int n) {
        if (!this.isSealed()) {
            return;
        }
        String string2 = string != null ? string : Integer.toString(n);
        throw Context.reportRuntimeError1("msg.modify.sealed", string2);
    }

    public static Object getProperty(Scriptable scriptable, String string) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(string, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static Object getProperty(Scriptable scriptable, int n) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(n, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static boolean hasProperty(Scriptable scriptable, String string) {
        return null != ScriptableObject.getBase(scriptable, string);
    }

    public static void redefineProperty(Scriptable scriptable, String string, boolean bl) {
        ConstProperties constProperties;
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            return;
        }
        if (scriptable2 instanceof ConstProperties && (constProperties = (ConstProperties)((Object)scriptable2)).isConst(string)) {
            throw Context.reportRuntimeError1("msg.const.redecl", string);
        }
        if (bl) {
            throw Context.reportRuntimeError1("msg.var.redecl", string);
        }
    }

    public static boolean hasProperty(Scriptable scriptable, int n) {
        return null != ScriptableObject.getBase(scriptable, n);
    }

    public static void putProperty(Scriptable scriptable, String string, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(string, scriptable, object);
    }

    public static void putConstProperty(Scriptable scriptable, String string, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        if (scriptable2 instanceof ConstProperties) {
            ((ConstProperties)((Object)scriptable2)).putConst(string, scriptable, object);
        }
    }

    public static void putProperty(Scriptable scriptable, int n, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(n, scriptable, object);
    }

    public static boolean deleteProperty(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(string);
        return !scriptable2.has(string, scriptable);
    }

    public static boolean deleteProperty(Scriptable scriptable, int n) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(n);
        return !scriptable2.has(n, scriptable);
    }

    public static Object[] getPropertyIds(Scriptable scriptable) {
        if (scriptable == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray = scriptable.getIds();
        ObjToIntMap objToIntMap = null;
        while ((scriptable = scriptable.getPrototype()) != null) {
            int n;
            Object[] objectArray2 = scriptable.getIds();
            if (objectArray2.length == 0) continue;
            if (objToIntMap == null) {
                if (objectArray.length == 0) {
                    objectArray = objectArray2;
                    continue;
                }
                objToIntMap = new ObjToIntMap(objectArray.length + objectArray2.length);
                for (n = 0; n != objectArray.length; ++n) {
                    objToIntMap.intern(objectArray[n]);
                }
                objectArray = null;
            }
            for (n = 0; n != objectArray2.length; ++n) {
                objToIntMap.intern(objectArray2[n]);
            }
        }
        if (objToIntMap != null) {
            objectArray = objToIntMap.getKeys();
        }
        return objectArray;
    }

    public static Object callMethod(Scriptable scriptable, String string, Object[] objectArray) {
        return ScriptableObject.callMethod(null, scriptable, string, objectArray);
    }

    public static Object callMethod(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (!(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(scriptable, string);
        }
        Function function = (Function)object;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        if (context != null) {
            return function.call(context, scriptable2, scriptable, objectArray);
        }
        return Context.call(null, function, scriptable2, scriptable, objectArray);
    }

    private static Scriptable getBase(Scriptable scriptable, String string) {
        while (!scriptable.has(string, scriptable) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    private static Scriptable getBase(Scriptable scriptable, int n) {
        while (!scriptable.has(n, scriptable) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    public final Object getAssociatedValue(Object object) {
        Map<Object, Object> map = this.associatedValues;
        if (map == null) {
            return null;
        }
        return map.get(object);
    }

    public static Object getTopScopeValue(Scriptable scriptable, Object object) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        do {
            ScriptableObject scriptableObject;
            Object object2;
            if (!(scriptable instanceof ScriptableObject) || (object2 = (scriptableObject = (ScriptableObject)scriptable).getAssociatedValue(object)) == null) continue;
            return object2;
        } while ((scriptable = scriptable.getPrototype()) != null);
        return null;
    }

    public final synchronized Object associateValue(Object object, Object object2) {
        if (object2 == null) {
            throw new IllegalArgumentException();
        }
        Map<Object, Object> map = this.associatedValues;
        if (map == null && (map = this.associatedValues) == null) {
            this.associatedValues = map = new HashMap<Object, Object>();
        }
        return Kit.initHash(map, object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getImpl(String string, int n, Scriptable scriptable) {
        Slot slot = this.getSlot(string, n, 1);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        if (!(slot instanceof GetterSlot)) {
            return slot.value;
        }
        Object object = ((GetterSlot)slot).getter;
        if (object != null) {
            if (object instanceof MemberBox) {
                Object[] objectArray;
                Object object2;
                MemberBox memberBox = (MemberBox)object;
                if (memberBox.delegateTo == null) {
                    object2 = scriptable;
                    objectArray = ScriptRuntime.emptyArgs;
                } else {
                    object2 = memberBox.delegateTo;
                    objectArray = new Object[]{scriptable};
                }
                return memberBox.invoke(object2, objectArray);
            }
            Function function = (Function)object;
            Context context = Context.getContext();
            return function.call(context, function.getParentScope(), scriptable, ScriptRuntime.emptyArgs);
        }
        Object object3 = slot.value;
        if (object3 instanceof LazilyLoadedCtor) {
            LazilyLoadedCtor lazilyLoadedCtor = (LazilyLoadedCtor)object3;
            try {
                lazilyLoadedCtor.init();
            }
            finally {
                slot.value = object3 = lazilyLoadedCtor.getValue();
            }
        }
        return object3;
    }

    private boolean putImpl(String string, int n, Scriptable scriptable, Object object, int n2) {
        Slot slot;
        if (this != scriptable) {
            slot = this.getSlot(string, n, 1);
            if (slot == null) {
                return false;
            }
        } else {
            this.checkNotSealed(string, n);
            if (n2 != 0) {
                Slot slot2 = this.getSlot(string, n, 5);
                int n3 = slot2.getAttributes();
                if ((n3 & 1) == 0) {
                    throw Context.reportRuntimeError1("msg.var.redecl", string);
                }
                if ((n3 & 8) != 0) {
                    slot2.value = object;
                    if (n2 != 8) {
                        slot2.setAttributes(n3 & 0xFFFFFFF7);
                    }
                }
                return true;
            }
            slot = this.getSlot(string, n, 2);
        }
        if ((slot.getAttributes() & 1) != 0) {
            return true;
        }
        if (slot instanceof GetterSlot) {
            Object object2 = ((GetterSlot)slot).setter;
            if (object2 == null) {
                ((GetterSlot)slot).getter = null;
            } else {
                Context context = Context.getContext();
                if (object2 instanceof MemberBox) {
                    Object[] objectArray;
                    Object object3;
                    MemberBox memberBox = (MemberBox)object2;
                    Class<?>[] classArray = memberBox.argTypes;
                    Class<?> clazz = classArray[classArray.length - 1];
                    int n4 = FunctionObject.getTypeTag(clazz);
                    Object object4 = FunctionObject.convertArg(context, scriptable, object, n4);
                    if (memberBox.delegateTo == null) {
                        object3 = scriptable;
                        objectArray = new Object[]{object4};
                    } else {
                        object3 = memberBox.delegateTo;
                        objectArray = new Object[]{scriptable, object4};
                    }
                    memberBox.invoke(object3, objectArray);
                } else {
                    Function function = (Function)object2;
                    function.call(context, function.getParentScope(), scriptable, new Object[]{object});
                }
                return true;
            }
        }
        if (this == scriptable) {
            slot.value = object;
            return true;
        }
        return false;
    }

    private Slot findAttributeSlot(String string, int n, int n2) {
        Slot slot = this.getSlot(string, n, n2);
        if (slot == null) {
            String string2 = string != null ? string : Integer.toString(n);
            throw Context.reportRuntimeError1("msg.prop.not.found", string2);
        }
        return slot;
    }

    private Slot getSlot(String string, int n, int n2) {
        Slot slot = this.lastAccess;
        if (!(string == null ? slot.name != null || n != slot.indexOrHash : string != slot.name)) {
            if (!slot.wasDeleted && (n2 != 4 || slot instanceof GetterSlot)) {
                return slot;
            }
        }
        if ((slot = this.accessSlot(string, n, n2)) != null) {
            this.lastAccess = slot;
        }
        return slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Slot accessSlot(String string, int n, int n2) {
        int n3;
        int n4 = n3 = string != null ? string.hashCode() : n;
        if (n2 == 1 || n2 == 2 || n2 == 5 || n2 == 4) {
            Object object;
            int n5;
            Slot[] slotArray = this.slots;
            if (slotArray == null) {
                if (n2 == 1) {
                    return null;
                }
            } else {
                int n6 = slotArray.length;
                n5 = ScriptableObject.getSlotIndex(n6, n3);
                Slot slot = slotArray[n5];
                while (slot != null) {
                    object = slot.name;
                    if (object != null) {
                        if (object == string) break;
                        if (string != null && n3 == slot.indexOrHash && string.equals(object)) {
                            slot.name = string;
                            break;
                        }
                    } else if (string == null && n3 == slot.indexOrHash) break;
                    slot = slot.next;
                }
                if (n2 == 1) {
                    return slot;
                }
                if (n2 == 2 ? slot != null : (n2 == 4 ? slot instanceof GetterSlot : n2 == 5 && slot != null)) {
                    return slot;
                }
            }
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                Slot slot;
                slotArray = this.slots;
                if (this.count == 0) {
                    slotArray = new Slot[5];
                    this.slots = slotArray;
                    n5 = ScriptableObject.getSlotIndex(slotArray.length, n3);
                } else {
                    int n7 = slotArray.length;
                    n5 = ScriptableObject.getSlotIndex(n7, n3);
                    Object object2 = object = slotArray[n5];
                    while (!(object2 == null || ((Slot)object2).indexOrHash == n3 && (((Slot)object2).name == string || string != null && string.equals(((Slot)object2).name)))) {
                        object = object2;
                        object2 = ((Slot)object2).next;
                    }
                    if (object2 != null) {
                        if (n2 == 4 && !(object2 instanceof GetterSlot)) {
                            GetterSlot getterSlot = new GetterSlot(string, n3, ((Slot)object2).getAttributes());
                            getterSlot.value = ((Slot)object2).value;
                            getterSlot.next = ((Slot)object2).next;
                            if (this.lastAdded != null) {
                                this.lastAdded.orderedNext = getterSlot;
                            }
                            if (this.firstAdded == null) {
                                this.firstAdded = getterSlot;
                            }
                            this.lastAdded = getterSlot;
                            if (object == object2) {
                                slotArray[n5] = getterSlot;
                            } else {
                                ((Slot)object).next = getterSlot;
                            }
                            ((Slot)object2).wasDeleted = true;
                            ((Slot)object2).value = null;
                            ((Slot)object2).name = null;
                            if (object2 == this.lastAccess) {
                                this.lastAccess = REMOVED;
                            }
                            object2 = getterSlot;
                        } else if (n2 == 5) {
                            return null;
                        }
                        return object2;
                    }
                    if (4 * (this.count + 1) > 3 * slotArray.length) {
                        slotArray = new Slot[slotArray.length * 2 + 1];
                        ScriptableObject.copyTable(this.slots, slotArray, this.count);
                        this.slots = slotArray;
                        n5 = ScriptableObject.getSlotIndex(slotArray.length, n3);
                    }
                }
                Slot slot2 = slot = n2 == 4 ? new GetterSlot(string, n3, 0) : new Slot(string, n3, 0);
                if (n2 == 5) {
                    slot.setAttributes(13);
                }
                ++this.count;
                if (this.lastAdded != null) {
                    this.lastAdded.orderedNext = slot;
                }
                if (this.firstAdded == null) {
                    this.firstAdded = slot;
                }
                this.lastAdded = slot;
                ScriptableObject.addKnownAbsentSlot(slotArray, slot, n5);
                return slot;
            }
        }
        if (n2 == 3) {
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                Slot[] slotArray = this.slots;
                if (this.count != 0) {
                    Slot slot;
                    int n8 = this.slots.length;
                    int n9 = ScriptableObject.getSlotIndex(n8, n3);
                    Slot slot3 = slot = slotArray[n9];
                    while (!(slot3 == null || slot3.indexOrHash == n3 && (slot3.name == string || string != null && string.equals(slot3.name)))) {
                        slot = slot3;
                        slot3 = slot3.next;
                    }
                    if (slot3 != null && (slot3.getAttributes() & 4) == 0) {
                        --this.count;
                        if (slot == slot3) {
                            slotArray[n9] = slot3.next;
                        } else {
                            slot.next = slot3.next;
                        }
                        slot3.wasDeleted = true;
                        slot3.value = null;
                        slot3.name = null;
                        if (slot3 == this.lastAccess) {
                            this.lastAccess = REMOVED;
                        }
                    }
                }
            }
            return null;
        }
        throw Kit.codeBug();
    }

    private static int getSlotIndex(int n, int n2) {
        return (n2 & Integer.MAX_VALUE) % n;
    }

    private static void copyTable(Slot[] slotArray, Slot[] slotArray2, int n) {
        if (n == 0) {
            throw Kit.codeBug();
        }
        int n2 = slotArray2.length;
        int n3 = slotArray.length;
        block0: while (true) {
            Slot slot = slotArray[--n3];
            do {
                if (slot == null) continue block0;
                int n4 = ScriptableObject.getSlotIndex(n2, slot.indexOrHash);
                Slot slot2 = slot.next;
                ScriptableObject.addKnownAbsentSlot(slotArray2, slot, n4);
                slot.next = null;
                slot = slot2;
            } while (--n != 0);
            break;
        }
    }

    private static void addKnownAbsentSlot(Slot[] slotArray, Slot slot, int n) {
        if (slotArray[n] == null) {
            slotArray[n] = slot;
        } else {
            Slot slot2 = slotArray[n];
            while (slot2.next != null) {
                slot2 = slot2.next;
            }
            slot2.next = slot;
        }
    }

    Object[] getIds(boolean bl) {
        Object object;
        Slot[] slotArray = this.slots;
        Object[] objectArray = ScriptRuntime.emptyArgs;
        if (slotArray == null) {
            return objectArray;
        }
        int n = 0;
        Object[] objectArray2 = this.firstAdded;
        while (objectArray2 != null && objectArray2.wasDeleted) {
            objectArray2 = objectArray2.orderedNext;
        }
        this.firstAdded = objectArray2;
        while (objectArray2 != null) {
            if (bl || (objectArray2.getAttributes() & 2) == 0) {
                if (n == 0) {
                    objectArray = new Object[slotArray.length];
                }
                objectArray[n++] = objectArray2.name != null ? objectArray2.name : new Integer(objectArray2.indexOrHash);
            }
            object = objectArray2.orderedNext;
            while (object != null && object.wasDeleted) {
                object = object.orderedNext;
            }
            objectArray2.orderedNext = object;
            objectArray2 = object;
        }
        if (n == objectArray.length) {
            return objectArray;
        }
        object = new Object[n];
        System.arraycopy(objectArray, 0, object, 0, n);
        return object;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.count;
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        if (n == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.slots.length);
            Slot slot = this.firstAdded;
            while (slot != null && slot.wasDeleted) {
                slot = slot.orderedNext;
            }
            this.firstAdded = slot;
            while (slot != null) {
                objectOutputStream.writeObject(slot);
                Slot slot2 = slot.orderedNext;
                while (slot2 != null && slot2.wasDeleted) {
                    slot2 = slot2.orderedNext;
                }
                slot.orderedNext = slot2;
                slot = slot2;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lastAccess = REMOVED;
        int n = objectInputStream.readInt();
        if (n != 0) {
            this.slots = new Slot[n];
            int n2 = this.count;
            if (n2 < 0) {
                n2 ^= 0xFFFFFFFF;
            }
            Slot slot = null;
            for (int i = 0; i != n2; ++i) {
                this.lastAdded = (Slot)objectInputStream.readObject();
                if (i == 0) {
                    this.firstAdded = this.lastAdded;
                } else {
                    slot.orderedNext = this.lastAdded;
                }
                int n3 = ScriptableObject.getSlotIndex(n, this.lastAdded.indexOrHash);
                ScriptableObject.addKnownAbsentSlot(this.slots, this.lastAdded, n3);
                slot = this.lastAdded;
            }
        }
    }

    static {
        ScriptableObject.REMOVED.wasDeleted = true;
    }

    private static final class GetterSlot
    extends Slot {
        static final long serialVersionUID = -4900574849788797588L;
        Object getter;
        Object setter;

        GetterSlot(String string, int n, int n2) {
            super(string, n, n2);
        }
    }

    private static class Slot
    implements Serializable {
        private static final long serialVersionUID = -6090581677123995491L;
        String name;
        int indexOrHash;
        private volatile short attributes;
        volatile transient boolean wasDeleted;
        volatile Object value;
        volatile transient Slot next;
        volatile transient Slot orderedNext;

        Slot(String string, int n, int n2) {
            this.name = string;
            this.indexOrHash = n;
            this.attributes = (short)n2;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.name != null) {
                this.indexOrHash = this.name.hashCode();
            }
        }

        final int getAttributes() {
            return this.attributes;
        }

        final synchronized void setAttributes(int n) {
            ScriptableObject.checkValidAttributes(n);
            this.attributes = (short)n;
        }

        final void checkNotReadonly() {
            if ((this.attributes & 1) != 0) {
                String string = this.name != null ? this.name : Integer.toString(this.indexOrHash);
                throw Context.reportRuntimeError1("msg.modify.readonly", string);
            }
        }
    }
}

