/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.webframeworks;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.webframeworks.AddFrameworkPanel;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebFrameworksPanel
extends JPanel
implements ListSelectionListener {
    private final ProjectCustomizer.Category category;
    private Project project;
    private List<WebModuleExtender> newExtenders = new LinkedList<WebModuleExtender>();
    private List<WebFrameworkProvider> usedFrameworks = new LinkedList<WebFrameworkProvider>();
    private Map<WebFrameworkProvider, WebModuleExtender> extenders = new IdentityHashMap<WebFrameworkProvider, WebModuleExtender>();
    List<WebFrameworkProvider> addedFrameworks = new LinkedList<WebFrameworkProvider>();
    private ExtenderController controller = ExtenderController.create();
    private ModelHandle handle;
    static final String UI_LOGGER_NAME = "org.netbeans.ui.web.project";
    static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.web.project");
    private JButton btnRemoveAdded;
    private JButton jButtonAdd;
    private JLabel jLabelConfig;
    private JLabel jLabelFrameworks;
    private JList jListFrameworks;
    private JPanel jPanelConfig;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public WebFrameworksPanel(ProjectCustomizer.Category category, ModelHandle handle, Project prj) {
        this.category = category;
        this.project = prj;
        this.handle = handle;
        this.initComponents();
        this.btnRemoveAdded.setEnabled(false);
        this.initFrameworksList();
        this.jListFrameworks.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                WebFrameworkProvider prov = (WebFrameworkProvider)value;
                Component toRet = super.getListCellRendererComponent((JList<?>)list, prov.getName(), index, isSelected, cellHasFocus);
                if (toRet instanceof JLabel) {
                    JLabel lbl = (JLabel)toRet;
                    if (WebFrameworksPanel.this.addedFrameworks.contains(prov)) {
                        lbl.setFont(lbl.getFont().deriveFont(1));
                    } else {
                        lbl.setFont(lbl.getFont().deriveFont(0));
                    }
                }
                return toRet;
            }
        });
    }

    void applyChanges() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        for (int i = 0; i < this.newExtenders.size(); ++i) {
            this.newExtenders.get(i).extend(webModule);
        }
        if (this.addedFrameworks != null && this.addedFrameworks.size() > 0) {
            LogRecord logRecord = new LogRecord(Level.INFO, "UI_WEB_PROJECT_FRAMEWORK_ADDED");
            logRecord.setLoggerName(UI_LOGGER_NAME);
            logRecord.setResourceBundle(NbBundle.getBundle(WebFrameworksPanel.class));
            logRecord.setParameters(this.addedFrameworks.toArray());
            UI_LOGGER.log(logRecord);
        }
    }

    private void initFrameworksList() {
        String serverInstanceID;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        ExtenderController.Properties properties = this.controller.getProperties();
        String j2eeVersion = webModule.getJ2eePlatformVersion();
        properties.setProperty("j2eeLevel", (Object)j2eeVersion);
        properties.setProperty("maven", (Object)Boolean.TRUE);
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && (serverInstanceID = provider.getServerInstanceID()) != null && !"".equals(serverInstanceID)) {
            properties.setProperty("serverInstanceID", (Object)serverInstanceID);
        }
        this.jListFrameworks.setModel(new DefaultListModel());
        List frameworks = WebFrameworks.getFrameworks();
        for (int i = 0; i < frameworks.size(); ++i) {
            WebFrameworkProvider framework = (WebFrameworkProvider)frameworks.get(i);
            if (!framework.isInWebModule(webModule)) continue;
            this.usedFrameworks.add(framework);
            ((DefaultListModel)this.jListFrameworks.getModel()).addElement(framework);
            WebModuleExtender extender = framework.createWebModuleExtender(webModule, this.controller);
            this.extenders.put(framework, extender);
            extender.addChangeListener((ChangeListener)new ExtenderListener(extender));
        }
        this.jListFrameworks.getSelectionModel().setSelectionMode(0);
        this.jListFrameworks.addListSelectionListener(this);
        if (this.usedFrameworks.size() > 0) {
            this.jListFrameworks.setSelectedIndex(0);
        }
        if (frameworks.size() == this.jListFrameworks.getModel().getSize()) {
            this.jButtonAdd.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jLabelFrameworks = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListFrameworks = new JList();
        this.jButtonAdd = new JButton();
        this.btnRemoveAdded = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanelConfig = new JPanel();
        this.jLabelConfig = new JLabel();
        this.jLabelFrameworks.setLabelFor(this.jListFrameworks);
        Mnemonics.setLocalizedText((JLabel)this.jLabelFrameworks, (String)NbBundle.getMessage(WebFrameworksPanel.class, (String)"LBL_UsedFrameworks"));
        this.jScrollPane1.setViewportView(this.jListFrameworks);
        this.jListFrameworks.getAccessibleContext().setAccessibleDescription("Used Frameworks");
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAdd, (String)NbBundle.getMessage(WebFrameworksPanel.class, (String)"LBL_AddFramework"));
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebFrameworksPanel.this.jButtonAddActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveAdded, (String)NbBundle.getMessage(WebFrameworksPanel.class, (String)"BTN_Remove"));
        this.btnRemoveAdded.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebFrameworksPanel.this.btnRemoveAddedActionPerformed(evt);
            }
        });
        this.jPanelConfig.setLayout(new GridBagLayout());
        this.jLabelConfig.setLabelFor(this.jPanelConfig);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelFrameworks).add((Component)this.jScrollPane1, -1, 398, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonAdd).add((Component)this.btnRemoveAdded))).add((Component)this.jSeparator1, -1, 477, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelConfig, -2, 368, -2).addContainerGap()).add((Component)this.jPanelConfig, -1, 477, Short.MAX_VALUE));
        layout.linkSize(new Component[]{this.btnRemoveAdded, this.jButtonAdd}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelFrameworks).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.btnRemoveAdded)).add((Component)this.jScrollPane1, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 2, -2).addPreferredGap(0).add((Component)this.jLabelConfig, -2, 19, -2).addPreferredGap(0).add((Component)this.jPanelConfig, -1, 158, Short.MAX_VALUE)));
        this.jButtonAdd.getAccessibleContext().setAccessibleDescription("Add Framework");
        this.btnRemoveAdded.getAccessibleContext().setAccessibleDescription("Remove framework");
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        AddFrameworkPanel panel = new AddFrameworkPanel(this.usedFrameworks);
        JPanel inner = new JPanel();
        inner.setLayout(new GridBagLayout());
        inner.getAccessibleContext().setAccessibleDescription(panel.getAccessibleContext().getAccessibleDescription());
        inner.getAccessibleContext().setAccessibleName(panel.getAccessibleContext().getAccessibleName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        inner.add((Component)panel, gridBagConstraints);
        DialogDescriptor desc = new DialogDescriptor((Object)inner, NbBundle.getMessage(WebFrameworksPanel.class, (String)"LBL_SelectWebExtension_DialogTitle"));
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (res.equals(NotifyDescriptor.YES_OPTION)) {
            List<WebFrameworkProvider> newFrameworks = panel.getSelectedFrameworks();
            WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
            for (WebFrameworkProvider framework : newFrameworks) {
                WebModuleExtender extender;
                if (!((DefaultListModel)this.jListFrameworks.getModel()).contains(framework)) {
                    ((DefaultListModel)this.jListFrameworks.getModel()).addElement(framework);
                }
                boolean added = false;
                if (this.usedFrameworks.size() == 0) {
                    this.usedFrameworks.add(framework);
                    added = true;
                } else {
                    for (int j = 0; j < this.usedFrameworks.size(); ++j) {
                        if (this.usedFrameworks.get(j).getName().equals(framework.getName())) continue;
                        this.usedFrameworks.add(framework);
                        added = true;
                        break;
                    }
                }
                if (added && (extender = framework.createWebModuleExtender(wm, this.controller)) != null) {
                    this.extenders.put(framework, extender);
                    this.newExtenders.add(extender);
                    extender.addChangeListener((ChangeListener)new ExtenderListener(extender));
                    this.addedFrameworks.add(framework);
                }
                this.jListFrameworks.setSelectedValue(framework, true);
            }
        }
        if (WebFrameworks.getFrameworks().size() == this.jListFrameworks.getModel().getSize()) {
            this.jButtonAdd.setEnabled(false);
        }
    }

    private void btnRemoveAddedActionPerformed(ActionEvent evt) {
        WebModuleExtender extender;
        WebFrameworkProvider framework = (WebFrameworkProvider)this.jListFrameworks.getSelectedValue();
        if (framework != null && (extender = this.extenders.get(framework)) != null) {
            ((DefaultListModel)this.jListFrameworks.getModel()).removeElement(framework);
            this.addedFrameworks.remove(framework);
            this.newExtenders.remove(extender);
            this.extenders.remove(framework);
            this.usedFrameworks.remove(framework);
            boolean hasInvalid = false;
            for (WebModuleExtender ex : this.extenders.values()) {
                if (ex.isValid()) continue;
                ex.update();
                this.controller.setErrorMessage(null);
                ex.isValid();
                this.category.setValid(false);
                this.category.setErrorMessage(this.controller.getErrorMessage());
                hasInvalid = true;
            }
            if (!hasInvalid && !this.category.isValid()) {
                this.category.setValid(true);
                this.category.setErrorMessage(null);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.btnRemoveAdded.setEnabled(false);
        WebFrameworkProvider framework = (WebFrameworkProvider)this.jListFrameworks.getSelectedValue();
        if (framework != null) {
            WebModuleExtender extender;
            if (this.addedFrameworks.contains(framework)) {
                this.btnRemoveAdded.setEnabled(true);
            }
            if ((extender = this.extenders.get(framework)) != null) {
                String message = MessageFormat.format(NbBundle.getMessage(WebFrameworksPanel.class, (String)"LBL_FrameworkConfiguration"), framework.getName());
                this.jLabelConfig.setText(message);
                this.jPanelConfig.removeAll();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.gridheight = 0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                this.jPanelConfig.add((Component)extender.getComponent(), gridBagConstraints);
                this.jPanelConfig.repaint();
                this.jPanelConfig.revalidate();
                extender.update();
                this.controller.setErrorMessage(null);
                extender.isValid();
                this.category.setErrorMessage(this.controller.getErrorMessage());
            } else {
                this.hideConfigPanel();
            }
        } else {
            this.hideConfigPanel();
        }
    }

    private void hideConfigPanel() {
        this.jLabelConfig.setText("");
        this.jPanelConfig.removeAll();
        this.jPanelConfig.repaint();
        this.jPanelConfig.revalidate();
    }

    private final class ExtenderListener
    implements ChangeListener {
        private final WebModuleExtender extender;

        public ExtenderListener(WebModuleExtender extender) {
            this.extender = extender;
            extender.update();
            this.stateChanged(new ChangeEvent(this));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            WebFrameworksPanel.this.controller.setErrorMessage(null);
            if (this.extender.isValid()) {
                if (!WebFrameworksPanel.this.category.isValid()) {
                    WebFrameworksPanel.this.category.setValid(true);
                    WebFrameworksPanel.this.category.setErrorMessage(null);
                    String message = (String)WebFrameworksPanel.this.controller.getProperties().getProperty("WizardPanel_infoMessage");
                    if (message != null) {
                        WebFrameworksPanel.this.category.setErrorMessage(message);
                    }
                }
            } else {
                WebFrameworksPanel.this.category.setValid(false);
                WebFrameworksPanel.this.category.setErrorMessage(WebFrameworksPanel.this.controller.getErrorMessage());
            }
        }
    }
}

