/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.webframeworks;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AddFrameworkPanel
extends JPanel {
    public JLabel jLabel1;
    public JList jListFrameworks;
    public JScrollPane jScrollPane1;

    public AddFrameworkPanel(List<WebFrameworkProvider> usedFrameworks) {
        this.initComponents();
        this.jListFrameworks.setCellRenderer(new FrameworksListCellRenderer());
        this.createFrameworksList(usedFrameworks);
        this.jListFrameworks.getSelectionModel().setSelectionMode(2);
    }

    private void createFrameworksList(List<WebFrameworkProvider> usedFrameworks) {
        List frameworks = WebFrameworks.getFrameworks();
        DefaultListModel<WebFrameworkProvider> model = new DefaultListModel<WebFrameworkProvider>();
        this.jListFrameworks.setModel(model);
        for (WebFrameworkProvider framework : frameworks) {
            if (usedFrameworks.size() == 0) {
                model.addElement(framework);
                continue;
            }
            boolean isUsed = false;
            for (int j = 0; j < usedFrameworks.size(); ++j) {
                if (!usedFrameworks.get(j).getName().equals(framework.getName())) continue;
                isUsed = true;
                break;
            }
            if (isUsed) continue;
            model.addElement(framework);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListFrameworks = new JList();
        this.jLabel1 = new JLabel();
        this.jScrollPane1.setViewportView(this.jListFrameworks);
        this.jLabel1.setLabelFor(this.jListFrameworks);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddFrameworkPanel.class, (String)"LBL_Select_Framework"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 376, Short.MAX_VALUE).add((Component)this.jLabel1, -1, 376, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 163, Short.MAX_VALUE)));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/maven/webframeworks/Bundle");
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AddFramework"));
    }

    public List<WebFrameworkProvider> getSelectedFrameworks() {
        LinkedList<WebFrameworkProvider> selectedFrameworks = new LinkedList<WebFrameworkProvider>();
        DefaultListModel model = (DefaultListModel)this.jListFrameworks.getModel();
        int[] indexes = this.jListFrameworks.getSelectedIndices();
        for (int i = 0; i < indexes.length; ++i) {
            selectedFrameworks.add((WebFrameworkProvider)model.get(indexes[i]));
        }
        return selectedFrameworks;
    }

    public static class FrameworksListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof WebFrameworkProvider) {
                WebFrameworkProvider item = (WebFrameworkProvider)value;
                return super.getListCellRendererComponent((JList<?>)list, item.getName(), index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

