/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.spi.cos.AdditionalDestination;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class CopyOnSave
implements AdditionalDestination,
J2eeModuleProvider.DeployOnSaveSupport {
    private Project project;
    private J2eeModuleProvider provider;
    boolean active = false;
    private NbMavenProject mavenproject;
    private final List<ArtifactListener> listeners = new ArrayList<ArtifactListener>();
    private static final String NB_COS = ".netbeans_automatic_build";

    public CopyOnSave(Project prj, J2eeModuleProvider prov) {
        this.project = prj;
        this.provider = prov;
        this.mavenproject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
    }

    public void initialize() throws FileStateInvalidException {
    }

    public void cleanup() throws FileStateInvalidException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copySrcToDest(FileObject srcFile, FileObject destFile) throws IOException {
        if (destFile != null && !srcFile.isFolder()) {
            InputStream is = null;
            OutputStream os = null;
            FileLock fl = null;
            try {
                is = srcFile.getInputStream();
                fl = destFile.lock();
                os = destFile.getOutputStream(fl);
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (fl != null) {
                    fl.releaseLock();
                }
            }
        }
    }

    protected J2eeModule getJ2eeModule() {
        return this.provider.getJ2eeModule();
    }

    protected J2eeModuleProvider getJ2eeModuleProvider() {
        return this.provider;
    }

    protected Project getProject() {
        return this.project;
    }

    protected FileObject ensureDestinationFileExists(FileObject buildBase, String path, boolean isFolder) throws IOException {
        FileObject current = buildBase;
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String pathItem = st.nextToken();
            FileObject newCurrent = current.getFileObject(pathItem);
            if (newCurrent == null) {
                newCurrent = isFolder || st.hasMoreTokens() ? FileUtil.createFolder((FileObject)current, (String)pathItem) : FileUtil.createData((FileObject)current, (String)pathItem);
            }
            current = newCurrent;
        }
        return current;
    }

    public void copy(FileObject fo, String path) {
        try {
            FileObject contentDir = this.getJ2eeModule().getContentDirectory();
            if (contentDir != null) {
                FileObject destFile = this.ensureDestinationFileExists(contentDir, (this.getDestinationSubFolderName().length() > 0 ? this.getDestinationSubFolderName() + "/" : "") + path, fo.isFolder());
                File fil = FileUtil.toFile((FileObject)destFile);
                this.copySrcToDest(fo, destFile);
                this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)fil)));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected String getDestinationSubFolderName() {
        return "";
    }

    public void delete(FileObject fo, String path) {
        try {
            FileObject contentDir = this.getJ2eeModule().getContentDirectory();
            if (contentDir != null) {
                FileObject toDelete;
                FileObject classes;
                FileObject fileObject = classes = this.getDestinationSubFolderName().length() > 0 ? contentDir.getFileObject(this.getDestinationSubFolderName()) : contentDir;
                if (classes != null && (toDelete = classes.getFileObject(path)) != null) {
                    File fil = FileUtil.toFile((FileObject)toDelete);
                    toDelete.delete();
                    this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)fil)));
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArtifactListener(ArtifactListener listener) {
        List<ArtifactListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArtifactListener(ArtifactListener listener) {
        List<ArtifactListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireArtifactChange(Iterable<ArtifactListener.Artifact> artifacts) {
        List<ArtifactListener> list = this.listeners;
        synchronized (list) {
            for (ArtifactListener listener : this.listeners) {
                listener.artifactsUpdated(artifacts);
            }
        }
    }

    public boolean containsIdeArtifacts() {
        return new File(this.mavenproject.getOutputDirectory(false), NB_COS).exists();
    }
}

