/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsViewUtils;
import org.netbeans.modules.editor.lib2.view.NewlineView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.modules.editor.lib2.view.VisualUpdate;

public class EditorBoxViewChildren<V extends EditorView>
extends GapList<V> {
    private static final Logger LOG = Logger.getLogger(EditorBoxViewChildren.class.getName());
    protected static final double EXTEND_TO_END = 1.073741823E9;
    private static final int GAP_STORAGE_THRESHOLD = 10;
    private static final long serialVersionUID = 0L;
    GapStorage gapStorage;

    EditorBoxViewChildren(int capacity) {
        super(capacity);
    }

    protected boolean rawOffsetUpdate() {
        return false;
    }

    protected boolean handleTabableViews() {
        return false;
    }

    VisualUpdate<V> replace(EditorBoxView<V> boxView, int index, int removeCount, View[] addedViews, int offsetDelta) {
        VisualUpdate<V> visualUpdate = new VisualUpdate<V>(boxView);
        if (index < 0) {
            throw new IllegalArgumentException("index=" + index + " < 0");
        }
        if (removeCount < 0) {
            throw new IllegalArgumentException("removeCount=" + removeCount + " < 0");
        }
        if (index + removeCount > this.size()) {
            throw new IllegalArgumentException("index=" + index + ", removeCount=" + removeCount + ", viewCount=" + this.size());
        }
        this.moveOffsetGap(index + removeCount);
        this.moveVisualGap(index + removeCount);
        this.setVisualIndexAndOffset(boxView, visualUpdate, index);
        int gapIndexDelta = -removeCount;
        if (removeCount != 0) {
            this.remove(index, removeCount);
        }
        if (addedViews != null && addedViews.length != 0) {
            gapIndexDelta += addedViews.length;
            visualUpdate.endVisualIndex = index + addedViews.length;
            this.addArray(index, addedViews);
            int boxViewStartOffset = boxView.getStartOffset();
            boolean supportsRawOffsetUpdate = this.rawOffsetUpdate();
            for (int i = 0; i < addedViews.length; ++i) {
                EditorView view = (EditorView)addedViews[i];
                if (supportsRawOffsetUpdate) {
                    int offset = view.getRawOffset();
                    view.setRawOffset(offset - boxViewStartOffset);
                }
                view.setParent(boxView);
            }
        } else {
            visualUpdate.endVisualIndex = index;
        }
        if (this.gapStorage != null) {
            int relEndOffset;
            this.gapStorage.offsetGapIndex += gapIndexDelta;
            if (this.gapStorage.offsetGapIndex > 0) {
                V lastView = boxView.getEditorView(this.gapStorage.offsetGapIndex - 1);
                relEndOffset = ((EditorView)lastView).getRawOffset() + ((EditorView)lastView).getLength();
            } else {
                relEndOffset = 0;
            }
            this.gapStorage.offsetGapStart = relEndOffset;
            this.gapStorage.visualGapIndex += gapIndexDelta;
            this.gapStorage.offsetGapLength -= offsetDelta;
        } else if (this.rawOffsetUpdate() && offsetDelta != 0) {
            int viewCount = this.size();
            for (int i = visualUpdate.endVisualIndex; i < viewCount; ++i) {
                EditorView view = (EditorView)this.get(i);
                view.setRawOffset(view.getRawOffset() + offsetDelta);
            }
        }
        int newLength = this.getLength();
        if (newLength != boxView.getLength()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(boxView.getDumpId() + ": update length: " + boxView.getLength() + " => " + newLength + "\n");
            }
            boxView.setLength(newLength);
        }
        return visualUpdate;
    }

    void updateSpansAndLayout(EditorBoxView<V> boxView, VisualUpdate<V> visualUpdate, Shape alloc) {
        this.fixSpans(boxView, visualUpdate);
        this.updateLayout(boxView, visualUpdate, alloc);
    }

    VisualUpdate<V> updateViews(EditorBoxView<V> boxView, int index, int count, Shape alloc) {
        VisualUpdate<V> visualUpdate = new VisualUpdate<V>(boxView);
        this.moveVisualGap(index + count);
        this.setVisualIndexAndOffset(boxView, visualUpdate, index);
        visualUpdate.endVisualIndex = index + count;
        this.updateSpansAndLayout(boxView, visualUpdate, alloc);
        return visualUpdate;
    }

    private void setVisualIndexAndOffset(EditorBoxView<V> boxView, VisualUpdate<V> visualUpdate, int index) {
        if (this.handleTabableViews()) {
            index = HighlightsViewUtils.findAffectedLayoutIndex(boxView, visualUpdate, index);
        }
        visualUpdate.visualIndex = index;
        visualUpdate.visualOffset = this.getViewVisualOffset(boxView, index);
    }

    private void fixSpans(EditorBoxView<V> boxView, VisualUpdate<V> visualUpdate) {
        boolean handleTabableViews = this.handleTabableViews();
        int majorAxis = boxView.getMajorAxis();
        int minorAxis = ViewUtils.getOtherAxis(majorAxis);
        TabExpander tabExpander = handleTabableViews ? boxView.getTabExpander() : null;
        float minorAxisChildrenSpan = this.getMinorAxisChildrenSpan(boxView);
        double visualOffset = visualUpdate.visualOffset;
        assert (visualUpdate.visualIndex <= visualUpdate.endVisualIndex) : "visualIndex=" + visualUpdate.visualIndex + " > endVisualIndex=" + visualUpdate.endVisualIndex;
        if (handleTabableViews) {
            HighlightsViewUtils.fixLayouts(boxView, visualUpdate);
        }
        for (int i = visualUpdate.visualIndex; i < visualUpdate.endVisualIndex; ++i) {
            EditorView view = (EditorView)this.get(i);
            float majorSpan = handleTabableViews ? (view instanceof TabableView ? ((TabableView)((Object)view)).getTabbedSpan((float)visualOffset, tabExpander) : view.getPreferredSpan(majorAxis)) : view.getPreferredSpan(majorAxis);
            if (view instanceof NewlineView) {
                visualUpdate.markNewLineViewChanged();
            }
            view.setRawVisualOffset(visualOffset);
            visualOffset += (double)majorSpan;
            float viewMinorAxisSpan = view.getPreferredSpan(minorAxis);
            if (!(viewMinorAxisSpan > minorAxisChildrenSpan)) continue;
            visualUpdate.markMinorChildrenSpanChanged();
            minorAxisChildrenSpan = viewMinorAxisSpan;
        }
        if (visualUpdate.isMinorChildrenSpanChanged()) {
            this.setMinorAxisChildrenSpan(boxView, minorAxisChildrenSpan);
        }
        visualUpdate.endVisualOffset = visualOffset;
        double visualDelta = visualOffset - boxView.getViewVisualOffset(visualUpdate.endVisualIndex);
        if (visualDelta != 0.0) {
            visualUpdate.markMajorChildrenSpanChanged();
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer(boxView.getDumpId() + "=>fixSpans(): vUpdate: " + visualUpdate + "\nvDelta=" + visualDelta + " = vOffset=" + visualOffset + " - vOffset[" + visualUpdate.endVisualIndex + "]=" + boxView.getViewVisualOffset(visualUpdate.endVisualIndex) + "\n");
        }
        assert (visualUpdate.visualIndex <= visualUpdate.endVisualIndex) : "visualIndex=" + visualUpdate.visualIndex + " > endVisualIndex=" + visualUpdate.endVisualIndex;
        boolean tabsChanged = false;
        int viewCount = this.size();
        if (this.gapStorage != null) {
            this.gapStorage.visualGapIndex = visualUpdate.endVisualIndex;
            this.gapStorage.visualGapStart = visualOffset;
            this.gapStorage.visualGapLength -= visualDelta;
            this.setMajorAxisChildrenSpan(boxView, this.getMajorAxisChildrenSpan(boxView) + visualDelta);
            if (this.handleTabableViews()) {
                double tabVisualDelta = 0.0;
                for (int i = visualUpdate.endVisualIndex; i < viewCount; ++i) {
                    EditorView view = (EditorView)this.get(i);
                    if (tabsChanged) {
                        view.setRawVisualOffset(view.getRawVisualOffset() + tabVisualDelta);
                    }
                    if (!(view instanceof TabableView)) continue;
                    double viewVisualOffset = view.getRawVisualOffset() - this.gapStorage.visualGapLength;
                    double origMajorSpan = boxView.getViewVisualOffset(i + 1) + tabVisualDelta - viewVisualOffset;
                    double majorSpan = ((TabableView)((Object)view)).getTabbedSpan((float)viewVisualOffset, tabExpander);
                    double majorSpanDelta = majorSpan - origMajorSpan;
                    if (majorSpanDelta == 0.0) continue;
                    tabVisualDelta += majorSpanDelta;
                    tabsChanged = true;
                }
                if (tabsChanged) {
                    this.setMajorAxisChildrenSpan(boxView, this.getMajorAxisChildrenSpan(boxView) + tabVisualDelta);
                }
            }
        } else {
            for (int i = visualUpdate.endVisualIndex; i < viewCount; ++i) {
                EditorView view = (EditorView)this.get(i);
                view.setRawVisualOffset(view.getRawVisualOffset() + visualDelta);
                if (!this.handleTabableViews() || !(view instanceof TabableView)) continue;
                visualOffset = view.getRawVisualOffset();
                double origMajorSpan = boxView.getViewVisualOffset(i + 1) + visualDelta - visualOffset;
                double majorSpan = ((TabableView)((Object)view)).getTabbedSpan((float)visualOffset, tabExpander);
                double majorSpanDelta = majorSpan - origMajorSpan;
                if (majorSpanDelta == 0.0) continue;
                visualDelta += majorSpanDelta;
                tabsChanged = true;
            }
            if (visualDelta != 0.0) {
                this.setMajorAxisChildrenSpan(boxView, this.getMajorAxisChildrenSpan(boxView) + visualDelta);
                visualUpdate.markMajorChildrenSpanChanged();
            }
        }
        if (tabsChanged) {
            visualUpdate.markTabsChanged();
            visualUpdate.markMajorChildrenSpanChanged();
        }
    }

    protected double getMajorAxisChildrenSpan(EditorBoxView<V> boxView) {
        return boxView.getMajorAxisSpan();
    }

    protected void setMajorAxisChildrenSpan(EditorBoxView<V> boxView, double majorAxisSpan) {
        boxView.setMajorAxisSpan(majorAxisSpan);
    }

    protected float getMinorAxisChildrenSpan(EditorBoxView<V> boxView) {
        return boxView.getMinorAxisSpan();
    }

    protected void setMinorAxisChildrenSpan(EditorBoxView<V> boxView, float minorAxisSpan) {
        boxView.setMinorAxisSpan(minorAxisSpan);
    }

    protected void updateLayout(EditorBoxView<V> boxView, VisualUpdate<V> visualUpdate, Shape alloc) {
        int majorAxis = boxView.getMajorAxis();
        if (alloc != null) {
            Rectangle2D.Double repaintBounds = ViewUtils.shape2Bounds(alloc);
            assert (repaintBounds.width >= 0.0) : "repaintBounds.width=" + repaintBounds.width;
            assert (repaintBounds.height >= 0.0) : "repaintBounds.height=" + repaintBounds.height + "; boxView=" + boxView;
            if (majorAxis == 0) {
                repaintBounds.x += visualUpdate.visualOffset;
                if (visualUpdate.isMajorChildrenSpanChanged()) {
                    visualUpdate.markWidthChanged();
                    repaintBounds.width = 1.073741823E9;
                } else {
                    repaintBounds.width = visualUpdate.isNewLineViewChanged() ? 1.073741823E9 : (visualUpdate.isTabsChanged() ? this.getMajorAxisChildrenSpan(boxView) - visualUpdate.visualOffset : visualUpdate.changedMajorSpan());
                }
                if (visualUpdate.isMinorChildrenSpanChanged()) {
                    visualUpdate.markHeightChanged();
                    repaintBounds.height = 1.073741823E9;
                }
            } else {
                repaintBounds.y += visualUpdate.visualOffset;
                if (visualUpdate.isMajorChildrenSpanChanged()) {
                    visualUpdate.markHeightChanged();
                    repaintBounds.height = 1.073741823E9;
                } else {
                    repaintBounds.height = visualUpdate.changedMajorSpan();
                }
                if (visualUpdate.isMinorChildrenSpanChanged()) {
                    visualUpdate.markWidthChanged();
                    repaintBounds.width = 1.073741823E9;
                }
            }
            visualUpdate.repaintBounds = ViewUtils.toRect(repaintBounds);
        } else if (visualUpdate.isPreferenceChanged()) {
            if (majorAxis == 0) {
                if (visualUpdate.isMajorChildrenSpanChanged()) {
                    visualUpdate.markWidthChanged();
                }
                if (visualUpdate.isMinorChildrenSpanChanged()) {
                    visualUpdate.markMinorChildrenSpanChanged();
                }
            } else {
                if (visualUpdate.isMinorChildrenSpanChanged()) {
                    visualUpdate.markWidthChanged();
                }
                if (visualUpdate.isMajorChildrenSpanChanged()) {
                    visualUpdate.markMinorChildrenSpanChanged();
                }
            }
            boxView.preferenceChanged(null, visualUpdate.isWidthChanged(), visualUpdate.isHeightChanged());
        }
    }

    protected V getEditorViewChildrenValid(EditorBoxView<V> boxView, int index) {
        EditorView child = (EditorView)this.get(index);
        if (child instanceof EditorBoxView) {
            EditorBoxView boxChild = (EditorBoxView)child;
            if (boxChild.children == null) {
                boxView.initChildren(index, index + 1);
                child = (EditorView)this.get(index);
                assert (((EditorBoxView)child).children != null);
            }
        }
        return (V)child;
    }

    int getViewIndex(int offset, Position.Bias bias) {
        if (bias == Position.Bias.Backward) {
            --offset;
        }
        return this.getViewIndex(offset);
    }

    int getViewIndex(int offset) {
        int high = this.size() - 1;
        if (high == -1) {
            return -1;
        }
        return this.getViewIndex(offset, 0, high);
    }

    int getViewIndex(int offset, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            int midStartOffset = ((EditorView)this.get(mid)).getStartOffset();
            if (midStartOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (midStartOffset > offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return Math.max(high, 0);
    }

    int raw2RelOffset(int rawOffset) {
        return this.gapStorage == null || rawOffset < this.gapStorage.offsetGapStart ? rawOffset : rawOffset - this.gapStorage.offsetGapLength;
    }

    int relOffset2Raw(int offset) {
        return this.gapStorage == null || offset < this.gapStorage.offsetGapStart ? offset : offset + this.gapStorage.offsetGapLength;
    }

    int getLength() {
        int size = this.size();
        if (size > 0) {
            EditorView lastChildView = (EditorView)this.get(size - 1);
            return this.raw2RelOffset(lastChildView.getRawOffset()) + lastChildView.getLength();
        }
        return 0;
    }

    private double raw2VisualOffset(double rawVisualOffset) {
        return this.gapStorage == null || rawVisualOffset < this.gapStorage.visualGapStart ? rawVisualOffset : rawVisualOffset - this.gapStorage.visualGapLength;
    }

    final double getViewVisualOffset(EditorBoxView<V> boxView, int index) {
        return index == this.size() ? this.getMajorAxisChildrenSpan(boxView) : this.getViewVisualOffset(index);
    }

    final double getViewVisualOffset(int index) {
        return this.getViewVisualOffset(((EditorView)this.get(index)).getRawVisualOffset());
    }

    final double getViewVisualOffset(double rawVisualOffset) {
        return this.raw2VisualOffset(rawVisualOffset);
    }

    final double getViewMajorAxisSpan(EditorBoxView<V> boxView, int index) {
        return index == this.size() - 1 ? this.getMajorAxisChildrenSpan(boxView) - this.getViewVisualOffset(index) : this.getViewVisualOffset(index + 1) - this.getViewVisualOffset(index);
    }

    Shape getChildAllocation(EditorBoxView<V> boxView, int startIndex, int endIndex, Shape alloc) {
        double endVisualOffset;
        Rectangle2D.Double mutableBounds = ViewUtils.shape2Bounds(alloc);
        double visualOffset = this.getViewVisualOffset(startIndex);
        double d = endVisualOffset = endIndex == this.size() ? this.getMajorAxisChildrenSpan(boxView) : this.getViewVisualOffset(endIndex);
        if (boxView.getMajorAxis() == 0) {
            mutableBounds.x += visualOffset;
            mutableBounds.width = endVisualOffset - visualOffset;
            mutableBounds.height = this.getMinorAxisChildrenSpan(boxView);
        } else {
            mutableBounds.y += visualOffset;
            mutableBounds.height = endVisualOffset - visualOffset;
            mutableBounds.width = this.getMinorAxisChildrenSpan(boxView);
        }
        return mutableBounds;
    }

    int getViewIndexFirst(int offset) {
        int high = this.size() - 1;
        if (high == -1) {
            return -1;
        }
        return this.getViewIndexFirst(offset, 0, high);
    }

    int getViewIndexFirst(int offset, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            int viewStartOffset = ((EditorView)this.get(mid)).getStartOffset();
            if (viewStartOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (viewStartOffset > offset) {
                high = mid - 1;
                continue;
            }
            while (mid > 0) {
                if ((viewStartOffset = ((EditorView)this.get(--mid)).getStartOffset()) >= offset) continue;
                ++mid;
                break;
            }
            high = mid;
            break;
        }
        return Math.max(high, 0);
    }

    private int getViewIndexFirst(double visualOffset) {
        int high = this.size() - 1;
        if (high == -1) {
            return -1;
        }
        int low = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            double viewVisualOffset = this.getViewVisualOffset(mid);
            if (viewVisualOffset < visualOffset) {
                low = mid + 1;
                continue;
            }
            if (viewVisualOffset > visualOffset) {
                high = mid - 1;
                continue;
            }
            while (mid > 0) {
                if (!((viewVisualOffset = this.getViewVisualOffset(--mid)) < visualOffset)) continue;
                ++mid;
                break;
            }
            high = mid;
            break;
        }
        return Math.max(high, 0);
    }

    void moveOffsetGap(int index) {
        if (!this.rawOffsetUpdate() || this.size() == 0) {
            return;
        }
        if (this.gapStorage == null) {
            if (this.size() > 10) {
                this.gapStorage = new GapStorage(this.size());
            } else {
                return;
            }
        }
        this.checkGap();
        if (index != this.gapStorage.offsetGapIndex) {
            if (index < this.gapStorage.offsetGapIndex) {
                int lastOffset = 0;
                for (int i = this.gapStorage.offsetGapIndex - 1; i >= index; --i) {
                    EditorView view = (EditorView)this.get(i);
                    lastOffset = view.getRawOffset();
                    view.setRawOffset(lastOffset + this.gapStorage.offsetGapLength);
                }
                this.gapStorage.offsetGapStart = lastOffset;
            } else {
                for (int i = this.gapStorage.offsetGapIndex; i < index; ++i) {
                    EditorView view = (EditorView)this.get(i);
                    view.setRawOffset(view.getRawOffset() - this.gapStorage.offsetGapLength);
                }
                if (index < this.size()) {
                    EditorView view = (EditorView)this.get(index);
                    this.gapStorage.offsetGapStart = view.getRawOffset() - this.gapStorage.offsetGapLength;
                } else {
                    assert (index == this.size()) : "Invalid requested index=" + index + ", size()=" + this.size() + ", offsetGapIndex=" + this.gapStorage.offsetGapIndex;
                    this.gapStorage.offsetGapStart = 0x3FFFFFFF;
                }
            }
            this.gapStorage.offsetGapIndex = index;
        }
        this.checkGap();
    }

    private void moveVisualGap(int index) {
        this.checkGap();
        if (this.gapStorage != null && index != this.gapStorage.visualGapIndex) {
            if (index < this.gapStorage.visualGapIndex) {
                double lastVisualOffset = 0.0;
                for (int i = this.gapStorage.visualGapIndex - 1; i >= index; --i) {
                    EditorView view = (EditorView)this.get(i);
                    lastVisualOffset = view.getRawVisualOffset();
                    view.setRawVisualOffset(lastVisualOffset + this.gapStorage.visualGapLength);
                }
                this.gapStorage.visualGapStart = lastVisualOffset;
            } else {
                for (int i = this.gapStorage.visualGapIndex; i < index; ++i) {
                    EditorView view = (EditorView)this.get(i);
                    view.setRawVisualOffset(view.getRawVisualOffset() - this.gapStorage.visualGapLength);
                }
                if (index < this.size()) {
                    EditorView view = (EditorView)this.get(index);
                    this.gapStorage.visualGapStart = view.getRawVisualOffset() - this.gapStorage.visualGapLength;
                } else {
                    assert (index == this.size()) : "Invalid requested index=" + index + ", size()=" + this.size() + ", visualGapIndex=" + this.gapStorage.visualGapIndex;
                    this.gapStorage.visualGapStart = 2.147483647E9;
                }
            }
            this.gapStorage.visualGapIndex = index;
        }
        this.checkGap();
    }

    private void checkGap() {
        if (this.gapStorage != null && LOG.isLoggable(Level.FINE)) {
            String error = null;
            int offsetGapIndex = this.gapStorage.offsetGapIndex;
            int visualGapIndex = this.gapStorage.visualGapIndex;
            if (offsetGapIndex > this.size()) {
                error = "offsetGapIndex=" + offsetGapIndex + " > size()=" + this.size();
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    EditorView view = (EditorView)this.get(i);
                    int rawOffset = view.getRawOffset();
                    int relOffset = this.raw2RelOffset(rawOffset);
                    double rawVisualOffset = view.getRawVisualOffset();
                    double visualOffset = this.raw2VisualOffset(rawVisualOffset);
                    if (this.rawOffsetUpdate()) {
                        if (i < offsetGapIndex) {
                            if (rawOffset >= this.gapStorage.offsetGapStart) {
                                error = "Not below offset-gap: rawOffset=" + rawOffset + " >= offsetGapStart=" + this.gapStorage.offsetGapStart;
                            }
                        } else {
                            if (rawOffset < this.gapStorage.offsetGapStart) {
                                error = "Not above offset-gap: rawOffset=" + rawOffset + " < offsetGapStart=" + this.gapStorage.offsetGapStart;
                            }
                            if (i == offsetGapIndex && relOffset != this.gapStorage.offsetGapStart) {
                                error = "relOffset=" + relOffset + " != gapStorage.offsetGapStart=" + this.gapStorage.offsetGapStart;
                            }
                        }
                    }
                    if (i < visualGapIndex) {
                        if (rawVisualOffset >= this.gapStorage.visualGapStart) {
                            error = "Not below visual-gap: rawVisualOffset=" + rawVisualOffset + " >= visualGapStart=" + this.gapStorage.visualGapStart;
                        }
                    } else {
                        if (rawVisualOffset < this.gapStorage.visualGapStart) {
                            error = "Not above visual-gap: rawVisualOffset=" + rawVisualOffset + " < visualGapStart=" + this.gapStorage.visualGapStart;
                        }
                        if (i == visualGapIndex && visualOffset != this.gapStorage.visualGapStart) {
                            error = "visualOffset=" + visualOffset + " != gapStorage.visualGapStart=" + this.gapStorage.visualGapStart;
                        }
                    }
                    if (error != null) break;
                }
            }
            if (error != null) {
                throw new IllegalStateException("gapStorage INTEGRITY ERROR!!!\n" + error);
            }
        }
    }

    public int getViewIndexAtPoint(EditorBoxView<V> boxView, double x, double y, Shape alloc) {
        Rectangle2D.Double relXY = ViewUtils.shape2RelBounds(alloc, x, y);
        double visualOffset = boxView.getMajorAxis() == 0 ? relXY.getX() : relXY.getY();
        int high = this.size() - 1;
        if (high == -1) {
            return -1;
        }
        int low = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            double midVisualOffset = this.getViewVisualOffset(mid);
            if (midVisualOffset < visualOffset) {
                low = mid + 1;
                continue;
            }
            if (midVisualOffset > visualOffset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return Math.max(high, 0);
    }

    public Shape modelToViewChecked(EditorBoxView<V> boxView, int offset, Shape alloc, Position.Bias bias) {
        int index = this.getViewIndex(offset, bias);
        if (index >= 0) {
            V view = this.getEditorViewChildrenValid(boxView, index);
            Shape childAlloc = this.getChildAllocation(boxView, index, index + 1, alloc);
            return ((EditorView)view).modelToViewChecked(offset, childAlloc, bias);
        }
        return alloc;
    }

    public int viewToModelChecked(EditorBoxView<V> boxView, double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        int offset;
        int index = this.getViewIndexAtPoint(boxView, x, y, alloc);
        if (index >= 0) {
            V view = this.getEditorViewChildrenValid(boxView, index);
            Shape childAlloc = this.getChildAllocation(boxView, index, index + 1, alloc);
            offset = ((EditorView)view).viewToModelChecked(x, y, childAlloc, biasReturn);
        } else {
            offset = boxView.getStartOffset();
        }
        return offset;
    }

    public String getToolTipTextChecked(EditorBoxView<V> boxView, double x, double y, Shape alloc) {
        int index = this.getViewIndexAtPoint(boxView, x, y, alloc);
        if (index >= 0) {
            V view = this.getEditorViewChildrenValid(boxView, index);
            Shape childAlloc = this.getChildAllocation(boxView, index, index + 1, alloc);
            return ((EditorView)view).getToolTipTextChecked(x, y, childAlloc);
        }
        return null;
    }

    public JComponent getToolTip(EditorBoxView<V> boxView, double x, double y, Shape alloc) {
        int index = this.getViewIndexAtPoint(boxView, x, y, alloc);
        if (index >= 0) {
            V view = this.getEditorViewChildrenValid(boxView, index);
            Shape childAlloc = this.getChildAllocation(boxView, index, index + 1, alloc);
            return ((EditorView)view).getToolTip(x, y, childAlloc);
        }
        return null;
    }

    protected void paint(EditorBoxView<V> boxView, Graphics2D g, Shape alloc, Rectangle clipBounds) {
        Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
        Rectangle2D.Double mutableBounds = (Rectangle2D.Double)allocBounds.clone();
        Rectangle2D.intersect(mutableBounds, clipBounds, mutableBounds);
        if (!mutableBounds.isEmpty()) {
            double endVisualOffset;
            double startVisualOffset;
            int majorAxis = boxView.getMajorAxis();
            if (majorAxis == 0) {
                startVisualOffset = mutableBounds.x;
                endVisualOffset = startVisualOffset + mutableBounds.width;
            } else {
                startVisualOffset = mutableBounds.y;
                endVisualOffset = startVisualOffset + mutableBounds.height;
            }
            this.paintChildren(boxView, g, alloc, clipBounds, startVisualOffset, endVisualOffset);
        }
    }

    protected void paintChildren(EditorBoxView<V> boxView, Graphics2D g, Shape alloc, Rectangle clipBounds, double startVisualOffset, double endVisualOffset) {
        int index = Math.max(this.getViewIndexFirst(startVisualOffset), 0);
        int endIndex = this.getViewIndexFirst(endVisualOffset) + 1;
        this.paintChildren(boxView, g, alloc, clipBounds, index, endIndex);
    }

    protected void paintChildren(EditorBoxView<V> boxView, Graphics2D g, Shape alloc, Rectangle clipBounds, int startIndex, int endIndex) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("EBView.paintChildren(): <" + startIndex + "," + endIndex + ">\n");
        }
        boxView.initChildren(startIndex - 1, endIndex + 1);
        while (startIndex < endIndex) {
            V view = this.getEditorViewChildrenValid(boxView, startIndex);
            Shape childAlloc = this.getChildAllocation(boxView, startIndex, startIndex + 1, alloc);
            ((EditorView)view).paint(g, childAlloc, clipBounds);
            ++startIndex;
        }
    }

    public StringBuilder appendChildrenInfo(EditorBoxView<V> boxView, StringBuilder sb, int indent, int importantIndex) {
        int viewCount = this.size();
        int digitCount = ArrayUtilities.digitCount((int)viewCount);
        int importantLastIndex = -1;
        int childImportantIndex = importantIndex == -2 ? -2 : -1;
        for (int i = 0; i < viewCount; ++i) {
            sb.append('\n');
            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
            ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
            EditorView view = (EditorView)this.get(i);
            view.appendViewInfo(sb, indent, childImportantIndex);
            boolean appendDots = false;
            if (i == 4) {
                if (importantIndex == -1) {
                    if (i < viewCount - 6) {
                        appendDots = true;
                        i = viewCount - 6;
                    }
                } else if (importantIndex >= 0) {
                    importantLastIndex = importantIndex + 3;
                    if (i < (importantIndex -= 3) - 1) {
                        appendDots = true;
                        i = importantIndex - 1;
                    }
                }
            } else if (i == importantLastIndex && i < viewCount - 6) {
                appendDots = true;
                i = viewCount - 6;
            }
            if (!appendDots) continue;
            sb.append('\n');
            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
            sb.append("...");
        }
        return sb;
    }

    protected StringBuilder appendViewInfoCore(StringBuilder sb, int indent, int importantChildIndex) {
        if (this.gapStorage != null) {
            this.gapStorage.appendInfo(sb);
        }
        return sb;
    }

    static final class GapStorage {
        static final double INITIAL_VISUAL_GAP_LENGTH = 2.147483647E9;
        static final int INITIAL_OFFSET_GAP_LENGTH = 0x3FFFFFFF;
        double visualGapStart = 2.147483647E9;
        double visualGapLength = 2.147483647E9;
        int offsetGapStart = 0x3FFFFFFF;
        int offsetGapLength = 0x3FFFFFFF;
        int offsetGapIndex;
        int visualGapIndex;

        GapStorage(int gapIndex) {
            this.offsetGapIndex = gapIndex;
            this.visualGapIndex = gapIndex;
        }

        StringBuilder appendInfo(StringBuilder sb) {
            sb.append("<").append(this.offsetGapStart).append("|").append(this.offsetGapLength);
            sb.append(", vis<").append(this.visualGapStart).append("|").append(this.visualGapLength);
            return sb;
        }

        public String toString() {
            return this.appendInfo(new StringBuilder(100)).toString();
        }
    }
}

