/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.lib2.highlighting.CompoundHighlightsContainer;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingSpiPackageAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerAccessor;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsLayerFilter;
import org.netbeans.modules.editor.lib2.highlighting.MultiLayerContainer;
import org.netbeans.modules.editor.lib2.highlighting.ProxyHighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

public final class HighlightingManager {
    private static final Logger LOG = Logger.getLogger(HighlightingManager.class.getName());
    public static final boolean LINEWRAP_ENABLED;
    private static HighlightingManager instance;

    public static synchronized HighlightingManager getInstance() {
        if (instance == null) {
            instance = new HighlightingManager();
        }
        return instance;
    }

    public synchronized HighlightsContainer getHighlights(JTextComponent pane, HighlightsLayerFilter filter) {
        Highlighting h = (Highlighting)pane.getClientProperty(Highlighting.class);
        if (h == null) {
            h = new Highlighting(pane);
            pane.putClientProperty(Highlighting.class, h);
        }
        return h.getContainer(filter == null ? HighlightsLayerFilter.IDENTITY : filter);
    }

    private HighlightingManager() {
    }

    private static String simpleToString(Object o) {
        return o == null ? "null" : o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    private static String mimePathsToString(MimePath ... mimePaths) {
        if (mimePaths == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (MimePath mp : mimePaths) {
            sb.append('\'').append(mp.getPath()).append('\'');
            sb.append(",");
        }
        sb.append('}');
        return sb.toString();
    }

    static {
        String value = System.getProperty("org.netbeans.editor.linewrap");
        LINEWRAP_ENABLED = value != null ? !value.equalsIgnoreCase("false") : true;
    }

    private static final class RegExpFilter
    implements HighlightsLayerFilter {
        private final List<Pattern> includes;
        private final List<Pattern> excludes;

        public RegExpFilter(Object includes, Object excludes) {
            this.includes = RegExpFilter.buildPatterns(includes);
            this.excludes = RegExpFilter.buildPatterns(excludes);
        }

        @Override
        public List<? extends HighlightsLayer> filterLayers(List<? extends HighlightsLayer> layers) {
            List<? extends HighlightsLayer> includedLayers = this.includes.isEmpty() ? layers : RegExpFilter.filter(layers, this.includes, true);
            List<? extends HighlightsLayer> filteredLayers = this.excludes.isEmpty() ? includedLayers : RegExpFilter.filter(includedLayers, this.excludes, false);
            return filteredLayers;
        }

        private static List<? extends HighlightsLayer> filter(List<? extends HighlightsLayer> layers, List<Pattern> patterns, boolean includeMatches) {
            ArrayList<HighlightsLayer> filtered = new ArrayList<HighlightsLayer>();
            for (HighlightsLayer highlightsLayer : layers) {
                HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                for (Pattern pattern : patterns) {
                    boolean matches = pattern.matcher(layerAccessor.getLayerTypeId()).matches();
                    if (matches && includeMatches) {
                        filtered.add(highlightsLayer);
                    }
                    if (matches || includeMatches) continue;
                    filtered.add(highlightsLayer);
                }
            }
            return filtered;
        }

        private static List<Pattern> buildPatterns(Object expressions) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            if (expressions instanceof String) {
                try {
                    patterns.add(Pattern.compile((String)expressions));
                }
                catch (PatternSyntaxException e) {
                    LOG.log(Level.WARNING, "Ignoring invalid regexp for the HighlightsLayer filtering.", e);
                }
            } else if (expressions instanceof String[]) {
                for (String expression : (String[])expressions) {
                    try {
                        patterns.add(Pattern.compile(expression));
                    }
                    catch (PatternSyntaxException e) {
                        LOG.log(Level.WARNING, "Ignoring invalid regexp for the HighlightsLayer filtering.", e);
                    }
                }
            }
            return patterns;
        }
    }

    private static final class Highlighting
    implements PropertyChangeListener {
        private static final String PROP_MIME_TYPE = "mimeType";
        private static final String PROP_DOCUMENT = "document";
        private static final String PROP_HL_INCLUDES = "HighlightsLayerIncludes";
        private static final String PROP_HL_EXCLUDES = "HighlightsLayerExcludes";
        private Lookup.Result<HighlightsLayerFactory> factories = null;
        private final LookupListener factoriesTracker = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Highlighting.this.rebuildAllLayers();
            }
        };
        private LookupListener weakFactoriesTracker = null;
        private Lookup.Result<FontColorSettings> settings = null;
        private final LookupListener settingsTracker = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Highlighting.this.rebuildAllLayers();
            }
        };
        private LookupListener weakSettingsTracker = null;
        private final JTextComponent pane;
        private HighlightsLayerFilter paneFilter;
        private Reference<Document> lastKnownDocumentRef;
        private MimePath[] lastKnownMimePaths = null;
        private boolean inRebuildAllLayers = false;
        private List<? extends HighlightsLayer> allLayers = null;
        private List<HighlightsContainer> allLayerContainers = null;
        private final WeakHashMap<HighlightsLayerFilter, WeakReference<MultiLayerContainer>> containers = new WeakHashMap();

        public Highlighting(JTextComponent pane) {
            this.pane = pane;
            this.paneFilter = new RegExpFilter(pane.getClientProperty(PROP_HL_INCLUDES), pane.getClientProperty(PROP_HL_EXCLUDES));
            this.pane.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)pane));
            this.rebuildAll();
        }

        public synchronized HighlightsContainer getContainer(HighlightsLayerFilter filter) {
            MultiLayerContainer container;
            WeakReference<MultiLayerContainer> ref = this.containers.get(filter);
            MultiLayerContainer multiLayerContainer = container = ref == null ? null : (MultiLayerContainer)ref.get();
            if (container == null) {
                container = LINEWRAP_ENABLED ? new ProxyHighlightsContainer() : new CompoundHighlightsContainer();
                this.rebuildContainer(this.pane.getDocument(), filter, container);
                this.containers.put(filter, new WeakReference<MultiLayerContainer>(container));
            }
            return container;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Document doc;
            if ((evt.getPropertyName() == null || PROP_DOCUMENT.equals(evt.getPropertyName())) && (doc = this.pane.getDocument()) != null) {
                doc.render(new Runnable(){

                    @Override
                    public void run() {
                        Highlighting.this.rebuildAll();
                    }
                });
            }
            if ((PROP_HL_INCLUDES.equals(evt.getPropertyName()) || PROP_HL_EXCLUDES.equals(evt.getPropertyName())) && (doc = this.pane.getDocument()) != null) {
                doc.render(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        4 var1_1 = this;
                        synchronized (var1_1) {
                            Highlighting.this.paneFilter = new RegExpFilter(Highlighting.this.pane.getClientProperty(Highlighting.PROP_HL_INCLUDES), Highlighting.this.pane.getClientProperty(Highlighting.PROP_HL_EXCLUDES));
                            Highlighting.this.rebuildAllContainers(Highlighting.this.pane.getDocument());
                        }
                    }
                });
            }
        }

        private MimePath[] getAllDocumentMimePath() {
            Document doc = this.pane.getDocument();
            Object propMimeType = doc.getProperty(PROP_MIME_TYPE);
            String mainMimeType = propMimeType != null ? propMimeType.toString() : this.pane.getUI().getEditorKit(this.pane).getContentType();
            return new MimePath[]{MimePath.parse((String)mainMimeType)};
        }

        private synchronized void rebuildAll() {
            Document lastKnownDocument;
            Object[] mimePaths = this.getAllDocumentMimePath();
            Document document = lastKnownDocument = this.lastKnownDocumentRef == null ? null : this.lastKnownDocumentRef.get();
            if (!Utilities.compareObjects((Object)lastKnownDocument, (Object)this.pane.getDocument()) || !Arrays.equals(this.lastKnownMimePaths, mimePaths)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("rebuildAll: lastKnownDocument = " + HighlightingManager.simpleToString(lastKnownDocument) + ", document = " + HighlightingManager.simpleToString(this.pane.getDocument()) + ", lastKnownMimePaths = " + HighlightingManager.mimePathsToString(this.lastKnownMimePaths) + ", mimePaths = " + HighlightingManager.mimePathsToString((MimePath[])mimePaths));
                }
                if (this.factories != null && this.weakFactoriesTracker != null) {
                    this.factories.removeLookupListener(this.weakFactoriesTracker);
                    this.weakFactoriesTracker = null;
                }
                if (this.settings != null && this.weakSettingsTracker != null) {
                    this.settings.removeLookupListener(this.weakSettingsTracker);
                    this.weakSettingsTracker = null;
                }
                if (mimePaths != null) {
                    ArrayList<Lookup> lookups = new ArrayList<Lookup>();
                    for (Object mimePath : mimePaths) {
                        lookups.add(MimeLookup.getLookup((MimePath)mimePath));
                    }
                    ProxyLookup lookup = new ProxyLookup(lookups.toArray(new Lookup[lookups.size()]));
                    this.factories = lookup.lookup(new Lookup.Template(HighlightsLayerFactory.class));
                    this.settings = lookup.lookup(new Lookup.Template(FontColorSettings.class));
                } else {
                    this.factories = null;
                    this.settings = null;
                }
                if (this.factories != null) {
                    this.weakFactoriesTracker = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.factoriesTracker, this.factories);
                    this.factories.addLookupListener(this.weakFactoriesTracker);
                    this.factories.allItems();
                }
                if (this.settings != null) {
                    this.weakSettingsTracker = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.settingsTracker, this.settings);
                    this.settings.addLookupListener(this.weakSettingsTracker);
                    this.settings.allItems();
                }
                lastKnownDocument = this.pane.getDocument();
                this.lastKnownMimePaths = mimePaths;
                this.rebuildAllLayers();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void rebuildAllLayers() {
            if (this.inRebuildAllLayers) {
                return;
            }
            this.inRebuildAllLayers = true;
            try {
                Document doc = this.pane.getDocument();
                if (this.factories != null) {
                    List sortedLayers;
                    Collection all = this.factories.allInstances();
                    HashMap<String, HighlightsLayer> layers = new HashMap<String, HighlightsLayer>();
                    HighlightsLayerFactory.Context context = HighlightingSpiPackageAccessor.get().createFactoryContext(doc, this.pane);
                    for (HighlightsLayerFactory factory : all) {
                        HighlightsLayer[] factoryLayers = factory.createLayers(context);
                        if (factoryLayers == null) continue;
                        for (HighlightsLayer layer : factoryLayers) {
                            HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(layer);
                            String layerTypeId = layerAccessor.getLayerTypeId();
                            if (layers.containsKey(layerTypeId)) continue;
                            layers.put(layerTypeId, layer);
                        }
                    }
                    try {
                        sortedLayers = HighlightingSpiPackageAccessor.get().sort(layers.values());
                    }
                    catch (TopologicalSortException tse) {
                        List sl;
                        ErrorManager.getDefault().notify((Throwable)tse);
                        sortedLayers = sl = tse.partialSort();
                    }
                    ArrayList<HighlightsContainer> layerContainers = new ArrayList<HighlightsContainer>();
                    for (HighlightsLayer layer : sortedLayers) {
                        HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(layer);
                        layerContainers.add(layerAccessor.getContainer());
                    }
                    this.allLayers = sortedLayers;
                    this.allLayerContainers = layerContainers;
                } else {
                    this.allLayers = null;
                    this.allLayerContainers = null;
                }
                this.rebuildAllContainers(doc);
            }
            finally {
                this.inRebuildAllLayers = false;
            }
        }

        private synchronized void rebuildAllContainers(Document document) {
            if (LOG.isLoggable(Level.FINE)) {
                Document lastKnownDocument = this.lastKnownDocumentRef == null ? null : this.lastKnownDocumentRef.get();
                LOG.fine("rebuildAllContainers: lastKnownDocument = " + HighlightingManager.simpleToString(lastKnownDocument) + ", lastKnownMimePaths = " + HighlightingManager.mimePathsToString(this.lastKnownMimePaths));
            }
            for (HighlightsLayerFilter filter : this.containers.keySet()) {
                WeakReference<MultiLayerContainer> ref = this.containers.get(filter);
                MultiLayerContainer container = ref == null ? null : (MultiLayerContainer)ref.get();
                if (container == null) continue;
                this.rebuildContainer(document, filter, container);
            }
        }

        private synchronized void rebuildContainer(Document doc, HighlightsLayerFilter filter, MultiLayerContainer container) {
            if (this.allLayers != null) {
                List<? extends HighlightsLayer> filteredLayers = this.paneFilter.filterLayers(Collections.unmodifiableList(this.allLayers));
                filteredLayers = filter.filterLayers(Collections.unmodifiableList(filteredLayers));
                ArrayList<HighlightsContainer> hcs = new ArrayList<HighlightsContainer>();
                for (HighlightsLayer highlightsLayer : filteredLayers) {
                    int idx = this.allLayers.indexOf(highlightsLayer);
                    HighlightsContainer c = this.allLayerContainers.get(idx);
                    hcs.add(c);
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    Highlighting.logLayers(this.pane.getDocument(), this.lastKnownMimePaths, filteredLayers, Level.FINEST);
                }
                container.setLayers(doc, hcs.toArray(new HighlightsContainer[hcs.size()]));
            } else {
                container.setLayers(null, null);
            }
        }

        private static void logLayers(Document doc, MimePath[] mimePaths, List<? extends HighlightsLayer> layers, Level logLevel) {
            StringBuilder sb = new StringBuilder();
            sb.append("HighlighsLayers {\n");
            sb.append(" * document : ");
            sb.append(doc.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(doc)));
            Object streamDescriptor = doc.getProperty("stream");
            sb.append(" [").append(streamDescriptor == null ? "no stream descriptor" : streamDescriptor.toString()).append(']');
            sb.append("\n");
            sb.append(" * mime paths : \n");
            for (MimePath mimePath : mimePaths) {
                sb.append("    ");
                sb.append(mimePath.getPath());
                sb.append("\n");
            }
            sb.append(" * layers : \n");
            for (HighlightsLayer highlightsLayer : layers) {
                HighlightsLayerAccessor layerAccessor = HighlightingSpiPackageAccessor.get().getHighlightsLayerAccessor(highlightsLayer);
                sb.append("    ");
                sb.append(layerAccessor.getLayerTypeId());
                sb.append('[');
                sb.append(layerAccessor.getZOrder().toString());
                sb.append(']');
                sb.append('@');
                sb.append(Integer.toHexString(System.identityHashCode(highlightsLayer)));
                sb.append("\n");
            }
            sb.append("}\n");
            LOG.log(logLevel, sb.toString());
        }
    }
}

