/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.modelimpl.trace.TraceXRef;
import org.netbeans.modules.cnd.modelui.trace.TestFileContainerAction;
import org.netbeans.modules.cnd.modelui.trace.TestProjectActionBase;
import org.netbeans.modules.cnd.modelui.trace.TestReferencePanel;
import org.netbeans.modules.cnd.modelui.trace.TestReparseAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class TestProjectReferencesAction
extends TestProjectActionBase {
    private static boolean running = false;
    private final boolean allReferences;
    private final boolean analyzeStatistics;
    private final Boolean reportUnresolved;
    private int numThreads = 1;
    private long timeThreshold = 0L;
    private static final Map<CharSequence, Map<CharSequence, Long>> times = new HashMap<CharSequence, Map<CharSequence, Long>>();

    public static Action getSmartCompletionAnalyzerAction() {
        return (Action)SharedClassObject.findObject(SmartCompletionAnalyzerAction.class, (boolean)true);
    }

    public static Action getTestReparseAction() {
        return (Action)SharedClassObject.findObject(TestReparseAction.class, (boolean)true);
    }

    public static Action getDirectUsageReferencesAction() {
        return (Action)SharedClassObject.findObject(DirectUsageAction.class, (boolean)true);
    }

    public static Action getAllReferencesAction() {
        return (Action)SharedClassObject.findObject(AllUsagesAction.class, (boolean)true);
    }

    public static Action getAllReferencesPerformanceAction() {
        return (Action)SharedClassObject.findObject(AllUsagesPerformanceAction.class, (boolean)true);
    }

    public static Action getFileContainerAction() {
        return (Action)SharedClassObject.findObject(TestFileContainerAction.class, (boolean)true);
    }

    private Map<CharSequence, Long> getProjectMap(CsmProject csmProject) {
        CharSequence charSequence = csmProject.getName();
        Map<CharSequence, Long> map = times.get(charSequence);
        if (map == null) {
            map = new ConcurrentHashMap<CharSequence, Long>();
            this.loadXRefTimes(csmProject, map);
            times.put(charSequence, map);
        }
        return map;
    }

    private void loadXRefTimes(CsmProject csmProject, Map<CharSequence, Long> map) throws NumberFormatException {
        Preferences preferences = this.getProjectPrefs(csmProject);
        if (preferences != null) {
            String[] stringArray;
            String string = preferences.get("xRefTimes", "");
            for (String string2 : stringArray = string.split("\n")) {
                int n = string2.lastIndexOf("|");
                if (n <= 0) continue;
                try {
                    map.put(CharSequences.create((CharSequence)string2.substring(0, n)), Long.parseLong(string2.substring(n + 1)));
                }
                catch (NumberFormatException numberFormatException) {
                    Exceptions.printStackTrace((Throwable)numberFormatException);
                }
            }
        }
    }

    private void saveXRefTimes(CsmProject csmProject, Map<CharSequence, Long> map) throws NumberFormatException {
        Preferences preferences = this.getProjectPrefs(csmProject);
        if (preferences != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<CharSequence, Long> entry : map.entrySet()) {
                stringBuilder.append(entry.getKey()).append("|").append(entry.getValue().toString()).append("\n");
            }
            preferences.put("xRefTimes", stringBuilder.toString());
        }
    }

    protected TestProjectReferencesAction(boolean bl, boolean bl2, Boolean bl3) {
        this.allReferences = bl;
        this.analyzeStatistics = bl2;
        this.reportUnresolved = bl3;
        this.numThreads = bl3 == Boolean.FALSE ? Runtime.getRuntime().availableProcessors() : 1;
    }

    public String getName() {
        String string = this.analyzeStatistics ? "CTL_TestProjectSmartCCDirectUsageReferencesAction" : (this.reportUnresolved != null ? (this.reportUnresolved != false ? "CTL_TestProjectReferencesAction" : "CTL_TestProjectReferencesPerformanceAction") : "CTL_TestProjectDirectUsageReferencesAction");
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)string);
    }

    @Override
    protected void performAction(Collection<CsmProject> collection) {
        if (this.reportUnresolved == Boolean.FALSE) {
            CsmProject csmProject2;
            boolean bl = false;
            if (collection != null) {
                for (CsmProject csmProject2 : collection) {
                    bl |= !this.getProjectMap(csmProject2).isEmpty();
                }
            }
            TestReferencePanel testReferencePanel = new TestReferencePanel(this.numThreads, this.timeThreshold, bl);
            csmProject2 = new NotifyDescriptor((Object)testReferencePanel, "Test References", -1, 3, new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)csmProject2);
            if (object == NotifyDescriptor.CANCEL_OPTION) {
                return;
            }
            this.numThreads = testReferencePanel.getThreadsNumber();
            this.timeThreshold = testReferencePanel.getThreshold();
            if (!testReferencePanel.isCollecting()) {
                this.timeThreshold = -this.timeThreshold;
            }
        }
        if (collection != null) {
            for (CsmProject csmProject : collection) {
                this.testProject(csmProject);
            }
        }
    }

    private void testProject(CsmProject csmProject) {
        Map<CharSequence, Long> map;
        long l;
        String string = (this.allReferences ? "All " : "Direct usage ") + "xRef - " + csmProject.getName() + (this.analyzeStatistics ? " Statistics" : "");
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        inputOutput.select();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string, (Cancellable)new Cancellable(){

            public boolean cancel() {
                atomicBoolean.set(true);
                return true;
            }
        });
        progressHandle.start();
        final OutputWriter outputWriter = inputOutput.getOut();
        final OutputWriter outputWriter2 = inputOutput.getErr();
        final long[] lArray = new long[2];
        lArray[0] = System.currentTimeMillis();
        EnumSet<CsmReferenceKind> enumSet = this.allReferences ? CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE : EnumSet.of(CsmReferenceKind.DIRECT_USAGE);
        Map<CharSequence, Long> map2 = this.getProjectMap(csmProject);
        if (this.timeThreshold > 0L) {
            map2.clear();
        }
        if ((l = this.timeThreshold) < 0L) {
            l = 0L;
            map = new ConcurrentHashMap<CharSequence, Long>(map2.size());
            for (Map.Entry<CharSequence, Long> entry : map2.entrySet()) {
                if (entry.getValue() <= -this.timeThreshold) continue;
                map.put(entry.getKey(), entry.getValue());
            }
            outputWriter2.println("analyze " + map.size() + " remembered slow files only");
        } else {
            map = map2;
            if (l > 0L) {
                outputWriter2.println("collect files slower than " + l + "ms");
                map.clear();
            }
        }
        TraceXRef.traceProjectRefsStatistics((CsmProject)csmProject, map, (TraceXRef.StatisticsParameters)new TraceXRef.StatisticsParameters(enumSet, this.analyzeStatistics, this.reportUnresolved == null ? true : this.reportUnresolved, this.numThreads, l), (PrintWriter)outputWriter, (OutputWriter)outputWriter2, (CsmProgressListener)new CsmProgressAdapter(){
            private volatile int handled = 0;

            public void projectFilesCounted(CsmProject csmProject, int n) {
                outputWriter2.flush();
                outputWriter.println("Project " + csmProject.getName() + " has " + n + " files");
                outputWriter.flush();
                progressHandle.switchToDeterminate(n);
            }

            public synchronized void fileParsingStarted(CsmFile csmFile) {
                progressHandle.progress("Analyzing " + csmFile.getName(), ++this.handled);
            }

            public void projectParsingFinished(CsmProject csmProject) {
                lArray[1] = System.currentTimeMillis();
            }
        }, (AtomicBoolean)atomicBoolean);
        progressHandle.finish();
        outputWriter.println("Analyzing " + csmProject.getName() + " took " + (lArray[1] - lArray[0]) + "ms");
        if (this.timeThreshold > 0L) {
            this.saveXRefTimes(csmProject, map2);
            outputWriter2.println(map2.size() + " files which were analyzed longer than " + this.timeThreshold + "ms are remembered");
        }
        outputWriter2.flush();
        outputWriter.flush();
        outputWriter.close();
        outputWriter2.close();
    }

    static final class AllUsagesPerformanceAction
    extends TestProjectReferencesAction {
        AllUsagesPerformanceAction() {
            super(true, false, Boolean.FALSE);
        }
    }

    static final class AllUsagesAction
    extends TestProjectReferencesAction {
        AllUsagesAction() {
            super(true, false, Boolean.TRUE);
        }
    }

    static final class DirectUsageAction
    extends TestProjectReferencesAction {
        DirectUsageAction() {
            super(false, false, null);
        }
    }

    static final class SmartCompletionAnalyzerAction
    extends TestProjectReferencesAction {
        SmartCompletionAnalyzerAction() {
            super(false, true, null);
        }
    }
}

