/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.refactoring;

import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstMethodSuffix;
import com.sun.el.parser.AstPropertySuffix;
import com.sun.el.parser.Node;
import com.sun.el.parser.NodeVisitor;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELIndex;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.ELVariableResolvers;
import org.netbeans.modules.web.el.refactoring.ELRefactoringPlugin;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.netbeans.modules.web.el.refactoring.WhereUsedQueryElement;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ELWhereUsedQuery
extends ELRefactoringPlugin {
    private static final Logger LOGGER = Logger.getLogger(ELWhereUsedQuery.class.getName());
    protected RefactoringSessionContext refactoringContext;

    ELWhereUsedQuery(AbstractRefactoring whereUsedQuery) {
        super(whereUsedQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        TreePathHandle handle = this.getHandle();
        if (handle == null) {
            return null;
        }
        CompilationInfo info = RefactoringUtil.getCompilationInfo(handle, this.refactoring);
        ELTypeUtilities typeUtilities = ELTypeUtilities.create(info.getFileObject(), (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class));
        this.refactoringContext = new RefactoringSessionContext(info, typeUtilities);
        try {
            Element element = this.resolveElement(handle);
            if (element == null) {
                LOGGER.log(Level.INFO, "Could not resolve Element for TPH: {0}", handle);
                Problem problem = null;
                return problem;
            }
            if ((Tree.Kind.METHOD == handle.getKind() || Tree.Kind.MEMBER_SELECT == handle.getKind()) && element instanceof ExecutableElement) {
                Problem problem = this.handleProperty(refactoringElementsBag, handle, (ExecutableElement)element);
                return problem;
            }
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)handle.getKind())) {
                Problem problem = this.handleClass(refactoringElementsBag, handle, element);
                return problem;
            }
        }
        finally {
            this.refactoringContext.dispose();
        }
        return null;
    }

    private Element resolveElement(final TreePathHandle handle) {
        ClasspathInfo cpInfo = (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class);
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{handle.getFileObject()});
        final Element[] result = new Element[1];
        try {
            source.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    result[0] = handle.resolveElement((CompilationInfo)cc);
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result[0];
    }

    protected Problem handleClass(RefactoringElementsBag refactoringElementsBag, TreePathHandle handle, Element targetType) {
        TypeElement type = (TypeElement)targetType;
        String clazz = type.getQualifiedName().toString();
        String beanName = ELVariableResolvers.findBeanName(clazz, this.getFileObject());
        if (beanName != null) {
            ELIndex index = ELIndex.get(handle.getFileObject());
            Collection<? extends IndexResult> result = index.findIdentifierReferences(beanName);
            for (ELElement elem : this.getMatchingElements(result)) {
                this.addElements(elem, this.findMatchingIdentifierNodes(elem.getNode(), beanName), refactoringElementsBag);
            }
        }
        return null;
    }

    protected Problem handleProperty(RefactoringElementsBag refactoringElementsBag, TreePathHandle handle, ExecutableElement targetType) {
        String propertyName = RefactoringUtil.getPropertyName(targetType.getSimpleName().toString());
        ELIndex index = ELIndex.get(handle.getFileObject());
        HashSet<Object> result = new HashSet<Object>();
        if (targetType.getParameters().isEmpty() || targetType.getParameters().size() == 1 && targetType.isVarArgs()) {
            result.addAll(index.findPropertyReferences(propertyName));
        }
        result.addAll(index.findMethodReferences(propertyName));
        for (ELElement each : this.getMatchingElements(result)) {
            List<ELVariableResolver.VariableInfo> variables = ELVariableResolvers.getVariables(each.getSnapshot(), each.getOriginalOffset().getStart());
            List<Node> matchingNodes = this.findMatchingPropertyNodes(each.getNode(), targetType, each.getSnapshot().getSource().getFileObject(), variables);
            this.addElements(each, matchingNodes, refactoringElementsBag);
        }
        return null;
    }

    protected void addElements(ELElement elem, List<Node> matchingNodes, RefactoringElementsBag refactoringElementsBag) {
        for (Node property : matchingNodes) {
            WhereUsedQueryElement wuqe = new WhereUsedQueryElement(elem.getSnapshot().getSource().getFileObject(), property.getImage(), elem, property, ELWhereUsedQuery.getParserResult(elem.getSnapshot().getSource().getFileObject()));
            refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)wuqe);
        }
    }

    private List<Node> findMatchingPropertyNodes(Node root, final ExecutableElement targetMethod, final FileObject context, final List<ELVariableResolver.VariableInfo> variables) {
        final ArrayList<Node> result = new ArrayList<Node>();
        final TypeMirror targetType = targetMethod.getEnclosingElement().asType();
        root.accept(new NodeVisitor(){

            public void visit(Node node) throws ELException {
                if (node instanceof AstIdentifier) {
                    Node parent = node.jjtGetParent();
                    String astIdent = node.getImage();
                    String beanClass = ELVariableResolvers.findBeanClass(astIdent, context);
                    TypeElement fmbType = null;
                    if (beanClass != null) {
                        fmbType = ELWhereUsedQuery.this.refactoringContext.getInfo().getElements().getTypeElement(beanClass);
                    } else {
                        ELVariableResolver.VariableInfo var = ELWhereUsedQuery.this.findVariable(astIdent, variables);
                        if (var != null) {
                            if (var.clazz != null) {
                                beanClass = var.clazz;
                            } else {
                                fmbType = (TypeElement)ELWhereUsedQuery.this.refactoringContext.getUtilities().getReferredType(var, context);
                            }
                        }
                    }
                    if (fmbType == null) {
                        return;
                    }
                    TypeMirror enclosing = fmbType.asType();
                    for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                        Node child = parent.jjtGetChild(i);
                        if (!(child instanceof AstPropertySuffix) && !(child instanceof AstMethodSuffix)) continue;
                        if (enclosing == null) break;
                        if (ELWhereUsedQuery.this.isSameTypeOrSupertype(targetType, enclosing) && ELWhereUsedQuery.this.refactoringContext.getUtilities().isSameMethod(child, targetMethod)) {
                            TypeMirror matching = ELWhereUsedQuery.this.getTypeForProperty(child, enclosing);
                            if (matching == null) continue;
                            result.add(child);
                            continue;
                        }
                        enclosing = ELWhereUsedQuery.this.getTypeForProperty(child, enclosing);
                    }
                }
            }
        });
        return result;
    }

    private boolean isSameTypeOrSupertype(TypeMirror tm1, TypeMirror tm2) {
        DeclaredType declaredTm2 = (DeclaredType)tm2;
        List<Element> all = this.refactoringContext.getUtilities().getSuperTypesFor(declaredTm2.asElement());
        for (Element e : all) {
            TypeMirror tm = e.asType();
            if (!this.isSameType(tm1, tm)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameType(TypeMirror tm1, TypeMirror tm2) {
        if (this.refactoringContext.getInfo().getTypes().isSameType(tm1, tm2)) {
            return true;
        }
        if (tm1.getKind() == TypeKind.DECLARED && tm2.getKind() == TypeKind.DECLARED) {
            return ((DeclaredType)tm1).asElement().getSimpleName().contentEquals(((DeclaredType)tm2).asElement().getSimpleName());
        }
        return false;
    }

    private ELVariableResolver.VariableInfo findVariable(String varName, List<ELVariableResolver.VariableInfo> variables) {
        for (ELVariableResolver.VariableInfo var : variables) {
            if (!var.name.equals(varName)) continue;
            return var;
        }
        return null;
    }

    private List<Node> findMatchingIdentifierNodes(Node root, final String identifierName) {
        final ArrayList<Node> result = new ArrayList<Node>();
        root.accept(new NodeVisitor(){

            public void visit(Node node) throws ELException {
                if (node instanceof AstIdentifier && identifierName.equals(node.getImage())) {
                    result.add(node);
                }
            }
        });
        return result;
    }

    private TypeMirror getTypeForProperty(Node property, TypeMirror enclosing) {
        String name = property.getImage();
        Element el = this.refactoringContext.getInfo().getTypes().asElement(enclosing);
        for (Element element : this.refactoringContext.getUtilities().getSuperTypesFor(el)) {
            List<? extends Element> enclosedElements = element.getEnclosedElements();
            for (ExecutableElement each : ElementFilter.methodsIn(enclosedElements)) {
                if (!each.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                ExecutableElement methodElem = each;
                String methodName = methodElem.getSimpleName().toString();
                if (this.refactoringContext.getUtilities().isSameMethod(property, methodElem)) {
                    return this.refactoringContext.getUtilities().getReturnType(methodElem);
                }
                if (!RefactoringUtil.getPropertyName(methodName).equals(name) && !methodName.equals(name)) continue;
                return this.refactoringContext.getUtilities().getReturnType(methodElem);
            }
        }
        return null;
    }

    private List<ELElement> getMatchingElements(Collection<? extends IndexResult> indexResult) {
        ArrayList<ELElement> result = new ArrayList<ELElement>();
        for (IndexResult indexResult2 : indexResult) {
            FileObject file = indexResult2.getFile();
            ELRefactoringPlugin.ParserResultHolder parserResultHolder = ELWhereUsedQuery.getParserResult(file);
            if (parserResultHolder.parserResult == null) continue;
            String expression = indexResult2.getValue("expression");
            for (ELElement element : parserResultHolder.parserResult.getElements()) {
                if (!expression.equals(element.getExpression().getPreprocessedExpression()) || result.contains(element)) continue;
                result.add(element);
            }
        }
        return result;
    }

    protected class RefactoringSessionContext {
        private CompilationInfo info;
        private ELTypeUtilities utilities;
        private boolean active;

        public RefactoringSessionContext(CompilationInfo info, ELTypeUtilities utilities) {
            this.info = info;
            this.utilities = utilities;
            this.active = true;
        }

        public CompilationInfo getInfo() {
            this.checkActive();
            return this.info;
        }

        public ELTypeUtilities getUtilities() {
            this.checkActive();
            return this.utilities;
        }

        protected void dispose() {
            this.info = null;
            this.utilities = null;
            this.active = false;
        }

        private void checkActive() {
            if (!this.active) {
                throw new IllegalStateException("already disposed");
            }
        }
    }
}

