/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.completion;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.swing.ImageIcon;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.completion.ELElementHandle;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

final class ELJavaCompletionItem
extends DefaultCompletionProposal {
    private static final String ICON_PATH = "org/netbeans/modules/web/el/completion/resources/jsf_bean_16.png";
    private final String elementName;
    private final Element javaElement;
    private final ELElement elElement;
    private final ELTypeUtilities typeUtilities;
    private final ElementHandleAdapter adapter;

    public ELJavaCompletionItem(Element javaElement, ELElement elElement, ELTypeUtilities typeUtilities) {
        this(javaElement, null, elElement, typeUtilities);
    }

    public ELJavaCompletionItem(Element javaElement, String elementName, ELElement elElement, ELTypeUtilities typeUtilities) {
        assert (javaElement != null);
        this.javaElement = javaElement;
        this.elElement = elElement;
        this.typeUtilities = typeUtilities;
        this.elementName = elementName;
        this.adapter = new ElementHandleAdapter();
        this.setAnchorOffset(elElement.getOriginalOffset().getStart());
    }

    public ElementHandle getElement() {
        return this.adapter;
    }

    public String getName() {
        return this.adapter.getName();
    }

    public org.netbeans.modules.csl.api.ElementKind getKind() {
        return this.adapter.getKind();
    }

    public Set<Modifier> getModifiers() {
        return Collections.singleton(Modifier.PUBLIC);
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        org.netbeans.modules.csl.api.ElementKind kind = this.getKind();
        formatter.name(kind, true);
        formatter.appendText(this.getName());
        if (this.adapter.isMethod() && !this.adapter.isPropertyMethod()) {
            if (this.adapter.isMethodWithParamaters()) {
                formatter.appendText(this.typeUtilities.getParametersAsString((ExecutableElement)this.javaElement));
            } else {
                formatter.appendText("()");
            }
        }
        formatter.name(kind, false);
        return formatter.getText();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return this.typeUtilities.getTypeNameFor(this.javaElement);
    }

    public ImageIcon getIcon() {
        if (this.adapter.getKind() == org.netbeans.modules.csl.api.ElementKind.CLASS) {
            return ImageUtilities.loadImageIcon((String)ICON_PATH, (boolean)false);
        }
        return super.getIcon();
    }

    public List<String> getInsertParams() {
        if (!this.adapter.isMethod()) {
            return null;
        }
        if (this.adapter.isPropertyMethod()) {
            return null;
        }
        return !this.adapter.isPropertyMethod() && this.adapter.isMethodWithParamaters() ? this.typeUtilities.getParameterNames((ExecutableElement)this.javaElement) : Collections.singletonList("");
    }

    public String[] getParamListDelimiters() {
        return new String[]{"(", ")"};
    }

    final class ElementHandleAdapter
    extends ELElementHandle {
        ElementHandleAdapter() {
        }

        public FileObject getFileObject() {
            return ELJavaCompletionItem.this.elElement.getSnapshot().getSource().getFileObject();
        }

        public String getMimeType() {
            return "text/java";
        }

        public String getName() {
            return ELJavaCompletionItem.this.elementName != null ? ELJavaCompletionItem.this.elementName : RefactoringUtil.getPropertyName(ELJavaCompletionItem.this.javaElement.getSimpleName().toString(), true);
        }

        public String getIn() {
            if (this.isMethod()) {
                return ELJavaCompletionItem.this.javaElement.getEnclosingElement().getSimpleName().toString();
            }
            return ELJavaCompletionItem.this.javaElement.getSimpleName().toString();
        }

        public org.netbeans.modules.csl.api.ElementKind getKind() {
            if (this.isPropertyMethod()) {
                return org.netbeans.modules.csl.api.ElementKind.PROPERTY;
            }
            return this.isMethod() ? org.netbeans.modules.csl.api.ElementKind.METHOD : org.netbeans.modules.csl.api.ElementKind.CLASS;
        }

        public Set<Modifier> getModifiers() {
            return Collections.singleton(Modifier.PUBLIC);
        }

        public boolean signatureEquals(ElementHandle handle) {
            return this.getName().equals(handle.getName());
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return ELJavaCompletionItem.this.elElement.getOriginalOffset();
        }

        public Element getOriginalElement() {
            return ELJavaCompletionItem.this.javaElement;
        }

        private boolean isMethod() {
            return ELJavaCompletionItem.this.javaElement.getKind() == ElementKind.METHOD;
        }

        private boolean isMethodWithParamaters() {
            return this.isMethod() && !ELJavaCompletionItem.this.typeUtilities.getParameterNames((ExecutableElement)ELJavaCompletionItem.this.javaElement).isEmpty();
        }

        private boolean isPropertyMethod() {
            return this.isMethod() && !this.isMethodWithParamaters() && RefactoringUtil.isPropertyAccessor(ELJavaCompletionItem.this.javaElement.getSimpleName().toString());
        }

        @Override
        String document(ParserResult info) {
            final String[] result = new String[1];
            try {
                ClasspathInfo cp = ClasspathInfo.create((FileObject)info.getSnapshot().getSource().getFileObject());
                JavaSource source = JavaSource.create((ClasspathInfo)cp, (FileObject[])new FileObject[0]);
                if (source == null) {
                    return null;
                }
                source.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController parameter) throws Exception {
                        ElementJavadoc javadoc = ElementJavadoc.create((CompilationInfo)parameter, (Element)ElementHandleAdapter.this.getOriginalElement());
                        result[0] = javadoc.getText();
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return result[0];
        }
    }
}

