/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.editor.CssHelpResolver;
import org.netbeans.modules.css.editor.CssProjectSupport;
import org.netbeans.modules.css.editor.CssPropertyValue;
import org.netbeans.modules.css.editor.Property;
import org.netbeans.modules.css.editor.PropertyModel;
import org.netbeans.modules.css.editor.model.HtmlTags;
import org.netbeans.modules.css.gsf.CssCompletionItem;
import org.netbeans.modules.css.gsf.CssElement;
import org.netbeans.modules.css.gsf.CssPropertyElement;
import org.netbeans.modules.css.gsf.CssValueElement;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.indexing.CssIndex;
import org.netbeans.modules.css.lexer.api.CssTokenId;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.FileReferenceCompletion;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;

public class CssCompletion
implements CodeCompletionHandler {
    private final PropertyModel PROPERTIES = PropertyModel.instance();
    private static final Collection<String> AT_RULES = Arrays.asList("@media", "@page", "@import", "@charset", "@font-face");
    private static char firstPrefixChar;

    public CodeCompletionResult complete(CodeCompletionContext context) {
        String prefix;
        CssParserResult info = (CssParserResult)context.getParserResult();
        Snapshot snapshot = info.getSnapshot();
        FileObject file = snapshot.getSource().getFileObject();
        int caretOffset = context.getCaretOffset();
        String string = prefix = context.getPrefix() != null ? context.getPrefix() : "";
        if (firstPrefixChar != '\u0000') {
            prefix = firstPrefixChar + prefix;
        }
        TokenHierarchy th = snapshot.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(CssTokenId.language());
        assert (ts != null);
        CodeCompletionResult lexicalCompletionResult = this.handleLexicalBasedCompletion(file, (TokenSequence<CssTokenId>)ts, snapshot, caretOffset);
        if (lexicalCompletionResult != null) {
            return lexicalCompletionResult;
        }
        int offset = caretOffset - prefix.length();
        int astOffset = snapshot.getEmbeddedOffset(offset);
        boolean unmappableClassOrId = false;
        if (astOffset == -1) {
            if (prefix.length() == 1 && prefix.charAt(0) == '.' || prefix.length() > 0 && prefix.charAt(0) == '#') {
                unmappableClassOrId = true;
            } else {
                return null;
            }
        }
        ts.move(astOffset);
        boolean hasNext = ts.moveNext();
        SimpleNode root = info.root();
        if (root == null) {
            return CodeCompletionResult.NONE;
        }
        int astCaretOffset = snapshot.getEmbeddedOffset(caretOffset);
        char charAfterCaret = snapshot.getText().length() > astCaretOffset + 1 ? (char)snapshot.getText().subSequence(astCaretOffset, astCaretOffset + 1).charAt(0) : (char)' ';
        SimpleNode node = SimpleNodeUtil.findDescendant(root, astCaretOffset);
        if (node == null) {
            if (hasNext && ts.token().text().charAt(0) == '@') {
                return this.wrapRAWValues(AT_RULES, CssCompletionItem.Kind.VALUE, ts.offset());
            }
            return CodeCompletionResult.NONE;
        }
        int originalNodeKind = node.kind();
        if (node.kind() == 36 && (node = (SimpleNode)node.jjtGetParent()) == null) {
            return CodeCompletionResult.NONE;
        }
        if (node.kind() == 23 || (unmappableClassOrId || originalNodeKind == 36) && prefix.length() == 1 && prefix.charAt(0) == '.') {
            CssProjectSupport sup;
            if (file != null && (sup = CssProjectSupport.findFor(file)) != null) {
                CssIndex index = sup.getIndex();
                DependenciesGraph deps = index.getDependencies(file);
                Collection refered = deps.getAllReferedFiles();
                if (prefix.length() == 1 && prefix.charAt(0) == '.') {
                    prefix = "";
                    ++offset;
                }
                Map<FileObject, Collection<String>> search = index.findClassesByPrefix(prefix);
                HashSet<String> refclasses = new HashSet<String>();
                HashSet<String> allclasses = new HashSet<String>();
                for (FileObject fo : search.keySet()) {
                    allclasses.addAll(search.get(fo));
                    if (!refered.contains(fo)) continue;
                    refclasses.addAll(search.get(fo));
                }
                ArrayList<CssCompletionItem> proposals = new ArrayList<CssCompletionItem>(refclasses.size());
                for (String clazz : allclasses) {
                    proposals.add(CssCompletionItem.createSelectorCompletionItem(new CssElement(clazz), clazz, CssCompletionItem.Kind.VALUE, offset, refclasses.contains(clazz)));
                }
                if (proposals.size() > 0) {
                    return new DefaultCompletionResult(proposals, false);
                }
            }
        } else if (prefix.length() > 0 && (node.kind() == 27 || (unmappableClassOrId || originalNodeKind == 41 || originalNodeKind == 39) && prefix.charAt(0) == '#')) {
            CssProjectSupport sup;
            if (file != null && (sup = CssProjectSupport.findFor(file)) != null) {
                CssIndex index = sup.getIndex();
                DependenciesGraph deps = index.getDependencies(file);
                Collection refered = deps.getAllReferedFiles();
                prefix = prefix.length() == 1 && prefix.charAt(0) == '#' ? "" : prefix.substring(1);
                ++offset;
                Map<FileObject, Collection<String>> search = index.findIdsByPrefix(prefix);
                HashSet<String> allids = new HashSet<String>();
                HashSet<String> refids = new HashSet<String>();
                for (FileObject fo : search.keySet()) {
                    allids.addAll(search.get(fo));
                    if (!refered.contains(fo)) continue;
                    refids.addAll(search.get(fo));
                }
                ArrayList<CssCompletionItem> proposals = new ArrayList<CssCompletionItem>(allids.size());
                for (String id : allids) {
                    proposals.add(CssCompletionItem.createSelectorCompletionItem(new CssElement(id), id, CssCompletionItem.Kind.VALUE, offset, refids.contains(id)));
                }
                if (proposals.size() > 0) {
                    return new DefaultCompletionResult(proposals, false);
                }
            }
        } else {
            if (node.kind() == 1) {
                ArrayList<CompletionProposal> all = new ArrayList<CompletionProposal>();
                all.addAll(this.wrapRAWValues(AT_RULES, CssCompletionItem.Kind.VALUE, caretOffset).getItems());
                all.addAll(this.completeHtmlSelectors(prefix, caretOffset));
                return new DefaultCompletionResult(all, false);
            }
            if (node.kind() == 7 || node.kind() == 9) {
                return new DefaultCompletionResult(this.completeHtmlSelectors(prefix, caretOffset), false);
            }
            if (node.kind() == 38 || node.kind() == 41) {
                SimpleNode parent = (SimpleNode)node.jjtGetParent();
                if (parent != null && (parent.kind() == 5 || parent.kind() == 2)) {
                    Collection<String> possibleValues = this.filterStrings(AT_RULES, prefix);
                    return this.wrapRAWValues(possibleValues, CssCompletionItem.Kind.VALUE, snapshot.getOriginalOffset(parent.startOffset()));
                }
            } else if (node.kind() == 6 || node.kind() == 7 || node.kind() == 12 || node.kind() == 4 || node.kind() == 14) {
                TokenId id;
                if (hasNext && ((id = ts.token().id()) == CssTokenId.IMPORT_SYM || id == CssTokenId.MEDIA_SYM || id == CssTokenId.PAGE_SYM || id == CssTokenId.CHARSET_SYM || id == CssTokenId.FONT_FACE_SYM)) {
                    Collection<String> possibleValues = this.filterStrings(AT_RULES, prefix);
                    return this.wrapRAWValues(possibleValues, CssCompletionItem.Kind.VALUE, snapshot.getOriginalOffset(node.startOffset()));
                }
            } else {
                if (node.kind() == 18 && (prefix.length() > 0 || astCaretOffset == node.startOffset())) {
                    Collection<Property> possibleProps = this.filterProperties(this.PROPERTIES.properties(), prefix);
                    return this.wrapProperties(possibleProps, CssCompletionItem.Kind.PROPERTY, snapshot.getOriginalOffset(node.startOffset()));
                }
                if (node.kind() == 19) {
                    return this.wrapProperties(this.PROPERTIES.properties(), CssCompletionItem.Kind.PROPERTY, caretOffset);
                }
                if (node.kind() == 29) {
                    Property prop;
                    final SimpleNode[] result = new SimpleNode[2];
                    NodeVisitor propertySearch = new NodeVisitor(){

                        @Override
                        public void visit(SimpleNode node) {
                            if (node.kind() == 18) {
                                result[0] = node;
                            } else if (node.kind() == 40) {
                                result[1] = node;
                            }
                        }
                    };
                    node.visitChildren(propertySearch);
                    SimpleNode property = result[0];
                    if (property == null) {
                        return CodeCompletionResult.NONE;
                    }
                    String expressionText = "";
                    if (result[1] != null) {
                        int eolIndex;
                        int colonIndex;
                        String propertyImage = node.image().trim();
                        if (propertyImage.endsWith("}")) {
                            propertyImage = propertyImage.substring(0, propertyImage.length() - 1);
                        }
                        if ((colonIndex = propertyImage.indexOf(58)) >= 0) {
                            expressionText = propertyImage.substring(colonIndex + 1);
                        }
                        if ((eolIndex = expressionText.indexOf(10)) > 0) {
                            expressionText = expressionText.substring(0, eolIndex);
                        }
                    }
                    if ((prop = this.PROPERTIES.getProperty(property.image().trim())) != null) {
                        CssPropertyValue propVal = new CssPropertyValue(prop, expressionText);
                        Set<PropertyModel.Element> alts = propVal.alternatives();
                        Collection<PropertyModel.Element> filteredByPrefix = this.filterElements(alts, prefix);
                        int completionItemInsertPosition = prefix.trim().length() == 0 ? caretOffset : snapshot.getOriginalOffset(node.startOffset());
                        boolean addSpaceBeforeItem = false;
                        if (alts.size() > 0 && filteredByPrefix.size() == 0 && Character.isWhitespace(charAfterCaret)) {
                            completionItemInsertPosition = caretOffset;
                            filteredByPrefix = alts;
                            addSpaceBeforeItem = true;
                        }
                        return this.wrapPropertyValues(context, prefix, prop, filteredByPrefix, CssCompletionItem.Kind.VALUE, completionItemInsertPosition, false, addSpaceBeforeItem, false);
                    }
                } else {
                    List<CompletionProposal> proposals;
                    if (node.kind() == 32 || node.kind() == 40 && ((SimpleNode)node.jjtGetParent()).kind() == 29) {
                        String expressionText;
                        final SimpleNode[] result = new SimpleNode[1];
                        NodeVisitor declarationSearch = new NodeVisitor(){

                            @Override
                            public void visit(SimpleNode node) {
                                if (node.kind() == 29) {
                                    result[0] = node;
                                }
                            }
                        };
                        SimpleNodeUtil.visitAncestors(node, declarationSearch);
                        SimpleNode declaratioNode = result[0];
                        result[0] = null;
                        NodeVisitor propertySearch = new NodeVisitor(){

                            @Override
                            public void visit(SimpleNode node) {
                                if (node.kind() == 18) {
                                    result[0] = node;
                                }
                            }
                        };
                        SimpleNodeUtil.visitChildren(declaratioNode, propertySearch);
                        SimpleNode property = result[0];
                        Property prop = this.PROPERTIES.getProperty(property.image());
                        if (prop == null) {
                            return CodeCompletionResult.NONE;
                        }
                        if (node.kind() == 32) {
                            SimpleNode expression = (SimpleNode)node.jjtGetParent();
                            expressionText = expression.image();
                        } else {
                            expressionText = "";
                        }
                        int eolIndex = expressionText.indexOf(10);
                        if (eolIndex > 0) {
                            expressionText = expressionText.substring(0, eolIndex);
                        }
                        CssPropertyValue propVal = new CssPropertyValue(prop, expressionText);
                        Set<PropertyModel.Element> alts = propVal.alternatives();
                        Collection<PropertyModel.Element> filteredByPrefix = this.filterElements(alts, prefix);
                        int completionItemInsertPosition = prefix.trim().length() == 0 ? caretOffset : snapshot.getOriginalOffset(node.startOffset());
                        boolean addSpaceBeforeItem = false;
                        if (alts.size() > 0 && filteredByPrefix.size() == 0 && Character.isWhitespace(charAfterCaret)) {
                            completionItemInsertPosition = caretOffset;
                            filteredByPrefix = alts;
                            addSpaceBeforeItem = true;
                        }
                        boolean extendedItemsOnly = false;
                        if (prefix.equals("#")) {
                            --completionItemInsertPosition;
                            extendedItemsOnly = true;
                        }
                        return this.wrapPropertyValues(context, prefix, prop, filteredByPrefix, CssCompletionItem.Kind.VALUE, completionItemInsertPosition, false, addSpaceBeforeItem, extendedItemsOnly);
                    }
                    if (node.kind() == 24) {
                        List<CompletionProposal> proposals2 = this.completeHtmlSelectors(prefix, snapshot.getOriginalOffset(node.startOffset()));
                        if (proposals2.size() > 0) {
                            return new DefaultCompletionResult(proposals2, false);
                        }
                    } else if ((node.kind() == 20 || node.kind() == 16 || node.kind() == 21) && (proposals = this.completeHtmlSelectors(prefix, caretOffset)).size() > 0) {
                        return new DefaultCompletionResult(proposals, false);
                    }
                }
            }
        }
        return CodeCompletionResult.NONE;
    }

    private List<? extends CompletionProposal> completeImport(FileObject base, int offset, String prefix, boolean addQuotes, boolean addSemicolon) {
        CssLinkCompletion fileCompletion = new CssLinkCompletion(addQuotes, addSemicolon);
        return fileCompletion.getItems(base, offset - prefix.length(), prefix);
    }

    private List<CompletionProposal> completeHtmlSelectors(String prefix, int offset) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(20);
        for (String tagName : HtmlTags.getTags()) {
            if (!tagName.startsWith(prefix.toLowerCase(Locale.ENGLISH))) continue;
            proposals.add(CssCompletionItem.createSelectorCompletionItem(new CssElement(tagName), tagName, CssCompletionItem.Kind.VALUE, offset, true));
        }
        return proposals;
    }

    private CodeCompletionResult wrapRAWValues(Collection<String> props, CssCompletionItem.Kind kind, int anchor) {
        ArrayList<CssCompletionItem> proposals = new ArrayList<CssCompletionItem>(props.size());
        for (String value : props) {
            CssElement handle = new CssElement(value);
            CssCompletionItem proposal = CssCompletionItem.createCompletionItem(handle, value, kind, anchor, false);
            proposals.add(proposal);
        }
        return new DefaultCompletionResult(proposals, false);
    }

    private CodeCompletionResult wrapPropertyValues(CodeCompletionContext context, String prefix, Property property, Collection<PropertyModel.Element> props, CssCompletionItem.Kind kind, int anchor, boolean addSemicolon, boolean addSpaceBeforeItem, boolean extendedItemsOnly) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(props.size());
        boolean colorChooserAdded = false;
        for (PropertyModel.Element e : props) {
            if (e instanceof PropertyModel.ValueElement && ((PropertyModel.ValueElement)e).isUnit()) continue;
            CssValueElement handle = new CssValueElement(property, e);
            String origin = e.getResolvedOrigin();
            if ("color".equals(origin)) {
                if (!colorChooserAdded) {
                    proposals.add(CssCompletionItem.createColorChooserCompletionItem(anchor, origin, addSemicolon));
                    proposals.addAll(this.getUsedColorsItems(context, prefix, handle, origin, kind, anchor, addSemicolon, addSpaceBeforeItem));
                    colorChooserAdded = true;
                }
                if (extendedItemsOnly) continue;
                proposals.add(CssCompletionItem.createColorValueCompletionItem(handle, e, kind, anchor, addSemicolon, addSpaceBeforeItem));
                continue;
            }
            if (extendedItemsOnly) continue;
            proposals.add(CssCompletionItem.createValueCompletionItem(handle, e, kind, anchor, addSemicolon, addSpaceBeforeItem));
        }
        return new DefaultCompletionResult(proposals, false);
    }

    private Collection<CompletionProposal> getUsedColorsItems(CodeCompletionContext context, String prefix, CssElement element, String origin, CssCompletionItem.Kind kind, int anchor, boolean addSemicolon, boolean addSpaceBeforeItem) {
        FileObject current = context.getParserResult().getSnapshot().getSource().getFileObject();
        if (current == null) {
            return Collections.emptyList();
        }
        CssProjectSupport support = CssProjectSupport.findFor(current);
        if (support == null) {
            return Collections.emptyList();
        }
        CssIndex index = support.getIndex();
        Map<FileObject, Collection<String>> result = index.findAll(RefactoringElementType.COLOR);
        ArrayList<FileObject> resortedKeys = new ArrayList<FileObject>(result.keySet());
        if (resortedKeys.remove(current)) {
            resortedKeys.add(0, current);
        }
        HashSet<CompletionProposal> proposals = new HashSet<CompletionProposal>();
        for (FileObject file : resortedKeys) {
            Collection<String> colors = result.get(file);
            boolean usedInCurrentFile = file.equals(current);
            for (String color : colors) {
                if (!color.startsWith(prefix)) continue;
                proposals.add(CssCompletionItem.createHashColorCompletionItem(element, color, origin, kind, anchor, addSemicolon, addSpaceBeforeItem, usedInCurrentFile));
            }
        }
        return proposals;
    }

    private Collection<String> filterStrings(Collection<String> values, String propertyNamePrefix) {
        propertyNamePrefix = propertyNamePrefix.toLowerCase();
        ArrayList<String> filtered = new ArrayList<String>();
        for (String value : values) {
            if (!value.toLowerCase().startsWith(propertyNamePrefix)) continue;
            filtered.add(value);
        }
        return filtered;
    }

    private Collection<PropertyModel.Element> filterElements(Collection<PropertyModel.Element> values, String propertyNamePrefix) {
        propertyNamePrefix = propertyNamePrefix.toLowerCase();
        ArrayList<PropertyModel.Element> filtered = new ArrayList<PropertyModel.Element>();
        for (PropertyModel.Element value : values) {
            if (!value.toString().toLowerCase().startsWith(propertyNamePrefix)) continue;
            filtered.add(value);
        }
        return filtered;
    }

    private CodeCompletionResult wrapProperties(Collection<Property> props, CssCompletionItem.Kind kind, int anchor) {
        ArrayList<CssCompletionItem> proposals = new ArrayList<CssCompletionItem>(props.size());
        for (Property p : props) {
            if (p.name().startsWith("-")) continue;
            CssPropertyElement handle = new CssPropertyElement(p);
            CssCompletionItem proposal = CssCompletionItem.createPropertyNameCompletionItem(handle, p.name(), kind, anchor, false);
            proposals.add(proposal);
        }
        return new DefaultCompletionResult(proposals, false);
    }

    private Collection<Property> filterProperties(Collection<Property> props, String propertyNamePrefix) {
        propertyNamePrefix = propertyNamePrefix.toLowerCase();
        ArrayList<Property> filtered = new ArrayList<Property>();
        for (Property p : props) {
            if (!p.name().toLowerCase().startsWith(propertyNamePrefix)) continue;
            filtered.add(p);
        }
        return filtered;
    }

    public String document(ParserResult info, ElementHandle element) {
        block5: {
            if (element instanceof CssValueElement) {
                CssValueElement e = (CssValueElement)element;
                return CssHelpResolver.instance().getPropertyHelp(e.property().name());
            }
            if (element instanceof CssPropertyElement) {
                CssPropertyElement e = (CssPropertyElement)element;
                return CssHelpResolver.instance().getPropertyHelp(e.property().name());
            }
            if (element instanceof ElementHandle.UrlHandle) {
                try {
                    return CssHelpResolver.instance().getHelpText(new URL(element.getName()));
                }
                catch (MalformedURLException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
        }
        return null;
    }

    public ElementHandle resolveLink(String link, ElementHandle elementHandle) {
        return CssHelpResolver.getHelpZIPURLasString() == null ? null : new ElementHandle.UrlHandle(CssHelpResolver.getHelpZIPURLasString() + this.normalizeLink(elementHandle, link));
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        Snapshot snapshot = info.getSnapshot();
        TokenHierarchy hi = snapshot.getTokenHierarchy();
        String prefix = this.getPrefix((TokenSequence<CssTokenId>)hi.tokenSequence(), snapshot.getEmbeddedOffset(caretOffset));
        if (prefix.length() > 0 && (prefix.charAt(0) == '.' || prefix.charAt(0) == '#')) {
            firstPrefixChar = prefix.charAt(0);
            return prefix.substring(1);
        }
        firstPrefixChar = '\u0000';
        return prefix;
    }

    private String normalizeLink(ElementHandle handle, String link) {
        if (link.startsWith(".") || link.startsWith("/")) {
            return this.normalizeLink(handle, link.substring(1));
        }
        int index = link.lastIndexOf(35);
        if (index != -1 && (index == 0 || link.charAt(index - 1) == '/')) {
            String helpZipUrl = CssHelpResolver.getHelpZIPURL().getPath();
            if (handle instanceof CssPropertyElement) {
                String name = ((CssPropertyElement)handle).property().name();
                URL propertyHelpURL = CssHelpResolver.instance().getPropertyHelpURL(name);
                String path = propertyHelpURL.getPath();
                if (path.startsWith(helpZipUrl)) {
                    path = path.substring(helpZipUrl.length());
                }
                return path + link.substring(index);
            }
            if (handle instanceof ElementHandle.UrlHandle) {
                String url = handle.getName();
                int anchorIndex = url.lastIndexOf(35);
                if (anchorIndex != -1) {
                    url = url.substring(0, anchorIndex);
                }
                try {
                    URL _url = new URL(url);
                    url = _url.getPath();
                }
                catch (MalformedURLException mue) {
                    Logger.getLogger("global").log(Level.INFO, null, mue);
                }
                if (url.startsWith(helpZipUrl)) {
                    url = url.substring(helpZipUrl.length());
                }
                return url + link.substring(index);
            }
        }
        return link;
    }

    private String getPrefix(TokenSequence<CssTokenId> ts, int caretOffset) {
        if (ts == null) {
            return null;
        }
        int diff = ts.move(caretOffset);
        if (diff == 0) {
            if (!ts.movePrevious()) {
                return "";
            }
        } else if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        int skipPrefixChars = 0;
        if (t.id() == CssTokenId.COLON) {
            return "";
        }
        if (t.id() == CssTokenId.COMMA) {
            return "";
        }
        if (t.id() == CssTokenId.STRING) {
            skipPrefixChars = 1;
        }
        return ((Object)t.text().subSequence(skipPrefixChars, diff == 0 ? t.text().length() : diff)).toString().trim();
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        int offset = component.getCaretPosition();
        if (typedText == null || typedText.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        char c = typedText.charAt(typedText.length() - 1);
        TokenSequence ts = LexerUtils.getJoinedTokenSequence((Document)component.getDocument(), (int)offset, CssTokenId.language());
        if (ts != null) {
            int diff = ts.move(offset);
            TokenId currentTokenId = null;
            if (ts != null && (diff == 0 && ts.movePrevious() || ts.moveNext())) {
                currentTokenId = ts.token().id();
            }
            if (currentTokenId == CssTokenId.IDENT) {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
            if (typedText.length() == 1 && c == ' ' && currentTokenId != CssTokenId.COMMENT) {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
        }
        switch (c) {
            case '\n': 
            case ';': 
            case '}': {
                return CodeCompletionHandler.QueryType.STOP;
            }
            case '#': 
            case ',': 
            case '.': 
            case ':': {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    private CodeCompletionResult handleLexicalBasedCompletion(FileObject file, TokenSequence<CssTokenId> ts, Snapshot snapshot, int caretOffset) {
        int tokenDiff = ts.move(snapshot.getEmbeddedOffset(caretOffset));
        if (ts.moveNext() || ts.movePrevious()) {
            boolean addSemicolon = true;
            switch ((CssTokenId)ts.token().id()) {
                case SEMICOLON: {
                    addSemicolon = false;
                }
                case S: {
                    if (addSemicolon) {
                        Token semicolon = LexerUtils.followsToken(ts, (TokenId)CssTokenId.SEMICOLON, (boolean)false, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.S});
                        boolean bl = addSemicolon = semicolon == null;
                    }
                    if (null == LexerUtils.followsToken(ts, (TokenId)CssTokenId.IMPORT_SYM, (boolean)true, (boolean)false, (TokenId[])new TokenId[]{CssTokenId.S})) break;
                    List<CompletionProposal> imports = this.completeImport(file, caretOffset, "", true, addSemicolon);
                    int moveBack = (addSemicolon ? 1 : 0) + 1;
                    return new CssFileCompletionResult(imports, moveBack);
                }
                case STRING: {
                    Token originalToken = ts.token();
                    addSemicolon = false;
                    if (null == LexerUtils.followsToken(ts, (TokenId)CssTokenId.IMPORT_SYM, (boolean)true, (boolean)false, (TokenId[])new TokenId[]{CssTokenId.S})) break;
                    String valuePrefix = ((Object)originalToken.text()).toString().substring(1, tokenDiff);
                    List<CompletionProposal> imports = this.completeImport(file, caretOffset, valuePrefix, false, addSemicolon);
                    int moveBack = addSemicolon ? 1 : 0;
                    return new CssFileCompletionResult(imports, moveBack);
                }
            }
        }
        return null;
    }

    private static class CssLinkCompletion
    extends FileReferenceCompletion<CssCompletionItem> {
        private static final String GO_UP_TEXT = "../";
        private boolean addQuotes;
        private boolean addSemicolon;

        public CssLinkCompletion(boolean addQuotes, boolean addSemicolon) {
            this.addQuotes = addQuotes;
            this.addSemicolon = addSemicolon;
        }

        public CssCompletionItem createFileItem(int anchor, String name, Color color, ImageIcon icon) {
            return CssCompletionItem.createFileCompletionItem(new CssElement(name), name, anchor, color, icon, this.addQuotes, this.addSemicolon);
        }

        public CssCompletionItem createGoUpItem(int anchor, Color color, ImageIcon icon) {
            return CssCompletionItem.createFileCompletionItem(new CssElement(GO_UP_TEXT), GO_UP_TEXT, anchor, color, icon, this.addQuotes, this.addSemicolon);
        }
    }

    private static class CssFileCompletionResult
    extends DefaultCompletionResult {
        private int moveCaretBack;

        public CssFileCompletionResult(List<CompletionProposal> list, int moveCaretBack) {
            super(list, false);
            this.moveCaretBack = moveCaretBack;
        }

        public void afterInsert(CompletionProposal item) {
            Caret c = EditorRegistry.lastFocusedComponent().getCaret();
            c.setDot(c.getDot() - this.moveCaretBack);
        }
    }
}

