/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.wsdl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.e2e.api.wsdl.Operation;
import org.netbeans.modules.e2e.api.wsdl.PortType;
import org.netbeans.modules.e2e.wsdl.OperationImpl;

public class PortTypeImpl
implements PortType {
    private Map<String, Operation> operations;
    private QName myName;

    public PortTypeImpl(QName name) {
        this.myName = name;
        this.operations = new HashMap<String, Operation>();
    }

    @Override
    public String getName() {
        return this.getQName().getLocalPart();
    }

    @Override
    public QName getQName() {
        return this.myName;
    }

    @Override
    public void addOperation(Operation operation) {
        String newJavaName;
        String name;
        Operation op = this.operations.get(operation.getJavaName());
        if (op != null && (name = operation.getName()) != null && name.length() != 0) {
            newJavaName = this.generateJavaName(operation);
            operation.setJavaName(newJavaName);
        }
        if ((op = this.operations.get(this.getUpperCaseName(operation))) != null && (name = op.getName()) != null && name.length() != 0) {
            newJavaName = this.generateJavaName(op);
            op.setJavaName(newJavaName);
        }
        this.operations.put(operation.getName(), operation);
    }

    private String generateJavaName(Operation op) {
        String name = op.getName();
        int count = 1;
        String newName = name + count;
        while (this.operations.containsKey(OperationImpl.toJavaName(newName))) {
            newName = name + ++count;
        }
        return OperationImpl.toJavaName(newName);
    }

    @Override
    public List<Operation> getOperations() {
        return Collections.unmodifiableList(new ArrayList<Operation>(this.operations.values()));
    }

    public String getUpperCaseName(Operation op) {
        String name = op.getName();
        if (name.length() > 1) {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    public static class PortTypeReferenceImpl
    extends PortTypeImpl
    implements PortType.PortTypeReference {
        public PortTypeReferenceImpl(QName name) {
            super(name);
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }
}

