/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart.impl;

import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.BodyPartEntity;
import com.sun.jersey.multipart.Boundary;
import com.sun.jersey.multipart.MultiPart;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

@Produces(value={"multipart/*"})
public class MultiPartWriter
implements MessageBodyWriter<MultiPart> {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final Providers providers;

    public MultiPartWriter(@Context Providers providers) {
        this.providers = providers;
    }

    public long getSize(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type);
    }

    public void writeTo(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream stream) throws IOException, WebApplicationException {
        Object value;
        if (entity.getBodyParts() == null || entity.getBodyParts().size() < 1) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Must specify at least one body part"));
        }
        if (entity.getParent() == null && (value = headers.getFirst((Object)"MIME-Version")) == null) {
            headers.putSingle((Object)"MIME-Version", (Object)"1.0");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        MediaType boundaryMediaType = Boundary.addBoundary(mediaType);
        if (boundaryMediaType != mediaType) {
            headers.putSingle((Object)"Content-Type", (Object)boundaryMediaType);
        }
        String boundaryString = (String)boundaryMediaType.getParameters().get("boundary");
        for (BodyPart bodyPart : entity.getBodyParts()) {
            MessageBodyWriter bodyWriter;
            writer.write("\r\n--");
            writer.write(boundaryString);
            writer.write("\r\n");
            MediaType bodyMediaType = bodyPart.getMediaType();
            if (bodyMediaType == null) {
                throw new WebApplicationException((Throwable)new IllegalArgumentException("Missing body part media type"));
            }
            MultivaluedMap<String, String> bodyHeaders = bodyPart.getHeaders();
            bodyHeaders.putSingle((Object)"Content-Type", (Object)bodyMediaType.toString());
            if (bodyHeaders.getFirst((Object)"Content-Disposition") == null && bodyPart.getContentDisposition() != null) {
                bodyHeaders.putSingle((Object)"Content-Disposition", (Object)bodyPart.getContentDisposition().toString());
            }
            for (Map.Entry entry : bodyHeaders.entrySet()) {
                if (!((String)entry.getKey()).toLowerCase().startsWith("content-")) {
                    throw new WebApplicationException((Throwable)new IllegalArgumentException("Invalid body part header '" + (String)entry.getKey() + "', only Content-* allowed"));
                }
                writer.write((String)entry.getKey());
                ((Writer)writer).write(58);
                boolean first = true;
                for (String value2 : (List)entry.getValue()) {
                    if (first) {
                        ((Writer)writer).write(32);
                        first = false;
                    } else {
                        ((Writer)writer).write(44);
                    }
                    writer.write(value2);
                }
                writer.write("\r\n");
            }
            writer.write("\r\n");
            ((Writer)writer).flush();
            Object bodyEntity = bodyPart.getEntity();
            if (bodyEntity == null) {
                throw new WebApplicationException((Throwable)new IllegalArgumentException("Missing body part entity of type '" + bodyMediaType + "'"));
            }
            Class<Object> bodyClass = bodyEntity.getClass();
            if (bodyEntity instanceof BodyPartEntity) {
                bodyClass = InputStream.class;
                bodyEntity = ((BodyPartEntity)bodyEntity).getInputStream();
            }
            if ((bodyWriter = this.providers.getMessageBodyWriter(bodyClass, bodyClass, EMPTY_ANNOTATIONS, bodyMediaType)) == null) {
                throw new WebApplicationException((Throwable)new IllegalArgumentException("No MessageBodyWriter for body part of type '" + bodyEntity.getClass().getName() + "' and media type '" + bodyMediaType + "'"));
            }
            bodyWriter.writeTo(bodyEntity, bodyClass, bodyClass, EMPTY_ANNOTATIONS, bodyMediaType, bodyHeaders, stream);
        }
        writer.write("\r\n--");
        writer.write(boundaryString);
        writer.write("--\r\n");
        ((Writer)writer).flush();
    }
}

