/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyAccessor
extends CollectionAccessor {
    public OneToManyAccessor() {
        super("<one-to-many>");
    }

    public OneToManyAccessor(MetadataAnnotation oneToMany, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(oneToMany, accessibleObject, classAccessor);
        if (oneToMany != null) {
            this.setOrphanRemoval((Boolean)oneToMany.getAttribute("orphanRemoval"));
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof OneToManyAccessor;
    }

    @Override
    protected String getLoggingContext() {
        return "metadata_default_one_to_many_reference_class";
    }

    @Override
    public boolean isOneToMany() {
        return true;
    }

    @Override
    public void process() {
        super.process();
        if (this.hasMappedBy()) {
            this.processOneToManyMapping();
        } else if (this.getJoinColumns().isEmpty()) {
            this.processManyToManyMapping();
        } else {
            this.processUnidirectionalOneToManyMapping();
        }
    }

    @Override
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        if (this.getMapping().isUnidirectionalOneToManyMapping()) {
            UnidirectionalOneToManyMapping overrideMapping = new UnidirectionalOneToManyMapping();
            overrideMapping.setAttributeName(this.getAttributeName());
            this.processUnidirectionalOneToManyTargetForeignKeyRelationship(overrideMapping, associationOverride.getJoinColumns(), owningDescriptor);
            embeddableMapping.addOverrideUnidirectionalOneToManyMapping(overrideMapping);
            this.setOverrideMapping(overrideMapping);
        } else {
            super.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor);
        }
    }

    protected void processManyToManyMapping() {
        ManyToManyMapping mapping = new ManyToManyMapping();
        this.process(mapping);
        mapping.setDefinedAsOneToManyMapping(true);
        this.processJoinTable(mapping, mapping.getRelationTableMechanism(), this.getJoinTableMetadata());
    }

    protected void processOneToManyMapping() {
        DatabaseMapping owningMapping = this.getOwningMappingAccessor();
        if (owningMapping.isOneToOneMapping()) {
            OneToOneMapping ownerMapping = (OneToOneMapping)owningMapping;
            if (ownerMapping.hasRelationTableMechanism()) {
                ManyToManyMapping mapping = new ManyToManyMapping();
                this.process(mapping);
                this.processMappedByRelationTable(ownerMapping.getRelationTableMechanism(), mapping.getRelationTableMechanism());
                mapping.setIsReadOnly(true);
            } else {
                OneToManyMapping mapping = new OneToManyMapping();
                this.process(mapping);
                Map<DatabaseField, DatabaseField> keys = ownerMapping.getSourceToTargetKeyFields();
                for (DatabaseField fkField : keys.keySet()) {
                    DatabaseField pkField = keys.get(fkField);
                    if (this.getDescriptor().usesTablePerClassInheritanceStrategy() && !pkField.getTable().equals(this.getDescriptor().getPrimaryTable())) {
                        pkField = pkField.clone();
                        pkField.setTable(this.getDescriptor().getPrimaryTable());
                    }
                    mapping.addTargetForeignKeyField(fkField, pkField);
                }
            }
        } else {
            throw ValidationException.invalidMapping(this.getJavaClass(), this.getReferenceClass());
        }
    }

    protected void processUnidirectionalOneToManyMapping() {
        UnidirectionalOneToManyMapping mapping = new UnidirectionalOneToManyMapping();
        this.process(mapping);
        this.processUnidirectionalOneToManyTargetForeignKeyRelationship(mapping, this.getJoinColumns(this.getJoinColumns(), this.getReferenceDescriptor()), this.getOwningDescriptor());
    }

    protected void processUnidirectionalOneToManyTargetForeignKeyRelationship(UnidirectionalOneToManyMapping mapping, List<JoinColumnMetadata> joinColumns, MetadataDescriptor owningDescriptor) {
        String defaultFKFieldName = this.getDefaultAttributeName() + "_" + owningDescriptor.getPrimaryKeyFieldName();
        for (JoinColumnMetadata joinColumn : joinColumns) {
            MappingAccessor mappingAccessor;
            DatabaseField pkField = this.getReferencedField(joinColumn.getReferencedColumnName(), owningDescriptor, "metadata_default_pk_column");
            DatabaseField fkField = joinColumn.getForeignKeyField(pkField);
            this.setFieldName(fkField, defaultFKFieldName, "metadata_default_fk_column");
            if (!fkField.hasTableName()) {
                fkField.setTable(this.getReferenceDescriptor().getPrimaryTable());
            }
            if ((mappingAccessor = owningDescriptor.getPrimaryKeyAccessorForField(pkField)) != null) {
                Class fieldClassification = mappingAccessor.getMapping().getFieldClassification(mappingAccessor.getMapping().getField());
                String typeName = fieldClassification == null ? mappingAccessor.getRawClass().getName() : fieldClassification.getName();
                fkField.setTypeName(typeName);
            }
            mapping.addTargetForeignKeyField(fkField, pkField);
            if (!fkField.isReadOnly()) continue;
            mapping.setIsReadOnly(true);
        }
    }
}

