/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display.property;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.netbeans.modules.vmd.api.io.PopupUtil;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class ScreenTextFieldPropertyEditor
implements ScreenPropertyEditor {
    private String propertyName;
    private int alignment;
    private String refComponentPropertyName;
    private DesignComponent relatedComponent;

    public ScreenTextFieldPropertyEditor(String propertyName) {
        this(propertyName, null, 2);
    }

    public ScreenTextFieldPropertyEditor(String propertyName, String refComponentPropertyName) {
        this(propertyName, refComponentPropertyName, 2);
    }

    public ScreenTextFieldPropertyEditor(String propertyName, int alignment) {
        this(propertyName, null, alignment);
    }

    public ScreenTextFieldPropertyEditor(String propertyName, String referencedPropertyName, int alignment) {
        this.alignment = alignment;
        assert (propertyName != null);
        this.propertyName = propertyName;
        this.refComponentPropertyName = referencedPropertyName;
    }

    public JComponent createEditorComponent(ScreenPropertyDescriptor property) {
        this.relatedComponent = this.refComponentPropertyName == null ? property.getRelatedComponent() : property.getRelatedComponent().readProperty(this.refComponentPropertyName).getComponent();
        StringTextField editor = new StringTextField(property);
        editor.setMinimumSize(new Dimension(128, 21));
        PropertyValue value = this.relatedComponent.readProperty(this.propertyName);
        String string = MidpTypes.getString(value);
        editor.setText(string != null ? string : "");
        editor.selectAll();
        return editor;
    }

    public Insets getEditorComponentInsets(JComponent editorComponent) {
        return editorComponent.getBorder().getBorderInsets(editorComponent);
    }

    private class StringTextField
    extends JTextField
    implements KeyListener {
        private ScreenPropertyDescriptor property;

        public StringTextField(ScreenPropertyDescriptor property) {
            this.property = property;
            this.addKeyListener(this);
            this.setHorizontalAlignment(ScreenTextFieldPropertyEditor.this.alignment);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() != '\n') {
                return;
            }
            this.property.getRelatedComponent().getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    if (ScreenTextFieldPropertyEditor.this.relatedComponent == null) {
                        throw new IllegalStateException();
                    }
                    PropertyValue value = MidpTypes.createStringValue(StringTextField.this.getText());
                    ScreenTextFieldPropertyEditor.this.relatedComponent.writeProperty(ScreenTextFieldPropertyEditor.this.propertyName, value);
                }
            });
            PopupUtil.hidePopup();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

