/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display.injector;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.api.io.PopupUtil;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.injector.ScreenInjectorPresenter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class ScreenBooleanInjectorPresenter
extends ScreenInjectorPresenter {
    private String propertyName;
    private String displayName;
    private int order;

    public ScreenBooleanInjectorPresenter(String propertyName, String displayName, int order) {
        assert (propertyName != null && displayName != null);
        this.propertyName = propertyName;
        this.displayName = displayName;
        this.order = order;
    }

    public boolean isEnabled() {
        return true;
    }

    public JComponent getViewComponent() {
        InjectorCheckBox checkBox = new InjectorCheckBox(this.displayName);
        PropertyValue propertyValue = this.getComponent().readProperty(this.propertyName);
        if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
            checkBox.setSelected(MidpTypes.getBoolean(propertyValue));
        } else {
            checkBox.setEnabled(false);
        }
        return checkBox;
    }

    public Integer getOrder() {
        return this.order;
    }

    private class InjectorCheckBox
    extends JCheckBox
    implements ActionListener {
        public InjectorCheckBox(String text) {
            super(text);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final DesignComponent comp = ScreenBooleanInjectorPresenter.this.getComponent();
            comp.getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    comp.writeProperty(ScreenBooleanInjectorPresenter.this.propertyName, MidpTypes.createBooleanValue(InjectorCheckBox.this.isSelected()));
                }
            });
            PopupUtil.hidePopup();
        }
    }
}

