/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.general;

import java.awt.datatransfer.Transferable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptPresenter;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;

public abstract class FileAcceptPresenter
extends AcceptPresenter {
    private Map<String, TypeID> extensionsMap = new HashMap<String, TypeID>();
    private Map<String, String> propertyNamesMap = new HashMap<String, String>();

    public FileAcceptPresenter(String propertyName, TypeID typeID, String ... fileExtensions) {
        super(AcceptPresenter.Kind.TRANSFERABLE);
        this.addFileExtensions(propertyName, typeID, fileExtensions);
    }

    public FileAcceptPresenter addFileExtensions(String propertyName, TypeID typeID, String ... fileExtensions) {
        assert (typeID != null);
        assert (fileExtensions.length != 0);
        for (String fe : fileExtensions) {
            this.extensionsMap.put(fe, typeID);
            this.propertyNamesMap.put(fe, propertyName);
        }
        return this;
    }

    public boolean isAcceptable(Transferable transferable, AcceptSuggestion suggestion) {
        assert (!this.extensionsMap.isEmpty());
        FileObject fileObject = this.getNodeFileObject(transferable);
        if (fileObject == null && !this.belongsToProject(fileObject)) {
            return false;
        }
        DesignDocument document = this.getComponent().getDocument();
        Map<FileObject, String> mapFile = MidpProjectSupport.getAllFilesForProjectByExt(document, this.extensionsMap.keySet());
        if (mapFile.get(fileObject) == null) {
            return false;
        }
        TypeID typeID = this.getTypeForExtension(fileObject.getExt());
        return typeID != null;
    }

    public ComponentProducer.Result accept(Transferable transferable, AcceptSuggestion suggestion) {
        FileObject fileObject = this.getNodeFileObject(transferable);
        TypeID typeID = this.getTypeForExtension(fileObject.getExt());
        String propertyName = this.getPropertyNameForExtension(fileObject.getExt());
        if (propertyName == null) {
            return super.accept(transferable, suggestion);
        }
        DesignDocument document = this.getComponent().getDocument();
        ComponentProducer producer = DocumentSupport.getComponentProducer((DesignDocument)document, (String)typeID.toString());
        if (document == null || producer == null) {
            return super.accept(transferable, suggestion);
        }
        DesignComponent newComponent = producer.createComponent(document).getMainComponent();
        if (this.getComponent().readProperty(propertyName).getKind() == PropertyValue.Kind.ARRAY) {
            MidpArraySupport.append(this.getComponent(), propertyName, newComponent);
        } else {
            this.getComponent().writeProperty(propertyName, PropertyValue.createComponentReference((DesignComponent)newComponent));
        }
        return new ComponentProducer.Result(new DesignComponent[]{newComponent});
    }

    protected boolean belongsToProject(FileObject fileObject) {
        DesignDocument document = this.getComponent().getDocument();
        Map<FileObject, String> fileMap = MidpProjectSupport.getAllFilesForProjectByExt(document, this.extensionsMap.keySet());
        return fileMap.get(fileObject) != null;
    }

    protected InputStream getInputStream(Transferable transferable) {
        try {
            FileObject fileNode = this.getNodeFileObject(transferable);
            return fileNode != null ? fileNode.getInputStream() : null;
        }
        catch (FileNotFoundException ex) {
            Debug.warning((Object[])new Object[]{ex});
            return null;
        }
    }

    protected String getFileClasspath(FileObject fileObject) {
        DesignDocument document = this.getComponent().getDocument();
        Map<FileObject, String> fileMap = MidpProjectSupport.getAllFilesForProjectByExt(document, Arrays.asList(fileObject.getExt()));
        return fileMap.get(fileObject);
    }

    protected FileObject getNodeFileObject(Transferable transferable) {
        Node node = NodeTransfer.node((Transferable)transferable, (int)3);
        if (node == null) {
            return null;
        }
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        FileObject file = dataObject.getPrimaryFile();
        return file;
    }

    private TypeID getTypeForExtension(String fe) {
        for (String key : this.extensionsMap.keySet()) {
            if (!key.equalsIgnoreCase(fe)) continue;
            return this.extensionsMap.get(key);
        }
        return null;
    }

    private String getPropertyNameForExtension(String fe) {
        for (String key : this.propertyNamesMap.keySet()) {
            if (!key.equalsIgnoreCase(fe)) continue;
            return this.propertyNamesMap.get(key);
        }
        return null;
    }
}

