/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

final class AddTagFix
implements Fix,
CancellableTask<WorkingCopy> {
    private final ElementHandle methodHandle;
    private final String paramName;
    private final int index;
    private final FileObject file;
    private final SourceVersion spec;
    private final String descKey;
    private final Kind kind;
    private Position insertPosition;
    String insertJavadoc;
    private int openOffset;
    Document doc;

    private AddTagFix(ElementHandle methodHandle, String paramName, int index, FileObject file, SourceVersion spec, String descKey, Kind tagKind) {
        this.methodHandle = methodHandle;
        this.paramName = paramName;
        this.index = index;
        this.file = file;
        this.spec = spec;
        this.descKey = descKey;
        this.kind = tagKind;
    }

    public static Fix createAddParamTagFix(ExecutableElement elm, String paramName, FileObject file, SourceVersion spec) {
        return new AddTagFix(ElementHandle.create((Element)elm), paramName, -1, file, spec, "MISSING_PARAM_HINT", Kind.PARAM);
    }

    public static Fix createAddTypeParamTagFix(Element elm, String paramName, FileObject file, SourceVersion spec) {
        return new AddTagFix(ElementHandle.create((Element)elm), paramName, -1, file, spec, "MISSING_TYPEPARAM_HINT", Kind.TYPEPARAM);
    }

    public static Fix createAddReturnTagFix(ExecutableElement elm, FileObject file, SourceVersion spec) {
        return new AddTagFix(ElementHandle.create((Element)elm), "", -1, file, spec, "MISSING_RETURN_HINT", Kind.RETURN);
    }

    public static Fix createAddThrowsTagFix(ExecutableElement elm, String fqn, int throwIndex, FileObject file, SourceVersion spec) {
        return new AddTagFix(ElementHandle.create((Element)elm), fqn, throwIndex, file, spec, "MISSING_THROWS_HINT", Kind.THROWS);
    }

    public static Fix createAddDeprecatedTagFix(Element elm, FileObject file, SourceVersion spec) {
        return new AddTagFix(ElementHandle.create((Element)elm), "", -1, file, spec, "MISSING_DEPRECATED_HINT", Kind.DEPRECATED);
    }

    public String getText() {
        return NbBundle.getMessage(AddTagFix.class, (String)this.descKey, (Object)this.paramName);
    }

    public ChangeInfo implement() {
        JavaSource js = JavaSource.forFileObject((FileObject)this.file);
        try {
            js.runModificationTask((Task)this).commit();
            if (this.doc == null || this.insertPosition == null || this.insertJavadoc == null) {
                return null;
            }
            this.insertJavadoc();
            JavadocUtilities.open(this.file, this.openOffset);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(AddTagFix.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            Logger.getLogger(AddTagFix.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        return null;
    }

    public void run(final WorkingCopy wc) throws Exception {
        wc.toPhase(JavaSource.Phase.RESOLVED);
        final Element elm = this.methodHandle.resolve((CompilationInfo)wc);
        if (elm == null) {
            return;
        }
        final Doc jdoc = wc.getElementUtilities().javaDocFor(elm);
        this.doc = wc.getDocument();
        if (this.doc == null) {
            return;
        }
        NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AddTagFix.this.computeInsertPositionAndJavadoc((CompilationInfo)wc, elm, jdoc);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(AddTagFix.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        });
    }

    private void computeInsertPositionAndJavadoc(CompilationInfo wc, Element elm, Doc jdoc) throws BadLocationException {
        boolean[] isLastTag = new boolean[1];
        switch (this.kind) {
            case PARAM: {
                this.insertPosition = this.getParamInsertPosition(wc, this.doc, (ExecutableElement)elm, (ExecutableMemberDoc)jdoc, isLastTag);
                this.insertJavadoc = "@param " + this.paramName + " ";
                break;
            }
            case TYPEPARAM: {
                this.insertPosition = this.getTypeParamInsertPosition(wc, this.doc, elm, jdoc, isLastTag);
                this.insertJavadoc = "@param <" + this.paramName + "> ";
                break;
            }
            case RETURN: {
                this.insertPosition = this.getReturnInsertPosition(wc, this.doc, jdoc, isLastTag);
                this.insertJavadoc = "@return ";
                break;
            }
            case THROWS: {
                this.insertPosition = this.getThrowsInsertPosition(wc, this.doc, (ExecutableMemberDoc)jdoc, isLastTag);
                this.insertJavadoc = "@throws " + this.paramName + " ";
                break;
            }
            case DEPRECATED: {
                this.insertPosition = this.getDeprecatedInsertPosition(wc, this.doc, jdoc, isLastTag);
                this.insertJavadoc = "@deprecated ";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.insertPosition == null) {
            return;
        }
        Position[] jdBounds = JavadocUtilities.findDocBounds(wc, this.doc, jdoc);
        int jdBeginLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)jdBounds[0].getOffset());
        int jdEndLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)jdBounds[1].getOffset());
        int insertLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.insertPosition.getOffset());
        if (jdBeginLine == insertLine && insertLine == jdEndLine) {
            this.insertJavadoc = '\n' + this.insertJavadoc;
            this.openOffset = this.insertJavadoc.length();
            this.insertJavadoc = this.insertJavadoc + '\n';
        } else if (insertLine == jdEndLine) {
            if (isLastTag[0] && !this.isEmptyLine(this.doc, this.insertPosition.getOffset())) {
                this.insertJavadoc = '\n' + this.insertJavadoc;
            }
            this.openOffset = this.insertJavadoc.length();
            this.insertJavadoc = this.insertJavadoc + '\n';
        } else if (insertLine == jdBeginLine) {
            this.insertJavadoc = '\n' + this.insertJavadoc;
            this.openOffset = this.insertJavadoc.length();
            if (!isLastTag[0]) {
                this.insertJavadoc = this.insertJavadoc + '\n';
            }
        } else if (isLastTag[0]) {
            this.insertJavadoc = '\n' + this.insertJavadoc;
            this.openOffset = this.insertJavadoc.length();
        } else {
            this.openOffset = this.insertJavadoc.length();
            this.insertJavadoc = this.insertJavadoc + '\n';
        }
    }

    private boolean isEmptyLine(Document doc, int offset) throws BadLocationException {
        char c;
        CharSequence txt = (CharSequence)doc.getProperty(CharSequence.class);
        if (txt == null) {
            txt = doc.getText(0, offset + 1);
        }
        boolean isClean = true;
        int asterisks = 0;
        for (int i = offset; i >= 0 && (c = txt.charAt(i)) != '\n'; --i) {
            if (c == '*') {
                if (asterisks > 0) {
                    isClean = false;
                    break;
                }
                ++asterisks;
                continue;
            }
            if (Character.isSpaceChar(c)) continue;
            isClean = false;
            break;
        }
        return isClean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertJavadoc() throws BadLocationException {
        final Indent indent = Indent.get((Document)this.doc);
        try {
            indent.lock();
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        int begin = AddTagFix.this.insertPosition.getOffset();
                        int end = begin + AddTagFix.this.insertJavadoc.length() + 1;
                        AddTagFix.this.doc.insertString(begin, AddTagFix.this.insertJavadoc, null);
                        Position openPos = AddTagFix.this.doc.createPosition(begin + AddTagFix.this.openOffset - 1);
                        indent.reindent(begin, end);
                        AddTagFix.this.doc.insertString(openPos.getOffset(), " ", null);
                        AddTagFix.this.openOffset = openPos.getOffset();
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(AddTagFix.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            });
        }
        finally {
            indent.unlock();
        }
    }

    public void cancel() {
    }

    private Position getDeprecatedInsertPosition(CompilationInfo wc, Document doc, Doc jdoc, boolean[] isLastTag) throws BadLocationException {
        return this.getTagInsertPosition(wc, doc, jdoc, null, false, isLastTag);
    }

    private Position getTypeParamInsertPosition(CompilationInfo wc, Document doc, Element elm, Doc jdoc, boolean[] isLastTag) throws BadLocationException {
        ParamTag[] tags;
        ElementKind elmkind = elm.getKind();
        if (elmkind.isClass() || elmkind.isInterface()) {
            tags = ((ClassDoc)jdoc).typeParamTags();
        } else if (elmkind == ElementKind.METHOD || elmkind == ElementKind.CONSTRUCTOR) {
            tags = ((ExecutableMemberDoc)jdoc).typeParamTags();
        } else {
            throw new IllegalStateException(elm + ", " + (Object)((Object)elmkind) + "\n" + jdoc.getRawCommentText());
        }
        ParamTag where = null;
        boolean insertBefore = true;
        if (tags.length > 0) {
            List<? extends TypeParameterElement> typeParameters = elmkind == ElementKind.METHOD || elmkind == ElementKind.CONSTRUCTOR ? ((ExecutableElement)elm).getTypeParameters() : ((TypeElement)elm).getTypeParameters();
            int pindex = this.findParamIndex(typeParameters, this.paramName);
            where = pindex < tags.length ? tags[pindex] : tags[tags.length - 1];
            insertBefore = pindex < tags.length;
        } else {
            tags = jdoc.tags();
            if (tags.length > 0) {
                where = tags[0];
            }
        }
        return this.getTagInsertPosition(wc, doc, jdoc, (Tag)where, insertBefore, isLastTag);
    }

    private Position getThrowsInsertPosition(CompilationInfo wc, Document doc, ExecutableMemberDoc jdoc, boolean[] isLastTag) throws BadLocationException {
        ThrowsTag[] tags = jdoc.throwsTags();
        ThrowsTag where = null;
        boolean insertBefore = true;
        if (tags.length > 0) {
            where = this.index < tags.length ? tags[this.index] : tags[tags.length - 1];
            insertBefore = this.index < tags.length;
        } else {
            tags = jdoc.tags("@return");
            if (tags.length == 0) {
                tags = jdoc.tags("@param");
            }
            if (tags.length == 0) {
                tags = jdoc.tags();
            } else {
                insertBefore = false;
            }
            if (tags.length > 0) {
                where = tags[tags.length - 1];
            }
        }
        return this.getTagInsertPosition(wc, doc, (Doc)jdoc, (Tag)where, insertBefore, isLastTag);
    }

    private Position getReturnInsertPosition(CompilationInfo wc, Document doc, Doc jdoc, boolean[] isLastTag) throws BadLocationException {
        Tag[] tags = jdoc.tags("@param");
        Tag where = null;
        boolean insertBefore = true;
        if (tags.length > 0) {
            where = tags[tags.length - 1];
            insertBefore = false;
        } else {
            tags = jdoc.tags();
            if (tags.length > 0) {
                where = tags[0];
            }
        }
        return this.getTagInsertPosition(wc, doc, jdoc, where, insertBefore, isLastTag);
    }

    private Position getParamInsertPosition(CompilationInfo wc, Document doc, ExecutableElement elm, ExecutableMemberDoc jdoc, boolean[] isLastTag) throws BadLocationException {
        ParamTag[] tags = jdoc.paramTags();
        ParamTag where = null;
        boolean insertBefore = true;
        if (tags.length > 0) {
            int pindex = this.findParamIndex(elm.getParameters(), this.paramName);
            where = pindex < tags.length ? tags[pindex] : tags[tags.length - 1];
            insertBefore = pindex < tags.length;
        } else {
            tags = jdoc.typeParamTags();
            if (tags.length > 0) {
                where = tags[tags.length - 1];
                insertBefore = false;
            } else {
                tags = jdoc.tags();
                if (tags.length > 0) {
                    where = tags[0];
                }
            }
        }
        return this.getTagInsertPosition(wc, doc, (Doc)jdoc, (Tag)where, insertBefore, isLastTag);
    }

    private Position getTagInsertPosition(CompilationInfo wc, Document doc, Doc jdoc, Tag where, boolean insertBefore, boolean[] isLastTag) throws BadLocationException {
        Position[] bounds = null;
        if (where != null) {
            bounds = JavadocUtilities.findTagBounds(wc, doc, where, isLastTag);
            if (insertBefore) {
                isLastTag[0] = false;
            }
        } else {
            bounds = JavadocUtilities.findLastTokenBounds(wc, doc, jdoc);
            insertBefore = false;
            isLastTag[0] = true;
        }
        return bounds == null ? null : (insertBefore ? bounds[0] : bounds[1]);
    }

    private int findParamIndex(List<? extends Element> params, String name) {
        int i = 0;
        for (Element element : params) {
            if (name.contentEquals(element.getSimpleName())) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown param: " + name);
    }

    private static enum Kind {
        PARAM,
        RETURN,
        THROWS,
        TYPEPARAM,
        DEPRECATED;

    }
}

