/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddAbilityPanel
extends JPanel
implements ActionListener,
DocumentListener {
    private DialogDescriptor dd;
    private boolean editing;
    private Set<String> usedNames;
    private String originalKey;
    private JComboBox cKey;
    private ErrorPanel errorPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField tValue;

    public AddAbilityPanel() {
        this.initComponents();
        this.initAccessibility();
    }

    public void init(boolean editing, Vector allAbilities, Set<String> usedNames, String key, String value) {
        this.usedNames = usedNames;
        this.editing = editing;
        this.originalKey = key;
        this.cKey.setModel(new DefaultComboBoxModel(allAbilities));
        if (key != null) {
            this.cKey.getEditor().setItem(key);
        }
        this.tValue.setText(value == null ? "" : value);
        Component comp = this.cKey.getEditor().getEditorComponent();
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).getDocument().addDocumentListener(this);
        }
        this.tValue.getDocument().addDocumentListener(this);
        this.isStateValid();
    }

    public String getKey() {
        return this.cKey.getEditor().getItem().toString();
    }

    public String getValue() {
        return this.tValue.getText();
    }

    public void setDialogDescriptor(DialogDescriptor desc) {
        this.dd = desc;
        this.dd.setHelpCtx(new HelpCtx(AddAbilityPanel.class));
        this.actionPerformed(null);
    }

    public boolean isStateValid() {
        String key = this.getKey();
        if (!this.isValidAbility(key)) {
            this.errorPanel.setErrorBundleMessage("ERR_AddAbil_MustBeJavaIdentifier");
            return false;
        }
        if (!(this.editing && key.equals(this.originalKey) || !this.usedNames.contains(key))) {
            this.errorPanel.setErrorBundleMessage("ERR_AddAbil_AlreadyExists");
            return false;
        }
        this.errorPanel.setErrorMessage(null);
        return true;
    }

    private boolean isValidAbility(String s) {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '/' || c == '\\') continue;
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cKey = new JComboBox();
        this.jLabel2 = new JLabel();
        this.tValue = new JTextField();
        this.errorPanel = new ErrorPanel();
        this.setPreferredSize(new Dimension(500, 110));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.cKey);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddAbilityPanel.class, (String)"LBL_AddAbility_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddAbilityPanel.class, (String)"ACSN_AddAbility_Name"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddAbilityPanel.class, (String)"ACSD_AddAbility_Name"));
        this.cKey.setEditable(true);
        this.cKey.setPreferredSize(new Dimension(300, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.cKey, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tValue);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AddAbilityPanel.class, (String)"LBL_AddAbility_Value"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddAbilityPanel.class, (String)"ACSN_AddAbility_Value"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddAbilityPanel.class, (String)"ACSND_AddAbility_Value"));
        this.tValue.setPreferredSize(new Dimension(300, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add((Component)this.tValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddAbilityPanel.class, (String)"ACSN_AddAbility"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddAbilityPanel.class, (String)"ACSD_AddAbility"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dd.setValid(this.isStateValid());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.actionPerformed(null);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.actionPerformed(null);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.actionPerformed(null);
    }
}

