/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.jemmy.EventDispatcher;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.demo.CommentWindow;
import org.netbeans.jemmy.operators.JButtonOperator;

public class DefaultCommentWindow
extends JDialog
implements CommentWindow {
    JTextArea comments;
    JButton finishButton;
    JButton nextStepButton = new JButton("One step");
    JButton contButton;
    boolean stopped = true;
    boolean continual = false;
    boolean finished = false;
    boolean interrupted = false;
    long readCommentTimeout = 1000L;

    public DefaultCommentWindow(boolean modal) {
        this.nextStepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultCommentWindow.this.hideWindow();
                DefaultCommentWindow.this.nextStepButton.setEnabled(false);
                DefaultCommentWindow.this.contButton.setEnabled(false);
                DefaultCommentWindow.this.finishButton.setEnabled(false);
                DefaultCommentWindow.this.setStopped(false);
            }
        });
        this.contButton = new JButton("All steps");
        this.contButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultCommentWindow.this.hideWindow();
                DefaultCommentWindow.this.nextStepButton.setEnabled(false);
                DefaultCommentWindow.this.contButton.setEnabled(false);
                DefaultCommentWindow.this.finishButton.setEnabled(false);
                DefaultCommentWindow.this.continual = true;
                DefaultCommentWindow.this.setStopped(false);
            }
        });
        this.finishButton = new JButton("Interrupt");
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultCommentWindow.this.hideWindow();
                if (!DefaultCommentWindow.this.finished) {
                    DefaultCommentWindow.this.setInterrupted(true);
                }
                DefaultCommentWindow.this.continual = false;
                DefaultCommentWindow.this.setStopped(false);
            }
        });
        JPanel prepreNavPane = new JPanel();
        prepreNavPane.setLayout(new BorderLayout());
        prepreNavPane.add((Component)this.finishButton, "North");
        JPanel preNavPane = new JPanel();
        preNavPane.setLayout(new BorderLayout());
        preNavPane.add((Component)this.contButton, "North");
        preNavPane.add((Component)prepreNavPane, "Center");
        JPanel navPane = new JPanel();
        navPane.setLayout(new BorderLayout());
        navPane.add((Component)this.nextStepButton, "North");
        navPane.add((Component)preNavPane, "Center");
        this.comments = new JTextArea("");
        this.comments.setEditable(false);
        this.comments.setLineWrap(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)navPane, "West");
        this.getContentPane().add((Component)new JScrollPane(this.comments), "Center");
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int)screen.getWidth(), 200);
        this.setLocation(0, (int)screen.getHeight() - 200);
        this.setModal(modal);
    }

    public DefaultCommentWindow() {
        this(false);
    }

    public void setCommentTimeout(long timeout) {
        this.readCommentTimeout = timeout;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void nextStep(String stepComment) {
        this.comments.setText(stepComment);
        this.nextStepButton.setEnabled(true);
        this.contButton.setEnabled(true);
        this.finishButton.setEnabled(true);
        this.setStopped(true);
        if (!this.continual) {
            new Mover(this.nextStepButton).enter();
        } else {
            new Mover(this.nextStepButton).push();
        }
        this.showWindow();
    }

    public void showFinalComment(String stepComment) {
        this.setStopped(true);
        this.finished = true;
        this.continual = false;
        this.finishButton.setEnabled(true);
        this.finishButton.setText("Finish");
        this.comments.setText(stepComment);
        new Mover(this.finishButton).enter();
        this.showWindow();
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public String getInterruptMessage() {
        return "Step comments: \"" + this.comments.getText() + "\"";
    }

    public void close() {
        this.setVisible(false);
    }

    private void hideWindow() {
        if (this.isModal()) {
            this.hide();
        } else {
            this.toBack();
        }
    }

    private void showWindow() {
        this.show();
        if (!this.isModal()) {
            this.toFront();
        }
    }

    private void setStopped(boolean value) {
        this.stopped = value;
    }

    private void setInterrupted(boolean value) {
        this.interrupted = value;
    }

    public class Mover
    extends Thread {
        JButtonOperator bo;
        boolean toPush = false;

        public Mover(JButton button) {
            this.bo = new JButtonOperator(button);
            Timeouts times = JemmyProperties.getCurrentTimeouts();
            times.setTimeout("AbstractButton.PushButtonTimeout", DefaultCommentWindow.this.readCommentTimeout);
            this.bo.setTimeouts(times);
        }

        public void push() {
            this.toPush = true;
            this.start();
        }

        public void enter() {
            this.toPush = false;
            this.start();
        }

        public void run() {
            try {
                while (!this.bo.getSource().isShowing()) {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                EventDispatcher.waitQueueEmpty(TestOut.getNullOutput(), JemmyProperties.getCurrentTimeouts());
                this.bo.enterMouse();
                if (this.toPush) {
                    Thread.currentThread();
                    Thread.sleep(DefaultCommentWindow.this.readCommentTimeout);
                    this.bo.push();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (TimeoutExpiredException e) {
                e.printStackTrace();
            }
        }
    }
}

