/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.openide.ErrorManager;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PreferredVMParser
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(PreferredVMParser.class.getName());
    private static final String VM_SETTINGS = "vmSettings";
    private static final String VM_TYPE = "vmType";
    private static final String VM = "vm";
    private static final String LIBRARY_LOCATIONS = "libraryLocations";
    private static final String LIBRARY_LOCATION = "libraryLocation";
    private static final String DEFAULT_VM_ATTR = "defaultVM";
    private static final String ID_ATTR = "id";
    private static final String NAME_ATTR = "name";
    private static final String PATH_ATTR = "path";
    private static final int POSITION_NONE = 0;
    private static final int POSITION_VM_SETTINGS = 1;
    private static final int POSITION_VM_TYPE = 2;
    private static final int POSITION_VM = 3;
    private static final int POSITION_LIBRARY_LOCATIONS = 4;
    private static final int POSITION_LIBRARY_LOCATION = 5;
    private int position = 0;
    private StringBuffer chars;
    private String defaultId;
    private Map<String, String> jdks;

    private PreferredVMParser() {
    }

    static Map<String, String> parse(String string) throws ProjectImporterException {
        PreferredVMParser preferredVMParser = new PreferredVMParser();
        preferredVMParser.load(new InputSource(new StringReader(string)));
        return preferredVMParser.jdks;
    }

    private void load(InputSource inputSource) throws ProjectImporterException {
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            this.chars = new StringBuffer();
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new ProjectImporterException(iOException);
        }
        catch (SAXException sAXException) {
            throw new ProjectImporterException(sAXException);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.chars.append(cArray, n, n2);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.chars.setLength(0);
        switch (this.position) {
            case 0: {
                if (string2.equals(VM_SETTINGS)) {
                    this.position = 1;
                    String string4 = attributes.getValue(DEFAULT_VM_ATTR);
                    this.defaultId = string4.substring(string4.lastIndexOf(44) + 1);
                    this.jdks = new HashMap<String, String>();
                    break;
                }
                throw new SAXException("First element has to be vmSettings, but is " + string2);
            }
            case 1: {
                if (!string2.equals(VM_TYPE)) break;
                this.position = 2;
                break;
            }
            case 2: {
                if (!string2.equals(VM)) break;
                this.position = 3;
                this.addJDK(attributes.getValue(ID_ATTR), attributes.getValue(NAME_ATTR), attributes.getValue(PATH_ATTR));
                break;
            }
            case 3: {
                if (!string2.equals(LIBRARY_LOCATIONS)) break;
                this.position = 4;
                logger.info("JRE used by your project presuambly contains additional jars. This is not supported (imported) yet. CC yourself to issue http://www.netbeans.org/issues/show_bug.cgi?id=70733 to watch a progress.");
                break;
            }
            case 4: {
                if (!string2.equals(LIBRARY_LOCATION)) break;
                this.position = 5;
                break;
            }
            default: {
                throw new SAXException("Unknown position reached: " + this.position + " (element: " + string2 + ")");
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (this.position) {
            case 1: {
                this.position = 0;
                break;
            }
            case 2: {
                this.position = 1;
                break;
            }
            case 3: {
                this.position = 2;
                break;
            }
            case 4: {
                this.position = 3;
                break;
            }
            case 5: {
                this.position = 4;
                break;
            }
            default: {
                ErrorManager.getDefault().log(16, "Unknown state reached in ClassPathParser, position: " + this.position);
            }
        }
        this.chars.setLength(0);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        ErrorManager.getDefault().log(16, "Error occurres: " + sAXParseException);
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        ErrorManager.getDefault().log(16, "Fatal error occurres: " + sAXParseException);
        throw sAXParseException;
    }

    private void addJDK(String string, String string2, String string3) {
        if (string.equals(this.defaultId)) {
            this.jdks.put("org.eclipse.jdt.launching.JRE_CONTAINER", string3);
        }
        this.jdks.put(string2, string3);
    }
}

