/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonInstanceProperties;
import org.netbeans.modules.hudson.impl.ProjectHIP;
import org.netbeans.modules.hudson.spi.ProjectHudsonProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonManagerImpl {
    private static HudsonManagerImpl defaultInstance;
    private Map<String, HudsonInstanceImpl> instances;
    private final List<HudsonChangeListener> listeners = new ArrayList<HudsonChangeListener>();
    private PropertyChangeListener projectsListener;
    private Map<Project, HudsonInstanceImpl> projectInstances = new HashMap<Project, HudsonInstanceImpl>();

    private HudsonManagerImpl() {
        this.projectsListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            HudsonManagerImpl.this.checkOpenProjects();
                        }
                    });
                }
            }
        };
    }

    public static synchronized HudsonManagerImpl getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new HudsonManagerImpl();
        }
        return defaultInstance;
    }

    public HudsonInstanceImpl addInstance(final HudsonInstanceImpl hudsonInstanceImpl) {
        if (null == hudsonInstanceImpl || null != this.getInstancesMap().get(hudsonInstanceImpl.getUrl())) {
            return null;
        }
        if (null != this.getInstancesMap().put(hudsonInstanceImpl.getUrl(), hudsonInstanceImpl)) {
            return null;
        }
        this.fireChangeListeners();
        hudsonInstanceImpl.storeDefinition();
        hudsonInstanceImpl.getProperties().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                hudsonInstanceImpl.storeDefinition();
            }
        });
        return hudsonInstanceImpl;
    }

    public HudsonInstanceImpl removeInstance(HudsonInstanceImpl hudsonInstanceImpl) {
        if (null == hudsonInstanceImpl || null == this.getInstancesMap().get(hudsonInstanceImpl.getUrl())) {
            return null;
        }
        if (null == this.getInstancesMap().remove(hudsonInstanceImpl.getUrl())) {
            return null;
        }
        hudsonInstanceImpl.terminate();
        this.fireChangeListeners();
        this.removeInstanceDefinition(hudsonInstanceImpl);
        return hudsonInstanceImpl;
    }

    public HudsonInstanceImpl getInstance(String string) {
        return this.getInstancesMap().get(string);
    }

    public synchronized Collection<HudsonInstanceImpl> getInstances() {
        return Arrays.asList(this.getInstancesMap().values().toArray(new HudsonInstanceImpl[0]));
    }

    public HudsonInstance getInstanceByName(String string) {
        for (HudsonInstanceImpl hudsonInstanceImpl : this.getInstances()) {
            if (!hudsonInstanceImpl.getName().equals(string)) continue;
            return hudsonInstanceImpl;
        }
        return null;
    }

    public void addHudsonChangeListener(HudsonChangeListener hudsonChangeListener) {
        this.listeners.add(hudsonChangeListener);
    }

    public void removeHudsonChangeListener(HudsonChangeListener hudsonChangeListener) {
        this.listeners.remove(hudsonChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListeners() {
        ArrayList<HudsonChangeListener> arrayList;
        List<HudsonChangeListener> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<HudsonChangeListener>(this.listeners);
        }
        for (HudsonChangeListener hudsonChangeListener : arrayList) {
            hudsonChangeListener.stateChanged();
            hudsonChangeListener.contentChanged();
        }
    }

    public void terminate() {
        defaultInstance = null;
        OpenProjects.getDefault().removePropertyChangeListener(this.projectsListener);
        this.projectInstances.clear();
        for (HudsonInstanceImpl hudsonInstanceImpl : this.getInstances()) {
            hudsonInstanceImpl.terminate();
        }
    }

    static Preferences instancePrefs() {
        return NbPreferences.forModule(HudsonManagerImpl.class).node("instances");
    }

    public static String simplifyServerLocation(String string, boolean bl) {
        String string2 = string.replaceFirst("https?://", "").replaceFirst("/$", "");
        return bl ? string2.replaceAll("[/:]", "_") : string2;
    }

    private void removeInstanceDefinition(HudsonInstanceImpl hudsonInstanceImpl) {
        try {
            hudsonInstanceImpl.prefs().removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
    }

    private Map<String, HudsonInstanceImpl> getInstancesMap() {
        if (null == this.instances) {
            this.instances = new HashMap<String, HudsonInstanceImpl>();
            this.init();
        }
        return this.instances;
    }

    private void init() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        for (String string : HudsonManagerImpl.instancePrefs().childrenNames()) {
                            Preferences preferences = HudsonManagerImpl.instancePrefs().node(string);
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            for (String string2 : preferences.keys()) {
                                hashMap.put(string2, preferences.get(string2, null));
                            }
                            if (!hashMap.containsKey("name") || !hashMap.containsKey("url") || !hashMap.containsKey("sync_time")) continue;
                            HudsonInstanceImpl.createHudsonInstance(new HudsonInstanceProperties((Map<String, String>)hashMap));
                        }
                    }
                    catch (BackingStoreException backingStoreException) {
                        Exceptions.printStackTrace((Throwable)backingStoreException);
                    }
                }
                finally {
                    HudsonManagerImpl.this.checkOpenProjects();
                    OpenProjects.getDefault().addPropertyChangeListener(HudsonManagerImpl.this.projectsListener);
                    HudsonManagerImpl.this.fireChangeListeners();
                }
            }
        });
    }

    private void checkOpenProjects() {
        try {
            Future future = OpenProjects.getDefault().openProjects();
            Project[] projectArray = (Project[])future.get();
            for (Project object : projectArray) {
                Object object2;
                Object object3;
                ProjectHudsonProvider.Association association;
                boolean projectHIP = false;
                if (this.projectInstances.containsKey(object)) {
                    projectHIP = true;
                }
                if ((association = ProjectHudsonProvider.getDefault().findAssociation(object)) != null && !projectHIP) {
                    ProjectHIP projectHIP2;
                    object3 = association.getServerUrl();
                    object2 = this.getInstance((String)object3);
                    if (object2 != null && ((HudsonInstanceImpl)object2).getProperties() instanceof ProjectHIP) {
                        projectHIP2 = (ProjectHIP)((HudsonInstanceImpl)object2).getProperties();
                        projectHIP2.addProvider(object);
                        this.projectInstances.put(object, (HudsonInstanceImpl)object2);
                        continue;
                    }
                    if (object2 != null) continue;
                    projectHIP2 = new ProjectHIP();
                    projectHIP2.addProvider(object);
                    this.addInstance(HudsonInstanceImpl.createHudsonInstance(projectHIP2));
                    HudsonInstanceImpl hudsonInstanceImpl = this.getInstance((String)projectHIP2.get("url"));
                    this.projectInstances.put(object, hudsonInstanceImpl);
                    continue;
                }
                if (association != null || !projectHIP || (object3 = this.projectInstances.remove(object)) == null || !(((HudsonInstanceImpl)object3).getProperties() instanceof ProjectHIP)) continue;
                object2 = (ProjectHIP)((HudsonInstanceImpl)object3).getProperties();
                ((ProjectHIP)object2).removeProvider(object);
                if (!((ProjectHIP)object2).getProviders().isEmpty()) continue;
                this.removeInstance((HudsonInstanceImpl)object3);
            }
            ArrayList<Project> arrayList = new ArrayList<Project>(this.projectInstances.keySet());
            arrayList.removeAll(Arrays.asList(projectArray));
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Project project = (Project)iterator.next();
                HudsonInstanceImpl hudsonInstanceImpl = this.projectInstances.remove(project);
                if (hudsonInstanceImpl == null || !(hudsonInstanceImpl.getProperties() instanceof ProjectHIP)) continue;
                ProjectHIP projectHIP = (ProjectHIP)hudsonInstanceImpl.getProperties();
                projectHIP.removeProvider(project);
                if (!projectHIP.getProviders().isEmpty()) continue;
                this.removeInstance(hudsonInstanceImpl);
            }
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
    }
}

