/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.vcs.HookUtils;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FormatPanel
extends JPanel {
    private final VCSHooksConfig.Format defaultIssueInfoTemplate;
    private final VCSHooksConfig.Format defaultRevisionTemplate;
    private final String[] supportedIssueInfoVariables;
    private final String[] supportedRevisionVariables;
    private JRadioButton aboveCommitRadio;
    private JRadioButton belowCommitRadio;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JTextArea issueInfoTextArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel placeholder;
    private JButton resetCommitButton;
    private JButton resetIssueButton;
    private JTextArea revisionTextArea;
    private JLabel warningLabel;

    FormatPanel(VCSHooksConfig.Format format, VCSHooksConfig.Format format2, String[] stringArray, VCSHooksConfig.Format format3, VCSHooksConfig.Format format4, String[] stringArray2) {
        this.initComponents();
        this.warningLabel.setVisible(false);
        this.defaultIssueInfoTemplate = format4;
        this.supportedIssueInfoVariables = stringArray2;
        this.defaultRevisionTemplate = format2;
        this.supportedRevisionVariables = stringArray;
        this.setRevisionTemplate(format);
        this.setIssueInfoTemplate(format3);
        this.issueInfoTextArea.getDocument().addDocumentListener(new MsgListener(this.issueInfoTextArea));
        this.revisionTextArea.getDocument().addDocumentListener(new MsgListener(this.revisionTextArea));
    }

    VCSHooksConfig.Format getCommitFormat() {
        return new VCSHooksConfig.Format(this.aboveCommitRadio.isSelected(), this.issueInfoTextArea.getText());
    }

    VCSHooksConfig.Format getIssueFormat() {
        return new VCSHooksConfig.Format(false, this.revisionTextArea.getText());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.issueInfoTextArea = new JTextArea();
        this.jLabel2 = new JLabel();
        this.aboveCommitRadio = new JRadioButton();
        this.belowCommitRadio = new JRadioButton();
        this.resetCommitButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.revisionTextArea = new JTextArea();
        this.resetIssueButton = new JButton();
        this.jLabel4 = new JLabel();
        this.warningLabel = new JLabel();
        this.placeholder = new JLabel();
        this.jLabel1.setLabelFor(this.issueInfoTextArea);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jLabel1.text"));
        this.issueInfoTextArea.setColumns(20);
        this.issueInfoTextArea.setFont(new Font("Monospaced", 0, 13));
        this.issueInfoTextArea.setRows(5);
        this.issueInfoTextArea.setToolTipText(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.issueInfoTextArea.toolTipText"));
        this.jScrollPane1.setViewportView(this.issueInfoTextArea);
        this.issueInfoTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jTextArea1.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jLabel2.text"));
        this.buttonGroup1.add(this.aboveCommitRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.aboveCommitRadio, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.aboveCommitRadio.text"));
        this.buttonGroup1.add(this.belowCommitRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.belowCommitRadio, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.belowCommitRadio.text"));
        this.belowCommitRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatPanel.this.belowCommitRadioActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.resetCommitButton, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.resetCommitButton.text"));
        this.resetCommitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatPanel.this.resetCommitButtonActionPerformed(actionEvent);
            }
        });
        this.jLabel3.setLabelFor(this.revisionTextArea);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jLabel3.text"));
        this.revisionTextArea.setColumns(20);
        this.revisionTextArea.setFont(new Font("Monospaced", 0, 13));
        this.revisionTextArea.setRows(5);
        this.revisionTextArea.setToolTipText(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.revisionTextArea.toolTipText"));
        this.jScrollPane2.setViewportView(this.revisionTextArea);
        Mnemonics.setLocalizedText((AbstractButton)this.resetIssueButton, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.resetIssueButton.text"));
        this.resetIssueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatPanel.this.resetIssueButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jLabel4.text"));
        this.warningLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/bugtracking/bridge/resources/warning.gif")));
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.warningLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.placeholder, (String)NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.placeholder.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.aboveCommitRadio).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.resetIssueButton).add((Component)this.belowCommitRadio))).addPreferredGap(0, 89, Short.MAX_VALUE).add((Component)this.resetCommitButton)).add((Component)this.jLabel4).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 233, Short.MAX_VALUE).add((Component)this.jLabel1, -1, 233, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.jScrollPane2, -1, 229, Short.MAX_VALUE).add(1, (Component)this.jLabel3, 0, 0, Short.MAX_VALUE))).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.warningLabel, -1, 454, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.placeholder, -2, 14, -2))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -2, 131, -2).add((Component)this.jScrollPane2, -2, 131, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.aboveCommitRadio)).addPreferredGap(0).add((Component)this.belowCommitRadio).addPreferredGap(0).add((Component)this.resetIssueButton)).add((Component)this.resetCommitButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.warningLabel).add((Component)this.placeholder)).addContainerGap()));
        this.aboveCommitRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.aboveRadio.AccessibleContext.accessibleDescription"));
        this.belowCommitRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.beloveRadio.AccessibleContext.accessibleDescription"));
        this.resetCommitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.jButton1.AccessibleContext.accessibleDescription"));
        this.resetIssueButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.resetIssueButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.AccessibleContext.accessibleDescription"));
    }

    private void belowCommitRadioActionPerformed(ActionEvent actionEvent) {
    }

    private void resetCommitButtonActionPerformed(ActionEvent actionEvent) {
        this.setRevisionTemplate(this.defaultRevisionTemplate);
    }

    private void resetIssueButtonActionPerformed(ActionEvent actionEvent) {
        this.setIssueInfoTemplate(this.defaultIssueInfoTemplate);
    }

    private void setRevisionTemplate(VCSHooksConfig.Format format) {
        this.revisionTextArea.setText(format.getFormat());
    }

    private void setIssueInfoTemplate(VCSHooksConfig.Format format) {
        this.issueInfoTextArea.setText(format.getFormat());
        this.aboveCommitRadio.setSelected(format.isAbove());
        this.belowCommitRadio.setSelected(!format.isAbove());
    }

    private void validateText(JTextArea jTextArea) {
        assert (jTextArea == this.revisionTextArea || jTextArea == this.issueInfoTextArea);
        String[] stringArray = jTextArea == this.revisionTextArea ? this.supportedRevisionVariables : this.supportedIssueInfoVariables;
        boolean bl = !HookUtils.containsUnsupportedVariables(jTextArea.getText(), stringArray);
        this.warningLabel.setText(NbBundle.getMessage(FormatPanel.class, (String)"FormatPanel.warningLabel.text", (Object)this.list(stringArray)));
        this.warningLabel.setVisible(!bl);
    }

    private String list(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("{");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("}");
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private class MsgListener
    implements DocumentListener {
        private final JTextArea textArea;

        public MsgListener(JTextArea jTextArea) {
            this.textArea = jTextArea;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            FormatPanel.this.validateText(this.textArea);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            FormatPanel.this.validateText(this.textArea);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            FormatPanel.this.validateText(this.textArea);
        }
    }
}

