/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared;

import java.awt.Image;
import java.io.IOException;
import java.util.Collection;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.swing.Action;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.ComponentMethodViewStrategy;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class MethodNode
extends AbstractNode
implements OpenCookie {
    private final ClasspathInfo cpInfo;
    private final String implBean;
    private final FileObject implBeanFO;
    private final MethodModel method;
    private final ComponentMethodViewStrategy cmvs;
    private final Collection interfaces;

    public MethodNode(ClasspathInfo classpathInfo, MethodModel methodModel, String string, Collection collection, ComponentMethodViewStrategy componentMethodViewStrategy) {
        this(classpathInfo, methodModel, string, collection, componentMethodViewStrategy, new InstanceContent());
    }

    private MethodNode(ClasspathInfo classpathInfo, MethodModel methodModel, String string, Collection collection, ComponentMethodViewStrategy componentMethodViewStrategy, InstanceContent instanceContent) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        instanceContent.add((Object)this);
        instanceContent.add((Object)methodModel);
        this.cpInfo = classpathInfo;
        this.method = methodModel;
        this.implBean = string;
        this.interfaces = collection;
        this.cmvs = componentMethodViewStrategy;
        this.implBeanFO = MethodNode.getFileObject(classpathInfo, string);
    }

    public Image getIcon(int n) {
        Image image = this.cmvs.getBadge(this.method, this.interfaces);
        Image image2 = this.cmvs.getIcon(this.method, this.interfaces);
        if (image != null) {
            return ImageUtilities.mergeImages((Image)image2, (Image)image, (int)7, (int)7);
        }
        return image2;
    }

    public String getName() {
        return this.method.getName();
    }

    public boolean canDestroy() {
        final boolean[] blArray = new boolean[]{false};
        try {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    if ("findByPrimaryKey".equals(MethodNode.this.method.getName())) {
                        if (MethodNode.this.isEntityBeanMethod()) {
                            blArray[0] = false;
                        }
                    } else if (MethodNode.this.method.getModifiers().contains((Object)Modifier.ABSTRACT) && (MethodNode.this.isGetter(MethodNode.this.method) || MethodNode.this.isSetter(MethodNode.this.method)) && MethodNode.this.isEntityBeanMethod()) {
                        blArray[0] = false;
                    }
                    blArray[0] = true;
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return blArray[0];
    }

    public void destroy() throws IOException {
        if (this.implBeanFO != null) {
            this.cmvs.deleteImplMethod(this.method, this.implBean, this.implBeanFO, this.interfaces);
        }
        super.destroy();
    }

    public Action[] getActions(boolean bl) {
        return new Action[0];
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public void open() {
        this.cmvs.openMethod(this.method, this.implBean, this.implBeanFO, this.interfaces);
    }

    private boolean isEntityBeanMethod() throws IOException {
        final boolean[] blArray = new boolean[]{false};
        JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Elements elements = compilationController.getElements();
                TypeElement typeElement = elements.getTypeElement("javax.ejb.EntityBean");
                TypeElement typeElement2 = elements.getTypeElement(MethodNode.this.implBean);
                blArray[0] = compilationController.getTypes().isSubtype(typeElement2.asType(), typeElement.asType());
            }
        }, true);
        return blArray[0];
    }

    private boolean isGetter(MethodModel methodModel) {
        boolean bl = "void".equals(methodModel.getReturnType());
        return methodModel.getName().indexOf("get") == 0 && !bl && methodModel.getParameters().size() == 0;
    }

    private boolean isSetter(MethodModel methodModel) {
        boolean bl = "void".equals(methodModel.getReturnType());
        return methodModel.getName().indexOf("set") == 0 && bl && methodModel.getParameters().size() == 1;
    }

    private static FileObject getFileObject(ClasspathInfo classpathInfo, final String string) {
        final FileObject[] fileObjectArray = new FileObject[1];
        try {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                    if (typeElement != null) {
                        fileObjectArray[0] = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)compilationController.getClasspathInfo());
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return fileObjectArray[0];
    }
}

