/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common.annotation;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.modules.j2ee.dd.util.AnnotationUtils;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.DefaultProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;

public class ResourceImpl {
    static final String DEFAULT_AUTHENTICATION_TYPE = Resource.AuthenticationType.CONTAINER.name();
    static final String DEFAULT_SHAREABLE = Boolean.TRUE.toString();
    static final String DEFAULT_MAPPED_NAME = "";
    static final String DEFAULT_DESCRIPTION = "";
    private final ParseResult parseResult;
    private final AnnotationModelHelper annotationModelHelper;
    private final TypeElement typeElement;
    private final Element element;

    public ResourceImpl(Element element, TypeElement typeElement, AnnotationModelHelper annotationModelHelper) {
        this.annotationModelHelper = annotationModelHelper;
        this.typeElement = typeElement;
        this.element = element;
        Map map = annotationModelHelper.getAnnotationsByType(element.getAnnotationMirrors());
        this.parseResult = this.parseAnnotation((AnnotationMirror)map.get(Resource.class.getName()));
    }

    private ParseResult parseAnnotation(AnnotationMirror annotationMirror) {
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)this.annotationModelHelper);
        annotationParser.expectString("name", new DefaultProvider(){

            public Object getDefaultValue() {
                switch (ResourceImpl.this.element.getKind()) {
                    case METHOD: {
                        return AnnotationUtils.setterNameToPropertyName(ResourceImpl.this.element.getSimpleName().toString());
                    }
                    case FIELD: {
                        return ResourceImpl.this.element.getSimpleName().toString();
                    }
                }
                return "";
            }
        });
        annotationParser.expectClass("type", new DefaultProvider(){

            public Object getDefaultValue() {
                switch (ResourceImpl.this.element.getKind()) {
                    case CLASS: {
                        TypeElement typeElement = (TypeElement)ResourceImpl.this.element;
                        return typeElement.getQualifiedName().toString();
                    }
                    case METHOD: {
                        ExecutableElement executableElement = (ExecutableElement)ResourceImpl.this.element;
                        List<? extends VariableElement> list = executableElement.getParameters();
                        if (list.isEmpty()) break;
                        VariableElement variableElement = list.get(0);
                        return ((Object)variableElement.asType()).toString();
                    }
                    case FIELD: {
                        VariableElement variableElement = (VariableElement)ResourceImpl.this.element;
                        return ((Object)variableElement.asType()).toString();
                    }
                }
                return Object.class.getName();
            }
        });
        annotationParser.expectEnumConstant("authenticationType", this.annotationModelHelper.resolveType("javax.annotation.Resource.AuthenticationType"), AnnotationParser.defaultValue((Object)DEFAULT_AUTHENTICATION_TYPE));
        annotationParser.expectPrimitive("shareable", Boolean.class, AnnotationParser.defaultValue((Object)Boolean.parseBoolean(DEFAULT_SHAREABLE)));
        annotationParser.expectString("mappedName", AnnotationParser.defaultValue((Object)""));
        annotationParser.expectString("description", AnnotationParser.defaultValue((Object)""));
        return annotationParser.parse(annotationMirror);
    }

    public String getName() {
        return (String)this.parseResult.get("name", String.class);
    }

    public String getType() {
        return (String)this.parseResult.get("type", String.class);
    }

    public String getAuthenticationType() {
        return (String)this.parseResult.get("authenticationType", String.class);
    }

    public String getShareable() {
        return ((Boolean)this.parseResult.get("shareable", Boolean.class)).toString();
    }

    public String getMappedName() {
        return (String)this.parseResult.get("mappedName", String.class);
    }

    public String getDescription() {
        return (String)this.parseResult.get("description", String.class);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        stringBuilder.append(this.getClass().getName() + " Object {");
        stringBuilder.append(string);
        stringBuilder.append(" Name: ");
        stringBuilder.append(this.getName());
        stringBuilder.append(string);
        stringBuilder.append(" Type: ");
        stringBuilder.append(this.getType());
        stringBuilder.append(string);
        stringBuilder.append(" AuthenticationType: ");
        stringBuilder.append(this.getAuthenticationType());
        stringBuilder.append(string);
        stringBuilder.append(" Shareable: ");
        stringBuilder.append(this.getShareable());
        stringBuilder.append(string);
        stringBuilder.append(" MappedName: ");
        stringBuilder.append(this.getMappedName());
        stringBuilder.append(string);
        stringBuilder.append(" Description: ");
        stringBuilder.append(this.getDescription());
        stringBuilder.append(string);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

