/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class J9Builder
extends Task {
    private File home;
    private String mainclass;
    private String args;
    private File dist;
    private String jvmargs;
    private String id;
    private String platform;
    private boolean xlet;
    private boolean applet;
    private String jarName;
    private List<FileSet> filesets = new LinkedList<FileSet>();

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        if (this.dist == null) {
            throw new BuildException("Dist can not be null!");
        }
        assert (this.id != null);
        assert (this.mainclass != null);
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.jvmargs != null && this.jvmargs.length() != 0) {
            arguments.add(this.jvmargs);
        }
        if (!this.xlet) {
            arguments.add("-cp");
            arguments.add(this.createPath());
            if (!this.applet) {
                arguments.add(this.mainclass);
            } else if (this.applet) {
                arguments.add("com.ibm.oti.appletviewer.AppletViewer");
            }
            if (this.args != null && this.args.length() != 0 && !this.applet) {
                arguments.add(this.args);
            }
        } else if (this.xlet) {
            StringTokenizer st = new StringTokenizer(this.mainclass, ";");
            arguments.add("com.ibm.oti.xlet.XletApplicationManager");
            while (st.hasMoreElements()) {
                arguments.add("-name:" + st.nextElement());
                arguments.add("-path:" + this.createPath());
                if (this.args == null || this.args.length() == 0 || this.applet) continue;
                arguments.add("-args:" + this.args);
            }
        }
        if (this.applet) {
            arguments.add("file:/C:/private/" + this.id + "/applet.html");
            if (this.home == null || !this.home.exists()) {
                throw new BuildException("Home does not exist!");
            }
            this.generateHtml();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.dist);
            Iterator it = arguments.iterator();
            while (it.hasNext()) {
                fos.write(((String)it.next()).getBytes());
                if (!it.hasNext()) continue;
                fos.write(" ".getBytes());
            }
        }
        catch (IOException ex) {
            throw new BuildException("Can not write " + this.dist.toString(), (Throwable)ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                throw new BuildException("Can not close " + this.dist.toString(), (Throwable)ex);
            }
        }
    }

    private String createPath() {
        StringBuffer sb = new StringBuffer();
        if (this.jarName != null) {
            if (this.platform.startsWith("semc")) {
                sb.append("C:\\private\\" + this.id + "\\" + this.jarName + ";D:\\private\\" + this.id + "\\" + this.jarName);
            } else if (this.platform.startsWith("nokia")) {
                sb.append(this.jarName);
            } else {
                throw new BuildException("Unknown target platform " + this.platform);
            }
        }
        for (FileSet fs : this.filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                if (this.platform.startsWith("semc")) {
                    sb.append("C:\\private\\" + this.id + "\\" + files[i] + ";D:\\private\\" + this.id + "\\" + files[i]);
                    continue;
                }
                if (this.platform.startsWith("nokia")) {
                    sb.append(files[i]);
                    continue;
                }
                throw new BuildException("Unknown target platform " + this.platform);
            }
        }
        return sb.toString();
    }

    private void generateHtml() throws BuildException {
        File f = null;
        if (this.platform.startsWith("semc")) {
            f = new File(this.home, "epoc32\\winscw\\c\\private\\" + this.id + "\\applet.html");
        } else if (this.platform.startsWith("nokia")) {
            f = new File(this.home, "epoc32\\wins\\c\\PP_Applications\\applet" + this.id + ".html");
        } else {
            throw new BuildException("Unknown target platform " + this.platform);
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(f));
            pw.println("<HTML>");
            pw.println("<HEAD>");
            pw.println("<TITLE> A Simple Program </TITLE>");
            pw.println("</HEAD>");
            pw.println("<BODY>");
            pw.println("<APPLET CODE=\"" + this.mainclass + ".class\" WIDTH=240 HEIGHT=320>");
            pw.println("</APPLET>");
            pw.println("</BODY>");
            pw.println("</HTML>");
        }
        catch (IOException ex) {
            throw new BuildException("HTML can not be writen");
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public String getMainclass() {
        return this.mainclass;
    }

    public void setMainclass(String mainclass) {
        this.mainclass = mainclass;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public File getDist() {
        return this.dist;
    }

    public void setDist(File dist) {
        this.dist = dist;
    }

    public String getJvmargs() {
        return this.jvmargs;
    }

    public void setJvmargs(String jvmargs) {
        this.jvmargs = jvmargs;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isXlet() {
        return this.xlet;
    }

    public void setXlet(boolean xlet) {
        this.xlet = xlet;
    }

    public boolean isApplet() {
        return this.applet;
    }

    public void setApplet(boolean applet) {
        this.applet = applet;
    }

    public File getHome() {
        return this.home;
    }

    public void setHome(File home) {
        this.home = home;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform.toLowerCase();
    }
}

