/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.spi.dynhelp.CompletionDocumentationProvider;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.modelutil.CsmPaintComponent;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.ParamStr;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmResultItem
implements CompletionItem {
    private static boolean enableInstantSubstitution = true;
    protected int selectionStartOffset = -1;
    protected int selectionEndOffset = -1;
    protected int substituteOffset = -1;
    CsmObject associatedObject;
    private static final Color KEYWORD_COLOR = Color.gray;
    private static final Color TYPE_COLOR = Color.black;
    private int priority;
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    private String toAdd;

    protected CsmResultItem(CsmObject csmObject, int n) {
        this.associatedObject = csmObject;
        this.priority = n;
    }

    public abstract String getItemText();

    public Object getAssociatedObject() {
        return this.associatedObject;
    }

    protected static Color getTypeColor(CsmType csmType) {
        return csmType.isBuiltInBased(false) ? KEYWORD_COLOR : TYPE_COLOR;
    }

    public void setSubstituteOffset(int n) {
        this.substituteOffset = n;
    }

    public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
        return false;
    }

    public boolean substituteText(final JTextComponent jTextComponent, final int n, final int n2, boolean bl) {
        final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        final String string = this.getReplaceText();
        final boolean[] blArray = new boolean[]{true};
        if (string != null) {
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n, (int)n2);
                        if (CharSequenceUtilities.textEquals((CharSequence)string, (CharSequence)charSequence)) {
                            blArray[0] = false;
                            return;
                        }
                        baseDocument.remove(n, n2);
                        baseDocument.insertString(n, string, null);
                        if (CsmResultItem.this.selectionStartOffset >= 0) {
                            jTextComponent.select(n + CsmResultItem.this.selectionStartOffset, n + CsmResultItem.this.selectionEndOffset);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        return blArray[0];
    }

    public Component getPaintComponent(JList jList, boolean bl, boolean bl2) {
        Component component = this.getPaintComponent(bl);
        if (component == null) {
            return null;
        }
        if (bl) {
            component.setBackground(jList.getSelectionBackground());
            component.setForeground(jList.getSelectionForeground());
        } else {
            component.setBackground(jList.getBackground());
            component.setForeground(jList.getForeground());
        }
        component.getAccessibleContext().setAccessibleName(this.getItemText());
        component.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return component;
    }

    protected abstract Component getPaintComponent(boolean var1);

    public int getPreferredWidth(Graphics graphics, Font font) {
        Component component = this.getPaintComponent(false);
        component.setFont(font);
        int n = component.getPreferredSize().width;
        return n;
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        Component component = this.getPaintComponent(bl);
        component.setFont(font);
        component.setForeground(color);
        component.setBackground(color2);
        component.setBounds(0, 0, n, n2);
        ((CsmPaintComponent)component).paintComponent(graphics);
    }

    protected static String getTypeName(CsmType csmType, boolean bl) {
        CharSequence charSequence = bl ? CsmInstantiationProvider.getDefault().getInstantiatedText(csmType) : csmType.getText();
        return ((Object)charSequence).toString();
    }

    public String toString() {
        Component component = this.getPaintComponent(false);
        return component != null ? component.toString() : "";
    }

    protected int convertCsmModifiers(CsmObject csmObject) {
        return CsmUtilities.getModifiers((CsmObject)csmObject);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400) {
            Completion completion = Completion.get();
            switch (keyEvent.getKeyChar()) {
                case ' ': {
                    if (keyEvent.getModifiers() != 0) break;
                    completion.hideCompletion();
                    completion.hideDocumentation();
                    break;
                }
                case '%': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case ';': 
                case '=': {
                    completion.hideCompletion();
                    completion.hideDocumentation();
                    break;
                }
                case '.': {
                    if (!this.defaultAction((JTextComponent)keyEvent.getSource(), Character.toString(keyEvent.getKeyChar()))) break;
                    keyEvent.consume();
                }
            }
        }
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public CompletionTask createDocumentationTask() {
        CompletionDocumentationProvider completionDocumentationProvider = (CompletionDocumentationProvider)Lookup.getDefault().lookup(CompletionDocumentationProvider.class);
        return completionDocumentationProvider != null ? completionDocumentationProvider.createDocumentationTask(this) : null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public static void setEnableInstantSubstitution(boolean bl) {
        enableInstantSubstitution = bl;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        if (enableInstantSubstitution) {
            Completion completion = Completion.get();
            completion.hideCompletion();
            completion.hideDocumentation();
            this.defaultAction(jTextComponent);
            return true;
        }
        return false;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(jTextComponent, "");
    }

    boolean defaultAction(JTextComponent jTextComponent, String string) {
        int n = this.substituteOffset;
        if (n == -1) {
            n = jTextComponent.getCaret().getDot();
        }
        this.toAdd = string;
        if (this.substituteText(jTextComponent, n, jTextComponent.getCaret().getDot() - n, false)) {
            if (CsmCompletionUtils.isAutoInsertIncludeDirectives()) {
                CsmIncludeResolver csmIncludeResolver = CsmIncludeResolver.getDefault();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                Object object = this.getAssociatedObject();
                if (CsmKindUtilities.isCsmObject((Object)object)) {
                    String string2;
                    CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)false);
                    if (!(csmIncludeResolver.isObjectVisible(csmFile, (CsmObject)object) || (string2 = csmIncludeResolver.getIncludeDirective(csmFile, (CsmObject)object)).length() == 0 || this.isForwardDeclaration(jTextComponent) || this.isAlreadyIncluded(jTextComponent, string2))) {
                        this.insertInclude(jTextComponent, csmFile, string2, string2.charAt(string2.length() - 1) == '>');
                    }
                } else {
                    System.err.println("not yet handled object " + object);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isAlreadyIncluded(JTextComponent jTextComponent, String string) {
        TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((JTextComponent)jTextComponent, (int)0, (boolean)false, (boolean)false);
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            StringBuilder stringBuilder;
            if (!((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.PREPROCESSOR_DIRECTIVE) || !this.isIncludesEqual(string, (stringBuilder = new StringBuilder(tokenSequence.token().text())).toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isIncludesEqual(String string, String string2) {
        string = this.normalizeInclude(string);
        string2 = this.normalizeInclude(string2);
        return string.equals(string2);
    }

    private String normalizeInclude(String string) {
        string = string.toLowerCase();
        string = string.replaceAll("[\\s\n]+", " ");
        string = string.replaceAll("[<>\"]", "\"");
        string = string.trim();
        return string;
    }

    private boolean isForwardDeclaration(JTextComponent jTextComponent) {
        TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((JTextComponent)jTextComponent, (int)0, (boolean)false, (boolean)false);
        tokenSequence.moveStart();
        if (!tokenSequence.moveNext()) {
            return false;
        }
        CppTokenId cppTokenId = (CppTokenId)tokenSequence.token().id();
        while (tokenSequence.offset() < this.substituteOffset) {
            switch ((CppTokenId)tokenSequence.token().id()) {
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: 
                case NEW_LINE: 
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case WHITESPACE: {
                    break;
                }
                default: {
                    cppTokenId = (CppTokenId)tokenSequence.token().id();
                }
            }
            if (tokenSequence.moveNext()) continue;
            return false;
        }
        switch (cppTokenId) {
            case CLASS: 
            case STRUCT: 
            case UNION: {
                return true;
            }
        }
        return false;
    }

    private void insertInclude(JTextComponent jTextComponent, CsmFile csmFile, String string, boolean bl) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        CsmInclude csmInclude = null;
        boolean bl2 = false;
        for (CsmInclude csmInclude2 : csmFile.getIncludes()) {
            if (csmInclude2.isSystem() == bl) {
                csmInclude = csmInclude2;
                bl2 = true;
                continue;
            }
            if (csmInclude != null && (bl2 || bl)) continue;
            csmInclude = csmInclude2;
        }
        Iterator iterator = csmInclude;
        boolean bl3 = bl2;
        baseDocument.runAtomic(new Runnable((CsmInclude)iterator, bl3, baseDocument, string, bl, csmFile, jTextComponent){
            final /* synthetic */ CsmInclude val$lastInclude2;
            final /* synthetic */ boolean val$isLastIncludeTypeMatch2;
            final /* synthetic */ BaseDocument val$doc;
            final /* synthetic */ String val$include;
            final /* synthetic */ boolean val$isSystem;
            final /* synthetic */ CsmFile val$currentFile;
            final /* synthetic */ JTextComponent val$component;
            {
                this.val$lastInclude2 = csmInclude;
                this.val$isLastIncludeTypeMatch2 = bl;
                this.val$doc = baseDocument;
                this.val$include = string;
                this.val$isSystem = bl2;
                this.val$currentFile = csmFile;
                this.val$component = jTextComponent;
            }

            public void run() {
                try {
                    if (this.val$lastInclude2 != null) {
                        if (this.val$isLastIncludeTypeMatch2) {
                            this.val$doc.insertString(this.val$lastInclude2.getEndOffset(), "\n" + this.val$include, null);
                        } else if (!this.val$isSystem) {
                            this.val$doc.insertString(this.val$lastInclude2.getEndOffset(), "\n\n" + this.val$include, null);
                        } else {
                            this.val$doc.insertString(this.val$lastInclude2.getStartOffset(), this.val$include + "\n\n", null);
                        }
                    } else {
                        CsmFileInfoQuery csmFileInfoQuery = CsmFileInfoQuery.getDefault();
                        CsmOffsetable csmOffsetable = csmFileInfoQuery.getGuardOffset(this.val$currentFile);
                        TokenSequence tokenSequence = csmOffsetable != null ? CndLexerUtilities.getCppTokenSequence((JTextComponent)this.val$component, (int)csmOffsetable.getStartOffset(), (boolean)false, (boolean)false) : CndLexerUtilities.getCppTokenSequence((JTextComponent)this.val$component, (int)0, (boolean)false, (boolean)false);
                        if (tokenSequence != null) {
                            int n = CsmResultItem.this.getIncludeOffsetFromTokenSequence((TokenSequence<CppTokenId>)tokenSequence);
                            if (n == 0 || csmOffsetable != null) {
                                this.val$doc.insertString(n, "\n" + this.val$include + "\n\n", null);
                            } else {
                                this.val$doc.insertString(n, "\n\n" + this.val$include + "\n", null);
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private int getIncludeOffsetFromTokenSequence(TokenSequence<CppTokenId> tokenSequence) {
        if (!tokenSequence.moveNext()) {
            return 0;
        }
        int n = tokenSequence.offset();
        if (n != 0) {
            if (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                if (!tokenSequence.moveNext()) {
                    return 0;
                }
                n = tokenSequence.offset();
                if (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                    if (!tokenSequence.moveNext()) {
                        return 0;
                    }
                    n = tokenSequence.offset();
                }
            }
        } else {
            while (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.WHITESPACE) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.NEW_LINE)) {
                if (tokenSequence.moveNext()) continue;
                return n;
            }
            if (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.BLOCK_COMMENT) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.DOXYGEN_COMMENT)) {
                if (!tokenSequence.moveNext()) {
                    return n;
                }
                int n2 = tokenSequence.offset();
                int n3 = 0;
                while (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.WHITESPACE) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.NEW_LINE)) {
                    if (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.NEW_LINE)) {
                        ++n3;
                    }
                    if (tokenSequence.moveNext()) continue;
                    return n;
                }
                if (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.BLOCK_COMMENT) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.DOXYGEN_COMMENT)) {
                    return n2;
                }
                if (n3 > 1) {
                    return n2;
                }
            }
        }
        return n;
    }

    protected String getReplaceText() {
        return this.getItemText();
    }

    public int getSortPriority() {
        return this.priority;
    }

    public static class StringResultItem
    extends CsmResultItem {
        private String str;
        private static CsmPaintComponent.StringPaintComponent stringComponent = null;

        public StringResultItem(String string, int n) {
            super(null, n);
            this.str = string;
        }

        public String getItemText() {
            return this.str;
        }

        public Component getPaintComponent(boolean bl) {
            if (stringComponent == null) {
                stringComponent = this.createStringPaintComponent();
            }
            stringComponent.setSelected(bl);
            stringComponent.setString(this.str);
            return stringComponent;
        }

        public Object getAssociatedObject() {
            return this.str;
        }

        protected CsmPaintComponent.StringPaintComponent createStringPaintComponent() {
            return new CsmPaintComponent.StringPaintComponent();
        }
    }

    public static class TypedefResultItem
    extends CsmResultItem {
        private CsmTypedef def;
        private int defDisplayOffset;
        private boolean displayFQN;
        private static CsmPaintComponent.TypedefPaintComponent defComponent = null;

        public TypedefResultItem(CsmTypedef csmTypedef, boolean bl, int n) {
            this(csmTypedef, 0, bl, n);
        }

        public TypedefResultItem(CsmTypedef csmTypedef, int n, boolean bl, int n2) {
            super((CsmObject)csmTypedef, n2);
            this.def = csmTypedef;
            this.defDisplayOffset = n;
            this.displayFQN = bl;
        }

        protected String getName() {
            return ((Object)this.def.getName()).toString();
        }

        protected String getReplaceText() {
            String string = this.getItemText();
            if (this.defDisplayOffset > 0 && this.defDisplayOffset < string.length()) {
                string = string.substring(this.defDisplayOffset);
            }
            return string;
        }

        public String getItemText() {
            return this.displayFQN ? ((Object)this.def.getQualifiedName()).toString() : ((Object)this.def.getName()).toString();
        }

        protected CsmPaintComponent.TypedefPaintComponent createTypedefPaintComponent() {
            return new CsmPaintComponent.TypedefPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (defComponent == null) {
                defComponent = this.createTypedefPaintComponent();
            }
            defComponent.setSelected(bl);
            defComponent.setFormatTypedefName(this.getName());
            return defComponent;
        }
    }

    public static class ForwardClassResultItem
    extends CsmResultItem {
        private CsmClassForwardDeclaration cls;
        private CsmDeclaration.Kind kind;
        private int classDisplayOffset;
        private boolean displayFQN;
        private static CsmPaintComponent.ClassPaintComponent clsComponent = null;
        private static CsmPaintComponent.StructPaintComponent structComponent = null;
        private static CsmPaintComponent.UnionPaintComponent unionComponent = null;

        public ForwardClassResultItem(CsmClassForwardDeclaration csmClassForwardDeclaration, boolean bl, int n) {
            this(csmClassForwardDeclaration, 0, bl, n);
        }

        public ForwardClassResultItem(CsmClassForwardDeclaration csmClassForwardDeclaration, int n, boolean bl, int n2) {
            super((CsmObject)csmClassForwardDeclaration, n2);
            this.cls = csmClassForwardDeclaration;
            CsmClass csmClass = csmClassForwardDeclaration.getCsmClass();
            this.kind = csmClass != null ? csmClass.getKind() : CsmDeclaration.Kind.STRUCT;
            this.classDisplayOffset = n;
            this.displayFQN = bl;
        }

        protected String getName() {
            return ((Object)this.cls.getName()).toString();
        }

        protected String getReplaceText() {
            String string = this.getItemText();
            if (this.classDisplayOffset > 0 && this.classDisplayOffset < string.length()) {
                string = string.substring(this.classDisplayOffset);
            }
            return string;
        }

        public String getItemText() {
            return this.displayFQN ? ((Object)this.cls.getQualifiedName()).toString() : this.getName();
        }

        protected CsmPaintComponent.StructPaintComponent createStructPaintComponent() {
            return new CsmPaintComponent.StructPaintComponent();
        }

        protected CsmPaintComponent.UnionPaintComponent createUnionPaintComponent() {
            return new CsmPaintComponent.UnionPaintComponent();
        }

        protected CsmPaintComponent.ClassPaintComponent createClassPaintComponent() {
            return new CsmPaintComponent.ClassPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (this.kind == CsmDeclaration.Kind.STRUCT) {
                if (structComponent == null) {
                    structComponent = this.createStructPaintComponent();
                }
                structComponent.setSelected(bl);
                structComponent.setFormatClassName(this.getName());
                return structComponent;
            }
            if (this.kind == CsmDeclaration.Kind.UNION) {
                if (unionComponent == null) {
                    unionComponent = this.createUnionPaintComponent();
                }
                unionComponent.setSelected(bl);
                unionComponent.setFormatClassName(this.getName());
                return unionComponent;
            }
            assert (this.kind == CsmDeclaration.Kind.CLASS) : "must be class kind";
            if (clsComponent == null) {
                clsComponent = this.createClassPaintComponent();
            }
            clsComponent.setSelected(bl);
            clsComponent.setFormatClassName(this.getName());
            return clsComponent;
        }
    }

    public static class ClassResultItem
    extends CsmResultItem {
        private CsmClass cls;
        private CsmDeclaration.Kind kind;
        private int classDisplayOffset;
        private boolean displayFQN;
        private static CsmPaintComponent.ClassPaintComponent clsComponent = null;
        private static CsmPaintComponent.StructPaintComponent structComponent = null;
        private static CsmPaintComponent.UnionPaintComponent unionComponent = null;

        public ClassResultItem(CsmClass csmClass, boolean bl, int n) {
            this(csmClass, 0, bl, n);
        }

        public ClassResultItem(CsmClass csmClass, int n, boolean bl, int n2) {
            super((CsmObject)csmClass, n2);
            this.cls = csmClass;
            this.kind = csmClass.getKind();
            this.classDisplayOffset = n;
            this.displayFQN = bl;
        }

        protected String getName() {
            return CsmKindUtilities.isTemplate((CsmObject)this.cls) ? ((Object)((CsmTemplate)this.cls).getDisplayName()).toString() : ((Object)this.cls.getName()).toString();
        }

        protected String getReplaceText() {
            String string = ((Object)this.cls.getName()).toString();
            if (this.classDisplayOffset > 0 && this.classDisplayOffset < string.length()) {
                string = string.substring(this.classDisplayOffset);
            }
            return string;
        }

        public String getItemText() {
            return this.displayFQN ? ((Object)this.cls.getQualifiedName()).toString() : this.getName();
        }

        protected CsmPaintComponent.StructPaintComponent createStructPaintComponent() {
            return new CsmPaintComponent.StructPaintComponent();
        }

        protected CsmPaintComponent.UnionPaintComponent createUnionPaintComponent() {
            return new CsmPaintComponent.UnionPaintComponent();
        }

        protected CsmPaintComponent.ClassPaintComponent createClassPaintComponent() {
            return new CsmPaintComponent.ClassPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (this.kind == CsmDeclaration.Kind.STRUCT) {
                if (structComponent == null) {
                    structComponent = this.createStructPaintComponent();
                }
                structComponent.setSelected(bl);
                structComponent.setFormatClassName(this.getName());
                return structComponent;
            }
            if (this.kind == CsmDeclaration.Kind.UNION) {
                if (unionComponent == null) {
                    unionComponent = this.createUnionPaintComponent();
                }
                unionComponent.setSelected(bl);
                unionComponent.setFormatClassName(this.getName());
                return unionComponent;
            }
            assert (this.kind == CsmDeclaration.Kind.CLASS) : "must be class kind";
            if (clsComponent == null) {
                clsComponent = this.createClassPaintComponent();
            }
            clsComponent.setSelected(bl);
            clsComponent.setFormatClassName(this.getName());
            return clsComponent;
        }
    }

    public static class EnumeratorResultItem
    extends CsmResultItem {
        private CsmEnumerator enmtr;
        private int enumDisplayOffset;
        private boolean displayFQN;
        private static CsmPaintComponent.EnumeratorPaintComponent enumtrComponent = null;

        public EnumeratorResultItem(CsmEnumerator csmEnumerator, boolean bl, int n) {
            this(csmEnumerator, 0, bl, n);
        }

        public EnumeratorResultItem(CsmEnumerator csmEnumerator, int n, boolean bl, int n2) {
            super((CsmObject)csmEnumerator, n2);
            this.enmtr = csmEnumerator;
            this.enumDisplayOffset = n;
            this.displayFQN = bl;
        }

        protected String getName() {
            return ((Object)this.enmtr.getName()).toString();
        }

        protected String getReplaceText() {
            String string = this.getItemText();
            if (this.enumDisplayOffset > 0 && this.enumDisplayOffset < string.length()) {
                string = string.substring(this.enumDisplayOffset);
            }
            return string;
        }

        public String getItemText() {
            return (this.displayFQN ? this.enmtr.getEnumeration().getQualifiedName() + "::" : "") + this.enmtr.getName();
        }

        protected CsmPaintComponent.EnumeratorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.EnumeratorPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (enumtrComponent == null) {
                enumtrComponent = this.createPaintComponent();
            }
            enumtrComponent.setSelected(bl);
            enumtrComponent.setFormatEnumeratorName(this.getName());
            return enumtrComponent;
        }
    }

    public static class EnumResultItem
    extends CsmResultItem {
        private CsmEnum enm;
        private int classDisplayOffset;
        private boolean displayFQN;
        private static CsmPaintComponent.EnumPaintComponent enumComponent = null;

        public EnumResultItem(CsmEnum csmEnum, boolean bl, int n) {
            this(csmEnum, 0, bl, n);
        }

        public EnumResultItem(CsmEnum csmEnum, int n, boolean bl, int n2) {
            super((CsmObject)csmEnum, n2);
            this.enm = csmEnum;
            this.classDisplayOffset = n;
            this.displayFQN = bl;
        }

        protected String getName() {
            return ((Object)this.enm.getName()).toString();
        }

        protected String getReplaceText() {
            String string = this.getItemText();
            if (this.classDisplayOffset > 0 && this.classDisplayOffset < string.length()) {
                string = string.substring(this.classDisplayOffset);
            }
            return string;
        }

        public String getItemText() {
            return this.displayFQN ? ((Object)this.enm.getQualifiedName()).toString() : ((Object)this.enm.getName()).toString();
        }

        protected CsmPaintComponent.EnumPaintComponent createPaintComponent() {
            return new CsmPaintComponent.EnumPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (enumComponent == null) {
                enumComponent = this.createPaintComponent();
            }
            enumComponent.setSelected(bl);
            enumComponent.setFormatEnumName(this.getName());
            return enumComponent;
        }
    }

    public static class NamespaceResultItem
    extends CsmResultItem {
        private boolean displayFullNamespacePath;
        private CsmNamespace pkg;
        private CharSequence pkgName;
        private static CsmPaintComponent.NamespacePaintComponent pkgComponent;

        public NamespaceResultItem(CsmNamespace csmNamespace, boolean bl, int n) {
            super((CsmObject)csmNamespace, n);
            this.pkg = csmNamespace;
            this.displayFullNamespacePath = bl;
            this.pkgName = csmNamespace.getName();
        }

        public String getItemText() {
            return this.displayFullNamespacePath ? ((Object)this.pkg.getQualifiedName()).toString() : ((Object)this.pkg.getName()).toString();
        }

        protected CsmPaintComponent.NamespacePaintComponent createPaintComponent() {
            return new CsmPaintComponent.NamespacePaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (pkgComponent == null) {
                pkgComponent = this.createPaintComponent();
            }
            pkgComponent.setSelected(bl);
            pkgComponent.setNamespaceName(((Object)this.pkgName).toString());
            pkgComponent.setDisplayFullNamespacePath(this.displayFullNamespacePath);
            return pkgComponent;
        }
    }

    public static class NamespaceAliasResultItem
    extends CsmResultItem {
        private CharSequence aliasName;
        private static CsmPaintComponent.NamespaceAliasPaintComponent aliasComponent;

        public NamespaceAliasResultItem(CsmNamespaceAlias csmNamespaceAlias, boolean bl, int n) {
            super((CsmObject)csmNamespaceAlias, n);
            this.aliasName = csmNamespaceAlias.getAlias();
        }

        public String getItemText() {
            return ((Object)this.aliasName).toString();
        }

        protected CsmPaintComponent.NamespaceAliasPaintComponent createPaintComponent() {
            return new CsmPaintComponent.NamespaceAliasPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (aliasComponent == null) {
                aliasComponent = this.createPaintComponent();
            }
            aliasComponent.setSelected(bl);
            aliasComponent.setAliasName(((Object)this.aliasName).toString());
            return aliasComponent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstructorResultItem
    extends CsmResultItem {
        private CsmFunction ctr;
        private CsmCompletionExpression substituteExp;
        private final boolean isDeclaration;
        private List<ParamStr> params = new ArrayList<ParamStr>();
        private List<?> excs = new ArrayList();
        private int modifiers;
        private static CsmPaintComponent.ConstructorPaintComponent ctrComponent = null;
        private int activeParameterIndex = -1;
        private int varArgIndex = -1;
        private final CharSequence mtdName;

        public ConstructorResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression, int n, boolean bl, boolean bl2) {
            super((CsmObject)csmFunction, n);
            this.ctr = csmFunction;
            this.substituteExp = csmCompletionExpression;
            this.isDeclaration = bl;
            this.modifiers = this.convertCsmModifiers((CsmObject)csmFunction);
            this.mtdName = CsmKindUtilities.isTemplate((CsmObject)csmFunction) ? ((CsmTemplate)csmFunction).getDisplayName() : csmFunction.getName();
            int n2 = 0;
            for (CsmParameter csmParameter : csmFunction.getParameters()) {
                if (csmParameter == null) continue;
                CsmType csmType = csmParameter.getType();
                if (csmType == null) {
                    assert (csmParameter.isVarArgs());
                    this.params.add(new ParamStr("", "", ((Object)csmParameter.getName()).toString(), true, KEYWORD_COLOR));
                    this.varArgIndex = n2;
                } else {
                    String string = ConstructorResultItem.getTypeName(csmType, bl2);
                    this.params.add(new ParamStr(string, string, ((Object)csmParameter.getName()).toString(), false, TYPE_COLOR));
                }
                ++n2;
            }
        }

        public CsmCompletionExpression getExpression() {
            return this.substituteExp;
        }

        int getActiveParameterIndex() {
            return this.activeParameterIndex;
        }

        void setActiveParameterIndex(int n) {
            this.activeParameterIndex = n;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public String getName() {
            return ((Object)this.mtdName).toString();
        }

        public List<ParamStr> getParams() {
            return this.params;
        }

        public List<?> getExceptions() {
            return this.excs;
        }

        public int getCurrentParamIndex() {
            int n = 0;
            if (this.substituteExp != null && this.substituteExp.getExpID() == 10) {
                n = this.substituteExp.getParameterCount() - 1;
            }
            if (this.varArgIndex > -1 && this.varArgIndex < n) {
                n = this.varArgIndex;
            }
            return n;
        }

        public List<String> createParamsList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator<ParamStr> iterator = this.getParams().iterator();
            while (iterator.hasNext()) {
                StringBuilder stringBuilder = new StringBuilder();
                ParamStr paramStr = iterator.next();
                stringBuilder.append(paramStr.getSimpleTypeName());
                if (paramStr.isVarArg()) {
                    stringBuilder.append("...");
                } else {
                    String string = paramStr.getName();
                    if (string != null && string.length() > 0) {
                        stringBuilder.append(" ");
                        stringBuilder.append(string);
                    }
                }
                if (iterator.hasNext()) {
                    stringBuilder.append(", ");
                }
                arrayList.add(stringBuilder.toString());
            }
            return arrayList;
        }

        @Override
        public boolean substituteText(final JTextComponent jTextComponent, final int n, final int n2, boolean bl) {
            final boolean[] blArray = new boolean[]{true};
            final AtomicBoolean atomicBoolean = new AtomicBoolean();
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            final ConstructorResultItem constructorResultItem = this;
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    int n6;
                    String string = null;
                    boolean bl = true;
                    int n22 = n2;
                    switch (ConstructorResultItem.this.substituteExp != null ? ConstructorResultItem.this.substituteExp.getExpID() : -1) {
                        case 11: {
                            break;
                        }
                        case 10: {
                            boolean bl2;
                            int n3;
                            int n4 = ConstructorResultItem.this.params.size();
                            if (n4 == 0) {
                                if (ConstructorResultItem.this.getActiveParameterIndex() != -1) break;
                                try {
                                    n6 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n22));
                                    if (n6 > -1 && baseDocument.getChars(n6, 1)[0] == ')') {
                                        string = baseDocument.getText(n + n22, n6 + 1 - n - n22);
                                        n22 = n6 + 1 - n;
                                    }
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                                if (string != null) break;
                                string = ")";
                                break;
                            }
                            n6 = ConstructorResultItem.this.getActiveParameterIndex();
                            if (n6 != -1) {
                                String string2;
                                n3 = 0;
                                if (n6 < n4 && (string2 = ((ParamStr)ConstructorResultItem.this.params.get(n6)).getName()) != null) {
                                    try {
                                        baseDocument.insertString(jTextComponent.getCaretPosition(), string2, null);
                                        n3 = 1;
                                    }
                                    catch (BadLocationException badLocationException) {
                                        // empty catch block
                                    }
                                }
                                blArray[0] = n3;
                            }
                            n3 = ConstructorResultItem.this.substituteExp.getParameterCount() - 1;
                            boolean bl3 = CodeStyle.getDefault((Document)baseDocument).spaceAfterComma();
                            try {
                                if (bl3 && (n3 == 0 || n > 0 && Character.isWhitespace(DocumentUtilities.getText((Document)baseDocument, (int)(n - 1), (int)1).charAt(0)))) {
                                    bl3 = false;
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                            boolean bl4 = bl2 = n4 > 0 ? ((ParamStr)ConstructorResultItem.this.params.get(n4 - 1)).isVarArg() : false;
                            if (n3 >= n4 && !bl2) break;
                            string = bl3 ? " " : "";
                            break;
                        }
                        default: {
                            int n5;
                            Object object;
                            string = ConstructorResultItem.this.getItemText();
                            n6 = CodeStyle.getDefault((Document)baseDocument).spaceBeforeMethodCallParen();
                            boolean bl5 = false;
                            String string3 = CsmCompletionUtils.getMimeType((Document)baseDocument);
                            if (string3 != null) {
                                object = (Preferences)MimeLookup.getLookup((String)string3).lookup(Preferences.class);
                                bl5 = ((Preferences)object).getBoolean("pair-characters-completion", false);
                            }
                            if (bl) {
                                boolean bl6 = bl = !ConstructorResultItem.this.isFunctionAsPointer(jTextComponent, string);
                            }
                            if (!bl) break;
                            object = null;
                            try {
                                n5 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n22));
                                if (n5 > -1 && n5 <= Utilities.getRowEnd((BaseDocument)baseDocument, (int)(n + n22)) && baseDocument.getChars(n5, 1)[0] == '(') {
                                    object = baseDocument.getText(n + n22, n5 + 1 - n - n22);
                                    if (n6 != 0 && ((String)object).length() < 2) {
                                        string = string + ' ';
                                    }
                                    n22 = n5 + 1 - n;
                                    string = string + (String)object;
                                    constructorResultItem.toAdd = null;
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                            if (object == null) {
                                if (n6 != 0) {
                                    string = string + ' ';
                                }
                                string = string + '(';
                                if (ConstructorResultItem.this.params.size() > 0) {
                                    ConstructorResultItem.this.selectionStartOffset = ConstructorResultItem.this.selectionEndOffset = string.length();
                                    atomicBoolean.set(true);
                                }
                                if (ConstructorResultItem.this.isDeclaration) {
                                    for (String string4 : ConstructorResultItem.this.createParamsList()) {
                                        string = string + string4;
                                    }
                                }
                                if (!ConstructorResultItem.this.isDeclaration && !bl5) break;
                                string = string + ")";
                                if (!ConstructorResultItem.this.isDeclaration || !CsmKindUtilities.isMethod((CsmObject)ConstructorResultItem.this.ctr) || !((CsmMethod)ConstructorResultItem.this.ctr).isConst()) break;
                                string = string + " const";
                                break;
                            }
                            try {
                                n5 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n22));
                                if (n5 <= -1 || baseDocument.getChars(n5, 1)[0] != ')') break;
                                object = baseDocument.getText(n + n22, n5 + 1 - n - n22);
                                n22 = n5 + 1 - n;
                                if (ConstructorResultItem.this.params.size() > 0) {
                                    ConstructorResultItem.this.selectionStartOffset = ConstructorResultItem.this.selectionEndOffset = string.length();
                                }
                                string = string + (String)object;
                                break;
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    }
                    if (string != null) {
                        if (constructorResultItem.toAdd != null && !constructorResultItem.toAdd.equals("\n") && !"(".equals(constructorResultItem.toAdd)) {
                            string = string + constructorResultItem.toAdd;
                        }
                        try {
                            CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n, (int)n22);
                            if (CharSequenceUtilities.textEquals((CharSequence)string, (CharSequence)charSequence)) {
                                jTextComponent.setCaretPosition(n + n22);
                                blArray[0] = false;
                            }
                            baseDocument.remove(n, n22);
                            baseDocument.insertString(n, string, null);
                            if (ConstructorResultItem.this.isDeclaration) {
                                jTextComponent.setCaretPosition(n + string.length());
                            } else if (ConstructorResultItem.this.selectionStartOffset >= 0) {
                                jTextComponent.select(n + ConstructorResultItem.this.selectionStartOffset, n + ConstructorResultItem.this.selectionEndOffset);
                            } else if ("(".equals(constructorResultItem.toAdd) && (n6 = string.lastIndexOf(41)) > -1) {
                                jTextComponent.setCaretPosition(n + n6);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        blArray[0] = true;
                    } else {
                        blArray[0] = false;
                    }
                }
            });
            if (atomicBoolean.get()) {
                Completion completion = Completion.get();
                completion.hideCompletion();
                completion.hideDocumentation();
                completion.showToolTip();
            }
            return blArray[0];
        }

        protected boolean isFunctionAsPointer(JTextComponent jTextComponent, String string) {
            return false;
        }

        @Override
        public String getItemText() {
            return ((Object)this.ctr.getName()).toString();
        }

        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.ConstructorPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean bl) {
            if (ctrComponent == null) {
                ctrComponent = this.createPaintComponent();
            }
            ctrComponent.setName(this.getItemText());
            ctrComponent.setModifiers(this.getModifiers());
            ctrComponent.setParams(this.getParams());
            ctrComponent.setExceptions(this.getExceptions());
            ctrComponent.setSelected(bl);
            return ctrComponent;
        }
    }

    public static class MethodResultItem
    extends ConstructorResultItem {
        private static CsmPaintComponent.MethodPaintComponent mtdComponent = null;
        private static CsmPaintComponent.MethodPaintComponent globFunComponent = null;
        private CharSequence typeName;
        private Color typeColor;

        public MethodResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression, int n, boolean bl, boolean bl2) {
            super(csmFunction, csmCompletionExpression, n, bl, bl2);
            this.typeName = CsmResultItem.getTypeName(csmFunction.getReturnType(), bl2);
            this.typeColor = CsmResultItem.getTypeColor(csmFunction.getReturnType());
        }

        public String getTypeName() {
            return ((Object)this.typeName).toString();
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public void setTypeColor(Color color) {
            this.typeColor = color;
        }

        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.MethodPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            CsmPaintComponent.MethodPaintComponent methodPaintComponent = null;
            assert (CsmKindUtilities.isCsmObject((Object)this.getAssociatedObject())) : "must be csm object";
            CsmObject csmObject = (CsmObject)this.getAssociatedObject();
            if (CsmKindUtilities.isMethod((CsmObject)csmObject)) {
                if (mtdComponent == null) {
                    mtdComponent = (CsmPaintComponent.MethodPaintComponent)this.createPaintComponent();
                }
                methodPaintComponent = mtdComponent;
            } else {
                assert (CsmKindUtilities.isGlobalFunction((CsmObject)csmObject)) : "support only global fun and class methods";
                if (globFunComponent == null) {
                    globFunComponent = (CsmPaintComponent.MethodPaintComponent)this.createPaintComponent();
                }
                methodPaintComponent = globFunComponent;
            }
            methodPaintComponent.setName(this.getName());
            methodPaintComponent.setModifiers(this.getModifiers());
            methodPaintComponent.setTypeName(this.getTypeName());
            methodPaintComponent.setTypeColor(this.getTypeColor());
            methodPaintComponent.setParams(this.getParams());
            methodPaintComponent.setExceptions(this.getExceptions());
            methodPaintComponent.setSelected(bl);
            return methodPaintComponent;
        }
    }

    public static class GlobalFunctionResultItem
    extends MethodResultItem {
        public GlobalFunctionResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression, int n, boolean bl, boolean bl2) {
            super(csmFunction, csmCompletionExpression, n, bl, bl2);
        }

        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.GlobalFunctionPaintComponent();
        }

        protected boolean isFunctionAsPointer(JTextComponent jTextComponent, String string) {
            return (string.startsWith("endl") || string.startsWith("ends") || string.startsWith("flush") || string.startsWith("getline") || string.startsWith("ws")) && this.isAfterShiftOperator(jTextComponent);
        }

        private boolean isAfterShiftOperator(JTextComponent jTextComponent) {
            TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((JTextComponent)jTextComponent, (int)0, (boolean)true, (boolean)false);
            tokenSequence.moveStart();
            if (!tokenSequence.moveNext()) {
                return false;
            }
            boolean bl = false;
            while (tokenSequence.offset() < this.substituteOffset) {
                CppTokenId cppTokenId = (CppTokenId)tokenSequence.token().id();
                block0 : switch (cppTokenId) {
                    case LTLT: 
                    case GTGT: {
                        bl = true;
                        break;
                    }
                    default: {
                        switch (cppTokenId) {
                            case BLOCK_COMMENT: 
                            case DOXYGEN_COMMENT: 
                            case NEW_LINE: 
                            case LINE_COMMENT: 
                            case DOXYGEN_LINE_COMMENT: 
                            case WHITESPACE: 
                            case IDENTIFIER: 
                            case SCOPE: {
                                break block0;
                            }
                        }
                        bl = false;
                    }
                }
                if (tokenSequence.moveNext()) continue;
                return false;
            }
            return bl;
        }
    }

    public static class FileLocalFunctionResultItem
    extends MethodResultItem {
        public FileLocalFunctionResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression, int n, boolean bl, boolean bl2) {
            super(csmFunction, csmCompletionExpression, n, bl, bl2);
        }

        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.FileLocalFunctionPaintComponent();
        }
    }

    public static abstract class VariableResultItem
    extends CsmResultItem {
        private CharSequence typeName;
        private Color typeColor;
        private CharSequence fldName;
        private int modifiers;
        private static CsmPaintComponent.FieldPaintComponent fieldComponent = null;
        private static CsmPaintComponent.FieldPaintComponent globVarComponent = null;
        private static CsmPaintComponent.FieldPaintComponent localVarComponent = null;
        private static CsmPaintComponent.FieldPaintComponent fileLocalVarComponent = null;

        public VariableResultItem(CsmVariable csmVariable, int n) {
            super((CsmObject)csmVariable, n);
            this.fldName = csmVariable.getName();
            this.modifiers = this.convertCsmModifiers((CsmObject)csmVariable);
            this.typeName = VariableResultItem.getTypeName(csmVariable.getType(), false);
            this.typeColor = VariableResultItem.getTypeColor(csmVariable.getType());
        }

        public String getItemText() {
            return ((Object)this.fldName).toString();
        }

        protected abstract CsmPaintComponent.FieldPaintComponent createPaintComponent();

        public Component getPaintComponent(boolean bl) {
            CsmPaintComponent.FieldPaintComponent fieldPaintComponent = null;
            assert (CsmKindUtilities.isCsmObject((Object)this.getAssociatedObject())) : "must be csm object";
            CsmObject csmObject = (CsmObject)this.getAssociatedObject();
            if (CsmKindUtilities.isField((CsmObject)csmObject)) {
                if (fieldComponent == null) {
                    fieldComponent = this.createPaintComponent();
                }
                fieldPaintComponent = fieldComponent;
            } else if (CsmKindUtilities.isGlobalVariable((CsmObject)csmObject)) {
                if (globVarComponent == null) {
                    globVarComponent = this.createPaintComponent();
                }
                fieldPaintComponent = globVarComponent;
            } else if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObject)) {
                if (fileLocalVarComponent == null) {
                    fileLocalVarComponent = this.createPaintComponent();
                }
                fieldPaintComponent = fileLocalVarComponent;
            } else {
                assert (CsmKindUtilities.isLocalVariable((CsmObject)csmObject)) : "support only global var, local var, file local var and class fields";
                if (localVarComponent == null) {
                    localVarComponent = this.createPaintComponent();
                }
                fieldPaintComponent = localVarComponent;
            }
            fieldPaintComponent.setTypeName(((Object)this.typeName).toString());
            fieldPaintComponent.setName(((Object)this.fldName).toString());
            fieldPaintComponent.setTypeColor(this.typeColor);
            fieldPaintComponent.setModifiers(this.modifiers);
            fieldPaintComponent.setSelected(bl);
            return fieldPaintComponent;
        }
    }

    public static class LabelResultItem
    extends CsmResultItem {
        private CharSequence parName;
        private static CsmPaintComponent.LabelPaintComponent parPaintComp = null;

        public LabelResultItem(CsmLabel csmLabel, int n) {
            super((CsmObject)csmLabel, n);
            this.parName = csmLabel.getLabel();
        }

        private String getName() {
            return ((Object)this.parName).toString();
        }

        public String getItemText() {
            return this.getName();
        }

        protected CsmPaintComponent.LabelPaintComponent createPaintComponent() {
            return new CsmPaintComponent.LabelPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (parPaintComp == null) {
                parPaintComp = this.createPaintComponent();
            }
            parPaintComp.setName(this.getName());
            parPaintComp.setSelected(bl);
            return parPaintComp;
        }
    }

    public static class TemplateParameterResultItem
    extends CsmResultItem {
        private CharSequence parName;
        private static CsmPaintComponent.TemplateParameterPaintComponent parPaintComp = null;

        public TemplateParameterResultItem(CsmTemplateParameter csmTemplateParameter, int n) {
            super((CsmObject)csmTemplateParameter, n);
            this.parName = csmTemplateParameter.getName();
        }

        private String getName() {
            return ((Object)this.parName).toString();
        }

        public String getItemText() {
            return this.getName();
        }

        protected CsmPaintComponent.TemplateParameterPaintComponent createPaintComponent() {
            return new CsmPaintComponent.TemplateParameterPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (parPaintComp == null) {
                parPaintComp = this.createPaintComponent();
            }
            parPaintComp.setName(this.getName());
            parPaintComp.setSelected(bl);
            return parPaintComp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MacroResultItem
    extends CsmResultItem {
        private CharSequence macName;
        private List<CharSequence> params;
        private static CsmPaintComponent.MacroPaintComponent macroPaintComp = null;

        public MacroResultItem(CsmMacro csmMacro, int n) {
            super((CsmObject)csmMacro, n);
            this.macName = csmMacro.getName();
            this.params = csmMacro.getParameters();
        }

        private String getName() {
            return ((Object)this.macName).toString();
        }

        private List<CharSequence> getParams() {
            return this.params;
        }

        @Override
        public String getItemText() {
            return this.getName();
        }

        protected CsmPaintComponent.MacroPaintComponent createPaintComponent() {
            return new CsmPaintComponent.MacroPaintComponent();
        }

        @Override
        public Component getPaintComponent(boolean bl) {
            if (macroPaintComp == null) {
                macroPaintComp = this.createPaintComponent();
            }
            macroPaintComp.setName(this.getName());
            macroPaintComp.setParams(this.getParams());
            macroPaintComp.setSelected(bl);
            return macroPaintComp;
        }
    }

    public static class FieldResultItem
    extends VariableResultItem {
        public FieldResultItem(CsmField csmField, int n) {
            super((CsmVariable)csmField, n);
        }

        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.FieldPaintComponent();
        }
    }

    public static class LocalVariableResultItem
    extends VariableResultItem {
        public LocalVariableResultItem(CsmVariable csmVariable, int n) {
            super(csmVariable, n);
        }

        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.LocalVariablePaintComponent();
        }
    }

    public static class GlobalVariableResultItem
    extends VariableResultItem {
        public GlobalVariableResultItem(CsmVariable csmVariable, int n) {
            super(csmVariable, n);
        }

        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.GlobalVariablePaintComponent();
        }
    }

    public static class FileLocalVariableResultItem
    extends VariableResultItem {
        public FileLocalVariableResultItem(CsmVariable csmVariable, int n) {
            super(csmVariable, n);
        }

        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.FileLocalVariablePaintComponent();
        }
    }
}

