/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.editor;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HibernateEditorUtil {
    public static JavaSource getJavaSource(Document document) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        int n = 0;
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        SourceGroup[] sourceGroupArray2 = sourceGroupArray;
        int n2 = sourceGroupArray2.length;
        if (n < n2) {
            SourceGroup sourceGroup = sourceGroupArray2[n];
            return JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)sourceGroup.getRootFolder()), (FileObject[])new FileObject[0]);
        }
        return null;
    }

    public static Node getClassNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeName().equalsIgnoreCase("class") || node.getNodeName().equalsIgnoreCase("subclass") || node.getNodeName().equalsIgnoreCase("joined-subclass") || node.getNodeName().equalsIgnoreCase("union-subclass")) {
            return node;
        }
        Node node2 = node;
        Node node3;
        while ((node3 = node2.getParentNode()) != null) {
            if (node3.getNodeName().equalsIgnoreCase("class") || node3.getNodeName().equalsIgnoreCase("subclass") || node3.getNodeName().equalsIgnoreCase("joined-subclass") || node3.getNodeName().equalsIgnoreCase("union-subclass")) {
                return node3;
            }
            if (node3.getNodeName().equalsIgnoreCase("hibernate-mapping")) {
                return null;
            }
            node2 = node3;
        }
        return null;
    }

    public static String getClassName(Node node) {
        NamedNodeMap namedNodeMap;
        Node node2 = HibernateEditorUtil.getClassNode(node);
        if (node2 != null && (namedNodeMap = node2.getAttributes()) != null && namedNodeMap.getNamedItem("name") != null) {
            return namedNodeMap.getNamedItem("name").getNodeValue();
        }
        return null;
    }

    public static String getTableName(Node node) {
        NamedNodeMap namedNodeMap;
        Node node2 = HibernateEditorUtil.getClassNode(node);
        if (node2 != null && (namedNodeMap = node2.getAttributes()) != null && namedNodeMap.getNamedItem("table") != null) {
            return namedNodeMap.getNamedItem("table").getNodeValue();
        }
        return null;
    }

    public static String getHbPropertyName(Node node) {
        if (!node.getNodeName().equalsIgnoreCase("property")) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && namedNodeMap.getNamedItem("name") != null) {
            return namedNodeMap.getNamedItem("name").getNodeValue();
        }
        return null;
    }

    public static TypeElement findClassElementByBinaryName(String string, CompilationController compilationController) {
        PackageElement packageElement;
        if (!string.contains("$")) {
            return compilationController.getElements().getTypeElement(string);
        }
        String string2 = "";
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        if ((packageElement = compilationController.getElements().getPackageElement(string2)) == null) {
            return null;
        }
        return (TypeElement)new BinaryNameTypeScanner().visit(packageElement, string);
    }

    public static void findAndOpenJavaClass(final String string, Document document) {
        final JavaSource javaSource = HibernateEditorUtil.getJavaSource(document);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        boolean bl = false;
                        TypeElement typeElement = HibernateEditorUtil.findClassElementByBinaryName(string, compilationController);
                        if (typeElement != null) {
                            bl = ElementOpen.open((ClasspathInfo)javaSource.getClasspathInfo(), (Element)typeElement);
                        }
                        if (!bl) {
                            String string2 = NbBundle.getMessage(HibernateEditorUtil.class, (String)"LBL_SourceNotFound", (Object)string);
                            StatusDisplayer.getDefault().setStatusText(string2);
                        }
                    }
                }, false);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    public static VariableElement findFieldElementOnType(ElementUtilities elementUtilities, TypeMirror typeMirror, String string) {
        FieldAcceptor fieldAcceptor = new FieldAcceptor(string);
        Iterable iterable = elementUtilities.getMembers(typeMirror, (ElementUtilities.ElementAcceptor)fieldAcceptor);
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return (VariableElement)iterator.next();
    }

    private static class FieldAcceptor
    implements ElementUtilities.ElementAcceptor {
        private String fieldName;

        public FieldAcceptor(String string) {
            this.fieldName = string;
        }

        public boolean accept(Element element, TypeMirror typeMirror) {
            if (element.getKind() != ElementKind.FIELD) {
                return false;
            }
            return element.getSimpleName().toString().equals(this.fieldName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryNameTypeScanner
    extends SimpleElementVisitor6<TypeElement, String> {
        private BinaryNameTypeScanner() {
        }

        @Override
        public TypeElement visitPackage(PackageElement packageElement, String string) {
            for (Element element : packageElement.getEnclosedElements()) {
                TypeElement typeElement;
                if (!element.getKind().isClass() || (typeElement = element.accept(this, string)) == null) continue;
                return typeElement;
            }
            return null;
        }
    }
}

