/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.uihandler.Installer;
import org.openide.awt.Mnemonics;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ButtonsParser {
    private final InputStream is;
    private String title;
    private List<Object> options;
    private List<Object> additionalOptions;
    private boolean containsExitButton = false;
    private List<Node> nodes;
    private String url;

    public ButtonsParser(InputStream inputStream) {
        this.is = inputStream;
    }

    void parse() throws IOException, ParserConfigurationException, SAXException, InterruptedException, InvocationTargetException {
        Object object;
        Object object2;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        PushbackInputStream pushbackInputStream = new PushbackInputStream(this.is, 255);
        byte[] byArray = new byte[5];
        int n = pushbackInputStream.read(byArray);
        pushbackInputStream.unread(byArray, 0, n);
        if (n < 5 || byArray[0] != 60 || byArray[1] != 63 || byArray[2] != 120 || byArray[3] != 109 || byArray[4] != 108) {
            object2 = "<?xml version='1.0' encoding='utf-8'?>";
            pushbackInputStream.unread(((String)object2).getBytes("utf-8"));
        }
        this.nodes = new ArrayList<Node>();
        documentBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                if (string2.equals("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd")) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                    return new InputSource(byteArrayInputStream);
                }
                return null;
            }
        });
        object2 = documentBuilder.parse(pushbackInputStream);
        NodeList nodeList = object2.getElementsByTagName("form");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getAttributes().getNamedItem("action").getNodeValue();
            if (string == null || "".equals(string)) {
                throw new IllegalStateException("Action should not be empty");
            }
            this.url = string;
            object = object2.getElementsByTagName("input");
            for (int j = 0; j < object.getLength(); ++j) {
                Node node;
                String string2;
                if (!ButtonsParser.isChild(object.item(j), nodeList.item(i)) || !"hidden".equals(string2 = ButtonsParser.attrValue(node = object.item(j), "type"))) continue;
                this.nodes.add(node);
            }
        }
        NodeList nodeList2 = object2.getElementsByTagName("title");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object = nodeList2.item(i).getTextContent();
            if (object == null) continue;
            this.title = object;
            break;
        }
    }

    public void createButtons() {
        this.options = new ArrayList<Object>();
        this.additionalOptions = new ArrayList<Object>();
        for (Node node : this.nodes) {
            Object object;
            List<Object> list;
            String string = ButtonsParser.attrValue(node, "name");
            String string2 = ButtonsParser.attrValue(node, "value");
            String string3 = ButtonsParser.attrValue(node, "align");
            String string4 = ButtonsParser.attrValue(node, "alt");
            boolean bl = true;
            if ("true".equals(ButtonsParser.attrValue(node, "disabled"))) {
                bl = false;
            } else if ("disabled".equals(ButtonsParser.attrValue(node, "disabled"))) {
                bl = false;
            }
            List<Object> list2 = list = "left".equals(string3) ? this.additionalOptions : this.options;
            if (Installer.Button.isSubmitTrigger(string)) {
                object = string2;
                JButton jButton = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)jButton, (String)object);
                jButton.setActionCommand(string);
                jButton.putClientProperty("url", this.url);
                jButton.setDefaultCapable(list.isEmpty() && list == this.options);
                jButton.putClientProperty("alt", string4);
                jButton.putClientProperty("now", object);
                jButton.setEnabled(bl);
                list.add(jButton);
                continue;
            }
            object = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)object, (String)string2);
            ((AbstractButton)object).setActionCommand(string);
            ((JButton)object).setDefaultCapable(list.isEmpty() && list == this.options);
            ((JComponent)object).putClientProperty("alt", string4);
            ((JComponent)object).putClientProperty("now", string2);
            ((AbstractButton)object).setEnabled(bl && Installer.Button.isKnown(string));
            list.add(object);
            if (Installer.Button.EXIT.isCommand(string)) {
                this.containsExitButton = true;
            }
            if (!Installer.Button.REDIRECT.isCommand(string)) continue;
            ((JComponent)object).putClientProperty("url", this.url);
        }
    }

    List<Object> getOptions() {
        return this.options;
    }

    List<Object> getAditionalOptions() {
        return this.additionalOptions;
    }

    String getTitle() {
        return this.title;
    }

    boolean containsExitButton() {
        return this.containsExitButton;
    }

    private static String attrValue(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        return node2 == null ? null : node2.getNodeValue();
    }

    private static boolean isChild(Node node, Node node2) {
        while (node != null) {
            if (node == node2) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }
}

