/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.elements.AstMethodElement;
import org.netbeans.modules.groovy.editor.api.elements.ElementHandleSupport;
import org.netbeans.modules.groovy.editor.api.elements.GroovyElement;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstElement
extends GroovyElement {
    protected final ASTNode node;
    protected final GroovyParserResult info;
    protected List<AstElement> children;
    protected String name;
    protected Set<Modifier> modifiers;
    protected String in;
    protected String signature;

    public AstElement(GroovyParserResult groovyParserResult, ASTNode aSTNode) {
        this.info = groovyParserResult;
        this.node = aSTNode;
    }

    public List<AstElement> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public void addChild(AstElement astElement) {
        if (this.children == null) {
            this.children = new ArrayList<AstElement>();
        }
        this.children.add(astElement);
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getIn();
            if (string != null && string.length() > 0) {
                stringBuilder.append(string);
                stringBuilder.append(".");
            }
            stringBuilder.append(this.getName());
            this.signature = stringBuilder.toString();
        }
        return this.signature;
    }

    @Override
    public abstract String getName();

    public ASTNode getNode() {
        return this.node;
    }

    @Override
    public String getIn() {
        return this.in;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.OTHER;
    }

    @Override
    public Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            int n = -1;
            if (this.node instanceof FieldNode) {
                n = ((FieldNode)this.node).getModifiers();
            } else if (this.node instanceof MethodNode) {
                n = ((MethodNode)this.node).getModifiers();
            }
            if (n != -1) {
                EnumSet<Modifier> enumSet = EnumSet.noneOf(Modifier.class);
                if ((n & 1) != 0) {
                    enumSet.add(Modifier.PUBLIC);
                }
                if ((n & 4) != 0) {
                    enumSet.add(Modifier.PROTECTED);
                }
                if ((n & 2) != 0) {
                    enumSet.add(Modifier.PRIVATE);
                }
                if ((n & 8) != 0) {
                    enumSet.add(Modifier.STATIC);
                }
                this.modifiers = enumSet;
            } else {
                this.modifiers = Collections.emptySet();
            }
        }
        return this.modifiers;
    }

    public void setIn(String string) {
        this.in = string;
    }

    @Override
    public boolean signatureEquals(ElementHandle elementHandle) {
        if (elementHandle instanceof AstElement) {
            return this.equals(elementHandle);
        }
        return false;
    }

    @Override
    public FileObject getFileObject() {
        return null;
    }

    public GroovyParserResult getParseResult() {
        return this.info;
    }

    @Override
    public String getMimeType() {
        return "text/x-groovy";
    }

    public static AstElement create(GroovyParserResult groovyParserResult, ASTNode aSTNode) {
        if (aSTNode instanceof MethodNode) {
            return new AstMethodElement(groovyParserResult, aSTNode);
        }
        return null;
    }

    public String toString() {
        return this.getKind() + "<" + this.getName() + ">";
    }

    @Override
    public OffsetRange getOffsetRange(ParserResult parserResult) {
        BaseDocument baseDocument;
        GroovyParserResult groovyParserResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        GroovyElement groovyElement = ElementHandleSupport.resolveHandle(groovyParserResult, ElementHandleSupport.createHandle(parserResult, this));
        if (groovyElement instanceof AstElement) {
            BaseDocument baseDocument2 = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(false);
            if (baseDocument2 != null) {
                AstElement astElement = (AstElement)groovyElement;
                OffsetRange offsetRange = AstUtilities.getRange(astElement.getNode(), baseDocument2);
                return LexUtilities.getLexerOffsets(groovyParserResult, offsetRange);
            }
            return OffsetRange.NONE;
        }
        if (groovyElement != null) {
            Logger logger = Logger.getLogger(AstElement.class.getName());
            logger.log(Level.WARNING, "Foreign element: " + groovyElement + " of type " + (groovyElement != null ? groovyElement.getClass().getName() : "null"));
        } else if (this.getNode() != null && (baseDocument = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(false)) != null) {
            OffsetRange offsetRange = AstUtilities.getRange(this.getNode(), baseDocument);
            if (offsetRange != OffsetRange.NONE) {
                GroovyParserResult groovyParserResult2 = this.info;
                if (groovyParserResult2 == null) {
                    groovyParserResult2 = groovyParserResult;
                }
                return LexUtilities.getLexerOffsets(groovyParserResult2, offsetRange);
            }
            return OffsetRange.NONE;
        }
        return OffsetRange.NONE;
    }
}

