/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceFlags;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.event.EventSupport;
import org.netbeans.modules.parsing.impl.indexing.BinaryPathNotifier;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.ClusteredIndexables;
import org.netbeans.modules.parsing.impl.indexing.Crawler;
import org.netbeans.modules.parsing.impl.indexing.DeletedIndexable;
import org.netbeans.modules.parsing.impl.indexing.EventKind;
import org.netbeans.modules.parsing.impl.indexing.FileEventLog;
import org.netbeans.modules.parsing.impl.indexing.FileObjectCrawler;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.FileObjectProvider;
import org.netbeans.modules.parsing.impl.indexing.IndexImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexerCache;
import org.netbeans.modules.parsing.impl.indexing.Pair;
import org.netbeans.modules.parsing.impl.indexing.PathRecognizerRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryEvent;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryListener;
import org.netbeans.modules.parsing.impl.indexing.ProxyIterable;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.TimeStamps;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingActivityInterceptor;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.SourceIndexerFactory;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryUpdater
implements PathRegistryListener,
FileChangeListener,
PropertyChangeListener,
DocumentListener,
AtomicLockListener {
    final FileEventLog eventQueue = new FileEventLog();
    private static RepositoryUpdater instance;
    private static final Logger LOGGER;
    private static final Logger TEST_LOGGER;
    private static final Logger SFEC_LOGGER;
    private static final boolean PERF_TEST;
    private static final boolean notInterruptible;
    private static final int FILE_LOCKS_DELAY;
    private static final String PROP_LAST_INDEXED_VERSION;
    private static final String PROP_LAST_DIRTY_VERSION;
    private static final String PROP_MODIFIED_UNDER_WRITE_LOCK;
    private static final String PROP_OWNING_SOURCE_ROOT_URL;
    private static final String PROP_OWNING_SOURCE_ROOT;
    static final List<URL> EMPTY_DEPS;
    private final Map<URL, List<URL>> scannedRoots2Dependencies = Collections.synchronizedMap(new TreeMap(new LexicographicComparator(true)));
    private final Map<URL, List<URL>> scannedBinaries2InvDependencies = Collections.synchronizedMap(new HashMap());
    private final Set<URL> scannedUnknown = Collections.synchronizedSet(new HashSet());
    private final Set<URL> sourcesForBinaryRoots = Collections.synchronizedSet(new HashSet());
    private volatile State state = State.CREATED;
    private volatile Task worker;
    private volatile Reference<Document> activeDocumentRef = null;
    private volatile Reference<JTextComponent> activeComponentRef = null;
    private Lookup.Result<? extends IndexingActivityInterceptor> indexingActivityInterceptors = null;
    private IndexingController controller;
    private final String lastOwningSourceRootCacheLock = new String("lastOwningSourceRootCacheLock");
    private boolean ignoreIndexerCacheEvents = false;
    private final FileChangeListener binaryRootsListener = new FileChangeAdapter(){

        public void fileDataCreated(FileEvent fileEvent) {
            RepositoryUpdater.this.fileChangedImpl(fileEvent, false);
        }

        public void fileChanged(FileEvent fileEvent) {
            RepositoryUpdater.this.fileChangedImpl(fileEvent, false);
        }

        public void fileDeleted(FileEvent fileEvent) {
            RepositoryUpdater.this.fileDeletedImpl(fileEvent, false);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            RepositoryUpdater.this.fileRenamedImpl(fileRenameEvent, false);
        }
    };
    private static final Map<List<StackTraceElement>, Long> lastRecordedStackTraces;
    private static long stackTraceId;
    private static final Comparator<URL> C;

    public static synchronized RepositoryUpdater getDefault() {
        if (instance == null) {
            instance = new RepositoryUpdater();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean bl) {
        InitialRootsWork initialRootsWork = null;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state == State.CREATED) {
                this.state = State.STARTED;
                LOGGER.fine("Initializing...");
                this.indexingActivityInterceptors = Lookup.getDefault().lookupResult(IndexingActivityInterceptor.class);
                PathRegistry.getDefault().addPathRegistryListener(this);
                BinaryPathNotifier.getDefault().addFileChangeListener(this.binaryRootsListener);
                FileUtil.addFileChangeListener((FileChangeListener)this);
                EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
                IndexerCache.getCifCache().addPropertyChangeListener(this);
                IndexerCache.getEifCache().addPropertyChangeListener(this);
                if (bl) {
                    initialRootsWork = new InitialRootsWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, false);
                }
            }
        }
        if (initialRootsWork != null) {
            this.scheduleWork(initialRootsWork, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean bl = false;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state != State.STOPPED) {
                this.state = State.STOPPED;
                LOGGER.fine("Closing...");
                PathRegistry.getDefault().removePathRegistryListener(this);
                BinaryPathNotifier.getDefault().removeFileChangeListener(this.binaryRootsListener);
                FileUtil.removeFileChangeListener((FileChangeListener)this);
                EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
                bl = true;
            }
        }
        if (bl) {
            this.getWorker().cancelAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScanInProgress() {
        boolean bl;
        boolean bl2;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            bl2 = this.state == State.CREATED || this.state == State.STARTED;
        }
        try {
            Future future = OpenProjects.getDefault().openProjects();
            bl = !future.isDone() || ((Project[])future.get()).length > 0;
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl2 && bl || this.getWorker().isWorking() || !PathRegistry.getDefault().isFinished();
    }

    public boolean waitUntilFinished(long l) throws InterruptedException {
        long l2;
        long l3 = l2 = System.currentTimeMillis();
        do {
            boolean bl = !this.getWorker().waitUntilFinished(l);
            l3 = System.currentTimeMillis();
            if (!bl) continue;
            return false;
        } while (this.isScanInProgress() && (l <= 0L || l3 - l2 < l));
        return l <= 0L || l3 - l2 < l;
    }

    public void addIndexingJob(URL uRL, Collection<? extends URL> collection, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        FileObject fileObject;
        assert (uRL != null);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("addIndexingJob: rootUrl=" + uRL + ", fileUrls=" + collection + ", followUpJob=" + bl + ", checkEditor=" + bl2 + ", wait=" + bl3);
        }
        if ((fileObject = URLMapper.findFileObject((URL)uRL)) == null) {
            LOGGER.info(uRL + " can't be translated to FileObject");
            return;
        }
        FileListWork fileListWork = null;
        if (collection != null && collection.size() > 0) {
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            for (URL uRL2 : collection) {
                FileObject fileObject2 = URLMapper.findFileObject((URL)uRL2);
                if (fileObject2 == null) continue;
                if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
                    hashSet.add(fileObject2);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.warning(fileObject2 + " does not lie under " + fileObject + ", not indexing it");
            }
            if (hashSet.size() > 0) {
                fileListWork = new FileListWork(this.scannedRoots2Dependencies, uRL, hashSet, bl, bl2, bl4, this.sourcesForBinaryRoots.contains(uRL), bl5);
            }
        } else {
            fileListWork = new FileListWork(this.scannedRoots2Dependencies, uRL, bl, bl2, bl4, this.sourcesForBinaryRoots.contains(uRL));
        }
        if (fileListWork != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Scheduling index refreshing: root=" + uRL + ", files=" + collection);
            }
            this.scheduleWork(fileListWork, bl3);
        }
    }

    public void addIndexingJob(String string) {
        Collection<IndexerCache.IndexerInfo<CustomIndexerFactory>> collection;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("addIndexingJob: indexerName=" + string);
        }
        if ((collection = IndexerCache.getCifCache().getIndexersByName(string)) == null) {
            throw new InvalidParameterException("No CustomIndexerFactory with name: '" + string + "'");
        }
        RefreshCifIndices refreshCifIndices = new RefreshCifIndices(collection, this.scannedRoots2Dependencies, this.sourcesForBinaryRoots);
        this.scheduleWork(refreshCifIndices, false);
    }

    public void refreshAll(boolean bl, boolean bl2, boolean bl3, Object ... objectArray) {
        FSRefreshInterceptor fSRefreshInterceptor = null;
        for (IndexingActivityInterceptor indexingActivityInterceptor : this.indexingActivityInterceptors.allInstances()) {
            if (!(indexingActivityInterceptor instanceof FSRefreshInterceptor)) continue;
            fSRefreshInterceptor = (FSRefreshInterceptor)indexingActivityInterceptor;
            break;
        }
        this.scheduleWork(new RefreshWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, bl, bl3, objectArray == null ? Collections.emptySet() : Arrays.asList(objectArray), fSRefreshInterceptor), bl2);
    }

    public synchronized IndexingController getController() {
        if (this.controller == null) {
            this.controller = new Controller();
        }
        return this.controller;
    }

    @Override
    public void pathsChanged(PathRegistryEvent pathRegistryEvent) {
        assert (pathRegistryEvent != null);
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Paths changed:\n");
            for (PathRegistryEvent.Change object : pathRegistryEvent.getChanges()) {
                stringBuilder.append(" event=").append((Object)object.getEventKind());
                stringBuilder.append(" pathKind=").append((Object)object.getPathKind());
                stringBuilder.append(" pathType=").append(object.getPathType());
                stringBuilder.append(" affected paths:\n");
                Set<? extends ClassPath> set = object.getAffectedPaths();
                if (set != null) {
                    for (ClassPath classPath : set) {
                        stringBuilder.append("  \"");
                        stringBuilder.append(classPath.toString(ClassPath.PathConversionMode.PRINT));
                        stringBuilder.append("\"\n");
                    }
                }
                stringBuilder.append("--\n");
            }
            stringBuilder.append("====\n");
            LOGGER.fine(stringBuilder.toString());
        }
        boolean bl = false;
        boolean bl2 = false;
        for (PathRegistryEvent.Change change : pathRegistryEvent.getChanges()) {
            bl2 = true;
            if (change.getEventKind() != EventKind.PATHS_CHANGED && change.getEventKind() != EventKind.INCLUDES_CHANGED) continue;
            bl = true;
            break;
        }
        if (bl2) {
            this.scheduleWork(new RootsWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, !bl), false);
        }
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        if (this.isCacheFile(fileObject)) {
            return;
        }
        if (!this.authorize(fileEvent)) {
            return;
        }
        boolean bl = false;
        Pair<URL, FileObject> pair = null;
        if (fileObject != null && fileObject.isValid() && VisibilityQuery.getDefault().isVisible(fileObject)) {
            pair = this.getOwningSourceRoot(fileObject);
            if (pair != null) {
                ClassPath.Entry entry;
                boolean bl2 = this.sourcesForBinaryRoots.contains(pair.first);
                ClassPath.Entry entry2 = entry = bl2 ? null : RepositoryUpdater.getClassPathEntry((FileObject)pair.second);
                if (entry == null || entry.includes(fileObject)) {
                    FileListWork fileListWork = new FileListWork(this.scannedRoots2Dependencies, (URL)pair.first, Collections.singleton(fileObject), false, false, true, bl2, true);
                    this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)pair.first, FileUtil.getRelativePath((FileObject)((FileObject)pair.second), (FileObject)fileObject), fileEvent, fileListWork);
                    bl = true;
                }
            } else {
                pair = this.getOwningBinaryRoot(fileObject);
                if (pair != null) {
                    BinaryWork binaryWork = new BinaryWork((URL)pair.first);
                    this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)pair.first, null, fileEvent, binaryWork);
                    bl = true;
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Folder created (" + (bl ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + pair);
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.fileChanged(fileEvent);
    }

    public void fileChanged(FileEvent fileEvent) {
        this.fileChangedImpl(fileEvent, true);
    }

    private void fileChangedImpl(FileEvent fileEvent, boolean bl) {
        FileObject fileObject = fileEvent.getFile();
        if (this.isCacheFile(fileObject)) {
            return;
        }
        if (!this.authorize(fileEvent)) {
            return;
        }
        boolean bl2 = false;
        Pair<URL, FileObject> pair = null;
        if (fileObject != null && fileObject.isValid() && VisibilityQuery.getDefault().isVisible(fileObject)) {
            if (bl) {
                pair = this.getOwningSourceRoot(fileObject);
                if (pair != null) {
                    ClassPath.Entry entry;
                    boolean bl3 = this.sourcesForBinaryRoots.contains(pair.first);
                    ClassPath.Entry entry2 = entry = bl3 ? null : RepositoryUpdater.getClassPathEntry((FileObject)pair.second);
                    if (entry == null || entry.includes(fileObject)) {
                        FileListWork fileListWork = new FileListWork(this.scannedRoots2Dependencies, (URL)pair.first, Collections.singleton(fileObject), false, false, true, bl3, true);
                        this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)pair.first, FileUtil.getRelativePath((FileObject)((FileObject)pair.second), (FileObject)fileObject), fileEvent, fileListWork);
                        bl2 = true;
                    }
                }
            } else {
                pair = this.getOwningBinaryRoot(fileObject);
                if (pair != null) {
                    BinaryWork binaryWork = new BinaryWork((URL)pair.first);
                    this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)pair.first, null, fileEvent, binaryWork);
                    bl2 = true;
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("File modified (" + (bl2 ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + pair);
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.fileDeletedImpl(fileEvent, true);
    }

    private void fileDeletedImpl(FileEvent fileEvent, boolean bl) {
        FileObject fileObject = fileEvent.getFile();
        if (this.isCacheFile(fileObject)) {
            return;
        }
        if (!this.authorize(fileEvent)) {
            return;
        }
        boolean bl2 = false;
        Pair<URL, FileObject> pair = null;
        if (fileObject != null && VisibilityQuery.getDefault().isVisible(fileObject)) {
            if (bl) {
                pair = this.getOwningSourceRoot(fileObject);
                if (pair != null && fileObject.isData()) {
                    String string = FileUtil.getRelativePath((FileObject)((FileObject)pair.second), (FileObject)fileObject);
                    assert (string != null) : "FileObject not under root: f=" + fileObject + ", root=" + pair;
                    DeleteWork deleteWork = new DeleteWork((URL)pair.first, Collections.singleton(string));
                    this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)pair.first, string, fileEvent, deleteWork);
                    bl2 = true;
                }
            } else {
                pair = this.getOwningBinaryRoot(fileObject);
                if (pair != null) {
                    BinaryWork binaryWork = new BinaryWork((URL)pair.first);
                    this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)pair.first, null, fileEvent, binaryWork);
                    bl2 = true;
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("File deleted (" + (bl2 ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + pair);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.fileRenamedImpl(fileRenameEvent, true);
    }

    public void fileRenamedImpl(FileRenameEvent fileRenameEvent, boolean bl) {
        FileObject fileObject = fileRenameEvent.getFile();
        if (this.isCacheFile(fileObject)) {
            return;
        }
        if (!this.authorize((FileEvent)fileRenameEvent)) {
            return;
        }
        FileObject fileObject2 = fileRenameEvent.getFile();
        String string = fileRenameEvent.getExt().length() == 0 ? fileRenameEvent.getName() : fileRenameEvent.getName() + "." + fileRenameEvent.getExt();
        Pair<URL, FileObject> pair = null;
        boolean bl2 = false;
        if (fileObject2 != null && fileObject2.isValid()) {
            if (bl) {
                pair = this.getOwningSourceRoot(fileObject2);
                if (pair != null) {
                    Object object;
                    ClassPath.Entry entry;
                    Object object2;
                    String string2;
                    FileObject fileObject3 = (FileObject)pair.second;
                    String string3 = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject2.getParent());
                    String string4 = string2 = string3.length() == 0 ? string : string3 + "/" + string;
                    if (fileObject2.isData()) {
                        object2 = new DeleteWork((URL)pair.first, Collections.singleton(string2));
                        this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)pair.first, string2, (FileEvent)fileRenameEvent, (Work)object2);
                    } else {
                        object2 = new HashSet<String>();
                        RepositoryUpdater.collectFilePaths(fileObject2, string2, object2);
                        entry = object2.iterator();
                        while (entry.hasNext()) {
                            object = (String)entry.next();
                            DeleteWork deleteWork = new DeleteWork((URL)pair.first, (Set<String>)object2);
                            this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)pair.first, (String)object, (FileEvent)fileRenameEvent, deleteWork);
                        }
                    }
                    if (VisibilityQuery.getDefault().isVisible(fileObject2) && fileObject2.isData()) {
                        boolean bl3 = this.sourcesForBinaryRoots.contains(pair.first);
                        ClassPath.Entry entry2 = entry = bl3 ? null : RepositoryUpdater.getClassPathEntry(fileObject3);
                        if (entry == null || entry.includes(fileObject2)) {
                            object = new FileListWork(this.scannedRoots2Dependencies, (URL)pair.first, Collections.singleton(fileObject2), false, false, true, bl3, true);
                            this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)pair.first, FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject2), (FileEvent)fileRenameEvent, (Work)object);
                        }
                    }
                    bl2 = true;
                }
            } else {
                pair = this.getOwningBinaryRoot(fileObject2);
                if (pair != null) {
                    File file = FileUtil.toFile((FileObject)fileObject2.getParent());
                    if (file != null) {
                        try {
                            URL uRL = new File(file, string).toURI().toURL();
                            this.eventQueue.record(FileEventLog.FileOp.DELETE, uRL, null, (FileEvent)fileRenameEvent, new BinaryWork(uRL));
                        }
                        catch (MalformedURLException malformedURLException) {
                            LOGGER.log(Level.WARNING, null, malformedURLException);
                        }
                    }
                    this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)pair.first, null, (FileEvent)fileRenameEvent, new BinaryWork((URL)pair.first));
                    bl2 = true;
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("File renamed (" + (bl2 ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)fileObject2) + " Owner: " + pair + " Original Name: " + string);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Serializable serializable;
        if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals(CustomIndexerFactory.class.getName())) {
            if (!this.ignoreIndexerCacheEvents) {
                Set set = (Set)propertyChangeEvent.getNewValue();
                this.scheduleWork(new RefreshCifIndices(set, this.scannedRoots2Dependencies, this.sourcesForBinaryRoots), false);
            }
            return;
        }
        if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals(EmbeddingIndexerFactory.class.getName())) {
            if (!this.ignoreIndexerCacheEvents) {
                Set set = (Set)propertyChangeEvent.getNewValue();
                this.scheduleWork(new RefreshEifIndices(set, this.scannedRoots2Dependencies, this.sourcesForBinaryRoots), false);
            }
            return;
        }
        assert (SwingUtilities.isEventDispatchThread()) : "Changes in focused editor component should be delivered on AWT";
        List<Object> list = Collections.emptyList();
        if (propertyChangeEvent.getPropertyName() == null) {
            list = EditorRegistry.componentList();
        } else if (propertyChangeEvent.getPropertyName().equals("focusLost") || propertyChangeEvent.getPropertyName().equals("lastFocusedRemoved")) {
            if (propertyChangeEvent.getOldValue() instanceof JTextComponent) {
                serializable = (JTextComponent)propertyChangeEvent.getOldValue();
                this.handleActiveDocumentChange(((JTextComponent)serializable).getDocument(), null);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("componentRemoved")) {
            if (propertyChangeEvent.getOldValue() instanceof JTextComponent) {
                serializable = (JTextComponent)propertyChangeEvent.getOldValue();
                list = Collections.singletonList(serializable);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("focusGained")) {
            if (propertyChangeEvent.getNewValue() instanceof JTextComponent) {
                Iterator<Object> iterator;
                serializable = (JTextComponent)propertyChangeEvent.getNewValue();
                this.handleActiveDocumentChange(null, ((JTextComponent)serializable).getDocument());
                Iterator<Object> iterator2 = iterator = this.activeComponentRef == null ? null : this.activeComponentRef.get();
                if (iterator != serializable) {
                    if (iterator != null) {
                        list = Collections.singletonList(iterator);
                    }
                    this.activeComponentRef = new WeakReference<Serializable>(serializable);
                }
            }
        } else if (propertyChangeEvent.getPropertyName().equals("focusedDocument")) {
            serializable = EditorRegistry.focusedComponent();
            if (serializable == null) {
                serializable = EditorRegistry.lastFocusedComponent();
            }
            if (serializable != null) {
                list = Collections.singletonList(serializable);
            }
            this.handleActiveDocumentChange((Document)propertyChangeEvent.getOldValue(), (Document)propertyChangeEvent.getNewValue());
        }
        serializable = new HashMap();
        if (list.size() > 0) {
            for (JTextComponent object : list) {
                FileListWork fileListWork;
                Document document = object.getDocument();
                Pair<URL, FileObject> pair = this.getOwningSourceRoot(document);
                if (pair == null) continue;
                long l = DocumentUtilities.getDocumentVersion((Document)document);
                Long l2 = (Long)document.getProperty(PROP_LAST_INDEXED_VERSION);
                Long l3 = (Long)document.getProperty(PROP_LAST_DIRTY_VERSION);
                boolean bl = false;
                boolean bl2 = EditorRegistry.componentList().contains(object);
                bl = bl2 ? (l2 == null ? l3 != null : l2 < l) : l3 != null;
                FileObject fileObject = Util.getFileObject(document);
                LOGGER.log(Level.FINE, "{0}: version={1}, lastIndexerVersion={2}, lastDirtyVersion={3}, openedInEditor={4} => reindex={5}", new Object[]{fileObject.getPath(), l, l2, l3, bl2, bl});
                if (!bl) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Document modified (reindexing): " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + pair.first);
                }
                if ((fileListWork = (FileListWork)serializable.get(pair.first)) == null) {
                    fileListWork = new FileListWork(this.scannedRoots2Dependencies, (URL)pair.first, Collections.singleton(fileObject), false, bl2, true, this.sourcesForBinaryRoots.contains(pair.first), true);
                    serializable.put(pair.first, fileListWork);
                    continue;
                }
                fileListWork.addFile(fileObject);
            }
        }
        if (serializable.isEmpty()) {
            this.scheduleWork(null, false);
        } else {
            for (FileListWork fileListWork : serializable.values()) {
                this.scheduleWork(fileListWork, false);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.removeUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document instanceof BaseDocument) {
            document.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, true);
        } else {
            this.handleDocumentModification(document);
        }
    }

    public void atomicLock(AtomicLockEvent atomicLockEvent) {
        Document document = (Document)atomicLockEvent.getSource();
        document.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, null);
    }

    public void atomicUnlock(AtomicLockEvent atomicLockEvent) {
        Document document = (Document)atomicLockEvent.getSource();
        Boolean bl = (Boolean)document.getProperty(PROP_MODIFIED_UNDER_WRITE_LOCK);
        document.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, null);
        if (bl != null && bl.booleanValue()) {
            this.handleDocumentModification(document);
        }
    }

    private RepositoryUpdater() {
    }

    private void handleActiveDocumentChange(Document document, Document document2) {
        Document document3;
        Document document4 = document3 = this.activeDocumentRef == null ? null : this.activeDocumentRef.get();
        if (document != null && document == document3) {
            if (document3 instanceof BaseDocument) {
                ((BaseDocument)document3).removeAtomicLockListener((AtomicLockListener)this);
            }
            document3.removeDocumentListener(this);
            this.activeDocumentRef = null;
            LOGGER.log(Level.FINE, "Unregistering active document listener: activeDocument={0}", document3);
        }
        if (document2 != null && document2 != document3) {
            if (document3 != null) {
                if (document3 instanceof BaseDocument) {
                    ((BaseDocument)document3).removeAtomicLockListener((AtomicLockListener)this);
                }
                document3.removeDocumentListener(this);
                LOGGER.log(Level.FINE, "Unregistering active document listener: activeDocument={0}", document3);
            }
            document3 = document2;
            this.activeDocumentRef = new WeakReference<Document>(document3);
            if (document3 instanceof BaseDocument) {
                ((BaseDocument)document3).addAtomicLockListener((AtomicLockListener)this);
            }
            document3.addDocumentListener(this);
            LOGGER.log(Level.FINE, "Registering active document listener: activeDocument={0}", document3);
        }
    }

    public void handleDocumentModification(Document document) {
        block10: {
            Pair<URL, FileObject> pair;
            block11: {
                Object iOException;
                Reference<Document> reference = this.activeDocumentRef;
                Document document2 = reference == null ? null : reference.get();
                pair = this.getOwningSourceRoot(document);
                if (pair == null) break block10;
                if (document2 != document) break block11;
                long l = DocumentUtilities.getDocumentVersion((Document)document2);
                Long l2 = (Long)document2.getProperty(PROP_LAST_DIRTY_VERSION);
                boolean bl = false;
                if (l2 == null || l2 < l) {
                    bl = true;
                }
                document2.putProperty(PROP_LAST_DIRTY_VERSION, l);
                if (!bl) break block10;
                FileObject fileObject = Util.getFileObject(document);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Active document modified (marking dirty): " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + pair.first);
                }
                Set<Indexable> set = Collections.singleton(SPIAccessor.getInstance().create(new FileObjectIndexable((FileObject)pair.second, fileObject)));
                String string = DocumentUtilities.getMimeType((Document)document);
                Collection<IndexerCache.IndexerInfo<CustomIndexerFactory>> collection = IndexerCache.getCifCache().getIndexersFor(string);
                for (IndexerCache.IndexerInfo<CustomIndexerFactory> object32 : collection) {
                    try {
                        iOException = object32.getIndexerFactory();
                        iOException = SPIAccessor.getInstance().createContext(CacheFolder.getDataFolder((URL)pair.first), (URL)pair.first, ((SourceIndexerFactory)iOException).getIndexerName(), ((SourceIndexerFactory)iOException).getIndexVersion(), null, false, true, false, null);
                        ((SourceIndexerFactory)iOException).filesDirty(set, (Context)iOException);
                    }
                    catch (IOException iOException2) {
                        LOGGER.log(Level.WARNING, null, iOException2);
                    }
                }
                Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> collection2 = IndexerCache.getEifCache().getIndexersFor(string);
                Iterator iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    iOException = (IndexerCache.IndexerInfo)iterator.next();
                    try {
                        iOException = (EmbeddingIndexerFactory)((IndexerCache.IndexerInfo)iOException).getIndexerFactory();
                        Context context = SPIAccessor.getInstance().createContext(CacheFolder.getDataFolder((URL)pair.first), (URL)pair.first, ((SourceIndexerFactory)iOException).getIndexerName(), ((SourceIndexerFactory)iOException).getIndexVersion(), null, false, true, false, null);
                        ((SourceIndexerFactory)iOException).filesDirty(set, context);
                    }
                    catch (IOException iOException3) {
                        LOGGER.log(Level.WARNING, null, iOException3);
                    }
                }
                break block10;
            }
            try {
                FileObject fileObject = Util.getFileObject(document);
                this.addIndexingJob((URL)pair.first, Collections.singleton(fileObject.getURL()), false, true, false, true, true);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOGGER.log(Level.WARNING, null, fileStateInvalidException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleWork(Iterable<? extends Work> iterable) {
        boolean bl;
        RepositoryUpdater.recordCaller();
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            bl = this.state == State.INITIAL_SCAN_RUNNING || this.state == State.ACTIVE;
        }
        if (bl) {
            this.getWorker().schedule(iterable);
        } else {
            for (Work work : iterable) {
                this.scheduleWork(work, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleWork(Work work, boolean bl) {
        RepositoryUpdater.recordCaller();
        boolean bl2 = false;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state == State.STARTED) {
                this.state = State.INITIAL_SCAN_RUNNING;
                bl2 = !(work instanceof InitialRootsWork);
            }
        }
        if (bl2) {
            this.getWorker().schedule(new InitialRootsWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, true), false);
            if (work instanceof RootsWork) {
                return;
            }
        }
        if (work != null) {
            this.getWorker().schedule(work, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task getWorker() {
        Task task = this.worker;
        if (task == null) {
            RepositoryUpdater repositoryUpdater = this;
            synchronized (repositoryUpdater) {
                if (this.worker == null) {
                    this.worker = new Task();
                }
                task = this.worker;
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<URL, FileObject> getOwningSourceRoot(Object object) {
        String string = this.lastOwningSourceRootCacheLock;
        synchronized (string) {
            FileObject fileObject;
            URL uRL;
            FileObject fileObject2 = null;
            Document document = null;
            if (object instanceof Document) {
                document = (Document)object;
                fileObject2 = Util.getFileObject(document);
                if (fileObject2 == null) {
                    return null;
                }
                uRL = (URL)document.getProperty(PROP_OWNING_SOURCE_ROOT_URL);
                fileObject = (FileObject)document.getProperty(PROP_OWNING_SOURCE_ROOT);
                if (uRL != null && fileObject != null && fileObject.isValid() && FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
                    return Pair.of(uRL, fileObject);
                }
            } else if (object instanceof FileObject) {
                fileObject2 = (FileObject)object;
            } else {
                return null;
            }
            uRL = null;
            fileObject = null;
            ArrayList<URL> arrayList = new ArrayList<URL>(this.scannedRoots2Dependencies.keySet());
            for (URL uRL2 : arrayList) {
                FileObject fileObject3 = URLCache.getInstance().findFileObject(uRL2);
                if (fileObject3 == null || !FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject2)) continue;
                uRL = uRL2;
                fileObject = fileObject3;
                break;
            }
            if (uRL != null) {
                assert (fileObject != null) : "Expecting both owningSourceRootUrl=" + uRL + " and owningSourceRoot=" + fileObject;
                if (document != null) {
                    document.putProperty(PROP_OWNING_SOURCE_ROOT_URL, uRL);
                    document.putProperty(PROP_OWNING_SOURCE_ROOT, fileObject);
                }
                return Pair.of(uRL, fileObject);
            }
            return null;
        }
    }

    private Pair<URL, FileObject> getOwningBinaryRoot(FileObject fileObject) {
        String string;
        if (fileObject == null) {
            return null;
        }
        try {
            string = fileObject.getURL().getPath();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            LOGGER.log(Level.WARNING, null, fileStateInvalidException);
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(this.scannedBinaries2InvDependencies.keySet());
        for (URL uRL : arrayList) {
            String string2;
            URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
            boolean bl = true;
            if (uRL2 == null) {
                uRL2 = uRL;
                bl = false;
            }
            if ((string2 = uRL2.getPath()).equals(string)) {
                return Pair.of(uRL, null);
            }
            if (bl || !string.startsWith(string2)) continue;
            return Pair.of(uRL, null);
        }
        return null;
    }

    private static ClassPath.Entry getClassPathEntry(FileObject fileObject) {
        try {
            Set<String> set;
            if (fileObject != null && (set = PathRegistry.getDefault().getSourceIdsFor(fileObject.getURL())) != null) {
                for (String string : set) {
                    ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)string);
                    if (classPath == null) continue;
                    URL uRL = fileObject.getURL();
                    for (ClassPath.Entry entry : classPath.entries()) {
                        if (!uRL.equals(entry.getURL())) continue;
                        return entry;
                    }
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return null;
    }

    private boolean authorize(FileEvent fileEvent) {
        Collection collection = this.indexingActivityInterceptors.allInstances();
        for (IndexingActivityInterceptor indexingActivityInterceptor : collection) {
            if (indexingActivityInterceptor.authorizeFileSystemEvent(fileEvent) != IndexingActivityInterceptor.Authorization.IGNORE) continue;
            return false;
        }
        return true;
    }

    private boolean isCacheFile(FileObject fileObject) {
        return FileUtil.isParentOf((FileObject)CacheFolder.getCacheFolder(), (FileObject)fileObject);
    }

    private static void collectFilePaths(FileObject fileObject, String string, Set<String> set) {
        assert (fileObject.isFolder()) : "Expecting folder: " + fileObject;
        if (fileObject.isValid()) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!fileObject2.isValid()) continue;
                String string2 = string + "/" + fileObject2.getNameExt();
                if (fileObject2.isData()) {
                    set.add(string2);
                    continue;
                }
                RepositoryUpdater.collectFilePaths(fileObject2, string2, set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean findDependencies(URL uRL, DependenciesContext dependenciesContext, Set<String> set, Set<String> object, CancelRequest cancelRequest) {
        LinkedList<URL> linkedList;
        block38: {
            boolean bl;
            block37: {
                boolean bl2;
                block36: {
                    boolean bl3;
                    block35: {
                        List list;
                        if (cancelRequest.isRaised()) {
                            return false;
                        }
                        if (dependenciesContext.useInitialState && (list = (List)dependenciesContext.initialRoots2Deps.get(uRL)) != null && list != EMPTY_DEPS) {
                            dependenciesContext.oldRoots.remove(uRL);
                            return true;
                        }
                        if (dependenciesContext.newRoots2Deps.containsKey(uRL)) {
                            return true;
                        }
                        list = URLMapper.findFileObject((URL)uRL);
                        if (list == null) {
                            return true;
                        }
                        linkedList = new LinkedList<URL>();
                        dependenciesContext.cycleDetector.push(uRL);
                        try {
                            URL uRL2;
                            Set<String> set2;
                            if (set == null || object == null) {
                                Iterator<String> iterator;
                                set2 = PathRegistry.getDefault().getSourceIdsFor(uRL);
                                if (null != set2 && !set2.isEmpty()) {
                                    LOGGER.log(Level.FINER, "Resolving Ids based on sourceIds for {0}: {1}", new Object[]{uRL, set2});
                                    iterator = new HashSet();
                                    HashSet<String> hashSet = new HashSet<String>();
                                    for (String string : set2) {
                                        iterator.addAll(PathRecognizerRegistry.getDefault().getLibraryIdsForSourceId(string));
                                        hashSet.addAll(PathRecognizerRegistry.getDefault().getBinaryLibraryIdsForSourceId(string));
                                    }
                                    if (set == null) {
                                        set = iterator;
                                    }
                                    if (object == null) {
                                        object = hashSet;
                                    }
                                } else {
                                    set2 = PathRegistry.getDefault().getLibraryIdsFor(uRL);
                                    if (null != set2 && !set2.isEmpty()) {
                                        LOGGER.log(Level.FINER, "Resolving Ids based on libraryIds for {0}: {1}", new Object[]{uRL, set2});
                                        iterator = new HashSet();
                                        for (String string : set2) {
                                            iterator.addAll(PathRecognizerRegistry.getDefault().getBinaryLibraryIdsForLibraryId(string));
                                        }
                                        if (set == null) {
                                            set = set2;
                                        }
                                        if (object == null) {
                                            object = iterator;
                                        }
                                    }
                                }
                            }
                            if (cancelRequest.isRaised()) {
                                boolean bl4 = false;
                                Object var21_31 = null;
                                dependenciesContext.cycleDetector.pop();
                                return bl4;
                            }
                            LOGGER.log(Level.FINER, "LibraryIds for {0}: {1}", new Object[]{uRL, set});
                            LOGGER.log(Level.FINER, "BinaryLibraryIds for {0}: {1}", new Object[]{uRL, object});
                            set2 = set == null ? PathRecognizerRegistry.getDefault().getLibraryIds() : set;
                            for (String string : set2) {
                                if (cancelRequest.isRaised()) {
                                    bl3 = false;
                                    break block35;
                                }
                                ClassPath classPath = ClassPath.getClassPath((FileObject)list, (String)string);
                                if (classPath == null) continue;
                                for (ClassPath.Entry entry : classPath.entries()) {
                                    if (cancelRequest.isRaised()) {
                                        boolean bl5 = false;
                                        Object var21_33 = null;
                                        dependenciesContext.cycleDetector.pop();
                                        return bl5;
                                    }
                                    uRL2 = entry.getURL();
                                    if (uRL2.equals(uRL) || dependenciesContext.cycleDetector.contains(uRL2)) continue;
                                    linkedList.add(uRL2);
                                    if (RepositoryUpdater.findDependencies(uRL2, dependenciesContext, set, (Set<String>)object, cancelRequest)) continue;
                                    boolean bl6 = false;
                                    Object var21_34 = null;
                                    dependenciesContext.cycleDetector.pop();
                                    return bl6;
                                }
                            }
                            set2 = object == null ? PathRecognizerRegistry.getDefault().getBinaryLibraryIds() : object;
                            for (String string : set2) {
                                if (cancelRequest.isRaised()) {
                                    bl2 = false;
                                    break block36;
                                }
                                ClassPath classPath = ClassPath.getClassPath((FileObject)list, (String)string);
                                if (classPath == null) continue;
                                for (ClassPath.Entry entry : classPath.entries()) {
                                    Object object2;
                                    if (cancelRequest.isRaised()) {
                                        bl = false;
                                        break block37;
                                    }
                                    uRL2 = entry.getURL();
                                    URL[] uRLArray = PathRegistry.getDefault().sourceForBinaryQuery(uRL2, classPath, false);
                                    if (uRLArray != null) {
                                        for (URL uRL3 : uRLArray) {
                                            if (cancelRequest.isRaised()) {
                                                boolean bl7 = false;
                                                Object var21_37 = null;
                                                dependenciesContext.cycleDetector.pop();
                                                return bl7;
                                            }
                                            if (uRL3.equals(uRL)) {
                                                dependenciesContext.sourcesForBinaryRoots.add(uRL);
                                                continue;
                                            }
                                            if (dependenciesContext.cycleDetector.contains(uRL3)) continue;
                                            linkedList.add(uRL3);
                                            if (RepositoryUpdater.findDependencies(uRL3, dependenciesContext, set, (Set<String>)object, cancelRequest)) continue;
                                            boolean bl8 = false;
                                            Object var21_38 = null;
                                            dependenciesContext.cycleDetector.pop();
                                            return bl8;
                                        }
                                        continue;
                                    }
                                    if (dependenciesContext.useInitialState) {
                                        if (!dependenciesContext.initialBinaries2InvDeps.keySet().contains(uRL2)) {
                                            dependenciesContext.newBinariesToScan.add(uRL2);
                                            object2 = (List)dependenciesContext.newBinaries2InvDeps.get(uRL2);
                                            if (object2 == null) {
                                                object2 = new LinkedList();
                                                dependenciesContext.newBinaries2InvDeps.put(uRL2, object2);
                                            }
                                            object2.add(uRL);
                                        }
                                        dependenciesContext.oldBinaries.remove(uRL2);
                                    } else {
                                        dependenciesContext.newBinariesToScan.add(uRL2);
                                        object2 = (List)dependenciesContext.newBinaries2InvDeps.get(uRL2);
                                        if (object2 == null) {
                                            object2 = new LinkedList();
                                            dependenciesContext.newBinaries2InvDeps.put(uRL2, object2);
                                        }
                                        object2.add(uRL);
                                        dependenciesContext.oldBinaries.remove(uRL2);
                                    }
                                    object2 = PathRegistry.getDefault().getSourceIdsFor(uRL2);
                                    if (object2 == null || object2.isEmpty()) {
                                        if (uRL2.equals(uRL) || dependenciesContext.cycleDetector.contains(uRL2)) continue;
                                        linkedList.add(uRL2);
                                        continue;
                                    }
                                    LOGGER.log(Level.INFO, "The root {0} is registered for both {1} and {2}", new Object[]{uRL2, string, object2});
                                }
                            }
                            break block38;
                        }
                        catch (Throwable throwable) {
                            Object var21_40 = null;
                            dependenciesContext.cycleDetector.pop();
                            throw throwable;
                        }
                    }
                    Object var21_32 = null;
                    dependenciesContext.cycleDetector.pop();
                    return bl3;
                }
                Object var21_35 = null;
                dependenciesContext.cycleDetector.pop();
                return bl2;
            }
            Object var21_36 = null;
            dependenciesContext.cycleDetector.pop();
            return bl;
        }
        Object var21_39 = null;
        dependenciesContext.cycleDetector.pop();
        dependenciesContext.newRoots2Deps.put(uRL, linkedList);
        return true;
    }

    private static Map<FileObject, Document> getEditorFiles() {
        HashMap<FileObject, Document> hashMap = new HashMap<FileObject, Document>();
        for (JTextComponent jTextComponent : EditorRegistry.componentList()) {
            Document document = jTextComponent.getDocument();
            FileObject fileObject = Util.getFileObject(document);
            if (fileObject == null) continue;
            hashMap.put(fileObject, document);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordCaller() {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        Map<List<StackTraceElement>, Long> map = lastRecordedStackTraces;
        synchronized (map) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>(stackTraceElementArray.length);
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                arrayList.add(stackTraceElement);
            }
            Long l = lastRecordedStackTraces.get(arrayList);
            if (l == null) {
                Long l2 = stackTraceId++;
                lastRecordedStackTraces.put(arrayList, l2);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("RepositoryUpdater caller [id=").append(l2).append("] :\n");
                for (StackTraceElement stackTraceElement : arrayList) {
                    stringBuilder.append(stackTraceElement.toString());
                    stringBuilder.append("\n");
                }
                LOGGER.fine(stringBuilder.toString());
            } else {
                StackTraceElement stackTraceElement = Util.findCaller(stackTraceElementArray, new Object[0]);
                LOGGER.fine("RepositoryUpdater caller [refid=" + l + "]: " + stackTraceElement);
            }
        }
    }

    private static void printMap(Map<URL, List<URL>> map, Level level) {
        TreeSet<URL> treeSet = new TreeSet<URL>(C);
        treeSet.addAll(map.keySet());
        for (URL uRL : treeSet) {
            LOGGER.log(level, "  {0}:\n", uRL);
        }
    }

    private static StringBuilder printMap(Map<URL, List<URL>> map, StringBuilder stringBuilder) {
        TreeSet<URL> treeSet = new TreeSet<URL>(C);
        treeSet.addAll(map.keySet());
        for (URL uRL : treeSet) {
            stringBuilder.append("  ").append(uRL).append(":\n");
        }
        return stringBuilder;
    }

    private static void printCollection(Collection<? extends URL> collection, Level level) {
        TreeSet<URL> treeSet = new TreeSet<URL>(C);
        treeSet.addAll(collection);
        for (URL uRL : treeSet) {
            LOGGER.log(level, "  {0}\n", uRL);
        }
    }

    private static StringBuilder printCollection(Collection<? extends URL> collection, StringBuilder stringBuilder) {
        TreeSet<URL> treeSet = new TreeSet<URL>(C);
        treeSet.addAll(collection);
        for (URL uRL : treeSet) {
            stringBuilder.append("  ").append(uRL).append("\n");
        }
        return stringBuilder;
    }

    private static StringBuilder printMimeTypes(Collection<? extends String> collection, StringBuilder stringBuilder) {
        Iterator<? extends String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuilder.append("'").append(string).append("'");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder;
    }

    State getState() {
        return this.state;
    }

    Set<URL> getScannedBinaries() {
        return this.scannedBinaries2InvDependencies.keySet();
    }

    Set<URL> getScannedSources() {
        return this.scannedRoots2Dependencies.keySet();
    }

    Map<URL, List<URL>> getScannedRoots2Dependencies() {
        return this.scannedRoots2Dependencies;
    }

    Set<URL> getScannedUnknowns() {
        return this.scannedUnknown;
    }

    void ignoreIndexerCacheEvents(boolean bl) {
        this.ignoreIndexerCacheEvents = bl;
    }

    static {
        LOGGER = Logger.getLogger(RepositoryUpdater.class.getName());
        TEST_LOGGER = Logger.getLogger(RepositoryUpdater.class.getName() + ".tests");
        SFEC_LOGGER = Logger.getLogger("org.netbeans.ui.ScanForExternalChanges");
        PERF_TEST = Boolean.getBoolean("perf.refactoring.test");
        notInterruptible = Boolean.getBoolean("netbeans.indexing.notInterruptible");
        FILE_LOCKS_DELAY = org.openide.util.Utilities.isWindows() ? 2000 : 1000;
        PROP_LAST_INDEXED_VERSION = RepositoryUpdater.class.getName() + "-last-indexed-document-version";
        PROP_LAST_DIRTY_VERSION = RepositoryUpdater.class.getName() + "-last-dirty-document-version";
        PROP_MODIFIED_UNDER_WRITE_LOCK = RepositoryUpdater.class.getName() + "-modified-under-write-lock";
        PROP_OWNING_SOURCE_ROOT_URL = RepositoryUpdater.class.getName() + "-owning-source-root-url";
        PROP_OWNING_SOURCE_ROOT = RepositoryUpdater.class.getName() + "-owning-source-root";
        EMPTY_DEPS = Collections.unmodifiableList(new LinkedList());
        lastRecordedStackTraces = new HashMap<List<StackTraceElement>, Long>();
        stackTraceId = 0L;
        C = new Comparator<URL>(){

            @Override
            public int compare(URL uRL, URL uRL2) {
                return uRL.toString().compareTo(uRL2.toString());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LexicographicComparator
    implements Comparator<URL> {
        private final boolean reverse;

        public LexicographicComparator(boolean bl) {
            this.reverse = bl;
        }

        @Override
        public int compare(URL uRL, URL uRL2) {
            int n = uRL.toString().compareTo(uRL2.toString());
            return this.reverse ? -1 * n : n;
        }
    }

    public static final class FSRefreshInterceptor
    implements IndexingActivityInterceptor {
        private FileSystem.AtomicAction activeAA = null;
        private boolean ignoreFsEvents = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexingActivityInterceptor.Authorization authorizeFileSystemEvent(FileEvent fileEvent) {
            FSRefreshInterceptor fSRefreshInterceptor = this;
            synchronized (fSRefreshInterceptor) {
                if (this.activeAA != null) {
                    boolean bl = fileEvent.firedFrom(this.activeAA);
                    LOGGER.log(Level.FINE, "{0} fired from {1}: {2}", new Object[]{fileEvent, this.activeAA, bl});
                    return bl ? IndexingActivityInterceptor.Authorization.IGNORE : IndexingActivityInterceptor.Authorization.PROCESS;
                }
                LOGGER.log(Level.FINE, "Set to ignore {0}: {1}", new Object[]{fileEvent, this.ignoreFsEvents});
                return this.ignoreFsEvents ? IndexingActivityInterceptor.Authorization.IGNORE : IndexingActivityInterceptor.Authorization.PROCESS;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setActiveAtomicAction(FileSystem.AtomicAction atomicAction) {
            FSRefreshInterceptor fSRefreshInterceptor = this;
            synchronized (fSRefreshInterceptor) {
                LOGGER.log(Level.FINE, "setActiveAtomicAction({0})", atomicAction);
                if (atomicAction != null) {
                    assert (this.activeAA == null) : "Expecting no activeAA: " + this.activeAA;
                    this.activeAA = atomicAction;
                } else {
                    assert (this.activeAA != null) : "Expecting some activeAA";
                    this.activeAA = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIgnoreFsEvents(boolean bl) {
            FSRefreshInterceptor fSRefreshInterceptor = this;
            synchronized (fSRefreshInterceptor) {
                LOGGER.log(Level.FINE, "setIgnoreFsEvents({0})", bl);
                assert (this.activeAA == null) : "Expecting no activeAA: " + this.activeAA;
                this.ignoreFsEvents = bl;
            }
        }
    }

    private static final class URLCache {
        private static URLCache instance = null;
        private final Map<URL, Reference<FileObject>> cache = new WeakHashMap<URL, Reference<FileObject>>();

        public static synchronized URLCache getInstance() {
            if (instance == null) {
                instance = new URLCache();
            }
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject findFileObject(URL uRL) {
            FileObject fileObject = null;
            Map<URL, Reference<FileObject>> map = this.cache;
            synchronized (map) {
                Reference<FileObject> reference = this.cache.get(uRL);
                if (reference != null) {
                    fileObject = reference.get();
                }
            }
            try {
                if (fileObject != null && fileObject.isValid() && uRL.equals(fileObject.getURL())) {
                    return fileObject;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            fileObject = URLMapper.findFileObject((URL)uRL);
            map = this.cache;
            synchronized (map) {
                if (fileObject != null && fileObject.isValid()) {
                    this.cache.put(uRL, new WeakReference<FileObject>(fileObject));
                }
                return fileObject;
            }
        }

        private URLCache() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Controller
    extends IndexingController {
        private Map<URL, List<URL>> roots2Dependencies = Collections.emptyMap();
        private Map<URL, List<URL>> binRoots2Dependencies = Collections.emptyMap();

        public Controller() {
            RepositoryUpdater.this.start(false);
        }

        @Override
        public void enterProtectedMode() {
            RepositoryUpdater.this.getWorker().enterProtectedMode();
        }

        @Override
        public void exitProtectedMode(Runnable runnable) {
            RepositoryUpdater.this.getWorker().exitProtectedMode(runnable);
        }

        @Override
        public boolean isInProtectedMode() {
            return RepositoryUpdater.this.getWorker().isInProtectedMode();
        }

        @Override
        public synchronized Map<URL, List<URL>> getRootDependencies() {
            return this.roots2Dependencies;
        }

        @Override
        public synchronized Map<URL, List<URL>> getBinaryRootDependencies() {
            return this.binRoots2Dependencies;
        }

        @Override
        public int getFileLocksDelay() {
            return FILE_LOCKS_DELAY;
        }
    }

    private static final class Indexers {
        public final Set<IndexerCache.IndexerInfo<CustomIndexerFactory>> changedCifs;
        public final Collection<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos;
        public final Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> changedEifs;
        public final Map<String, Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>> eifInfosMap;

        public static Indexers load(boolean bl) {
            return new Indexers(bl);
        }

        private Indexers(boolean bl) {
            long l = System.currentTimeMillis();
            if (bl) {
                this.changedCifs = new HashSet<IndexerCache.IndexerInfo<CustomIndexerFactory>>();
                this.changedEifs = new HashSet<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>();
            } else {
                this.changedCifs = null;
                this.changedEifs = null;
            }
            this.cifInfos = IndexerCache.getCifCache().getIndexers(this.changedCifs);
            this.eifInfosMap = IndexerCache.getEifCache().getIndexersMap(this.changedEifs);
            long l2 = System.currentTimeMillis() - l;
            LOGGER.log(Level.FINE, "Loading indexers took {0} ms.", l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DependenciesContext {
        private final Map<URL, List<URL>> initialRoots2Deps;
        private final Map<URL, List<URL>> initialBinaries2InvDeps;
        private final Set<URL> oldRoots;
        private final Set<URL> oldBinaries;
        private final Map<URL, List<URL>> newRoots2Deps;
        private final Map<URL, List<URL>> newBinaries2InvDeps;
        private final List<URL> newRootsToScan;
        private final Set<URL> newBinariesToScan;
        private final Set<URL> scannedRoots;
        private final Set<URL> scannedBinaries;
        private final Set<URL> sourcesForBinaryRoots;
        private Set<URL> fullRescanSourceRoots;
        private final Stack<URL> cycleDetector;
        private final boolean useInitialState;

        public DependenciesContext(Map<URL, List<URL>> map, Map<URL, List<URL>> map2, Set<URL> set, boolean bl) {
            assert (map != null);
            assert (map2 != null);
            this.initialRoots2Deps = Collections.unmodifiableMap(map);
            this.initialBinaries2InvDeps = Collections.unmodifiableMap(map2);
            this.oldRoots = new HashSet<URL>(map.keySet());
            this.oldBinaries = new HashSet<URL>(map2.keySet());
            this.newRoots2Deps = new HashMap<URL, List<URL>>();
            this.newBinaries2InvDeps = new HashMap<URL, List<URL>>();
            this.newRootsToScan = new ArrayList<URL>();
            this.newBinariesToScan = new HashSet<URL>();
            this.scannedRoots = new HashSet<URL>();
            this.scannedBinaries = new HashSet<URL>();
            this.sourcesForBinaryRoots = set;
            this.fullRescanSourceRoots = new HashSet<URL>();
            this.useInitialState = bl;
            this.cycleDetector = new Stack();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.toString());
            stringBuilder.append(": {\n");
            stringBuilder.append("  useInitialState=" + this.useInitialState).append("\n");
            stringBuilder.append("  initialRoots2Deps(").append(this.initialRoots2Deps.size()).append(")=\n");
            RepositoryUpdater.printMap((Map<URL, List<URL>>)this.initialRoots2Deps, stringBuilder);
            stringBuilder.append("  initialBinaries(").append(this.initialBinaries2InvDeps.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.initialBinaries2InvDeps.keySet(), stringBuilder);
            stringBuilder.append("  oldRoots(").append(this.oldRoots.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.oldRoots, stringBuilder);
            stringBuilder.append("  oldBinaries(").append(this.oldBinaries.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.oldBinaries, stringBuilder);
            stringBuilder.append("  newRootsToScan(").append(this.newRootsToScan.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.newRootsToScan, stringBuilder);
            stringBuilder.append("  newBinariesToScan(").append(this.newBinariesToScan.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.newBinariesToScan, stringBuilder);
            stringBuilder.append("  scannedRoots(").append(this.scannedRoots.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.scannedRoots, stringBuilder);
            stringBuilder.append("  scannedBinaries(").append(this.scannedBinaries.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.scannedBinaries, stringBuilder);
            stringBuilder.append("} ----\n");
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Task
    extends ParserResultTask {
        private final List<Work> todo = new LinkedList<Work>();
        private Work workInProgress = null;
        private Work cancelledWork = null;
        private boolean scheduled = false;
        private boolean allCancelled = false;
        private boolean cancelled = false;
        private int protectedMode = 0;
        private List<Runnable> followupTasks = null;

        private Task() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(Iterable<? extends Work> iterable) {
            List<Work> list = this.todo;
            synchronized (list) {
                for (Work work : iterable) {
                    this.schedule(work, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(Work work, boolean bl) {
            boolean bl2 = false;
            boolean bl3 = false;
            List<Work> list = this.todo;
            synchronized (list) {
                assert (work != null);
                if (!this.allCancelled) {
                    if (bl && Utilities.holdsParserLock()) {
                        if (this.protectedMode == 0) {
                            bl2 = true;
                        } else {
                            LOGGER.log(Level.FINE, "Won't enforce {0} when in protected mode", work);
                            bl = false;
                        }
                    }
                    if (!bl2) {
                        if (this.workInProgress != null) {
                            this.workInProgress.cancelBy(work);
                        }
                        boolean bl4 = false;
                        if (!bl) {
                            for (Work work2 : this.todo) {
                                if (!work2.absorb(work)) continue;
                                bl4 = true;
                                break;
                            }
                        }
                        if (!bl4) {
                            LOGGER.log(Level.FINE, "Scheduling {0}", work);
                            this.todo.add(work);
                        } else {
                            LOGGER.log(Level.FINE, "Work absorbed {0}", work);
                        }
                        if (!this.scheduled && this.protectedMode == 0) {
                            this.scheduled = true;
                            Utilities.scheduleSpecialTask(this);
                        }
                        bl3 = bl;
                    }
                }
            }
            if (bl2) {
                LOGGER.log(Level.FINE, "Enforcing {0}", work);
                work.doTheWork();
            } else if (bl3) {
                LOGGER.log(Level.FINE, "Waiting for {0}", work);
                work.waitUntilDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelAll() {
            List<Work> list = this.todo;
            synchronized (list) {
                if (!this.allCancelled) {
                    this.allCancelled = true;
                    this.todo.clear();
                    Work work = this.workInProgress;
                    if (work != null) {
                        work.setCancelled(true);
                    }
                    while (this.scheduled) {
                        try {
                            this.todo.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWorking() {
            List<Work> list = this.todo;
            synchronized (list) {
                return this.scheduled || this.protectedMode > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enterProtectedMode() {
            List<Work> list = this.todo;
            synchronized (list) {
                ++this.protectedMode;
                LOGGER.log(Level.FINE, "Entering protected mode: {0}", this.protectedMode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exitProtectedMode(Runnable runnable) {
            List<Work> list = this.todo;
            synchronized (list) {
                if (this.protectedMode <= 0) {
                    throw new IllegalStateException("Calling exitProtectedMode without enterProtectedMode");
                }
                if (runnable != null) {
                    if (this.followupTasks == null) {
                        this.followupTasks = new LinkedList<Runnable>();
                    }
                    this.followupTasks.add(runnable);
                }
                --this.protectedMode;
                LOGGER.log(Level.FINE, "Exiting protected mode: {0}", this.protectedMode);
                if (this.protectedMode == 0) {
                    final List<Runnable> list2 = this.followupTasks;
                    RequestProcessor.getDefault().create(new Runnable(){

                        public void run() {
                            Task.this.schedule(new Work(false, false, false, true){

                                protected boolean getDone() {
                                    if (list2 != null) {
                                        for (Runnable runnable : list2) {
                                            try {
                                                runnable.run();
                                            }
                                            catch (ThreadDeath threadDeath) {
                                                throw threadDeath;
                                            }
                                            catch (Throwable throwable) {
                                                LOGGER.log(Level.WARNING, null, throwable);
                                            }
                                        }
                                    }
                                    return true;
                                }
                            }, false);
                        }
                    }).schedule(FILE_LOCKS_DELAY);
                    LOGGER.log(Level.FINE, "Protected mode exited, scheduling postprocess tasks: {0}", list2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInProtectedMode() {
            List<Work> list = this.todo;
            synchronized (list) {
                return this.protectedMode > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitUntilFinished(long l) throws InterruptedException {
            if (Utilities.holdsParserLock()) {
                throw new IllegalStateException("Can't wait for indexing to finish from inside a running parser task");
            }
            List<Work> list = this.todo;
            synchronized (list) {
                while (this.scheduled) {
                    if (l > 0L) {
                        this.todo.wait(l);
                        return !this.scheduled;
                    }
                    this.todo.wait();
                }
            }
            return true;
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public Class<? extends Scheduler> getSchedulerClass() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            RepositoryUpdater.recordCaller();
            if (notInterruptible) {
                return;
            }
            List<Work> list = this.todo;
            synchronized (list) {
                if (!this.cancelled) {
                    this.cancelled = true;
                    this.cancelledWork = this.workInProgress;
                    if (this.cancelledWork != null) {
                        this.cancelledWork.setCancelled(true);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
            List<Work> list;
            List<Work> list2 = this.todo;
            synchronized (list2) {
                this.cancelled = false;
                this.cancelledWork = null;
            }
            try {
                this._run();
                Object var6_5 = null;
                list = this.todo;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                List<Work> list3 = this.todo;
                synchronized (list3) {
                    if (this.cancelledWork != null && !this.cancelledWork.isFinished()) {
                        if (!this.allCancelled) {
                            this.cancelledWork.setCancelled(false);
                            this.todo.add(0, this.cancelledWork);
                        }
                        this.cancelledWork = null;
                    }
                    if (this.todo.isEmpty()) {
                        this.scheduled = false;
                    } else {
                        Utilities.scheduleSpecialTask(this);
                    }
                    this.todo.notifyAll();
                }
                throw throwable;
            }
            synchronized (list) {
                if (this.cancelledWork != null && !this.cancelledWork.isFinished()) {
                    if (!this.allCancelled) {
                        this.cancelledWork.setCancelled(false);
                        this.todo.add(0, this.cancelledWork);
                    }
                    this.cancelledWork = null;
                }
                if (this.todo.isEmpty()) {
                    this.scheduled = false;
                } else {
                    Utilities.scheduleSpecialTask(this);
                }
                this.todo.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void _run() {
            ProgressHandle progressHandle = null;
            try {
                Work work = this.getWork();
                while (work != null) {
                    block17: {
                        Object var7_6;
                        if (progressHandle == null) {
                            if (work.getProgressTitle() != null) {
                                progressHandle = ProgressHandleFactory.createHandle((String)work.getProgressTitle());
                                progressHandle.start();
                            }
                        } else if (work.getProgressTitle() != null) {
                            progressHandle.setDisplayName(work.getProgressTitle());
                        } else {
                            progressHandle.setDisplayName(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_BackgroundCompileStart"));
                        }
                        long l = 0L;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            l = System.currentTimeMillis();
                            LOGGER.log(Level.FINE, "Performing {0}", work);
                        }
                        work.setProgressHandle(progressHandle);
                        try {
                            try {
                                work.doTheWork();
                            }
                            catch (ThreadDeath threadDeath) {
                                throw threadDeath;
                            }
                            catch (Throwable throwable) {
                                LOGGER.log(Level.WARNING, null, throwable);
                                var7_6 = null;
                                work.setProgressHandle(null);
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.log(Level.FINE, "Finished {0} in {1} ms with result {2}", new Object[]{work, System.currentTimeMillis() - l, work.isCancelled() ? "Cancelled" : (work.isFinished() ? "Done" : "Interrupted")});
                                }
                                break block17;
                            }
                            var7_6 = null;
                            work.setProgressHandle(null);
                            if (!LOGGER.isLoggable(Level.FINE)) break block17;
                        }
                        catch (Throwable throwable) {
                            var7_6 = null;
                            work.setProgressHandle(null);
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "Finished {0} in {1} ms with result {2}", new Object[]{work, System.currentTimeMillis() - l, work.isCancelled() ? "Cancelled" : (work.isFinished() ? "Done" : "Interrupted")});
                            }
                            throw throwable;
                        }
                        LOGGER.log(Level.FINE, "Finished {0} in {1} ms with result {2}", new Object[]{work, System.currentTimeMillis() - l, work.isCancelled() ? "Cancelled" : (work.isFinished() ? "Done" : "Interrupted")});
                    }
                    work = this.getWork();
                }
                Object var9_8 = null;
                if (progressHandle == null) return;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (progressHandle != null) {
                    progressHandle.finish();
                    progressHandle = null;
                }
                throw throwable;
            }
            progressHandle.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Work getWork() {
            List<Work> list = this.todo;
            synchronized (list) {
                Work work = !this.cancelled && this.protectedMode == 0 && this.todo.size() > 0 ? this.todo.remove(0) : null;
                this.workInProgress = work;
                return work;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InitialRootsWork
    extends RootsWork {
        private final boolean waitForProjects;

        public InitialRootsWork(Map<URL, List<URL>> map, Map<URL, List<URL>> map2, Set<URL> set, boolean bl) {
            super(map, map2, set, true);
            this.waitForProjects = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean getDone() {
            boolean bl;
            try {
                if (this.indexers == null) {
                    this.indexers = Indexers.load(true);
                }
                if (this.waitForProjects) {
                    bl = true;
                    while (bl) {
                        try {
                            OpenProjects.getDefault().openProjects().get(1000L, TimeUnit.MILLISECONDS);
                            bl = false;
                        }
                        catch (TimeoutException timeoutException) {
                            if (!this.isCancelledExternally()) continue;
                            boolean bl2 = false;
                            Object var5_6 = null;
                            if (RepositoryUpdater.this.state != State.INITIAL_SCAN_RUNNING) return bl2;
                            RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
                            synchronized (repositoryUpdater) {
                                if (RepositoryUpdater.this.state != State.INITIAL_SCAN_RUNNING) return bl2;
                                RepositoryUpdater.this.state = State.ACTIVE;
                                return bl2;
                            }
                        }
                        catch (Exception exception) {
                            bl = false;
                        }
                    }
                }
                bl = super.getDone();
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (RepositoryUpdater.this.state != State.INITIAL_SCAN_RUNNING) throw throwable;
                RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
                synchronized (repositoryUpdater) {
                    if (RepositoryUpdater.this.state != State.INITIAL_SCAN_RUNNING) throw throwable;
                    RepositoryUpdater.this.state = State.ACTIVE;
                    throw throwable;
                }
            }
            if (RepositoryUpdater.this.state != State.INITIAL_SCAN_RUNNING) return bl;
            RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
            synchronized (repositoryUpdater) {
                if (RepositoryUpdater.this.state != State.INITIAL_SCAN_RUNNING) return bl;
                RepositoryUpdater.this.state = State.ACTIVE;
                return bl;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractRootsWork
    extends Work {
        private boolean logStatistics;

        protected AbstractRootsWork(boolean bl) {
            super(false, false, true, true);
            this.logStatistics = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final boolean scanBinaries(DependenciesContext dependenciesContext) {
            assert (dependenciesContext != null);
            long l = 0L;
            long l2 = 0L;
            boolean bl = true;
            for (URL uRL : dependenciesContext.newBinariesToScan) {
                long l3;
                Object var13_9;
                if (this.isCancelled()) {
                    bl = false;
                    break;
                }
                long l4 = System.currentTimeMillis();
                try {
                    try {
                        this.updateProgress(uRL);
                        this.indexBinary(uRL);
                        dependenciesContext.scannedBinaries.add(uRL);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, null, iOException);
                        var13_9 = null;
                        l3 = System.currentTimeMillis() - l4;
                        l2 += l3;
                        ++l;
                        if (PERF_TEST) {
                            AbstractRootsWork.reportRootScan(uRL, l3);
                        }
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine(String.format("Indexing of: %s took: %d ms", uRL.toExternalForm(), l3));
                        continue;
                    }
                    var13_9 = null;
                }
                catch (Throwable throwable) {
                    var13_9 = null;
                    l3 = System.currentTimeMillis() - l4;
                    l2 += l3;
                    ++l;
                    if (PERF_TEST) {
                        AbstractRootsWork.reportRootScan(uRL, l3);
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Indexing of: %s took: %d ms", uRL.toExternalForm(), l3));
                    }
                    throw throwable;
                }
                l3 = System.currentTimeMillis() - l4;
                l2 += l3;
                ++l;
                if (PERF_TEST) {
                    AbstractRootsWork.reportRootScan(uRL, l3);
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(String.format("Indexing of: %s took: %d ms", uRL.toExternalForm(), l3));
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("Complete indexing of %d binary roots took: %d ms", l, l2));
            }
            TEST_LOGGER.log(Level.FINEST, "scanBinary", dependenciesContext.newBinariesToScan);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final boolean scanSources(DependenciesContext var1_1, Indexers var2_2, Map<URL, List<URL>> var3_3) {
            if (!AbstractRootsWork.$assertionsDisabled && var1_1 == null) {
                throw new AssertionError();
            }
            var4_4 = 0L;
            var6_5 = 0L;
            var8_6 = 0;
            var9_7 = 0;
            var10_8 = true;
            if (var2_2 == null) {
                var2_2 = Indexers.load(false);
            }
            for (URL var12_10 : DependenciesContext.access$2300(var1_1)) {
                block21: {
                    block20: {
                        if (this.isCancelled()) {
                            var10_8 = false;
                            break;
                        }
                        var13_11 = System.currentTimeMillis();
                        var15_12 = new int[]{0};
                        var16_13 = new int[]{0};
                        try {
                            try {
                                this.updateProgress(var12_10);
                                var17_14 = false;
                                var18_16 = false;
                                if (var3_3 != null && !var3_3.containsKey(var12_10)) {
                                    var3_3.put(var12_10, RepositoryUpdater.EMPTY_DEPS);
                                    var17_14 = true;
                                }
                                try {
                                    block22: {
                                        if (!this.scanSource(var12_10, DependenciesContext.access$2400(var1_1).contains(var12_10), DependenciesContext.access$800(var1_1).contains(var12_10), var2_2, var15_12, var16_13)) break block22;
                                        DependenciesContext.access$2500(var1_1).add(var12_10);
                                        var18_16 = true;
                                        ** GOTO lbl-1000
                                    }
                                    var10_8 = false;
                                    var20_17 = null;
                                    if (var17_14 && !var18_16) {
                                        var3_3.remove(var12_10);
                                    }
                                }
                                catch (Throwable var19_20) {
                                    var20_17 = null;
                                    if (var17_14 && !var18_16) {
                                        var3_3.remove(var12_10);
                                    }
                                    throw var19_20;
                                }
                                var22_18 = null;
                                break block20;
lbl-1000:
                                // 1 sources

                                {
                                    var20_17 = null;
                                    if (!var17_14 || var18_16) break block21;
                                    var3_3.remove(var12_10);
                                    break block21;
                                }
                            }
                            catch (IOException var17_15) {
                                RepositoryUpdater.access$1400().log(Level.WARNING, null, var17_15);
                                var22_18 = null;
                                var23_19 = System.currentTimeMillis() - var13_11;
                                var6_5 += var23_19;
                                ++var4_4;
                                var8_6 += var15_12[0];
                                var9_7 += var16_13[0];
                                if (RepositoryUpdater.access$3600()) {
                                    AbstractRootsWork.reportRootScan(var12_10, var23_19);
                                }
                                if (!RepositoryUpdater.access$1400().isLoggable(Level.INFO)) continue;
                                RepositoryUpdater.access$1400().info(String.format("Indexing of: %s took: %d ms (New or modified files: %d, Deleted files: %d)", new Object[]{var12_10.toExternalForm(), var23_19, var15_12[0], var16_13[0]}));
                                continue;
                            }
                        }
                        catch (Throwable var21_21) {
                            var22_18 = null;
                            var23_19 = System.currentTimeMillis() - var13_11;
                            var6_5 += var23_19;
                            ++var4_4;
                            var8_6 += var15_12[0];
                            var9_7 += var16_13[0];
                            if (RepositoryUpdater.access$3600()) {
                                AbstractRootsWork.reportRootScan(var12_10, var23_19);
                            }
                            if (RepositoryUpdater.access$1400().isLoggable(Level.INFO)) {
                                RepositoryUpdater.access$1400().info(String.format("Indexing of: %s took: %d ms (New or modified files: %d, Deleted files: %d)", new Object[]{var12_10.toExternalForm(), var23_19, var15_12[0], var16_13[0]}));
                            }
                            throw var21_21;
                        }
                    }
                    var23_19 = System.currentTimeMillis() - var13_11;
                    var6_5 += var23_19;
                    ++var4_4;
                    var8_6 += var15_12[0];
                    var9_7 += var16_13[0];
                    if (RepositoryUpdater.access$3600()) {
                        AbstractRootsWork.reportRootScan(var12_10, var23_19);
                    }
                    if (!RepositoryUpdater.access$1400().isLoggable(Level.INFO)) break;
                    RepositoryUpdater.access$1400().info(String.format("Indexing of: %s took: %d ms (New or modified files: %d, Deleted files: %d)", new Object[]{var12_10.toExternalForm(), var23_19, var15_12[0], var16_13[0]}));
                    break;
                }
                var22_18 = null;
                var23_19 = System.currentTimeMillis() - var13_11;
                var6_5 += var23_19;
                ++var4_4;
                var8_6 += var15_12[0];
                var9_7 += var16_13[0];
                if (RepositoryUpdater.access$3600()) {
                    AbstractRootsWork.reportRootScan(var12_10, var23_19);
                }
                if (!RepositoryUpdater.access$1400().isLoggable(Level.INFO)) continue;
                RepositoryUpdater.access$1400().info(String.format("Indexing of: %s took: %d ms (New or modified files: %d, Deleted files: %d)", new Object[]{var12_10.toExternalForm(), var23_19, var15_12[0], var16_13[0]}));
            }
            if (RepositoryUpdater.access$1400().isLoggable(Level.INFO)) {
                RepositoryUpdater.access$1400().info(String.format("Complete indexing of %d source roots took: %d ms (New or modified files: %d, Deleted files: %d)", new Object[]{var4_4, var6_5, var8_6, var9_7}));
            }
            RepositoryUpdater.access$2200().log(Level.FINEST, "scanSources", DependenciesContext.access$2300(var1_1));
            return var10_8;
        }

        private static boolean isNoRootsScan() {
            return Boolean.getBoolean("netbeans.indexing.noRootsScan");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean scanSource(URL uRL, boolean bl, boolean bl2, Indexers indexers, int[] nArray, int[] nArray2) throws IOException {
            block17: {
                LOGGER.log(Level.FINE, "Scanning sources root: {0}", uRL);
                if (!AbstractRootsWork.isNoRootsScan() || bl || !TimeStamps.existForRoot(uRL)) break block17;
                LinkedList linkedList = new LinkedList();
                try {
                    FileObject fileObject = CacheFolder.getDataFolder(uRL);
                    for (IndexerCache.IndexerInfo<CustomIndexerFactory> indexerInfo : indexers.cifInfos) {
                        CustomIndexerFactory customIndexerFactory = indexerInfo.getIndexerFactory();
                        Context context = SPIAccessor.getInstance().createContext(fileObject, uRL, customIndexerFactory.getIndexerName(), customIndexerFactory.getIndexVersion(), null, this.isFollowUpJob(), this.hasToCheckEditor(), bl2, null);
                        CustomIndexer customIndexer = customIndexerFactory.createIndexer();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Fake indexing: indexer=" + customIndexer);
                        }
                        try {
                            SPIAccessor.getInstance().index(customIndexer, Collections.emptySet(), context);
                        }
                        catch (ThreadDeath threadDeath) {
                            throw threadDeath;
                        }
                        catch (Throwable throwable) {
                            LOGGER.log(Level.WARNING, null, throwable);
                        }
                    }
                    Object var16_24 = null;
                }
                catch (Throwable throwable) {
                    Object var16_25 = null;
                    for (Context context : linkedList) {
                        IndexImpl indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                        if (indexImpl == null) continue;
                        indexImpl.store(this.isSteady(), null);
                    }
                    throw throwable;
                }
                for (Context context : linkedList) {
                    IndexImpl indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                    if (indexImpl == null) continue;
                    indexImpl.store(this.isSteady(), null);
                }
                return true;
            }
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null) {
                ClassPath.Entry entry = bl2 ? null : RepositoryUpdater.getClassPathEntry(fileObject);
                FileObjectCrawler fileObjectCrawler = new FileObjectCrawler(fileObject, !bl, entry, this.getShuttdownRequest());
                Collection<IndexableImpl> collection = fileObjectCrawler.getResources();
                Collection<IndexableImpl> collection2 = fileObjectCrawler.getAllResources();
                Collection<IndexableImpl> collection3 = fileObjectCrawler.getDeletedResources();
                if (fileObjectCrawler.isFinished()) {
                    IdentityHashMap<SourceIndexerFactory, Context> identityHashMap;
                    block16: {
                        boolean bl3;
                        IdentityHashMap<SourceIndexerFactory, Boolean> identityHashMap2 = new IdentityHashMap<SourceIndexerFactory, Boolean>();
                        identityHashMap = new IdentityHashMap<SourceIndexerFactory, Context>();
                        this.scanStarted(uRL, bl2, indexers, identityHashMap2, identityHashMap);
                        try {
                            this.delete(collection3, uRL);
                            if (!this.index(collection, collection2, uRL, bl2, indexers, identityHashMap2)) break block16;
                            fileObjectCrawler.storeTimestamps();
                            nArray[0] = collection.size();
                            nArray2[0] = collection3.size();
                            if (this.logStatistics) {
                                this.logStatistics = false;
                                if (SFEC_LOGGER.isLoggable(Level.INFO)) {
                                    LogRecord logRecord = new LogRecord(Level.INFO, "STATS_SCAN_SOURCES");
                                    logRecord.setParameters(new Object[]{nArray[0] > 0 || nArray2[0] > 0});
                                    logRecord.setResourceBundle(NbBundle.getBundle(RepositoryUpdater.class));
                                    logRecord.setResourceBundleName(RepositoryUpdater.class.getPackage().getName() + ".Bundle");
                                    logRecord.setLoggerName(SFEC_LOGGER.getName());
                                    SFEC_LOGGER.log(logRecord);
                                }
                            }
                            this.invalidateSources(collection);
                            bl3 = true;
                            Object var21_35 = null;
                        }
                        catch (Throwable throwable) {
                            Object var21_37 = null;
                            this.scanFinished(identityHashMap);
                            throw throwable;
                        }
                        this.scanFinished(identityHashMap);
                        return bl3;
                    }
                    Object var21_36 = null;
                    this.scanFinished(identityHashMap);
                    {
                    }
                }
                return false;
            }
            return true;
        }

        private static void reportRootScan(URL uRL, long l) {
            try {
                Class<?> clazz = Class.forName("org.netbeans.performance.test.utilities.LoggingScanClasspath", true, Thread.currentThread().getContextClassLoader());
                Method method = clazz.getMethod("reportScanOfFile", String.class, Long.class);
                method.invoke(clazz.newInstance(), uRL.toExternalForm(), new Long(l));
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, null, exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootsWork
    extends AbstractRootsWork {
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Map<URL, List<URL>> scannedBinaries2InvDependencies;
        private final Set<URL> sourcesForBinaryRoots;
        private boolean useInitialState;
        private DependenciesContext depCtx;
        protected Indexers indexers = null;

        public RootsWork(Map<URL, List<URL>> map, Map<URL, List<URL>> map2, Set<URL> set, boolean bl) {
            super(false);
            this.scannedRoots2Dependencies = map;
            this.scannedBinaries2InvDependencies = map2;
            this.sourcesForBinaryRoots = set;
            this.useInitialState = bl;
        }

        @Override
        public String toString() {
            return super.toString() + ", useInitialState=" + this.useInitialState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getDone() {
            boolean bl;
            Object object;
            Object object2;
            if (this.isCancelled()) {
                return false;
            }
            this.updateProgress(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_ProjectDependencies"));
            long l = System.currentTimeMillis();
            if (this.depCtx == null) {
                Object object3;
                this.depCtx = new DependenciesContext(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, this.useInitialState);
                LinkedList<? extends URL> linkedList = new LinkedList<URL>();
                object2 = PathRegistry.getDefault().getSources();
                LOGGER.log(Level.FINE, "PathRegistry.sources=");
                RepositoryUpdater.printCollection((Collection<? extends URL>)object2, Level.FINE);
                linkedList.addAll((Collection<? extends URL>)object2);
                object2 = PathRegistry.getDefault().getLibraries();
                LOGGER.log(Level.FINE, "PathRegistry.libraries=");
                RepositoryUpdater.printCollection((Collection<? extends URL>)object2, Level.FINE);
                linkedList.addAll((Collection<? extends URL>)object2);
                this.depCtx.newBinariesToScan.addAll(PathRegistry.getDefault().getBinaryLibraries());
                Object object4 = this.depCtx.newBinariesToScan.iterator();
                while (object4.hasNext()) {
                    if (!this.depCtx.oldBinaries.remove(object4.next())) continue;
                    object4.remove();
                }
                if (this.useInitialState) {
                    object2 = PathRegistry.getDefault().getUnknownRoots();
                    LOGGER.log(Level.FINE, "PathRegistry.unknown=");
                    RepositoryUpdater.printCollection((Collection<? extends URL>)object2, Level.FINE);
                    linkedList.addAll((Collection<? extends URL>)object2);
                }
                object4 = linkedList.iterator();
                while (object4.hasNext()) {
                    object = (URL)object4.next();
                    if (RepositoryUpdater.findDependencies((URL)object, this.depCtx, null, null, this.getShuttdownRequest())) continue;
                    this.depCtx = null;
                    return false;
                }
                object = object4 = (Controller)IndexingController.getDefault();
                synchronized (object) {
                    ((Controller)object4).roots2Dependencies = Collections.unmodifiableMap(this.depCtx.newRoots2Deps);
                    ((Controller)object4).binRoots2Dependencies = Collections.unmodifiableMap(this.depCtx.newBinaries2InvDeps);
                }
                try {
                    this.depCtx.newRootsToScan.addAll(org.openide.util.Utilities.topologicalSort(this.depCtx.newRoots2Deps.keySet(), (Map)this.depCtx.newRoots2Deps));
                }
                catch (TopologicalSortException topologicalSortException) {
                    LOGGER.log(Level.INFO, "Cycles detected in classpath roots dependencies, using partial ordering", topologicalSortException);
                    object3 = topologicalSortException.partialSort();
                    this.depCtx.newRootsToScan.addAll(object3);
                }
                Collections.reverse(this.depCtx.newRootsToScan);
                if (!this.useInitialState) {
                    object = new HashMap();
                    object3 = new HashMap();
                    RootsWork.diff(this.depCtx.initialRoots2Deps, this.depCtx.newRoots2Deps, object3, object);
                    Level level = Level.FINE;
                    if (LOGGER.isLoggable(level) && (object3.size() > 0 || object.size() > 0)) {
                        LOGGER.log(level, "Changes in dependencies detected:");
                        LOGGER.log(level, "initialRoots2Deps({0})=", this.depCtx.initialRoots2Deps.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)this.depCtx.initialRoots2Deps, level);
                        LOGGER.log(level, "newRoots2Deps({0})=", this.depCtx.newRoots2Deps.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)this.depCtx.newRoots2Deps, level);
                        LOGGER.log(level, "addedOrChanged({0})=", object3.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)((Map)object3), level);
                        LOGGER.log(level, "removed({0})=", object.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)((Map)object), level);
                    }
                    this.depCtx.oldRoots.clear();
                    this.depCtx.oldRoots.addAll(object.keySet());
                    this.depCtx.newRootsToScan.retainAll(object3.keySet());
                    this.depCtx.fullRescanSourceRoots = this.depCtx.newRoots2Deps.keySet();
                    HashMap hashMap = new HashMap();
                    HashMap hashMap2 = new HashMap();
                    RootsWork.diff(this.depCtx.initialBinaries2InvDeps, this.depCtx.newBinaries2InvDeps, hashMap, hashMap2);
                    if (LOGGER.isLoggable(level) && (hashMap.size() > 0 || hashMap2.size() > 0)) {
                        LOGGER.log(level, "Changes in binary dependencies detected:");
                        LOGGER.log(level, "initialBinaries2InvDeps({0})=", this.depCtx.initialBinaries2InvDeps.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)this.depCtx.initialBinaries2InvDeps, level);
                        LOGGER.log(level, "newBinaries2InvDeps({0})=", this.depCtx.newBinaries2InvDeps.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)this.depCtx.newBinaries2InvDeps, level);
                        LOGGER.log(level, "adderOrChangedBin({0})=", hashMap.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)hashMap, level);
                        LOGGER.log(level, "removedBin({0})=", hashMap2.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)hashMap2, level);
                    }
                    HashSet hashSet = new HashSet();
                    for (Map.Entry object5 : hashMap.entrySet()) {
                        List list = (List)this.depCtx.initialBinaries2InvDeps.get(object5.getKey());
                        List list2 = (List)object5.getValue();
                        if (list == null) {
                            hashSet.addAll(list2);
                            continue;
                        }
                        RootsWork.diff(list, list2, hashSet, hashSet);
                    }
                    for (List list : hashMap2.values()) {
                        hashSet.addAll(list);
                    }
                    for (URL uRL : hashSet) {
                        if (this.depCtx.newRootsToScan.contains(uRL)) continue;
                        this.depCtx.newRootsToScan.add(uRL);
                    }
                }
            } else {
                this.depCtx.newRootsToScan.removeAll(this.depCtx.scannedRoots);
                this.depCtx.scannedRoots.clear();
                this.depCtx.newBinariesToScan.removeAll(this.depCtx.scannedBinaries);
                this.depCtx.scannedBinaries.clear();
                this.depCtx.oldBinaries.clear();
                this.depCtx.oldRoots.clear();
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Resolving dependencies took: {0} ms", System.currentTimeMillis() - l);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Running " + this + " on \n" + this.depCtx.toString());
            }
            if (bl = this.scanBinaries(this.depCtx)) {
                bl = this.scanSources(this.depCtx, this.indexers, this.scannedRoots2Dependencies);
            }
            for (Object object4 : this.depCtx.scannedRoots) {
                object = (List)this.depCtx.newRoots2Deps.get(object4);
                this.scannedRoots2Dependencies.put((URL)object4, (List<URL>)object);
            }
            this.scannedRoots2Dependencies.keySet().removeAll(this.depCtx.oldRoots);
            BinaryPathNotifier.getDefault().unregisterRoots(this.depCtx.oldBinaries);
            BinaryPathNotifier.getDefault().registerRoots(this.depCtx.scannedBinaries);
            for (Object object4 : this.depCtx.scannedBinaries) {
                object = (List)this.depCtx.newBinaries2InvDeps.get(object4);
                if (object == null) {
                    object = EMPTY_DEPS;
                }
                this.scannedBinaries2InvDependencies.put((URL)object4, (List<URL>)object);
            }
            this.scannedBinaries2InvDependencies.keySet().removeAll(this.depCtx.oldBinaries);
            this.notifyRootsRemoved(this.depCtx.oldBinaries, this.depCtx.oldRoots);
            object2 = Level.FINE;
            if (LOGGER.isLoggable((Level)object2)) {
                LOGGER.log((Level)object2, this + " " + (this.isCancelled() ? "cancelled" : "finished") + ": {");
                LOGGER.log((Level)object2, "  scannedRoots2Dependencies(" + this.scannedRoots2Dependencies.size() + ")=");
                RepositoryUpdater.printMap((Map<URL, List<URL>>)this.scannedRoots2Dependencies, (Level)object2);
                LOGGER.log((Level)object2, "  scannedBinaries(" + this.scannedBinaries2InvDependencies.size() + ")=");
                RepositoryUpdater.printCollection((Collection<? extends URL>)this.scannedBinaries2InvDependencies.keySet(), (Level)object2);
                LOGGER.log((Level)object2, "} ====");
            }
            this.refreshActiveDocument();
            return bl;
        }

        @Override
        protected boolean isCancelledBy(Work work) {
            boolean bl;
            boolean bl2 = bl = work instanceof RootsWork && this.useInitialState;
            if (bl && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cancelling " + this + ", because of " + work);
            }
            return bl;
        }

        @Override
        public boolean absorb(Work work) {
            if (work.getClass().equals(RootsWork.class)) {
                if (!((RootsWork)work).useInitialState) {
                    this.useInitialState = ((RootsWork)work).useInitialState;
                    LOGGER.fine("Absorbing " + work + ", updating useInitialState to " + this.useInitialState);
                }
                return true;
            }
            return false;
        }

        private void notifyRootsRemoved(Set<URL> set, Set<URL> set2) {
            Collection<Object> collection;
            Set<URL> set3;
            if (!set.isEmpty()) {
                set3 = MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookupAll(BinaryIndexerFactory.class);
                collection = Collections.unmodifiableSet(set);
                for (BinaryIndexerFactory iterator2 : set3) {
                    iterator2.rootsRemoved(collection);
                }
            }
            if (!set2.isEmpty()) {
                set3 = Collections.unmodifiableSet(set2);
                collection = IndexerCache.getCifCache().getIndexers(null);
                for (IndexerCache.IndexerInfo indexerInfo : collection) {
                    ((CustomIndexerFactory)indexerInfo.getIndexerFactory()).rootsRemoved(set3);
                }
                Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> collection2 = IndexerCache.getEifCache().getIndexers(null);
                Iterator iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    IndexerCache.IndexerInfo indexerInfo = (IndexerCache.IndexerInfo)iterator.next();
                    ((EmbeddingIndexerFactory)indexerInfo.getIndexerFactory()).rootsRemoved(set3);
                }
            }
        }

        private static <A, B> void diff(Map<A, B> map, Map<A, B> map2, Map<A, B> map3, Map<A, B> map4) {
            for (A a : map.keySet()) {
                if (!map2.containsKey(a)) {
                    map4.put(a, map.get(a));
                    continue;
                }
                if (org.openide.util.Utilities.compareObjects(map.get(a), map2.get(a))) continue;
                map3.put(a, map2.get(a));
            }
            for (A a : map2.keySet()) {
                if (map.containsKey(a)) continue;
                map3.put(a, map2.get(a));
            }
        }

        private static <T> void diff(List<T> list, List<T> list2, Collection<? super T> collection, Collection<? super T> collection2) {
            HashSet<T> hashSet = new HashSet<T>(list);
            HashSet<T> hashSet2 = new HashSet<T>(list2);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                iterator.remove();
                if (hashSet2.remove(e)) continue;
                collection2.add(e);
            }
            collection.addAll(hashSet2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RefreshWork
    extends AbstractRootsWork {
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Map<URL, List<URL>> scannedBinaries2InvDependencies;
        private final Set<URL> sourcesForBinaryRoots;
        private final Set<Pair<Object, Boolean>> suspectFilesOrFileObjects;
        private final FSRefreshInterceptor interceptor;
        private DependenciesContext depCtx;
        private Map<URL, Set<FileObject>> fullRescanFiles;
        private Map<URL, Set<FileObject>> checkTimestampFiles;

        public RefreshWork(Map<URL, List<URL>> map, Map<URL, List<URL>> map2, Set<URL> set, boolean bl, boolean bl2, Collection<? extends Object> collection, FSRefreshInterceptor fSRefreshInterceptor) {
            super(bl2);
            Parameters.notNull((CharSequence)"scannedRoots2Depencencies", map);
            Parameters.notNull((CharSequence)"scannedBinaries2InvDependencies", map2);
            Parameters.notNull((CharSequence)"sourcesForBinaryRoots", set);
            Parameters.notNull((CharSequence)"interceptor", (Object)fSRefreshInterceptor);
            this.scannedRoots2Dependencies = map;
            this.scannedBinaries2InvDependencies = map2;
            this.sourcesForBinaryRoots = set;
            this.suspectFilesOrFileObjects = new HashSet<Pair<Object, Boolean>>();
            if (collection != null) {
                this.addSuspects(collection, bl);
            }
            this.interceptor = fSRefreshInterceptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean getDone() {
            Object object;
            if (this.depCtx == null) {
                Object object2;
                this.depCtx = new DependenciesContext(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.sourcesForBinaryRoots, false);
                if (this.suspectFilesOrFileObjects.size() == 0) {
                    this.depCtx.newBinariesToScan.addAll(this.scannedBinaries2InvDependencies.keySet());
                    try {
                        this.depCtx.newRootsToScan.addAll(org.openide.util.Utilities.topologicalSort(this.scannedRoots2Dependencies.keySet(), this.scannedRoots2Dependencies));
                    }
                    catch (TopologicalSortException topologicalSortException) {
                        LOGGER.log(Level.INFO, "Cycles detected in classpath roots dependencies, using partial ordering", topologicalSortException);
                        object = topologicalSortException.partialSort();
                        this.depCtx.newRootsToScan.addAll(object);
                    }
                    Collections.reverse(this.depCtx.newRootsToScan);
                } else {
                    Set<Object> set;
                    Object object3;
                    Object object4;
                    object2 = new HashSet();
                    for (Pair<Object, Boolean> object52 : this.suspectFilesOrFileObjects) {
                        Iterator<Object> iterator = null;
                        if (object52.first instanceof File) {
                            FileObject fileObject = FileUtil.toFileObject((File)((File)object52.first));
                            if (fileObject != null) {
                                iterator = Pair.of(fileObject, object52.second);
                            }
                        } else if (object52.first instanceof FileObject) {
                            iterator = Pair.of((FileObject)object52.first, object52.second);
                        } else {
                            LOGGER.fine("Not File or FileObject, ignoring: " + object52);
                        }
                        if (iterator == null) continue;
                        object2.add(iterator);
                    }
                    object = object2.iterator();
                    block7: while (object.hasNext()) {
                        Pair pair = (Pair)object.next();
                        for (URL uRL : this.scannedBinaries2InvDependencies.keySet()) {
                            object4 = FileUtil.archiveOrDirForURL((URL)uRL);
                            if (object4 != null && (object3 = FileUtil.toFileObject((File)object4)) != null && (pair.first == object3 || FileUtil.isParentOf((FileObject)((FileObject)pair.first), (FileObject)object3))) {
                                this.depCtx.newBinariesToScan.add(uRL);
                                continue block7;
                            }
                            object3 = URLCache.getInstance().findFileObject(uRL);
                            if (object3 == null || pair.first != object3 && !FileUtil.isParentOf((FileObject)object3, (FileObject)((FileObject)pair.first))) continue;
                            this.depCtx.newBinariesToScan.add(uRL);
                            continue block7;
                        }
                    }
                    object = new HashSet();
                    HashMap hashMap = new HashMap();
                    for (URL uRL : this.scannedRoots2Dependencies.keySet()) {
                        object4 = URLCache.getInstance().findFileObject(uRL);
                        if (object4 == null) continue;
                        object3 = object2.iterator();
                        while (object3.hasNext()) {
                            set = (Pair)object3.next();
                            if (((Pair)((Object)set)).first != object4 && !FileUtil.isParentOf((FileObject)((FileObject)((Pair)((Object)set)).first), (FileObject)object4)) continue;
                            Pair<Object, Object> pair = (Pair)hashMap.get(uRL);
                            pair = pair == null ? Pair.of(object4, ((Pair)((Object)set)).second) : Pair.of(object4, (Boolean)pair.second != false || (Boolean)((Pair)((Object)set)).second != false);
                            hashMap.put(uRL, pair);
                            object.add(set);
                        }
                    }
                    object2.removeAll((Collection<?>)object);
                    for (Map.Entry entry : hashMap.entrySet()) {
                        object4 = object2.iterator();
                        while (object4.hasNext()) {
                            object3 = (Pair)object4.next();
                            set = (Pair)entry.getValue();
                            if (!FileUtil.isParentOf((FileObject)((FileObject)((Pair)((Object)set)).first), (FileObject)((FileObject)((Pair)object3).first)) || !((Boolean)((Pair)((Object)set)).second).booleanValue() && ((Boolean)((Pair)object3).second).booleanValue()) continue;
                            object4.remove();
                        }
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.depCtx.newRootsToScan.add(entry.getKey());
                        if (!((Boolean)((Pair)entry.getValue()).second).booleanValue()) continue;
                        this.depCtx.fullRescanSourceRoots.add(entry.getKey());
                    }
                    this.fullRescanFiles = new HashMap<URL, Set<FileObject>>();
                    this.checkTimestampFiles = new HashMap<URL, Set<FileObject>>();
                    object = object2.iterator();
                    block14: while (object.hasNext()) {
                        Pair pair = (Pair)object.next();
                        for (URL uRL : this.scannedRoots2Dependencies.keySet()) {
                            object4 = URLCache.getInstance().findFileObject(uRL);
                            if (object4 == null || pair.first != object4 && !FileUtil.isParentOf((FileObject)object4, (FileObject)((FileObject)pair.first))) continue;
                            object3 = (Boolean)pair.second != false ? this.fullRescanFiles : this.checkTimestampFiles;
                            set = (Set)object3.get(uRL);
                            if (set == null) {
                                set = new HashSet();
                                object3.put(uRL, set);
                            }
                            set.add(pair.first);
                            continue block14;
                        }
                    }
                }
                object2 = new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        FileUtil.refreshAll();
                    }
                };
                this.interceptor.setIgnoreFsEvents(true);
                try {
                    try {
                        FileUtil.runAtomicAction((FileSystem.AtomicAction)object2);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, null, iOException);
                        Object var11_29 = null;
                        this.interceptor.setIgnoreFsEvents(false);
                    }
                    Object var11_28 = null;
                    this.interceptor.setIgnoreFsEvents(false);
                }
                catch (Throwable throwable) {
                    Object var11_30 = null;
                    this.interceptor.setIgnoreFsEvents(false);
                    throw throwable;
                }
            } else {
                this.depCtx.newRootsToScan.removeAll(this.depCtx.scannedRoots);
                this.depCtx.scannedRoots.clear();
                this.depCtx.newBinariesToScan.removeAll(this.depCtx.scannedBinaries);
                this.depCtx.scannedBinaries.clear();
            }
            boolean bl = this.scanBinaries(this.depCtx);
            if (bl && (bl = this.scanSources(this.depCtx, null, null)) && (bl = this.scanRootFiles(this.fullRescanFiles))) {
                bl = this.scanRootFiles(this.checkTimestampFiles);
            }
            object = Level.FINE;
            if (LOGGER.isLoggable((Level)object)) {
                LOGGER.log((Level)object, this + " " + (this.isCancelled() ? "cancelled" : "finished") + ": {");
                LOGGER.log((Level)object, "  scannedRoots2Dependencies(" + this.scannedRoots2Dependencies.size() + ")=");
                RepositoryUpdater.printMap((Map<URL, List<URL>>)this.scannedRoots2Dependencies, object);
                LOGGER.log((Level)object, "  scannedBinaries(" + this.scannedBinaries2InvDependencies.size() + ")=");
                RepositoryUpdater.printCollection((Collection<? extends URL>)this.scannedBinaries2InvDependencies.keySet(), (Level)object);
                LOGGER.log((Level)object, "} ====");
            }
            this.refreshActiveDocument();
            return bl;
        }

        @Override
        public boolean absorb(Work work) {
            if (work instanceof RefreshWork) {
                this.suspectFilesOrFileObjects.addAll(((RefreshWork)work).suspectFilesOrFileObjects);
                return true;
            }
            if (work instanceof FileListWork) {
                FileListWork fileListWork = (FileListWork)work;
                if (fileListWork.files.isEmpty()) {
                    this.suspectFilesOrFileObjects.add(Pair.of(URLCache.getInstance().findFileObject(fileListWork.root), fileListWork.forceRefresh));
                } else {
                    this.addSuspects(fileListWork.files, fileListWork.forceRefresh);
                }
                return true;
            }
            if (work instanceof DeleteWork) {
                this.suspectFilesOrFileObjects.add(Pair.of(URLCache.getInstance().findFileObject(((DeleteWork)work).root), false));
                return true;
            }
            return false;
        }

        public void addSuspects(Collection<? extends Object> collection, boolean bl) {
            for (Object object : collection) {
                this.suspectFilesOrFileObjects.add(Pair.of(object, bl));
            }
        }

        private boolean scanRootFiles(Map<URL, Set<FileObject>> map) {
            if (map != null && map.size() > 0) {
                Iterator<Map.Entry<URL, Set<FileObject>>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<URL, Set<FileObject>> entry = iterator.next();
                    URL uRL = entry.getKey();
                    if (this.scanFiles(uRL, (Collection<FileObject>)entry.getValue(), true, this.sourcesForBinaryRoots.contains(uRL))) {
                        iterator.remove();
                        continue;
                    }
                    return false;
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + ", suspectFilesOrFileObjects=" + this.suspectFilesOrFileObjects;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RefreshEifIndices
    extends Work {
        private final Collection<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos;
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Set<URL> sourcesForBinaryRoots;

        public RefreshEifIndices(Collection<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> collection, Map<URL, List<URL>> map, Set<URL> set) {
            super(false, false, NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_RefreshingIndices"), true);
            this.eifInfos = collection;
            this.scannedRoots2Dependencies = map;
            this.sourcesForBinaryRoots = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean getDone() {
            Iterator<URL> iterator = this.scannedRoots2Dependencies.keySet().iterator();
            while (iterator.hasNext()) {
                URL uRL = iterator.next();
                if (this.getShuttdownRequest().isRaised()) {
                    return true;
                }
                this.updateProgress(uRL);
                try {
                    IndexImpl indexImpl;
                    Object var24_24;
                    LinkedList<HashSet<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>> linkedList;
                    LinkedList<Context> linkedList2;
                    FileObjectCrawler fileObjectCrawler;
                    block21: {
                        boolean bl;
                        block20: {
                            boolean bl2;
                            block19: {
                                FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                                if (fileObject == null) continue;
                                boolean bl3 = this.sourcesForBinaryRoots.contains(uRL);
                                ClassPath.Entry entry = bl3 ? null : RepositoryUpdater.getClassPathEntry(fileObject);
                                fileObjectCrawler = new FileObjectCrawler(fileObject, false, entry, this.getShuttdownRequest());
                                Collection<IndexableImpl> collection = fileObjectCrawler.getResources();
                                Collection<IndexableImpl> collection2 = fileObjectCrawler.getDeletedResources();
                                if (!fileObjectCrawler.isFinished()) continue;
                                if (collection2.size() > 0) {
                                    this.delete(collection2, uRL);
                                }
                                linkedList2 = new LinkedList<Context>();
                                linkedList = new LinkedList<HashSet<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>>();
                                try {
                                    Iterable<Object> iterable;
                                    HashMap<String, Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>> hashMap = new HashMap<String, Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>>();
                                    for (IndexerCache.IndexerInfo<EmbeddingIndexerFactory> indexerInfo : this.eifInfos) {
                                        for (String string : indexerInfo.getMimeTypes()) {
                                            iterable = (HashSet<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>)hashMap.get(string);
                                            if (iterable == null) {
                                                iterable = new HashSet<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>();
                                                hashMap.put(string, (Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>)iterable);
                                            }
                                            iterable.add(indexerInfo);
                                        }
                                    }
                                    ClusteredIndexables clusteredIndexables = new ClusteredIndexables(collection);
                                    FileObject fileObject2 = CacheFolder.getDataFolder(uRL);
                                    for (String string : Util.getAllMimeTypes()) {
                                        if (this.getShuttdownRequest().isRaised()) {
                                            bl2 = false;
                                            var24_24 = null;
                                            break block19;
                                        }
                                        if (!Util.canBeParsed(string)) continue;
                                        iterable = clusteredIndexables.getIndexablesFor(string);
                                        linkedList.add((HashSet<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>)iterable);
                                        long l = System.currentTimeMillis();
                                        boolean bl4 = this.indexEmbedding(hashMap, fileObject2, uRL, iterable, linkedList2, bl3);
                                        long l2 = System.currentTimeMillis();
                                        if (!bl4) {
                                            bl = false;
                                            break block20;
                                        }
                                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                                        LOGGER.fine("Indexing " + string + " embeddables under " + uRL + "; took " + (l2 - l) + "ms");
                                    }
                                    break block21;
                                }
                                catch (Throwable throwable) {
                                    var24_24 = null;
                                    Iterator iterator2 = linkedList2.iterator();
                                    while (true) {
                                        if (!iterator2.hasNext()) {
                                            throw throwable;
                                        }
                                        Context context = (Context)iterator2.next();
                                        indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                                        if (indexImpl == null) continue;
                                        indexImpl.store(this.isSteady(), new ProxyIterable<Indexable>(linkedList, false));
                                    }
                                }
                            }
                            for (Context context : linkedList2) {
                                indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                                if (indexImpl == null) continue;
                                indexImpl.store(this.isSteady(), new ProxyIterable<Indexable>(linkedList, false));
                            }
                            return bl2;
                        }
                        var24_24 = null;
                        for (Context context : linkedList2) {
                            indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                            if (indexImpl == null) continue;
                            indexImpl.store(this.isSteady(), new ProxyIterable<Indexable>(linkedList, false));
                        }
                        return bl;
                    }
                    var24_24 = null;
                    for (Context context : linkedList2) {
                        indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                        if (indexImpl == null) continue;
                        indexImpl.store(this.isSteady(), new ProxyIterable<Indexable>(linkedList, false));
                    }
                    fileObjectCrawler.storeTimestamps();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, null, iOException);
                    continue;
                }
                break;
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> iterator = this.eifInfos.iterator();
            while (iterator.hasNext()) {
                IndexerCache.IndexerInfo<EmbeddingIndexerFactory> indexerInfo = iterator.next();
                stringBuilder.append(" indexer=").append(indexerInfo.getIndexerName()).append('/').append(indexerInfo.getIndexerVersion());
                stringBuilder.append(" (");
                RepositoryUpdater.printMimeTypes(indexerInfo.getMimeTypes(), stringBuilder);
                stringBuilder.append(')');
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            return super.toString() + stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RefreshCifIndices
    extends Work {
        private final Collection<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos;
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Set<URL> sourcesForBinaryRoots;

        public RefreshCifIndices(Collection<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> collection, Map<URL, List<URL>> map, Set<URL> set) {
            super(false, false, NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_RefreshingIndices"), true);
            this.cifInfos = collection;
            this.scannedRoots2Dependencies = map;
            this.sourcesForBinaryRoots = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean getDone() {
            Iterator<URL> iterator = this.scannedRoots2Dependencies.keySet().iterator();
            while (iterator.hasNext()) {
                URL uRL = iterator.next();
                if (this.getShuttdownRequest().isRaised()) {
                    return true;
                }
                this.updateProgress(uRL);
                try {
                    IndexImpl indexImpl;
                    Object var22_27;
                    LinkedList linkedList;
                    LinkedList<Context> linkedList2;
                    FileObjectCrawler fileObjectCrawler;
                    block20: {
                        boolean bl;
                        block19: {
                            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                            if (fileObject == null) continue;
                            boolean bl2 = this.sourcesForBinaryRoots.contains(uRL);
                            ClassPath.Entry entry = bl2 ? null : RepositoryUpdater.getClassPathEntry(fileObject);
                            fileObjectCrawler = new FileObjectCrawler(fileObject, false, entry, this.getShuttdownRequest());
                            Collection<IndexableImpl> collection = fileObjectCrawler.getResources();
                            Collection<IndexableImpl> collection2 = fileObjectCrawler.getDeletedResources();
                            if (!fileObjectCrawler.isFinished()) continue;
                            if (collection2.size() > 0) {
                                this.delete(collection2, uRL);
                            }
                            linkedList2 = new LinkedList<Context>();
                            linkedList = new LinkedList();
                            try {
                                ClusteredIndexables clusteredIndexables = new ClusteredIndexables(collection);
                                for (IndexerCache.IndexerInfo<CustomIndexerFactory> indexerInfo : this.cifInfos) {
                                    LinkedList<Iterable<Indexable>> linkedList3 = new LinkedList<Iterable<Indexable>>();
                                    for (String string : indexerInfo.getMimeTypes()) {
                                        linkedList3.add(clusteredIndexables.getIndexablesFor(string));
                                    }
                                    ProxyIterable proxyIterable = new ProxyIterable(linkedList3);
                                    linkedList.addAll(linkedList3);
                                    if (this.getShuttdownRequest().isRaised()) {
                                        bl = false;
                                        var22_27 = null;
                                        break block19;
                                    }
                                    CustomIndexerFactory customIndexerFactory = indexerInfo.getIndexerFactory();
                                    FileObject fileObject2 = CacheFolder.getDataFolder(uRL);
                                    Context context = SPIAccessor.getInstance().createContext(fileObject2, uRL, customIndexerFactory.getIndexerName(), customIndexerFactory.getIndexVersion(), null, false, false, bl2, this.getShuttdownRequest());
                                    SPIAccessor.getInstance().setAllFilesJob(context, true);
                                    linkedList2.add(context);
                                    CustomIndexer customIndexer = customIndexerFactory.createIndexer();
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        StringBuilder stringBuilder = RepositoryUpdater.printMimeTypes(indexerInfo.getMimeTypes(), new StringBuilder());
                                        LOGGER.fine("Reindexing " + uRL + " using " + customIndexer + "; mimeTypes=" + stringBuilder.toString());
                                    }
                                    try {
                                        SPIAccessor.getInstance().index(customIndexer, proxyIterable, context);
                                    }
                                    catch (ThreadDeath threadDeath) {
                                        throw threadDeath;
                                    }
                                    catch (Throwable throwable) {
                                        LOGGER.log(Level.WARNING, null, throwable);
                                    }
                                }
                                break block20;
                            }
                            catch (Throwable throwable) {
                                var22_27 = null;
                                Iterator iterator2 = linkedList2.iterator();
                                while (true) {
                                    if (!iterator2.hasNext()) {
                                        throw throwable;
                                    }
                                    Context context = (Context)iterator2.next();
                                    indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                                    if (indexImpl == null) continue;
                                    indexImpl.store(this.isSteady(), new ProxyIterable<Indexable>(linkedList, false));
                                }
                            }
                        }
                        for (Context context : linkedList2) {
                            indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                            if (indexImpl == null) continue;
                            indexImpl.store(this.isSteady(), new ProxyIterable<Indexable>(linkedList, false));
                        }
                        return bl;
                    }
                    var22_27 = null;
                    for (Context context : linkedList2) {
                        indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                        if (indexImpl == null) continue;
                        indexImpl.store(this.isSteady(), new ProxyIterable<Indexable>(linkedList, false));
                    }
                    fileObjectCrawler.storeTimestamps();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, null, iOException);
                    continue;
                }
                break;
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> iterator = this.cifInfos.iterator();
            while (iterator.hasNext()) {
                IndexerCache.IndexerInfo<CustomIndexerFactory> indexerInfo = iterator.next();
                stringBuilder.append(" indexer=").append(indexerInfo.getIndexerName()).append('/').append(indexerInfo.getIndexerVersion());
                stringBuilder.append(" (");
                RepositoryUpdater.printMimeTypes(indexerInfo.getMimeTypes(), stringBuilder);
                stringBuilder.append(')');
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            return super.toString() + stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DeleteWork
    extends Work {
        private final URL root;
        private final Set<String> relativePaths = new HashSet<String>();

        public DeleteWork(URL uRL, Set<String> set) {
            super(false, false, false, true);
            Parameters.notNull((CharSequence)"root", (Object)uRL);
            Parameters.notNull((CharSequence)"relativePath", set);
            this.root = uRL;
            this.relativePaths.addAll(set);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("DeleteWork@" + Integer.toHexString(System.identityHashCode(this)) + ": root=" + uRL + ", files=" + set);
            }
        }

        @Override
        public boolean getDone() {
            try {
                LinkedList<IndexableImpl> linkedList = new LinkedList<IndexableImpl>();
                for (String string : this.relativePaths) {
                    linkedList.add(new DeletedIndexable(this.root, string));
                }
                this.delete(linkedList, this.root);
                TEST_LOGGER.log(Level.FINEST, "delete");
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
            return true;
        }

        @Override
        public boolean absorb(Work work) {
            if (work instanceof DeleteWork) {
                DeleteWork deleteWork = (DeleteWork)work;
                if (deleteWork.root.equals(this.root)) {
                    this.relativePaths.addAll(deleteWork.relativePaths);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(this + ", root=" + this.root + " absorbed: " + deleteWork.relativePaths);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private static final class BinaryWork
    extends Work {
        private final URL root;

        public BinaryWork(URL uRL) {
            super(false, false, true, true);
            this.root = uRL;
        }

        protected boolean getDone() {
            try {
                this.indexBinary(this.root);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
            return true;
        }

        public boolean absorb(Work work) {
            if (work instanceof BinaryWork) {
                return this.root.equals(((BinaryWork)work).root);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FileListWork
    extends Work {
        private final URL root;
        private final Collection<FileObject> files = new HashSet<FileObject>();
        private final boolean forceRefresh;
        private final boolean sourceForBinaryRoot;
        private final Map<URL, List<URL>> scannedRoots2Depencencies;

        public FileListWork(Map<URL, List<URL>> map, URL uRL, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(bl, bl2, true, true);
            assert (uRL != null);
            this.root = uRL;
            this.forceRefresh = bl3;
            this.sourceForBinaryRoot = bl4;
            this.scannedRoots2Depencencies = map;
        }

        public FileListWork(Map<URL, List<URL>> map, URL uRL, Collection<FileObject> collection, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            super(bl, bl2, bl, bl5);
            assert (uRL != null);
            assert (collection != null && collection.size() > 0);
            this.root = uRL;
            this.files.addAll(collection);
            this.forceRefresh = bl3;
            this.sourceForBinaryRoot = bl4;
            this.scannedRoots2Depencencies = map;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("FileListWork@" + Integer.toHexString(System.identityHashCode(this)) + ": root=" + uRL + ", file=" + collection);
            }
        }

        public void addFile(FileObject fileObject) {
            assert (fileObject != null);
            assert (FileUtil.isParentOf((FileObject)URLMapper.findFileObject((URL)this.root), (FileObject)fileObject)) : "File " + fileObject + " does not belong under the root: " + this.root;
            this.files.add(fileObject);
        }

        @Override
        protected boolean getDone() {
            this.updateProgress(this.root);
            if (this.scanFiles(this.root, this.files, this.forceRefresh, this.sourceForBinaryRoot)) {
                if (!this.files.isEmpty()) {
                    Map map = RepositoryUpdater.getEditorFiles();
                    for (FileObject fileObject : this.files) {
                        Document document = (Document)map.get(fileObject);
                        if (document == null) continue;
                        long l = DocumentUtilities.getDocumentVersion((Document)document);
                        document.putProperty(PROP_LAST_INDEXED_VERSION, l);
                        document.putProperty(PROP_LAST_DIRTY_VERSION, null);
                    }
                }
                if (!this.scannedRoots2Depencencies.containsKey(this.root)) {
                    this.scannedRoots2Depencencies.put(this.root, EMPTY_DEPS);
                }
            }
            TEST_LOGGER.log(Level.FINEST, "filelist");
            this.refreshActiveDocument();
            return true;
        }

        @Override
        public boolean absorb(Work work) {
            if (work instanceof FileListWork) {
                FileListWork fileListWork = (FileListWork)work;
                if (fileListWork.root.equals(this.root) && fileListWork.isFollowUpJob() == this.isFollowUpJob() && fileListWork.hasToCheckEditor() == this.hasToCheckEditor()) {
                    this.files.addAll(fileListWork.files);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(this + ", root=" + this.root + " absorbed: " + fileListWork.files);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Work {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final AtomicBoolean finished = new AtomicBoolean(false);
        private final AtomicBoolean externalCancel = new AtomicBoolean(false);
        private final boolean followUpJob;
        private final boolean checkEditor;
        private final boolean steady;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final CancelRequest cancelRequest = new CancelRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isRaised() {
                if (Work.this.cancelled.get()) {
                    RepositoryUpdater repositoryUpdater = RepositoryUpdater.getDefault();
                    synchronized (repositoryUpdater) {
                        if (RepositoryUpdater.getDefault().getState() == State.STOPPED) {
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        private final String progressTitle;
        private ProgressHandle progressHandle = null;

        protected Work(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this(bl, bl2, bl3 ? NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_BackgroundCompileStart") : null, bl4);
        }

        protected Work(boolean bl, boolean bl2, String string, boolean bl3) {
            this.followUpJob = bl;
            this.checkEditor = bl2;
            this.progressTitle = string;
            this.steady = bl3;
        }

        protected final boolean isFollowUpJob() {
            return this.followUpJob;
        }

        protected final boolean hasToCheckEditor() {
            return this.checkEditor;
        }

        protected final boolean isSteady() {
            return this.steady;
        }

        protected final void updateProgress(String string) {
            assert (string != null);
            if (this.progressHandle == null) {
                return;
            }
            this.progressHandle.progress(string);
        }

        protected final void updateProgress(URL uRL) {
            assert (uRL != null);
            if (this.progressHandle == null) {
                return;
            }
            this.progressHandle.progress(this.urlForMessage(uRL));
        }

        protected final void updateProgress(URL uRL, int n, int n2) {
            assert (uRL != null);
            if (this.progressHandle == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.urlForMessage(uRL));
            stringBuilder.append(" (").append(n).append(" of ").append(n2).append(")");
            this.progressHandle.progress(stringBuilder.toString());
        }

        protected final void scanStarted(URL uRL, boolean bl, Indexers indexers, Map<SourceIndexerFactory, Boolean> map, Map<SourceIndexerFactory, Context> map2) throws IOException {
            FileObject fileObject = CacheFolder.getDataFolder(uRL);
            for (IndexerCache.IndexerInfo<CustomIndexerFactory> object3 : indexers.cifInfos) {
                CustomIndexerFactory customIndexerFactory = object3.getIndexerFactory();
                Object object = SPIAccessor.getInstance().createContext(fileObject, uRL, customIndexerFactory.getIndexerName(), customIndexerFactory.getIndexVersion(), null, this.followUpJob, this.checkEditor, bl, this.getShuttdownRequest());
                boolean bl2 = customIndexerFactory.scanStarted((Context)object);
                map.put(customIndexerFactory, bl2);
                map2.put(customIndexerFactory, (Context)object);
            }
            for (Set set : indexers.eifInfosMap.values()) {
                for (Object object : set) {
                    EmbeddingIndexerFactory embeddingIndexerFactory = (EmbeddingIndexerFactory)((IndexerCache.IndexerInfo)object).getIndexerFactory();
                    Context context = SPIAccessor.getInstance().createContext(fileObject, uRL, embeddingIndexerFactory.getIndexerName(), embeddingIndexerFactory.getIndexVersion(), null, this.followUpJob, this.checkEditor, bl, null);
                    boolean bl3 = embeddingIndexerFactory.scanStarted(context);
                    map.put(embeddingIndexerFactory, bl3);
                    map2.put(embeddingIndexerFactory, context);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void scanFinished(Map<SourceIndexerFactory, Context> map) throws IOException {
            try {
                for (Map.Entry<SourceIndexerFactory, Context> entry : map.entrySet()) {
                    entry.getKey().scanFinished(entry.getValue());
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                for (Context context : map.values()) {
                    IndexImpl indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                    if (indexImpl == null) continue;
                    indexImpl.store(this.isSteady(), null);
                }
                throw throwable;
            }
            for (Context context : map.values()) {
                IndexImpl indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                if (indexImpl == null) continue;
                indexImpl.store(this.isSteady(), null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void delete(Collection<IndexableImpl> collection, URL uRL) throws IOException {
            if (collection == null || collection.size() == 0) {
                return;
            }
            LinkedList<Object> linkedList = new LinkedList<Object>();
            ClusteredIndexables clusteredIndexables = new ClusteredIndexables(collection);
            try {
                Object object;
                Object object2;
                FileObject fileObject = CacheFolder.getDataFolder(uRL);
                Collection<IndexerCache.IndexerInfo<CustomIndexerFactory>> collection2 = IndexerCache.getCifCache().getIndexers(null);
                for (IndexerCache.IndexerInfo<CustomIndexerFactory> object32 : collection2) {
                    object2 = object32.getIndexerFactory();
                    object = SPIAccessor.getInstance().createContext(fileObject, uRL, ((SourceIndexerFactory)object2).getIndexerName(), ((SourceIndexerFactory)object2).getIndexVersion(), null, this.followUpJob, this.checkEditor, false, null);
                    linkedList.add(object);
                    ((SourceIndexerFactory)object2).filesDeleted(clusteredIndexables.getIndexablesFor(null), (Context)object);
                }
                Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> collection3 = IndexerCache.getEifCache().getIndexers(null);
                Iterator iterator = collection3.iterator();
                while (iterator.hasNext()) {
                    object2 = (IndexerCache.IndexerInfo)iterator.next();
                    object = (EmbeddingIndexerFactory)((IndexerCache.IndexerInfo)object2).getIndexerFactory();
                    Context context = SPIAccessor.getInstance().createContext(fileObject, uRL, ((SourceIndexerFactory)object).getIndexerName(), ((SourceIndexerFactory)object).getIndexVersion(), null, this.followUpJob, this.checkEditor, false, null);
                    linkedList.add(context);
                    ((SourceIndexerFactory)object).filesDeleted(clusteredIndexables.getIndexablesFor(null), context);
                }
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                for (Context context : linkedList) {
                    IndexImpl indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                    if (indexImpl == null) continue;
                    indexImpl.store(this.isSteady(), clusteredIndexables.getIndexablesFor(null));
                }
                throw throwable;
            }
            for (Context context : linkedList) {
                IndexImpl indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                if (indexImpl == null) continue;
                indexImpl.store(this.isSteady(), clusteredIndexables.getIndexablesFor(null));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final boolean index(Collection<IndexableImpl> var1_1, Collection<IndexableImpl> var2_2, URL var3_3, boolean var4_4, Indexers var5_5, Map<SourceIndexerFactory, Boolean> var6_6) throws IOException {
            block32: {
                block30: {
                    var7_7 = new LinkedList<Context>();
                    var8_8 = new LinkedList<E>();
                    try {
                        var9_9 = CacheFolder.getDataFolder(var3_3);
                        var10_10 = new ClusteredIndexables(var1_1);
                        var11_11 = null;
                        var12_12 = var5_5.cifInfos.iterator();
lbl8:
                        // 3 sources

                        while (true) {
                            if (var12_12.hasNext()) {
                                var13_15 = var12_12.next();
                                var14_18 = PathRegistry.getDefault().getMimeTypesFor(var3_3);
                                if (var14_18 != null && !var13_15.isAllMimeTypesIndexer() && !Util.containsAny(var14_18, var13_15.getMimeTypes())) {
                                    if (!RepositoryUpdater.access$1400().isLoggable(Level.FINE)) continue;
                                    RepositoryUpdater.access$1400().log(Level.FINE, "Not using {0} registered for {1} to scan root {2} marked for {3}", new Object[]{var13_15.getIndexerFactory().getIndexerName() + "/" + var13_15.getIndexerFactory().getIndexVersion(), RepositoryUpdater.access$1500(var13_15.getMimeTypes(), new StringBuilder()), var3_3, PathRegistry.getDefault().getMimeTypesFor(var3_3)});
                                    continue;
                                }
                                var15_20 = var13_15.getIndexerFactory();
                                var16_25 = SPIAccessor.getInstance().createContext(var9_9, var3_3, var15_20.getIndexerName(), var15_20.getIndexVersion(), null, this.followUpJob, this.checkEditor, var4_4, this.getShuttdownRequest());
                                var7_7.add(var16_25);
                                var17_30 = var5_5.changedCifs != null && var5_5.changedCifs.contains(var13_15) != false;
                                var18_34 = var6_6.get(var15_20) == Boolean.FALSE && var2_2 != null;
                                var19_37 = var17_30 != false || var18_34 != false || var1_1 == var2_2;
                                SPIAccessor.getInstance().setAllFilesJob(var16_25, var19_37);
                                var20_38 = new LinkedList<Iterable<Indexable>>();
                                var21_40 = var13_15.getMimeTypes().iterator();
                                break block30;
                            }
                            if (this.getShuttdownRequest().isRaised()) {
                                var12_13 = false;
                                break;
                            }
                            var12_14 = false;
                            var13_16 = false;
                            if (var2_2 != null) {
                                for (Set var15_22 : var5_5.eifInfosMap.values()) {
                                    for (IndexerCache.IndexerInfo var17_31 : var15_22) {
                                        if (var5_5.changedEifs != null && var5_5.changedEifs.contains(var17_31)) {
                                            var12_14 = true;
                                        }
                                        var13_17 = var6_6.get(var18_35 = (EmbeddingIndexerFactory)var17_31.getIndexerFactory()) == Boolean.FALSE;
                                    }
                                }
                            }
                            break block32;
                            break;
                        }
                    }
                    catch (Throwable var28_77) {
                        var29_58 = null;
                        var30_64 = var7_7.iterator();
                        while (true) {
                            if (!var30_64.hasNext()) {
                                throw var28_77;
                            }
                            var31_70 = (Context)var30_64.next();
                            var32_76 = SPIAccessor.getInstance().getIndexFactory(var31_70).getIndex(var31_70.getIndexFolder());
                            if (var32_76 == null) continue;
                            var32_76.store(this.isSteady(), new ProxyIterable<Indexable>(var8_8, false));
                        }
                    }
                    var29_54 = null;
                    for (Context var31_66 : var7_7) {
                        var32_72 = SPIAccessor.getInstance().getIndexFactory(var31_66).getIndex(var31_66.getIndexFolder());
                        if (var32_72 == null) continue;
                        var32_72.store(this.isSteady(), new ProxyIterable<Indexable>(var8_8, false));
                    }
                    return var12_13;
                }
                while (var21_40.hasNext()) {
                    var22_45 = var21_40.next();
                    if ((var17_30 || var18_34) && var1_1 != var2_2) {
                        if (var11_11 == null) {
                            var11_11 = new ClusteredIndexables(var2_2);
                        }
                        var20_38.add(var11_11.getIndexablesFor(var22_45));
                        continue;
                    }
                    var20_38.add(var10_10.getIndexablesFor(var22_45));
                }
                var21_40 = new ProxyIterable<T>(var20_38);
                var8_8.addAll(var20_38);
                if (this.getShuttdownRequest().isRaised()) {
                    var22_46 = false;
                    var29_53 = null;
                    for (Context var31_65 : var7_7) {
                        var32_71 = SPIAccessor.getInstance().getIndexFactory(var31_65).getIndex(var31_65.getIndexFolder());
                        if (var32_71 == null) continue;
                        var32_71.store(this.isSteady(), new ProxyIterable<Indexable>(var8_8, false));
                    }
                    return var22_46;
                }
                var22_43 = var15_20.createIndexer();
                var23_47 = -1L;
                var25_49 = -1L;
                try {
                    var23_47 = System.currentTimeMillis();
                    SPIAccessor.getInstance().index(var22_43, (Iterable<? extends Indexable>)var21_40, var16_25);
                    var25_49 = System.currentTimeMillis();
                }
                catch (ThreadDeath var27_51) {
                    throw var27_51;
                }
                catch (Throwable var27_52) {
                    RepositoryUpdater.access$1400().log(Level.WARNING, null, var27_52);
                }
                if (!RepositoryUpdater.access$1400().isLoggable(Level.FINE)) ** GOTO lbl8
                var27_50 = RepositoryUpdater.access$1500(var13_15.getMimeTypes(), new StringBuilder());
                RepositoryUpdater.access$1400().fine("Indexing source root " + var3_3 + " using " + var22_43 + "; mimeTypes=" + var27_50.toString() + "; took " + (var23_47 != -1L && var25_49 != -1L ? var25_49 - var23_47 + "ms" : "unknown time"));
                ** while (true)
            }
            var14_19 = false;
            if ((var12_14 || var13_17) && var1_1 != var2_2) {
                if (var11_11 == null) {
                    var11_11 = new ClusteredIndexables(var2_2);
                }
                var14_19 = true;
            }
            for (String var16_29 : Util.getAllMimeTypes()) {
                if (this.getShuttdownRequest().isRaised()) {
                    var17_32 = false;
                    var29_55 = null;
                    for (Context var31_67 : var7_7) {
                        var32_73 = SPIAccessor.getInstance().getIndexFactory(var31_67).getIndex(var31_67.getIndexFolder());
                        if (var32_73 == null) continue;
                        var32_73.store(this.isSteady(), new ProxyIterable<Indexable>(var8_8, false));
                    }
                    return var17_32;
                }
                if (!Util.canBeParsed(var16_29)) continue;
                var17_33 = var14_19 != false ? var11_11.getIndexablesFor(var16_29) : var10_10.getIndexablesFor(var16_29);
                var8_8.add(var17_33);
                var18_36 = System.currentTimeMillis();
                var20_39 = this.indexEmbedding(var5_5.eifInfosMap, var9_9, var3_3, var17_33, var7_7, var4_4);
                var21_42 = System.currentTimeMillis();
                if (!var20_39) {
                    var23_48 = false;
                    var29_56 = null;
                    for (Context var31_68 : var7_7) {
                        var32_74 = SPIAccessor.getInstance().getIndexFactory(var31_68).getIndex(var31_68.getIndexFolder());
                        if (var32_74 == null) continue;
                        var32_74.store(this.isSteady(), new ProxyIterable<Indexable>(var8_8, false));
                    }
                    return var23_48;
                }
                if (!RepositoryUpdater.access$1400().isLoggable(Level.FINE)) continue;
                RepositoryUpdater.access$1400().fine("Indexing " + var16_29 + " embeddables under " + var3_3 + "; took " + (var21_42 - var18_36) + "ms");
            }
            var15_24 = true;
            var29_57 = null;
            var30_63 = var7_7.iterator();
            while (true) {
                if (!var30_63.hasNext()) {
                    return var15_24;
                }
                var31_69 = (Context)var30_63.next();
                var32_75 = SPIAccessor.getInstance().getIndexFactory(var31_69).getIndex(var31_69.getIndexFolder());
                if (var32_75 == null) continue;
                var32_75.store(this.isSteady(), new ProxyIterable<Indexable>(var8_8, false));
            }
        }

        protected final void invalidateSources(Iterable<? extends IndexableImpl> iterable) {
            long l = System.currentTimeMillis();
            for (IndexableImpl indexableImpl : iterable) {
                Source source;
                FileObject fileObject = indexableImpl instanceof FileObjectProvider ? ((FileObjectProvider)((Object)indexableImpl)).getFileObject() : URLMapper.findFileObject((URL)indexableImpl.getURL());
                if (fileObject == null || (source = SourceAccessor.getINSTANCE().get(fileObject)) == null) continue;
                SourceAccessor.getINSTANCE().setFlags(source, EnumSet.of(SourceFlags.INVALID));
            }
            long l2 = System.currentTimeMillis();
            LOGGER.fine("InvalidateSources took: " + (l2 - l));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void indexBinary(URL uRL) throws IOException {
            Iterator iterator;
            Collection<IndexableImpl> collection;
            Object object;
            Object object2;
            LOGGER.log(Level.FINE, "Scanning binary root: {0}", uRL);
            boolean bl = false;
            boolean bl2 = false;
            if ("file".equals(uRL.getProtocol()) && (object2 = URLMapper.findFileObject((URL)uRL)) != null && object2.isFolder()) {
                bl = true;
                object = new FileObjectCrawler((FileObject)object2, true, null, this.getShuttdownRequest());
                collection = ((Crawler)object).getResources();
                Collection<IndexableImpl> collection2 = ((Crawler)object).getDeletedResources();
                if (((Crawler)object).isFinished()) {
                    ((Crawler)object).storeTimestamps();
                    if (collection2.size() == 0 && collection.size() == 0) {
                        bl2 = true;
                        LOGGER.log(Level.FINE, "Binary folder {0} is up-to-date", uRL);
                    }
                }
            }
            object2 = new LinkedList();
            try {
                object = CacheFolder.getDataFolder(uRL);
                collection = MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookupAll(BinaryIndexerFactory.class);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.fine("Using BinaryIndexerFactories: " + collection);
                }
                for (BinaryIndexerFactory binaryIndexerFactory : collection) {
                    Context context = SPIAccessor.getInstance().createContext((FileObject)object, uRL, binaryIndexerFactory.getIndexerName(), binaryIndexerFactory.getIndexVersion(), null, false, false, false, null);
                    SPIAccessor.getInstance().setAllFilesJob(context, !bl || !bl2);
                    object2.add(context);
                    BinaryIndexer binaryIndexer = binaryIndexerFactory.createIndexer();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Indexing binary " + uRL + " using " + binaryIndexer);
                    }
                    SPIAccessor.getInstance().index(binaryIndexer, context);
                }
                Object var12_11 = null;
                iterator = object2.iterator();
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Context context = (Context)iterator2.next();
                    IndexImpl indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                    if (indexImpl == null) continue;
                    indexImpl.store(this.isSteady(), null);
                }
                throw throwable;
            }
            while (iterator.hasNext()) {
                Context context = (Context)iterator.next();
                IndexImpl indexImpl = SPIAccessor.getInstance().getIndexFactory(context).getIndex(context.getIndexFolder());
                if (indexImpl == null) continue;
                indexImpl.store(this.isSteady(), null);
            }
        }

        protected final boolean indexEmbedding(final Map<String, Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>> map, final FileObject fileObject, final URL uRL, Iterable<? extends Indexable> iterable, final List<Context> list, final boolean bl) throws IOException {
            for (final Indexable indexable : iterable) {
                FileObject fileObject2;
                URL uRL2;
                if (this.getShuttdownRequest().isRaised()) {
                    return false;
                }
                Collection collection = map.get(indexable.getMimeType());
                if (collection == null || collection.size() <= 0 || (uRL2 = indexable.getURL()) == null || (fileObject2 = URLMapper.findFileObject((URL)uRL2)) == null) continue;
                Source source = Source.create(fileObject2);
                try {
                    ParserManager.parse(Collections.singleton(source), new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            String string = resultIterator.getSnapshot().getMimeType();
                            Collection collection = (Collection)map.get(string);
                            if (collection != null && collection.size() > 0) {
                                for (IndexerCache.IndexerInfo object : collection) {
                                    Parser.Result result;
                                    if (Work.this.getShuttdownRequest().isRaised()) {
                                        return;
                                    }
                                    EmbeddingIndexerFactory embeddingIndexerFactory = (EmbeddingIndexerFactory)object.getIndexerFactory();
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("Indexing file " + fileObject2.getPath() + " using " + embeddingIndexerFactory + "; mimeType='" + string + "'");
                                    }
                                    if ((result = resultIterator.getParserResult()) == null) continue;
                                    String string2 = embeddingIndexerFactory.getIndexerName();
                                    int n = embeddingIndexerFactory.getIndexVersion();
                                    Context context = SPIAccessor.getInstance().createContext(fileObject, uRL, string2, n, null, Work.this.followUpJob, Work.this.checkEditor, bl, null);
                                    list.add(context);
                                    EmbeddingIndexer embeddingIndexer = embeddingIndexerFactory.createIndexer(indexable, result.getSnapshot());
                                    if (embeddingIndexer == null) continue;
                                    try {
                                        SPIAccessor.getInstance().index(embeddingIndexer, indexable, result, context);
                                    }
                                    catch (ThreadDeath threadDeath) {
                                        throw threadDeath;
                                    }
                                    catch (Throwable throwable) {
                                        LOGGER.log(Level.WARNING, null, throwable);
                                    }
                                }
                            }
                            for (Embedding embedding : resultIterator.getEmbeddings()) {
                                if (Work.this.getShuttdownRequest().isRaised()) {
                                    return;
                                }
                                this.run(resultIterator.getResultIterator(embedding));
                            }
                        }
                    });
                }
                catch (ParseException parseException) {
                    LOGGER.log(Level.WARNING, null, parseException);
                }
            }
            return !this.getShuttdownRequest().isRaised();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final boolean scanFiles(URL uRL, Collection<FileObject> collection, boolean bl, boolean bl2) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) return true;
            try {
                IdentityHashMap<SourceIndexerFactory, Context> identityHashMap;
                block4: {
                    boolean bl3;
                    ClassPath.Entry entry;
                    ClassPath.Entry entry2 = entry = bl2 ? null : RepositoryUpdater.getClassPathEntry(fileObject);
                    FileObjectCrawler fileObjectCrawler = collection.isEmpty() ? new FileObjectCrawler(fileObject, !bl, entry, this.getShuttdownRequest()) : new FileObjectCrawler(fileObject, collection.toArray(new FileObject[collection.size()]), !bl, entry, this.getShuttdownRequest());
                    Collection<IndexableImpl> collection2 = fileObjectCrawler.getResources();
                    if (!fileObjectCrawler.isFinished()) return false;
                    IdentityHashMap<SourceIndexerFactory, Boolean> identityHashMap2 = new IdentityHashMap<SourceIndexerFactory, Boolean>();
                    identityHashMap = new IdentityHashMap<SourceIndexerFactory, Context>();
                    Indexers indexers = Indexers.load(false);
                    this.scanStarted(uRL, bl2, indexers, identityHashMap2, identityHashMap);
                    try {
                        if (!this.index(collection2, collection.isEmpty() && bl ? collection2 : null, uRL, bl2, indexers, identityHashMap2)) break block4;
                        fileObjectCrawler.storeTimestamps();
                        this.invalidateSources(collection2);
                        bl3 = true;
                        Object var14_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_16 = null;
                        this.scanFinished(identityHashMap);
                        throw throwable;
                    }
                    this.scanFinished(identityHashMap);
                    return bl3;
                }
                Object var14_15 = null;
                this.scanFinished(identityHashMap);
                return false;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
            return true;
        }

        protected abstract boolean getDone();

        protected boolean isCancelledBy(Work work) {
            return false;
        }

        public boolean absorb(Work work) {
            return false;
        }

        protected final boolean isCancelled() {
            return this.cancelled.get();
        }

        protected final boolean isCancelledExternally() {
            return this.externalCancel.get();
        }

        protected final CancelRequest getShuttdownRequest() {
            return this.cancelRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void doTheWork() {
            try {
                try {
                    this.finished.compareAndSet(false, this.getDone());
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, null, throwable);
                    this.finished.set(true);
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    Object var3_2 = null;
                    this.latch.countDown();
                }
                Object var3_1 = null;
                this.latch.countDown();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.latch.countDown();
                throw throwable;
            }
        }

        public final void waitUntilDone() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.WARNING, null, interruptedException);
            }
        }

        public final void setCancelled(boolean bl) {
            this.cancelled.set(bl);
            this.externalCancel.set(bl);
        }

        public final void cancelBy(Work work) {
            if (this.isCancelledBy(work)) {
                LOGGER.log(Level.FINE, "{0} cancelled by {1}", new Object[]{this, work});
                this.cancelled.set(true);
                this.finished.set(true);
            }
        }

        public final boolean isFinished() {
            return this.finished.get();
        }

        public final String getProgressTitle() {
            return this.progressTitle;
        }

        public final void setProgressHandle(ProgressHandle progressHandle) {
            this.progressHandle = progressHandle;
        }

        private String urlForMessage(URL uRL) {
            String string = null;
            URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
            if (uRL2 == null) {
                uRL2 = uRL;
            }
            try {
                if ("file".equals(uRL2.getProtocol())) {
                    File file = new File(new URI(uRL2.toString()));
                    string = file.getAbsolutePath();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return string == null ? uRL2.toString() : string;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[followUpJob=" + this.followUpJob + ", checkEditor=" + this.checkEditor;
        }

        protected final void refreshActiveDocument() {
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            if (jTextComponent == null) {
                return;
            }
            Document document = jTextComponent.getDocument();
            assert (document != null);
            Source source = Source.create(document);
            if (source != null) {
                LOGGER.fine("Invalidating source: " + source + " due to RootsWork");
                EventSupport eventSupport = SourceAccessor.getINSTANCE().getEventSupport(source);
                assert (eventSupport != null);
                eventSupport.resetState(true, -1, -1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CREATED,
        STARTED,
        INITIAL_SCAN_RUNNING,
        ACTIVE,
        STOPPED;

    }
}

