/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.FolderImpl;
import org.netbeans.modules.cnd.discovery.api.FolderProperties;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectImpl
implements ProjectProperties {
    private static boolean gatherFolders = true;
    private ItemProperties.LanguageKind language;
    private Set<String> userIncludes = new LinkedHashSet<String>();
    private Set<String> systemIncludes = new LinkedHashSet<String>();
    private Map<String, String> userMacros = new HashMap<String, String>();
    private Map<String, FolderProperties> folders = new HashMap<String, FolderProperties>();

    public ProjectImpl(ItemProperties.LanguageKind languageKind) {
        this.language = languageKind;
    }

    public void update(SourceFileProperties sourceFileProperties) {
        this.userIncludes.addAll(sourceFileProperties.getUserInludePaths());
        for (String string : sourceFileProperties.getUserInludePaths()) {
            this.userIncludes.add(DiscoveryUtils.convertRelativePathToAbsolute(sourceFileProperties, string));
        }
        this.userMacros.putAll(sourceFileProperties.getUserMacros());
        if (gatherFolders) {
            this.updateFolder(sourceFileProperties);
        }
    }

    public static List<ProjectProperties> divideByLanguage(List<SourceFileProperties> list) {
        ProjectImpl projectImpl = null;
        ProjectImpl projectImpl2 = null;
        for (SourceFileProperties sourceFileProperties : list) {
            ItemProperties.LanguageKind languageKind = sourceFileProperties.getLanguageKind();
            ProjectImpl projectImpl3 = null;
            if (languageKind == ItemProperties.LanguageKind.C) {
                if (projectImpl == null) {
                    projectImpl = new ProjectImpl(languageKind);
                }
                projectImpl3 = projectImpl;
            } else {
                if (projectImpl2 == null) {
                    projectImpl2 = new ProjectImpl(languageKind);
                }
                projectImpl3 = projectImpl2;
            }
            projectImpl3.update(sourceFileProperties);
        }
        ArrayList arrayList = new ArrayList();
        if (projectImpl != null) {
            arrayList.add(projectImpl);
        }
        if (projectImpl2 != null) {
            arrayList.add(projectImpl2);
        }
        return arrayList;
    }

    private void updateFolder(SourceFileProperties sourceFileProperties) {
        FolderProperties folderProperties;
        File file = new File(sourceFileProperties.getItemPath());
        String string = CndFileUtils.normalizeFile((File)file.getParentFile()).getAbsolutePath();
        if (Utilities.isWindows()) {
            string = string.replace('\\', '/');
        }
        if ((folderProperties = this.folders.get(string)) == null) {
            this.folders.put(string, new FolderImpl(string, sourceFileProperties));
        } else {
            ((FolderImpl)folderProperties).update(sourceFileProperties);
        }
    }

    @Override
    public List<FolderProperties> getConfiguredFolders() {
        return new ArrayList<FolderProperties>(this.folders.values());
    }

    @Override
    public String getMakePath() {
        return null;
    }

    @Override
    public String getBinaryPath() {
        return null;
    }

    @Override
    public ProjectProperties.BinaryKind getBinaryKind() {
        return null;
    }

    @Override
    public List<String> getUserInludePaths() {
        return new ArrayList<String>(this.userIncludes);
    }

    @Override
    public List<String> getSystemInludePaths() {
        return new ArrayList<String>(this.systemIncludes);
    }

    @Override
    public Map<String, String> getUserMacros() {
        return this.userMacros;
    }

    @Override
    public Map<String, String> getSystemMacros() {
        return null;
    }

    @Override
    public ItemProperties.LanguageKind getLanguageKind() {
        return this.language;
    }
}

