/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.RIConstants;
import com.sun.faces.renderkit.RenderKitImpl;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletContext;

public class Util {
    public static final String FACES_LOGGER = "javax.enterprise.resource.webcontainer.jsf";
    public static final String FACES_LOG_STRINGS = "com.sun.faces.LogStrings";
    private static final Logger LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf");
    public static final String RENDERKIT_LOGGER = ".renderkit";
    public static final String TAGLIB_LOGGER = ".taglib";
    public static final String APPLICATION_LOGGER = ".application";
    public static final String CONTEXT_LOGGER = ".context";
    public static final String CONFIG_LOGGER = ".config";
    public static final String LIFECYCLE_LOGGER = ".lifecycle";
    public static final String TIMING_LOGGER = ".timing";
    private static boolean unitTestModeEnabled = false;
    private static boolean coreTLVEnabled = true;
    private static boolean htmlTLVEnabled = true;
    private static final Map<String, Pattern> patternCache = new LRUMap<String, Pattern>(15);
    private static final String INVOCATION_PATH = "com.sun.faces.INVOCATION_PATH";

    private Util() {
        throw new IllegalStateException();
    }

    public static Object getListenerInstance(ValueExpression type, ValueExpression binding) {
        FacesContext faces = FacesContext.getCurrentInstance();
        Object instance = null;
        if (faces == null) {
            return null;
        }
        if (binding != null) {
            instance = binding.getValue(faces.getELContext());
        }
        if (instance == null && type != null) {
            try {
                instance = ReflectionUtils.newInstance((String)type.getValue(faces.getELContext()));
            }
            catch (Exception e) {
                throw new AbortProcessingException(e.getMessage(), (Throwable)e);
            }
            if (binding != null) {
                binding.setValue(faces.getELContext(), instance);
            }
        }
        return instance;
    }

    public static void setUnitTestModeEnabled(boolean enabled) {
        unitTestModeEnabled = enabled;
    }

    public static boolean isUnitTestModeEnabled() {
        return unitTestModeEnabled;
    }

    public static void setCoreTLVActive(boolean active) {
        coreTLVEnabled = active;
    }

    public static boolean isCoreTLVActive() {
        return coreTLVEnabled;
    }

    public static void setHtmlTLVActive(boolean active) {
        htmlTLVEnabled = active;
    }

    public static boolean isHtmlTLVActive() {
        return htmlTLVEnabled;
    }

    public static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Util.getCurrentLoader(fallbackClass);
        return Class.forName(name, false, loader);
    }

    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    public static Logger getLogger(String loggerName) {
        return Logger.getLogger(loggerName, FACES_LOG_STRINGS);
    }

    public static void verifyFactoriesAndInitDefaultRenderKit(ServletContext context) throws FacesException {
        RenderKitFactory renderKitFactory = null;
        LifecycleFactory lifecycleFactory = null;
        FacesContextFactory facesContextFactory = null;
        ApplicationFactory applicationFactory = null;
        RenderKit defaultRenderKit = null;
        renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        assert (null != renderKitFactory);
        lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        assert (null != lifecycleFactory);
        facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        assert (null != facesContextFactory);
        applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        assert (null != applicationFactory);
        defaultRenderKit = renderKitFactory.getRenderKit(null, "HTML_BASIC");
        if (defaultRenderKit == null) {
            defaultRenderKit = new RenderKitImpl();
            renderKitFactory.addRenderKit("HTML_BASIC", defaultRenderKit);
        }
        context.setAttribute("com.sun.faces.HTML_BASIC", (Object)defaultRenderKit);
        context.setAttribute("com.sun.faces.OneTimeInitialization", (Object)"com.sun.faces.OneTimeInitialization");
    }

    public static void verifyRequiredClasses(FacesContext facesContext) throws FacesException {
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        Boolean result = null;
        String className = "javax.servlet.jsp.jstl.fmt.LocalizationContext";
        Object[] params = new Object[]{className};
        result = (Boolean)applicationMap.get("com.sun.faces.HasRequiredClasses");
        if (null != result) {
            if (Boolean.FALSE.equals(result)) {
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.MISSING_CLASS_ERROR", params));
            }
            return;
        }
        try {
            Util.loadClass(className, facesContext);
        }
        catch (ClassNotFoundException e) {
            applicationMap.put("com.sun.faces.HasRequiredClasses", Boolean.FALSE);
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.MISSING_CLASS_ERROR", params), (Throwable)e);
        }
        applicationMap.put("com.sun.faces.HasRequiredClasses", Boolean.TRUE);
    }

    public static Locale getLocaleFromContextOrSystem(FacesContext context) {
        Locale temp = Locale.getDefault();
        UIViewRoot root = null;
        Locale result = temp;
        if (null != context && null != (root = context.getViewRoot()) && null == (result = root.getLocale())) {
            result = temp;
        }
        return result;
    }

    public static Converter getConverterForClass(Class converterClass, FacesContext context) {
        if (converterClass == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Converter getConverterForIdentifer(String converterId, FacesContext context) {
        if (converterId == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static StateManager getStateManager(FacesContext context) throws FacesException {
        return context.getApplication().getStateManager();
    }

    public static ViewHandler getViewHandler(FacesContext context) throws FacesException {
        Application application = context.getApplication();
        assert (application != null);
        ViewHandler viewHandler = application.getViewHandler();
        assert (viewHandler != null);
        return viewHandler;
    }

    public static boolean componentIsDisabled(UIComponent component) {
        return Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled")));
    }

    public static boolean componentIsDisabledOrReadonly(UIComponent component) {
        return Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled"))) != false || Boolean.valueOf(String.valueOf(component.getAttributes().get("readonly"))) != false;
    }

    public static Object createInstance(String className) {
        return Util.createInstance(className, null, null);
    }

    public static Object createInstance(String className, Class rootType, Object root) {
        Object returnObject;
        block6: {
            returnObject = null;
            if (className != null) {
                try {
                    Constructor construct;
                    Class clazz = Util.loadClass(className, returnObject);
                    if (clazz != null && rootType != null && root != null && (construct = ReflectionUtils.lookupConstructor(clazz, rootType)) != null) {
                        returnObject = construct.newInstance(root);
                    }
                    if (clazz != null && returnObject == null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "jsf.util.no.adapter.ctor.available", new Object[]{clazz.getName(), rootType != null ? rootType.getName() : "null"});
                        }
                        returnObject = clazz.newInstance();
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                    Object[] params = new Object[]{className};
                    String msg = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", params);
                    LOGGER.log(Level.SEVERE, msg, e);
                }
            }
        }
        return returnObject;
    }

    public static Locale getLocaleFromString(String localeStr) throws IllegalArgumentException {
        if (null == localeStr || localeStr.length() < 2) {
            throw new IllegalArgumentException("Illegal locale String: " + localeStr);
        }
        Locale result = null;
        String lang = null;
        String country = null;
        String variant = null;
        char[] seps = new char[]{'-', '_'};
        int i = 0;
        int j = 0;
        if (localeStr.length() >= 2 && -1 == (i = Util.indexOfSet(localeStr, seps, 0))) {
            if (2 != localeStr.length()) {
                throw new IllegalArgumentException("Illegal locale String: " + localeStr);
            }
            lang = localeStr.toLowerCase();
        }
        if (-1 != i) {
            lang = localeStr.substring(0, i);
            if (localeStr.length() >= 5 && -1 == (j = Util.indexOfSet(localeStr, seps, i + 1))) {
                if (5 != localeStr.length()) {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
                country = localeStr.substring(i + 1);
            }
            if (-1 != j) {
                country = localeStr.substring(i + 1, j);
                if (localeStr.length() >= 8) {
                    variant = localeStr.substring(j + 1);
                } else {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
            }
        }
        if (null != variant && null != country && null != lang) {
            result = new Locale(lang, country, variant);
        } else if (null != lang && null != country) {
            result = new Locale(lang, country);
        } else if (null != lang) {
            result = new Locale(lang, "");
        }
        return result;
    }

    public static int indexOfSet(String str, char[] set, int fromIndex) {
        int result = -1;
        char[] toSearch = str.toCharArray();
        int len = toSearch.length;
        for (int i = fromIndex; i < len; ++i) {
            int innerLen = set.length;
            for (int j = 0; j < innerLen; ++j) {
                if (toSearch[i] != set[j]) continue;
                result = i;
                break;
            }
            if (-1 != result) break;
        }
        return result;
    }

    public static void parameterNonNull(Object param) throws FacesException {
        if (null == param) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "param"));
        }
    }

    public static void parameterNonEmpty(String param) throws FacesException {
        if (null == param || 0 == param.length()) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.EMPTY_PARAMETER", new Object[0]));
        }
    }

    public static String getStackTraceString(Throwable e) {
        if (null == e) {
            return "";
        }
        StackTraceElement[] stacks = e.getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stacks.length; ++i) {
            sb.append(stacks[i].toString()).append('\n');
        }
        return sb.toString();
    }

    public static String getContentTypeFromResponse(Object response) {
        String result = null;
        if (null != response) {
            try {
                Object obj;
                Method method = ReflectionUtils.lookupMethod(response.getClass(), "getContentType", RIConstants.EMPTY_CLASS_ARGS);
                if (null != method && null != (obj = method.invoke(response, RIConstants.EMPTY_METH_ARGS))) {
                    result = obj.toString();
                }
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        return result;
    }

    public static boolean prefixViewTraversal(FacesContext context, UIComponent root, TreeTraversalCallback action) throws FacesException {
        boolean keepGoing = false;
        keepGoing = action.takeActionOnNode(context, root);
        if (keepGoing) {
            Iterator kids = root.getFacetsAndChildren();
            while (kids.hasNext() && keepGoing) {
                keepGoing = Util.prefixViewTraversal(context, (UIComponent)kids.next(), action);
            }
        }
        return keepGoing;
    }

    public static FeatureDescriptor getFeatureDescriptor(String name, String displayName, String desc, boolean expert, boolean hidden, boolean preferred, Object type, Boolean designTime) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setName(name);
        fd.setDisplayName(displayName);
        fd.setShortDescription(desc);
        fd.setExpert(expert);
        fd.setHidden(hidden);
        fd.setPreferred(preferred);
        fd.setValue("type", type);
        fd.setValue("resolvableAtDesignTime", designTime);
        return fd;
    }

    public static synchronized String[] split(String toSplit, String regex) {
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern.split(toSplit, 0);
    }

    public static String getFacesMapping(FacesContext context) {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        String mapping = (String)extContext.getRequestMap().get(INVOCATION_PATH);
        if (mapping == null) {
            Object request = extContext.getRequest();
            String servletPath = null;
            String pathInfo = null;
            servletPath = extContext.getRequestServletPath();
            mapping = Util.getMappingForRequest(servletPath, pathInfo = extContext.getRequestPathInfo());
            if (mapping == null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "jsf.faces_servlet_mapping_cannot_be_determined_error", new Object[]{servletPath});
            }
        }
        if ("/*".equals(mapping)) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.FACES_SERVLET_MAPPING_INCORRECT", new Object[0]));
        }
        if (mapping != null) {
            extContext.getRequestMap().put(INVOCATION_PATH, mapping);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "URL pattern of the FacesServlet executing the current request " + mapping);
        }
        return mapping;
    }

    private static String getMappingForRequest(String servletPath, String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "servletPath " + servletPath);
            LOGGER.log(Level.FINE, "pathInfo " + pathInfo);
        }
        if (servletPath.length() == 0) {
            return "/*";
        }
        if (pathInfo != null) {
            return servletPath;
        }
        if (servletPath.indexOf(46) < 0) {
            return servletPath;
        }
        return servletPath.substring(servletPath.lastIndexOf(46));
    }

    public static boolean isPrefixMapped(String mapping) {
        return mapping.charAt(0) == '/';
    }

    public static interface TreeTraversalCallback {
        public boolean takeActionOnNode(FacesContext var1, UIComponent var2) throws FacesException;
    }
}

