/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support;

import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.extras.api.ViewportModel;
import org.netbeans.modules.dlight.extras.api.ViewportModelState;
import org.netbeans.modules.dlight.util.Range;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultViewportModel
implements ViewportModel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private long lowerLimit;
    private long upperLimit;
    private long viewportStart;
    private long viewportEnd;
    private long minViewportSize;
    private boolean autoscroll;

    public DefaultViewportModel(Range<Long> range, Range<Long> range2) {
        this.lowerLimit = (Long)range.getStart();
        this.upperLimit = (Long)range.getEnd();
        this.viewportStart = (Long)range2.getStart();
        this.viewportEnd = (Long)range2.getEnd();
        this.minViewportSize = 0L;
        this.autoscroll = true;
    }

    public synchronized boolean getAutoscroll() {
        return this.autoscroll;
    }

    public synchronized void setAutoscroll(boolean bl) {
        this.autoscroll = bl;
    }

    public synchronized long getMinViewportSize() {
        return this.minViewportSize;
    }

    public synchronized void setMinViewportSize(long l) {
        this.minViewportSize = l;
    }

    @Override
    public synchronized Range<Long> getLimits() {
        return new Range((Number)this.lowerLimit, (Number)this.upperLimit);
    }

    @Override
    public synchronized void setLimits(Range<Long> range) {
        long l = range.getStart() != null ? Math.min((Long)range.getStart(), this.lowerLimit) : this.lowerLimit;
        long l2 = range.getEnd() != null ? Math.max((Long)range.getEnd(), this.upperLimit) : this.upperLimit;
        if (l < this.lowerLimit || this.upperLimit < l2) {
            if (l2 - l < 0L) {
                return;
            }
            boolean bl = this.autoscroll && this.viewportStart <= this.upperLimit && this.upperLimit <= this.viewportEnd;
            long l3 = this.viewportEnd - this.viewportStart;
            this.lowerLimit = l;
            this.upperLimit = l2;
            if (bl) {
                this.viewportStart = Math.max(0L, this.upperLimit - l3);
                this.viewportEnd = this.viewportStart + l3;
            }
            this.changeSupport.fireChange();
        }
    }

    @Override
    public synchronized Range<Long> getViewport() {
        return new Range((Number)this.viewportStart, (Number)this.viewportEnd);
    }

    @Override
    public synchronized void setViewport(Range<Long> range) {
        long l = range.getStart() != null ? (Long)range.getStart() : this.viewportStart;
        long l2 = range.getEnd() != null ? (Long)range.getEnd() : this.viewportEnd;
        if (l != this.viewportStart || l2 != this.viewportEnd) {
            if (l2 - l < this.minViewportSize) {
                return;
            }
            this.viewportStart = l;
            this.viewportEnd = l2;
            this.changeSupport.fireChange();
        }
    }

    @Override
    public synchronized ViewportModelState getState() {
        return new StateImpl(this.getLimits(), this.getViewport());
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StateImpl
    implements ViewportModelState {
        private final Range<Long> limits;
        private final Range<Long> viewport;

        public StateImpl(Range<Long> range, Range<Long> range2) {
            this.limits = range;
            this.viewport = range2;
        }

        @Override
        public Range<Long> getLimits() {
            return this.limits;
        }

        @Override
        public Range<Long> getViewport() {
            return this.viewport;
        }
    }
}

