/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.menu.VisualDesignerJPanelPopup;

class VisualDesignerPopupFactory
extends PopupFactory {
    public Map<JMenu, JPanel> containerMap = new HashMap<JMenu, JPanel>();
    private Map<JMenu, VisualDesignerJPanelPopup> popupMap = new HashMap<JMenu, VisualDesignerJPanelPopup>();
    private MenuEditLayer canvas;

    public VisualDesignerPopupFactory(MenuEditLayer menuEditLayer) {
        this.canvas = menuEditLayer;
    }

    public Popup getPopup(Component component, Component component2, int n, int n2) throws IllegalArgumentException {
        Object object;
        final JMenu jMenu = (JMenu)component;
        JPanel jPanel = this.containerMap.get(jMenu);
        if (jPanel == null) {
            jPanel = new VisualDesignerJPanelContainer(jMenu, this);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            object = (RADVisualContainer)this.canvas.formDesigner.getMetaComponent(jMenu);
            for (RADComponent rADComponent : ((RADVisualContainer)object).getSubBeans()) {
                JComponent jComponent = (JComponent)this.canvas.formDesigner.getComponent(rADComponent);
                jPanel.add(jComponent);
            }
            jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.containerMap.put(jMenu, jPanel);
            this.canvas.layers.add((Component)jPanel, JLayeredPane.DEFAULT_LAYER);
        }
        jPanel.setSize(jPanel.getLayout().preferredLayoutSize(jPanel));
        this.canvas.validate();
        this.canvas.setVisible(true);
        object = jPanel;
        SwingUtilities.invokeLater(new Runnable((JPanel)object){
            final /* synthetic */ JPanel val$fcont;
            {
                this.val$fcont = jPanel;
            }

            public void run() {
                VisualDesignerPopupFactory.this.setLocationFromMenu(jMenu, this.val$fcont);
            }
        });
        this.canvas.validate();
        this.canvas.repaint();
        VisualDesignerJPanelPopup visualDesignerJPanelPopup = new VisualDesignerJPanelPopup(jPanel, jMenu, this);
        this.popupMap.put(jMenu, visualDesignerJPanelPopup);
        return visualDesignerJPanelPopup;
    }

    VisualDesignerJPanelPopup getPopup(JMenu jMenu) {
        return this.popupMap.get(jMenu);
    }

    private void setLocationFromMenu(JMenu jMenu, JPanel jPanel) {
        Point point = SwingUtilities.convertPoint(jMenu, new Point(0, 0), this.canvas);
        JComponent jComponent = this.canvas.getMenuParent(jMenu);
        point = jComponent instanceof JMenu ? new Point(point.x + jMenu.getWidth(), point.y) : new Point(point.x, point.y + jMenu.getHeight());
        jPanel.setLocation(point);
    }

    void hideOtherMenus(JMenu jMenu) {
        for (JMenu jMenu2 : this.containerMap.keySet()) {
            if (jMenu2 == jMenu || this.isAncestor(jMenu2, jMenu)) continue;
            JPanel jPanel = this.containerMap.get(jMenu2);
            jPanel.setVisible(false);
        }
    }

    private boolean isAncestor(JMenu jMenu, JMenu jMenu2) {
        return this.canvas.isAncestor(jMenu2, jMenu);
    }

    private static class VisualDesignerJPanelContainer
    extends JPanel {
        private JMenu menu;
        private VisualDesignerPopupFactory fact;

        VisualDesignerJPanelContainer(JMenu jMenu, VisualDesignerPopupFactory visualDesignerPopupFactory) {
            this.menu = jMenu;
            this.fact = visualDesignerPopupFactory;
        }

        public void setVisible(boolean bl) {
            if (bl) {
                this.fact.hideOtherMenus(this.menu);
                this.fact.setLocationFromMenu(this.menu, this);
            }
            super.setVisible(bl);
        }
    }
}

