/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RADVisualComponent
extends RADComponent {
    private static final String PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE = "layoutComponentHorizontalSize";
    private static final String PROP_LAYOUT_COMPONENT_VERTICAL_SIZE = "layoutComponentVerticalSize";
    private static final String PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE = "layoutComponentHorizontalResizable";
    private static final String PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE = "layoutComponentVerticalResizable";
    private Map<String, LayoutConstraints> constraints = new HashMap<String, LayoutConstraints>();
    private Node.Property[] constraintsProperties;
    private ConstraintsListenerConvertor constraintsListener;

    public final RADVisualContainer getParentContainer() {
        return (RADVisualContainer)this.getParentComponent();
    }

    public final int getComponentIndex() {
        RADVisualContainer rADVisualContainer = (RADVisualContainer)this.getParentComponent();
        return rADVisualContainer != null ? rADVisualContainer.getIndexOf(this) : -1;
    }

    final LayoutSupportManager getParentLayoutSupport() {
        RADVisualContainer rADVisualContainer = (RADVisualContainer)this.getParentComponent();
        return rADVisualContainer != null ? rADVisualContainer.getLayoutSupport() : null;
    }

    boolean isMenuTypeComponent() {
        return MenuElement.class.isAssignableFrom(this.getBeanClass());
    }

    public boolean isMenuComponent() {
        RADVisualContainer rADVisualContainer;
        return this.isMenuTypeComponent() && ((rADVisualContainer = this.getParentContainer()) == null && !this.isInModel() || rADVisualContainer != null && (rADVisualContainer.isMenuTypeComponent() || this == rADVisualContainer.getContainerMenu()));
    }

    static MenuType getMenuType(Class clazz) {
        if (MenuElement.class.isAssignableFrom(clazz)) {
            if (JMenu.class.isAssignableFrom(clazz)) {
                return MenuType.JMenu;
            }
            if (JMenuBar.class.isAssignableFrom(clazz)) {
                return MenuType.JMenuBar;
            }
            if (JCheckBoxMenuItem.class.isAssignableFrom(clazz)) {
                return MenuType.JCheckBoxMenuItem;
            }
            if (JRadioButtonMenuItem.class.isAssignableFrom(clazz)) {
                return MenuType.JRadioButtonMenuItem;
            }
            if (JMenuItem.class.isAssignableFrom(clazz)) {
                return MenuType.JMenuItem;
            }
            if (JPopupMenu.class.isAssignableFrom(clazz)) {
                return MenuType.JPopupMenu;
            }
        } else if (JSeparator.class.isAssignableFrom(clazz)) {
            return MenuType.JSeparator;
        }
        return null;
    }

    public void setLayoutConstraints(Class clazz, LayoutConstraints layoutConstraints) {
        if (layoutConstraints != null) {
            this.constraints.put(clazz.getName(), layoutConstraints);
        }
    }

    public LayoutConstraints getLayoutConstraints(Class clazz) {
        return this.constraints.get(clazz.getName());
    }

    Map<String, LayoutConstraints> getConstraintsMap() {
        return this.constraints;
    }

    void setConstraintsMap(Map<String, LayoutConstraints> map) {
        this.constraints.putAll(map);
    }

    @Override
    protected void createPropertySets(List<Node.PropertySet> list) {
        super.createPropertySets(list);
        if (SUPPRESS_PROPERTY_TABS) {
            return;
        }
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        if (this.constraintsProperties != null && this.constraintsProperties.length > 0) {
            list.add(list.size() - 1, new Node.PropertySet("layout", FormUtils.getBundleString("CTL_LayoutTab"), FormUtils.getBundleString("CTL_LayoutTabHint")){

                public Node.Property[] getProperties() {
                    Node.Property[] propertyArray = RADVisualComponent.this.getConstraintsProperties();
                    return propertyArray == null ? RADComponent.NO_PROPERTIES : propertyArray;
                }
            });
        }
    }

    @Override
    protected void clearProperties() {
        super.clearProperties();
        this.constraintsProperties = null;
    }

    public Node.Property[] getConstraintsProperties() {
        if (this.constraintsProperties == null) {
            this.createConstraintsProperties();
        }
        return this.constraintsProperties;
    }

    public void resetConstraintsProperties() {
        if (this.constraintsProperties != null) {
            for (int i = 0; i < this.constraintsProperties.length; ++i) {
                this.nameToProperty.remove(this.constraintsProperties[i].getName());
            }
            this.constraintsProperties = null;
            this.propertySets = null;
            RADComponentNode rADComponentNode = this.getNodeReference();
            if (rADComponentNode != null) {
                rADComponentNode.fireComponentPropertySetsChange();
            }
        }
    }

    private void createConstraintsProperties() {
        Object object;
        this.constraintsProperties = null;
        LayoutSupportManager layoutSupportManager = this.getParentLayoutSupport();
        if (layoutSupportManager != null) {
            if (this.getParentContainer().isLayoutSubcomponent(this) && (object = layoutSupportManager.getConstraints(this)) != null) {
                this.constraintsProperties = object.getProperties();
            }
        } else if (this.getParentContainer() != null) {
            object = this.getFormModel().getLayoutModel().getLayoutComponent(this.getId());
            if (object == null) {
                return;
            }
            this.constraintsProperties = new Node.Property[]{new LayoutComponentSizeProperty((LayoutComponent)object, 0), new LayoutComponentSizeProperty((LayoutComponent)object, 1), new LayoutComponentResizableProperty((LayoutComponent)object, 0), new LayoutComponentResizableProperty((LayoutComponent)object, 1)};
            ((LayoutComponent)object).addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RADComponentNode rADComponentNode = RADVisualComponent.this.getNodeReference();
                    if (rADComponentNode != null) {
                        String string = propertyChangeEvent.getPropertyName();
                        if ("horizontalPrefSize".equals(string)) {
                            rADComponentNode.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE, null, null);
                        } else if ("verticalPrefSize".equals(string)) {
                            rADComponentNode.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_SIZE, null, null);
                        } else if ("horizontalMaxSize".equals(string)) {
                            rADComponentNode.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE, null, null);
                        } else if ("verticalMaxSize".equals(string)) {
                            rADComponentNode.firePropertyChangeHelper(RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE, null, null);
                        }
                    }
                }
            });
        }
        if (this.constraintsProperties == null) {
            this.constraintsProperties = NO_PROPERTIES;
            return;
        }
        for (int i = 0; i < this.constraintsProperties.length; ++i) {
            if (!(this.constraintsProperties[i] instanceof FormProperty)) continue;
            FormProperty formProperty = (FormProperty)this.constraintsProperties[i];
            formProperty.addVetoableChangeListener(this.getConstraintsListener());
            formProperty.addPropertyChangeListener(this.getConstraintsListener());
            formProperty.addValueConvertor(this.getConstraintsListener());
            formProperty.setPropertyContext(new FormPropertyContext.Component(this));
            if (this.isReadOnly() || !this.isValid()) {
                int n = formProperty.getAccessType() | 0xA;
                formProperty.setAccessType(n);
            }
            this.nameToProperty.put(formProperty.getName(), formProperty);
        }
    }

    private ConstraintsListenerConvertor getConstraintsListener() {
        if (this.constraintsListener == null) {
            this.constraintsListener = new ConstraintsListenerConvertor();
        }
        return this.constraintsListener;
    }

    private class LayoutComponentResizableProperty
    extends PropertySupport.ReadWrite {
        private LayoutComponent component;
        private int dimension;

        private LayoutComponentResizableProperty(LayoutComponent layoutComponent, int n) {
            super(n == 0 ? RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE : RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE, Boolean.class, null, null);
            boolean bl = n == 0;
            this.setDisplayName(FormUtils.getBundleString(bl ? "PROP_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE" : "PROP_LAYOUT_COMPONENT_VERTICAL_RESIZABLE"));
            this.setShortDescription(FormUtils.getBundleString(bl ? "HINT_LAYOUT_COMPONENT_HORIZONTAL_RESIZABLE" : "HINT_LAYOUT_COMPONENT_VERTICAL_RESIZABLE"));
            this.component = layoutComponent;
            this.dimension = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) {
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            Boolean bl = (Boolean)this.getValue();
            Boolean bl2 = (Boolean)object;
            boolean bl3 = bl2;
            LayoutModel layoutModel = RADVisualComponent.this.getFormModel().getLayoutModel();
            LayoutInterval layoutInterval = this.component.getLayoutInterval(this.dimension);
            Object object2 = layoutModel.getChangeMark();
            UndoableEdit undoableEdit = layoutModel.getUndoableEdit();
            boolean bl4 = true;
            try {
                layoutModel.setIntervalSize(layoutInterval, bl3 ? -1 : -2, layoutInterval.getPreferredSize(false), bl3 ? Short.MAX_VALUE : -2);
                RADVisualComponent.this.getNodeReference().firePropertyChangeHelper(this.getName(), bl, bl2);
                bl4 = false;
            }
            finally {
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
                if (!object2.equals(layoutModel.getChangeMark())) {
                    RADVisualComponent.this.getFormModel().addUndoableEdit(undoableEdit);
                }
                if (bl4) {
                    RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
                }
            }
        }

        public Object getValue() {
            int n = this.component.getLayoutInterval(this.dimension).getPreferredSize(false);
            int n2 = this.component.getLayoutInterval(this.dimension).getMaximumSize(false);
            return n2 != n && n2 != -2;
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() {
            this.setValue(Boolean.FALSE);
        }

        public boolean isDefaultValue() {
            return this.getValue().equals(Boolean.FALSE);
        }

        public boolean canWrite() {
            return !RADVisualComponent.this.isReadOnly();
        }
    }

    private class LayoutComponentSizeProperty
    extends PropertySupport.ReadWrite {
        private LayoutComponent component;
        private int dimension;

        private LayoutComponentSizeProperty(LayoutComponent layoutComponent, int n) {
            super(n == 0 ? RADVisualComponent.PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE : RADVisualComponent.PROP_LAYOUT_COMPONENT_VERTICAL_SIZE, Integer.class, null, null);
            boolean bl = n == 0;
            this.setDisplayName(FormUtils.getBundleString(bl ? "PROP_LAYOUT_COMPONENT_HORIZONTAL_SIZE" : "PROP_LAYOUT_COMPONENT_VERTICAL_SIZE"));
            this.setShortDescription(FormUtils.getBundleString(bl ? "HINT_LAYOUT_COMPONENT_HORIZONTAL_SIZE" : "HINT_LAYOUT_COMPONENT_VERTICAL_SIZE"));
            this.component = layoutComponent;
            this.dimension = n;
            this.setValue("canEditAsText", Boolean.TRUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) {
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            Integer n = (Integer)this.getValue();
            Integer n2 = (Integer)object;
            LayoutModel layoutModel = RADVisualComponent.this.getFormModel().getLayoutModel();
            LayoutInterval layoutInterval = this.component.getLayoutInterval(this.dimension);
            Object object2 = layoutModel.getChangeMark();
            UndoableEdit undoableEdit = layoutModel.getUndoableEdit();
            boolean bl = true;
            try {
                layoutModel.setIntervalSize(layoutInterval, layoutInterval.getMinimumSize(false), n2, layoutInterval.getMaximumSize(false));
                RADVisualComponent.this.getNodeReference().firePropertyChangeHelper(this.getName(), n, n2);
                bl = false;
            }
            finally {
                RADVisualComponent.this.getFormModel().fireContainerLayoutChanged(RADVisualComponent.this.getParentContainer(), null, null, null);
                if (!object2.equals(layoutModel.getChangeMark())) {
                    RADVisualComponent.this.getFormModel().addUndoableEdit(undoableEdit);
                }
                if (bl) {
                    RADVisualComponent.this.getFormModel().forceUndoOfCompoundEdit();
                }
            }
        }

        public Object getValue() {
            int n = this.component.getLayoutInterval(this.dimension).getPreferredSize(false);
            return new Integer(n);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() {
            this.setValue(new Integer(-1));
        }

        public boolean isDefaultValue() {
            return (Integer)this.getValue() == -1;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport(){
                private String notExplicitelyDefined = FormUtils.getBundleString("VALUE_SizeNotExplicitelyDefined");

                public String[] getTags() {
                    return new String[]{this.notExplicitelyDefined};
                }

                public String getAsText() {
                    Integer n = (Integer)this.getValue();
                    if (n == -1) {
                        return this.notExplicitelyDefined;
                    }
                    return n.toString();
                }

                public void setAsText(String string) {
                    if (this.notExplicitelyDefined.equals(string)) {
                        this.setValue(new Integer(-1));
                    } else {
                        try {
                            int n = Integer.parseInt(string);
                            if (n < 0) {
                                throw new IllegalArgumentException();
                            }
                            this.setValue(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException();
                        }
                    }
                }
            };
        }

        public boolean canWrite() {
            return !RADVisualComponent.this.isReadOnly();
        }
    }

    public static class AccessibleParentEditor
    extends ComponentChooserEditor {
        public AccessibleParentEditor() {
            this.setBeanTypes(new Class[]{Accessible.class});
        }
    }

    private class ConstraintsListenerConvertor
    implements VetoableChangeListener,
    PropertyChangeListener,
    FormProperty.ValueConvertor {
        private ConstraintsListenerConvertor() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (object instanceof FormProperty && ("propertyValue".equals(string) || "propertyValueAndEditor".equals(string))) {
                RADVisualComponent.this.resourcePropertyChanged(propertyChangeEvent);
                LayoutSupportManager layoutSupportManager = RADVisualComponent.this.getParentLayoutSupport();
                int n = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints layoutConstraints = layoutSupportManager.getConstraints(n);
                propertyChangeEvent = new PropertyChangeEvent(layoutConstraints, ((FormProperty)((Object)object)).getName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                layoutSupportManager.componentLayoutChanged(n, propertyChangeEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof FormProperty && "currentEditor".equals(propertyChangeEvent.getPropertyName())) {
                LayoutSupportManager layoutSupportManager = RADVisualComponent.this.getParentLayoutSupport();
                int n = RADVisualComponent.this.getComponentIndex();
                LayoutConstraints layoutConstraints = layoutSupportManager.getConstraints(n);
                propertyChangeEvent = new PropertyChangeEvent(layoutConstraints, null, null, null);
                try {
                    layoutSupportManager.componentLayoutChanged(n, propertyChangeEvent);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public Object convert(Object object, FormProperty formProperty) {
            return RADVisualComponent.this.resourcePropertyConvert(object, formProperty);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MenuType {
        JMenuItem,
        JCheckBoxMenuItem,
        JRadioButtonMenuItem,
        JMenu,
        JMenuBar,
        JPopupMenu,
        JSeparator;

    }
}

